/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.KMeansModel$;
import org.apache.spark.ml.clustering.KMeansModel$KMeansModelReader$;
import org.apache.spark.ml.clustering.KMeansModel$KMeansModelWriter$;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansParams$class;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.util.BaseReadWrite$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rMe\u0001B\u0001\u0003\u00015\u00111bS'fC:\u001cXj\u001c3fY*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u0015/A\u0019q\u0002\u0005\n\u000e\u0003\u0011I!!\u0005\u0003\u0003\u000b5{G-\u001a7\u0011\u0005M\u0001Q\"\u0001\u0002\u0011\u0005M)\u0012B\u0001\f\u0003\u00051YU*Z1ogB\u000b'/Y7t!\tA2$D\u0001\u001a\u0015\tQB!\u0001\u0003vi&d\u0017B\u0001\u000f\u001a\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u0019!C!?\u0005\u0019Q/\u001b3\u0016\u0003\u0001\u0002\"!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rB3!H\u00162!\tas&D\u0001.\u0015\tqc!\u0001\u0006b]:|G/\u0019;j_:L!\u0001M\u0017\u0003\u000bMKgnY3\"\u0003I\nQ!\r\u00186]AB\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0005k&$\u0007\u0005K\u00024WEB\u0001b\u000e\u0001\u0003\u0006\u0004%I\u0001O\u0001\fa\u0006\u0014XM\u001c;N_\u0012,G.F\u0001:!\tQd(D\u0001<\u0015\t\u0019AH\u0003\u0002>\r\u0005)Q\u000e\u001c7jE&\u0011\u0011a\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005s\u0005a\u0001/\u0019:f]Rlu\u000eZ3mA!1!\t\u0001C\u0001\t\r\u000ba\u0001P5oSRtDc\u0001\nE\r\")a$\u0011a\u0001A!\u001aAiK\u0019\t\u000b]\n\u0005\u0019A\u001d\t\u000b!\u0003A\u0011I%\u0002\t\r|\u0007/\u001f\u000b\u0003%)CQaS$A\u00021\u000bQ!\u001a=ue\u0006\u0004\"!\u0014)\u000e\u00039S!a\u0014\u0003\u0002\u000bA\f'/Y7\n\u0005Es%\u0001\u0003)be\u0006lW*\u00199)\u0007\u001d[\u0013\u0007C\u0003U\u0001\u0011\u0005Q+\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\u0005Y;V\"\u0001\u0001\t\u000ba\u001b\u0006\u0019\u0001\u0011\u0002\u000bY\fG.^3)\u0007M[#,I\u0001\\\u0003\u0015\u0011d\u0006\r\u00181\u0011\u0015i\u0006\u0001\"\u0001_\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002W?\")\u0001\f\u0018a\u0001A!\u001aAl\u000b.\t\u000b\t\u0004A\u0011I2\u0002\u0013Q\u0014\u0018M\\:g_JlGC\u00013y!\t)WO\u0004\u0002ge:\u0011q\r\u001d\b\u0003Q>t!!\u001b8\u000f\u0005)lW\"A6\u000b\u00051d\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011\u0011OB\u0001\u0004gFd\u0017BA:u\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u001d\u0004\n\u0005Y<(!\u0003#bi\u00064%/Y7f\u0015\t\u0019H\u000fC\u0003zC\u0002\u0007!0A\u0004eCR\f7/\u001a;1\u0007m\f\u0019\u0001E\u0002}{~l\u0011\u0001^\u0005\u0003}R\u0014q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0002\u0005\rA\u0002\u0001\u0003\f\u0003\u000bA\u0018\u0011!A\u0001\u0006\u0003\t9AA\u0002`IE\nB!!\u0003\u0002\u0010A\u0019!%a\u0003\n\u0007\u000551EA\u0004O_RD\u0017N\\4\u0011\u0007\t\n\t\"C\u0002\u0002\u0014\r\u00121!\u00118zQ\r\t7F\u0017\u0005\b\u00033\u0001A\u0011IA\u000e\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u000f\u0003S\u0001B!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003G!\u0018!\u0002;za\u0016\u001c\u0018\u0002BA\u0014\u0003C\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011!\tY#a\u0006A\u0002\u0005u\u0011AB:dQ\u0016l\u0017\r\u000b\u0003\u0002\u0018-\n\u0004\u0002CA\u0019\u0001\u0011\u0005!!a\r\u0002\u000fA\u0014X\rZ5diR!\u0011QGA\u001e!\r\u0011\u0013qG\u0005\u0004\u0003s\u0019#aA%oi\"A\u0011QHA\u0018\u0001\u0004\ty$\u0001\u0005gK\u0006$XO]3t!\u0011\t\t%a\u0012\u000e\u0005\u0005\r#bAA#\t\u00051A.\u001b8bY\u001eLA!!\u0013\u0002D\t1a+Z2u_JDq!!\u0014\u0001\t\u0003\ty%\u0001\bdYV\u001cH/\u001a:DK:$XM]:\u0016\u0005\u0005E\u0003#\u0002\u0012\u0002T\u0005}\u0012bAA+G\t)\u0011I\u001d:bs\"\"\u00111J\u0016[\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n1bY8naV$XmQ8tiR!\u0011qLA3!\r\u0011\u0013\u0011M\u0005\u0004\u0003G\u001a#A\u0002#pk\ndW\rC\u0004z\u00033\u0002\r!a\u001a1\t\u0005%\u0014Q\u000e\t\u0005yv\fY\u0007\u0005\u0003\u0002\u0002\u00055D\u0001DA8\u0003K\n\t\u0011!A\u0003\u0002\u0005\u001d!aA0%e!\"\u0011\u0011L\u0016[\u0011\u001d\t)\b\u0001C!\u0003o\nQa\u001e:ji\u0016,\"!!\u001f\u0011\u0007a\tY(C\u0002\u0002~e\u0011\u0001\"\u0014'Xe&$XM\u001d\u0015\u0006\u0003gZ\u0013\u0011Q\u0011\u0003\u0003\u0007\u000bQ!\r\u00187]AB\u0011\"a\"\u0001\u0001\u0004%I!!#\u0002\u001fQ\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef,\"!a#\u0011\u000b\t\ni)!%\n\u0007\u0005=5E\u0001\u0004PaRLwN\u001c\t\u0004'\u0005M\u0015bAAK\u0005\ti1*T3b]N\u001cV/\\7befD\u0011\"!'\u0001\u0001\u0004%I!a'\u0002'Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef|F%Z9\u0015\t\u0005u\u00151\u0015\t\u0004E\u0005}\u0015bAAQG\t!QK\\5u\u0011)\t)+a&\u0002\u0002\u0003\u0007\u00111R\u0001\u0004q\u0012\n\u0004\u0002CAU\u0001\u0001\u0006K!a#\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0003\u0002CAW\u0001\u0011\u0005!!a,\u0002\u0015M,GoU;n[\u0006\u0014\u0018\u0010F\u0002W\u0003cC\u0001\"a-\u0002,\u0002\u0007\u00111R\u0001\bgVlW.\u0019:z\u0011\u001d\t9\f\u0001C\u0001\u0003s\u000b!\u0002[1t'VlW.\u0019:z+\t\tY\fE\u0002#\u0003{K1!a0$\u0005\u001d\u0011un\u001c7fC:DC!!.,5\"9\u00111\u0017\u0001\u0005\u0002\u0005\u0015WCAAIQ\u0011\t\u0019m\u000b.)\u0007\u0001Y\u0013gB\u0004\u0002N\nA\t!a4\u0002\u0017-kU-\u00198t\u001b>$W\r\u001c\t\u0004'\u0005EgAB\u0001\u0003\u0011\u0003\t\u0019n\u0005\u0005\u0002R\u0006U\u00171\\Aq!\r\u0011\u0013q[\u0005\u0004\u00033\u001c#AB!osJ+g\r\u0005\u0003\u0019\u0003;\u0014\u0012bAAp3\tQQ\n\u0014*fC\u0012\f'\r\\3\u0011\u0007\t\n\u0019/C\u0002\u0002f\u000e\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqAQAi\t\u0003\tI\u000f\u0006\u0002\u0002P\"A\u0011Q^Ai\t\u0003\ny/\u0001\u0003sK\u0006$WCAAy!\u0011A\u00121\u001f\n\n\u0007\u0005U\u0018D\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0015\tYoKAA\u0011!\tY0!5\u0005B\u0005u\u0018\u0001\u00027pC\u0012$2AEA\u0000\u0011\u001d\u0011\t!!?A\u0002\u0001\nA\u0001]1uQ\"*\u0011\u0011`\u0016\u0002\u0002\u001a9!qAAi\t\n%!\u0001\u0002#bi\u0006\u001c\u0002B!\u0002\u0002V\n-\u0011\u0011\u001d\t\u0004E\t5\u0011b\u0001B\bG\t9\u0001K]8ek\u000e$\bb\u0003B\n\u0005\u000b\u0011)\u001a!C\u0001\u0005+\t!b\u00197vgR,'/\u00133y+\t\t)\u0004C\u0006\u0003\u001a\t\u0015!\u0011#Q\u0001\n\u0005U\u0012aC2mkN$XM]%eq\u0002B1B!\b\u0003\u0006\tU\r\u0011\"\u0001\u0003 \u0005i1\r\\;ti\u0016\u00148)\u001a8uKJ,\"!a\u0010\t\u0017\t\r\"Q\u0001B\tB\u0003%\u0011qH\u0001\u000fG2,8\u000f^3s\u0007\u0016tG/\u001a:!\u0011\u001d\u0011%Q\u0001C\u0001\u0005O!bA!\u000b\u0003.\t=\u0002\u0003\u0002B\u0016\u0005\u000bi!!!5\t\u0011\tM!Q\u0005a\u0001\u0003kA\u0001B!\b\u0003&\u0001\u0007\u0011q\b\u0005\n\u0011\n\u0015\u0011\u0011!C\u0001\u0005g!bA!\u000b\u00036\t]\u0002B\u0003B\n\u0005c\u0001\n\u00111\u0001\u00026!Q!Q\u0004B\u0019!\u0003\u0005\r!a\u0010\t\u0015\tm\"QAI\u0001\n\u0003\u0011i$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t}\"\u0006BA\u001b\u0005\u0003Z#Aa\u0011\u0011\t\t\u0015#QJ\u0007\u0003\u0005\u000fRAA!\u0013\u0003L\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003]\rJAAa\u0014\u0003H\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\tM#QAI\u0001\n\u0003\u0011)&\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]#\u0006BA \u0005\u0003B!Ba\u0017\u0003\u0006\u0005\u0005I\u0011\tB/\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!q\f\t\u0005\u0005C\u0012Y'\u0004\u0002\u0003d)!!Q\rB4\u0003\u0011a\u0017M\\4\u000b\u0005\t%\u0014\u0001\u00026bm\u0006L1\u0001\u000bB2\u0011)\u0011yG!\u0002\u0002\u0002\u0013\u0005!QC\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0005g\u0012)!!A\u0005\u0002\tU\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u001f\u00119\b\u0003\u0006\u0002&\nE\u0014\u0011!a\u0001\u0003kA!Ba\u001f\u0003\u0006\u0005\u0005I\u0011\tB?\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B@!\u0019\u0011\tIa\"\u0002\u00105\u0011!1\u0011\u0006\u0004\u0005\u000b\u001b\u0013AC2pY2,7\r^5p]&!!\u0011\u0012BB\u0005!IE/\u001a:bi>\u0014\bB\u0003BG\u0005\u000b\t\t\u0011\"\u0001\u0003\u0010\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002<\nE\u0005BCAS\u0005\u0017\u000b\t\u00111\u0001\u0002\u0010!Q!Q\u0013B\u0003\u0003\u0003%\tEa&\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u000e\t\u0015\tm%QAA\u0001\n\u0003\u0012i*\u0001\u0005u_N#(/\u001b8h)\t\u0011y\u0006\u0003\u0006\u0003\"\n\u0015\u0011\u0011!C!\u0005G\u000ba!Z9vC2\u001cH\u0003BA^\u0005KC!\"!*\u0003 \u0006\u0005\t\u0019AA\b\u000f)\u0011I+!5\u0002\u0002#%!1V\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0003,\t5fA\u0003B\u0004\u0003#\f\t\u0011#\u0003\u00030N1!Q\u0016BY\u0003C\u0004\"Ba-\u0003:\u0006U\u0012q\bB\u0015\u001b\t\u0011)LC\u0002\u00038\u000e\nqA];oi&lW-\u0003\u0003\u0003<\nU&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!9!I!,\u0005\u0002\t}FC\u0001BV\u0011)\u0011YJ!,\u0002\u0002\u0013\u0015#Q\u0014\u0005\u000b\u0005\u000b\u0014i+!A\u0005\u0002\n\u001d\u0017!B1qa2LHC\u0002B\u0015\u0005\u0013\u0014Y\r\u0003\u0005\u0003\u0014\t\r\u0007\u0019AA\u001b\u0011!\u0011iBa1A\u0002\u0005}\u0002B\u0003Bh\u0005[\u000b\t\u0011\"!\u0003R\u00069QO\\1qa2LH\u0003\u0002Bj\u00057\u0004RAIAG\u0005+\u0004rA\tBl\u0003k\ty$C\u0002\u0003Z\u000e\u0012a\u0001V;qY\u0016\u0014\u0004B\u0003Bo\u0005\u001b\f\t\u00111\u0001\u0003*\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u0005(QVA\u0001\n\u0013\u0011\u0019/A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bs!\u0011\u0011\tGa:\n\t\t%(1\r\u0002\u0007\u001f\nTWm\u0019;\u0007\u000f\t5\u0018\u0011\u001b#\u0003p\n9q\n\u001c3ECR\f7\u0003\u0003Bv\u0003+\u0014Y!!9\t\u0017\u00055#1\u001eBK\u0002\u0013\u0005!1_\u000b\u0003\u0005k\u0004RAIA*\u0005o\u0004BA!?\u0003~6\u0011!1 \u0006\u0004\u0003\u000bb\u0014\u0002BA%\u0005wD1b!\u0001\u0003l\nE\t\u0015!\u0003\u0003v\u0006y1\r\\;ti\u0016\u00148)\u001a8uKJ\u001c\b\u0005C\u0004C\u0005W$\ta!\u0002\u0015\t\r\u001d1\u0011\u0002\t\u0005\u0005W\u0011Y\u000f\u0003\u0005\u0002N\r\r\u0001\u0019\u0001B{\u0011%A%1^A\u0001\n\u0003\u0019i\u0001\u0006\u0003\u0004\b\r=\u0001BCA'\u0007\u0017\u0001\n\u00111\u0001\u0003v\"Q!1\bBv#\u0003%\taa\u0005\u0016\u0005\rU!\u0006\u0002B{\u0005\u0003B!Ba\u0017\u0003l\u0006\u0005I\u0011\tB/\u0011)\u0011yGa;\u0002\u0002\u0013\u0005!Q\u0003\u0005\u000b\u0005g\u0012Y/!A\u0005\u0002\ruA\u0003BA\b\u0007?A!\"!*\u0004\u001c\u0005\u0005\t\u0019AA\u001b\u0011)\u0011YHa;\u0002\u0002\u0013\u0005#Q\u0010\u0005\u000b\u0005\u001b\u0013Y/!A\u0005\u0002\r\u0015B\u0003BA^\u0007OA!\"!*\u0004$\u0005\u0005\t\u0019AA\b\u0011)\u0011)Ja;\u0002\u0002\u0013\u0005#q\u0013\u0005\u000b\u00057\u0013Y/!A\u0005B\tu\u0005B\u0003BQ\u0005W\f\t\u0011\"\u0011\u00040Q!\u00111XB\u0019\u0011)\t)k!\f\u0002\u0002\u0003\u0007\u0011qB\u0004\u000b\u0007k\t\t.!A\t\n\r]\u0012aB(mI\u0012\u000bG/\u0019\t\u0005\u0005W\u0019ID\u0002\u0006\u0003n\u0006E\u0017\u0011!E\u0005\u0007w\u0019ba!\u000f\u0004>\u0005\u0005\b\u0003\u0003BZ\u0007\u007f\u0011)pa\u0002\n\t\r\u0005#Q\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004b\u0002\"\u0004:\u0011\u00051Q\t\u000b\u0003\u0007oA!Ba'\u0004:\u0005\u0005IQ\tBO\u0011)\u0011)m!\u000f\u0002\u0002\u0013\u000551\n\u000b\u0005\u0007\u000f\u0019i\u0005\u0003\u0005\u0002N\r%\u0003\u0019\u0001B{\u0011)\u0011ym!\u000f\u0002\u0002\u0013\u00055\u0011\u000b\u000b\u0005\u0007'\u001a)\u0006E\u0003#\u0003\u001b\u0013)\u0010\u0003\u0006\u0003^\u000e=\u0013\u0011!a\u0001\u0007\u000fA!B!9\u0004:\u0005\u0005I\u0011\u0002Br\r%\u0019Y&!5\u0001\u0003#\u001ciFA\tL\u001b\u0016\fgn]'pI\u0016dwK]5uKJ\u001cBa!\u0017\u0002z!Q1\u0011MB-\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011%t7\u000f^1oG\u0016DqAQB-\t\u0003\u0019)\u0007\u0006\u0003\u0004h\r%\u0004\u0003\u0002B\u0016\u00073Bqa!\u0019\u0004d\u0001\u0007!\u0003\u0003\u0005\u0004n\reC\u0011KB8\u0003!\u0019\u0018M^3J[BdG\u0003BAO\u0007cBqA!\u0001\u0004l\u0001\u0007\u0001EB\u0004\u0004v\u0005EGaa\u001e\u0003#-kU-\u00198t\u001b>$W\r\u001c*fC\u0012,'o\u0005\u0003\u0004t\u0005E\bb\u0002\"\u0004t\u0011\u000511\u0010\u000b\u0003\u0007{\u0002BAa\u000b\u0004t!Q1\u0011QB:\u0005\u0004%IA!\u0018\u0002\u0013\rd\u0017m]:OC6,\u0007\"CBC\u0007g\u0002\u000b\u0011\u0002B0\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u0003w\u001c\u0019\b\"\u0011\u0004\nR\u0019!ca#\t\u000f\t\u00051q\u0011a\u0001A!Q!\u0011]Ai\u0003\u0003%IAa9)\u000b\u0005E7&!!)\u000b\u0005-7&!!")
public class KMeansModel
extends Model<KMeansModel>
implements KMeansParams,
MLWritable {
    private final String uid;
    private final org.apache.spark.mllib.clustering.KMeansModel parentModel;
    private Option<KMeansSummary> trainingSummary;
    private final IntParam k;
    private final Param<String> initMode;
    private final IntParam initSteps;
    private final DoubleParam tol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static KMeansModel load(String string) {
        return KMeansModel$.MODULE$.load(string);
    }

    public static MLReader<KMeansModel> read() {
        return KMeansModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public int getK() {
        return KMeansParams$class.getK(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams$class.getInitMode(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams$class.getInitSteps(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private org.apache.spark.mllib.clustering.KMeansModel parentModel() {
        return this.parentModel;
    }

    @Override
    public KMeansModel copy(ParamMap extra) {
        KMeansModel copied = this.copyValues(new KMeansModel(this.uid(), this.parentModel()), extra);
        return (KMeansModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    public KMeansModel setFeaturesCol(String value) {
        return (KMeansModel)this.set(this.featuresCol(), value);
    }

    public KMeansModel setPredictionCol(String value) {
        return (KMeansModel)this.set(this.predictionCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(KMeansModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansModel $outer;

            public final int apply(org.apache.spark.ml.linalg.Vector vector) {
                return this.$outer.predict(vector);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$$typecreator1$1(this)));
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        return this.parentModel().predict(VectorImplicits$.MODULE$.mlVectorToMLlibVector(features));
    }

    public org.apache.spark.ml.linalg.Vector[] clusterCenters() {
        return (org.apache.spark.ml.linalg.Vector[])Predef$.MODULE$.refArrayOps((Object[])this.parentModel().clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.linalg.Vector apply(Vector x$1) {
                return x$1.asML();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)));
    }

    public double computeCost(Dataset<?> dataset) {
        SchemaUtils$.MODULE$.checkColumnType(dataset.schema(), this.$(this.featuresCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(Row x0$1) {
                Object point;
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (point = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector) {
                    org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)point;
                    Vector vector2 = Vectors$.MODULE$.fromML(vector);
                    return vector2;
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        return this.parentModel().computeCost((RDD<Vector>)data);
    }

    @Override
    public MLWriter write() {
        return new KMeansModelWriter(this);
    }

    private Option<KMeansSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<KMeansSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public KMeansModel setSummary(Option<KMeansSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public KMeansSummary summary() {
        return (KMeansSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeansModel $outer;

            public final Nothing$ apply() {
                throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No training summary available for the ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getClass().getSimpleName()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public KMeansModel(String uid, org.apache.spark.mllib.clustering.KMeansModel parentModel) {
        this.uid = uid;
        this.parentModel = parentModel;
        HasMaxIter$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasSeed$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasTol$class.$init$(this);
        KMeansParams$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }

    public static class Data
    implements Product,
    Serializable {
        private final int clusterIdx;
        private final org.apache.spark.ml.linalg.Vector clusterCenter;

        public int clusterIdx() {
            return this.clusterIdx;
        }

        public org.apache.spark.ml.linalg.Vector clusterCenter() {
            return this.clusterCenter;
        }

        public Data copy(int clusterIdx, org.apache.spark.ml.linalg.Vector clusterCenter) {
            return new Data(clusterIdx, clusterCenter);
        }

        public int copy$default$1() {
            return this.clusterIdx();
        }

        public org.apache.spark.ml.linalg.Vector copy$default$2() {
            return this.clusterCenter();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.clusterCenter();
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this.clusterIdx());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.clusterIdx());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.clusterCenter()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.clusterIdx() != data.clusterIdx()) return false;
            org.apache.spark.ml.linalg.Vector vector = this.clusterCenter();
            org.apache.spark.ml.linalg.Vector vector2 = data.clusterCenter();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(int clusterIdx, org.apache.spark.ml.linalg.Vector clusterCenter) {
            this.clusterIdx = clusterIdx;
            this.clusterCenter = clusterCenter;
            Product.class.$init$((Product)this);
        }
    }

    public static class OldData
    implements Product,
    Serializable {
        private final Vector[] clusterCenters;

        public Vector[] clusterCenters() {
            return this.clusterCenters;
        }

        public OldData copy(Vector[] clusterCenters2) {
            return new OldData(clusterCenters2);
        }

        public Vector[] copy$default$1() {
            return this.clusterCenters();
        }

        public String productPrefix() {
            return "OldData";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 0: 
            }
            return this.clusterCenters();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof OldData;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof OldData)) return false;
            boolean bl = true;
            if (!bl) return false;
            OldData oldData = (OldData)x$1;
            if (this.clusterCenters() != oldData.clusterCenters()) return false;
            if (!oldData.canEqual(this)) return false;
            return true;
        }

        public OldData(Vector[] clusterCenters2) {
            this.clusterCenters = clusterCenters2;
            Product.class.$init$((Product)this);
        }
    }

    public static class KMeansModelWriter
    extends MLWriter {
        private final KMeansModel instance;

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data[] data = (Data[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.instance.clusterCenters()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Data apply(Tuple2<org.apache.spark.ml.linalg.Vector, Object> x0$2) {
                    Tuple2<org.apache.spark.ml.linalg.Vector, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        org.apache.spark.ml.linalg.Vector center = (org.apache.spark.ml.linalg.Vector)tuple2._1();
                        int idx = tuple2._2$mcI$sp();
                        Data data = new Data(idx, center);
                        return data;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Data.class)));
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelWriter$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.clustering.KMeansModel.Data")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelWriter$$typecreator2$1(KMeansModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])data), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelWriter$$typecreator2$1(this))).repartition(1).write().parquet(dataPath);
        }

        public KMeansModelWriter(KMeansModel instance) {
            this.instance = instance;
        }
    }

    public static class KMeansModelReader
    extends MLReader<KMeansModel> {
        private final String className = KMeansModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public KMeansModel load(String path) {
            Vector[] vectorArray;
            SparkSession sparkSession = BaseReadWrite$class.sparkSession(this);
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            if (VersionUtils$.MODULE$.majorVersion(metadata.sparkVersion()) >= 2) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.clustering.KMeansModel.Data")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator3$1(KMeansModelReader $outer) {
                    }
                }
                Dataset data = sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator3$1(this))));
                vectorArray = (Vector[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])data.collect()).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Data x$2) {
                        return x$2.clusterIdx();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final org.apache.spark.ml.linalg.Vector apply(Data x$3) {
                        return x$3.clusterCenter();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(org.apache.spark.ml.linalg.Vector v) {
                        return Vectors$.MODULE$.fromML(v);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(KMeansModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.clustering.KMeansModel.OldData")).asType()).toTypeConstructor();
                    }

                    public Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator4$1(KMeansModelReader $outer) {
                    }
                }
                vectorArray = ((OldData)sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_KMeansModel$KMeansModelReader$$typecreator4$1(this)))).head()).clusterCenters();
            }
            Vector[] clusterCenters2 = vectorArray;
            KMeansModel model = new KMeansModel(metadata.uid(), new org.apache.spark.mllib.clustering.KMeansModel(clusterCenters2));
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

