/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-d\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001b;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u001fmI!\u0001\b\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005y\tS\"A\u0010\u000b\u0005\u00012\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005\tz\"a\u0002'pO\u001eLgn\u001a\u0005\tI\u0001\u0011)\u0019!C\u0001K\u0005!!/\u00198l+\u00051\u0003CA\b(\u0013\tA\u0003CA\u0002J]RD3a\t\u00161!\tYc&D\u0001-\u0015\tic!\u0001\u0006b]:|G/\u0019;j_:L!a\f\u0017\u0003\u000bMKgnY3\"\u0003E\nQ\u0001\r\u00189]AB\u0001b\r\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0006e\u0006t7\u000e\t\u0015\u0004e)\u0002\u0004\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\u0002\u0019U\u001cXM\u001d$fCR,(/Z:\u0016\u0003a\u00022!\u000f\u001f?\u001b\u0005Q$BA\u001e\u0007\u0003\r\u0011H\rZ\u0005\u0003{i\u00121A\u0015#E!\u0011yqHJ!\n\u0005\u0001\u0003\"A\u0002+va2,'\u0007E\u0002\u0010\u0005\u0012K!a\u0011\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0019!u.\u001e2mK\"\u001aQG\u000b\u0019\t\u0011%\u0003!\u0011!Q\u0001\na\nQ\"^:fe\u001a+\u0017\r^;sKN\u0004\u0003f\u0001%+a!AA\n\u0001BC\u0002\u0013\u0005q'A\bqe>$Wo\u0019;GK\u0006$XO]3tQ\rY%\u0006\r\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005q\u0005\u0001\u0002O]8ek\u000e$h)Z1ukJ,7\u000f\t\u0015\u0004\u001d*\u0002\u0004\"\u0002*\u0001\t\u0003\u0019\u0016A\u0002\u001fj]&$h\b\u0006\u0003U-bS\u0006CA+\u0001\u001b\u0005\u0011\u0001\"\u0002\u0013R\u0001\u00041\u0003f\u0001,+a!)a'\u0015a\u0001q!\u001a\u0001L\u000b\u0019\t\u000b1\u000b\u0006\u0019\u0001\u001d)\u0007iS\u0003\u0007K\u0002RUABQA\u0018\u0001\u0005\n}\u000b\u0001C^1mS\u0012\fG/\u001a$fCR,(/Z:\u0015\u0007\u0001\u001cG\u000e\u0005\u0002\u0010C&\u0011!\r\u0005\u0002\u0005+:LG\u000fC\u0003e;\u0002\u0007Q-\u0001\u0003oC6,\u0007C\u00014j\u001d\tyq-\u0003\u0002i!\u00051\u0001K]3eK\u001aL!A[6\u0003\rM#(/\u001b8h\u0015\tA\u0007\u0003C\u0003n;\u0002\u0007\u0001(\u0001\u0005gK\u0006$XO]3t\u0011\u0015y\u0007\u0001\"\u0001q\u0003\u001d\u0001(/\u001a3jGR$2\u0001R9t\u0011\u0015\u0011h\u000e1\u0001'\u0003\u0011)8/\u001a:\t\u000bQt\u0007\u0019\u0001\u0014\u0002\u000fA\u0014x\u000eZ;di\"\u001aaN\u000b\u0019\t\r]\u0004\u0001\u0015\"\u0003y\u0003y\u0019w.\u001e8u\u0003B\u0004(o\u001c=ESN$\u0018N\\2u+N,'\u000f\u0015:pIV\u001cG\u000f\u0006\u0002z{B!qb\u0010>{!\ty10\u0003\u0002}!\t!Aj\u001c8h\u0011\u0015qh\u000f1\u0001\u0000\u00035)8/\u001a:t!J|G-^2ugB!\u0011\bPA\u0001!\u0011yqH\n\u0014\t\r=\u0004A\u0011AA\u0003)\u0011\t9!a\u0004\u0011\teb\u0014\u0011\u0002\t\u0004+\u0006-\u0011bAA\u0007\u0005\t1!+\u0019;j]\u001eDaA`A\u0002\u0001\u0004y\b&BA\u0002U\u0005M\u0011EAA\u000b\u0003\u0015\u0001d&\u000f\u00181\u0011\u0019y\u0007\u0001\"\u0001\u0002\u001aQ!\u00111DA\u0016!\u0019\ti\"a\n\u0002\n5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0003kCZ\f'bAA\u0013\r\u0005\u0019\u0011\r]5\n\t\u0005%\u0012q\u0004\u0002\b\u0015\u00064\u0018M\u0015#E\u0011\u001dq\u0018q\u0003a\u0001\u0003[\u0001\u0002\"!\b\u00020\u0005M\u00121G\u0005\u0005\u0003c\tyBA\u0006KCZ\f\u0007+Y5s%\u0012#\u0005\u0003BA\u001b\u0003{i!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005Y\u0006twM\u0003\u0002\u0002\"%!\u0011qHA\u001c\u0005\u001dIe\u000e^3hKJDS!a\u0006+\u0003\u0007\n#!!\u0012\u0002\u000bEr#G\f\u0019\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005\t\"/Z2p[6,g\u000e\u001a)s_\u0012,8\r^:\u0015\r\u00055\u0013qJA)!\u0011y!)!\u0003\t\rI\f9\u00051\u0001'\u0011\u001d\t\u0019&a\u0012A\u0002\u0019\n1A\\;nQ\u0015\t9EKA,C\t\tI&A\u00032]Er\u0003\u0007C\u0004\u0002^\u0001!\t!a\u0018\u0002\u001dI,7m\\7nK:$Wk]3sgR1\u0011QJA1\u0003GBa\u0001^A.\u0001\u00041\u0003bBA*\u00037\u0002\rA\n\u0015\u0006\u00037R\u0013q\u000b\u0005\n\u0003S\u0002!\u0019!C)\u0003W\nQBZ8s[\u0006$h+\u001a:tS>tW#A3\t\u000f\u0005=\u0004\u0001)A\u0005K\u0006qam\u001c:nCR4VM]:j_:\u0004\u0003bBA:\u0001\u0011\u0005\u0013QO\u0001\u0005g\u00064X\rF\u0003a\u0003o\n\u0019\t\u0003\u0005\u0002z\u0005E\u0004\u0019AA>\u0003\t\u00198\r\u0005\u0003\u0002~\u0005}T\"\u0001\u0004\n\u0007\u0005\u0005eA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0002\u0006\u0006E\u0004\u0019A3\u0002\tA\fG\u000f\u001b\u0015\u0006\u0003cR\u0013\u0011R\u0011\u0003\u0003\u0017\u000bQ!\r\u00184]ABq!a$\u0001\t\u0003\t\t*A\rsK\u000e|W.\\3oIB\u0013x\u000eZ;diN4uN]+tKJ\u001cH\u0003BAJ\u0003/\u0003B!\u000f\u001f\u0002\u0016B)qb\u0010\u0014\u0002N!9\u00111KAG\u0001\u00041\u0003&BAGU\u0005m\u0015EAAO\u0003\u0015\td\u0006\u000e\u00181\u0011\u001d\t\t\u000b\u0001C\u0001\u0003G\u000b\u0011D]3d_6lWM\u001c3Vg\u0016\u00148OR8s!J|G-^2ugR!\u00111SAS\u0011\u001d\t\u0019&a(A\u0002\u0019BS!a(+\u00037C3\u0001\u0001\u00161\u000f\u001d\tiK\u0001E\u0001\u0003_\u000b\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m!\r)\u0016\u0011\u0017\u0004\u0007\u0003\tA\t!a-\u0014\r\u0005Ef\"!.\u001b!\u0011)\u0012q\u0017+\n\u0007\u0005efC\u0001\u0004M_\u0006$WM\u001d\u0005\b%\u0006EF\u0011AA_)\t\ty\u000b\u0003\u0005\u0002B\u0006EF\u0011BAb\u0003%\u0011XmY8n[\u0016tG\r\u0006\u0005\u0002F\u0006%\u0017QZAi!\u0011y!)a2\u0011\t=yd\u0005\u0012\u0005\b\u0003\u0017\fy\f1\u0001B\u0003M\u0011XmY8n[\u0016tG\rV8GK\u0006$XO]3t\u0011\u001d\ty-a0A\u0002a\nQC]3d_6lWM\u001c3bE2,g)Z1ukJ,7\u000fC\u0004\u0002T\u0005}\u0006\u0019\u0001\u0014\t\u0011\u0005U\u0017\u0011\u0017C\u0005\u0003/\fqB]3d_6lWM\u001c3G_J\fE\u000e\u001c\u000b\u000b\u00033\fi.a8\u0002d\u0006\u001d\b\u0003B\u001d=\u00037\u0004RaD '\u0003\u000bDa\u0001JAj\u0001\u00041\u0003bBAq\u0003'\u0004\r\u0001O\u0001\fgJ\u001cg)Z1ukJ,7\u000fC\u0004\u0002f\u0006M\u0007\u0019\u0001\u001d\u0002\u0017\u0011\u001cHOR3biV\u0014Xm\u001d\u0005\b\u0003'\n\u0019\u000e1\u0001'\u0011!\tY/!-\u0005\n\u00055\u0018\u0001\u00032m_\u000e\\\u0017NZ=\u0015\r\u0005=(\u0011\u0001B\u0002!\u0011ID(!=\u0011\r=y\u00141_A{!\ry!I\n\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111 \u0003\u0002\r1Lg.\u00197h\u0013\u0011\ty0!?\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0005\u0007I\u0005%\b\u0019\u0001\u0014\t\r5\fI\u000f1\u00019\u0011!\u00119!!-\u0005B\t%\u0011\u0001\u00027pC\u0012$R\u0001\u0016B\u0006\u0005\u001bA\u0001\"!\u001f\u0003\u0006\u0001\u0007\u00111\u0010\u0005\b\u0003\u000b\u0013)\u00011\u0001fQ\u0015\u0011)AKAE\u000f%\u0011\u0019\"!-\t\u0002\t\u0011)\"\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007\u0005\u0003\u0003\u0018\teQBAAY\r%\u0011Y\"!-\t\u0002\t\u0011iB\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0003\u001a9AqA\u0015B\r\t\u0003\u0011\t\u0003\u0006\u0002\u0003\u0016!Q!Q\u0005B\r\u0005\u0004%IAa\n\u0002#QD\u0017n\u001d$pe6\fGOV3sg&|g.\u0006\u0002\u0003*A!\u0011Q\u0007B\u0016\u0013\rQ\u0017q\u0007\u0005\n\u0005_\u0011I\u0002)A\u0005\u0005S\t!\u0003\u001e5jg\u001a{'/\\1u-\u0016\u00148/[8oA!Y!1\u0007B\r\u0005\u0004%\tA\u0001B\u0014\u00035!\b.[:DY\u0006\u001c8OT1nK\"I!q\u0007B\rA\u0003%!\u0011F\u0001\u000fi\"L7o\u00117bgNt\u0015-\\3!\u0011!\t\u0019H!\u0007\u0005\u0002\tmB#\u00021\u0003>\t\u0005\u0003b\u0002B \u0005s\u0001\r\u0001V\u0001\u0006[>$W\r\u001c\u0005\b\u0003\u000b\u0013I\u00041\u0001f\u0011!\u00119A!\u0007\u0005\u0002\t\u0015C#\u0002+\u0003H\t%\u0003\u0002CA=\u0005\u0007\u0002\r!a\u001f\t\u000f\u0005\u0015%1\ta\u0001K\"A!Q\nB\r\t\u0013\u0011y%\u0001\u0005vg\u0016\u0014\b+\u0019;i)\r)'\u0011\u000b\u0005\b\u0003\u000b\u0013Y\u00051\u0001f\u0011!\u0011)F!\u0007\u0005\n\t]\u0013a\u00039s_\u0012,8\r\u001e)bi\"$2!\u001aB-\u0011\u001d\t)Ia\u0015A\u0002\u0015D!B!\u0018\u00022\u0006\u0005I\u0011\u0002B0\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u0005\u0004\u0003BA\u001b\u0005GJAA!\u001a\u00028\t1qJ\u00196fGRDS!!-+\u0003\u0013CS!a++\u0003\u0013\u0003")
public class MatrixFactorizationModel
implements Saveable,
Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModel $outer;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " feature dimension does not match the rank ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)this.$outer.rank())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)"Prediction on individual records could be slow.").toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. Prediction could be slow."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
    }

    public double predict(int user, int product) {
        double[] userVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head();
        double[] productVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head();
        return BLAS.getInstance().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<HyperLogLogPlus, HyperLogLogPlus> apply(Tuple2<HyperLogLogPlus, HyperLogLogPlus> hllTuple, Tuple2<Object, Object> v) {
                ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
                ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
                return hllTuple;
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<HyperLogLogPlus, HyperLogLogPlus> apply(Tuple2<HyperLogLogPlus, HyperLogLogPlus> h1, Tuple2<HyperLogLogPlus, HyperLogLogPlus> h2) {
                ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
                ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
                return h1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 != null) {
            RDD rDD;
            long productsCount;
            long productsCount2;
            long usersCount = tuple2._1$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount2 = tuple2._2$mcJ$sp());
            Tuple2.mcJJ.sp sp3 = sp2;
            long usersCount2 = sp3._1$mcJ$sp();
            if (usersCount2 < (productsCount = sp3._2$mcJ$sp())) {
                RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                        Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int user = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double[] uFeatures = (double[])tuple22._1();
                                int product = tuple22._2$mcI$sp();
                                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                                return tuple23;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                rDD = RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                        Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int product = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Tuple2 tuple23 = (Tuple2)tuple22._1();
                                double[] pFeatures = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int user = tuple23._1$mcI$sp();
                                    double[] uFeatures = (double[])tuple23._2();
                                    Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                                    return rating;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Rating.class));
            } else {
                RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x$2) {
                        return x$2.swap$mcII$sp();
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$3) {
                        Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            int product = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double[] pFeatures = (double[])tuple22._1();
                                int user = tuple22._2$mcI$sp();
                                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                                return tuple23;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                rDD = RDD$.MODULE$.rddToPairRDDFunctions(products, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$4) {
                        Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int user = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Tuple2 tuple23 = (Tuple2)tuple22._1();
                                double[] uFeatures = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int product = tuple23._1$mcI$sp();
                                    double[] pFeatures = (double[])tuple23._2();
                                    Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                                    return rating;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Rating.class));
            }
            return rDD;
        }
        throw new MatchError(tuple2);
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$5) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$5;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, user){
                        public static final long serialVersionUID = 0L;
                        private final int user$2;

                        public final Rating apply(Tuple2<Object, Object> x0$6) {
                            Tuple2<Object, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                int product = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(this.user$2, product, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.user$2 = user$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$7) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$7;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, product){
                        public static final long serialVersionUID = 0L;
                        private final int product$2;

                        public final Rating apply(Tuple2<Object, Object> x0$8) {
                            Tuple2<Object, Object> tuple2 = x0$8;
                            if (tuple2 != null) {
                                int user = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(user, this.product$2, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.product$2 = product$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

