/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCCostFun;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.LinearSVCParams$class;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u00015\u0011\u0011\u0002T5oK\u0006\u00148KV\"\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dqy\u0002#B\b\u0011%aIR\"\u0001\u0002\n\u0005E\u0011!AC\"mCN\u001c\u0018NZ5feB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011a\u0002T5oK\u0006\u00148KV\"N_\u0012,G\u000e\u0005\u0002\u0010;%\u0011aD\u0001\u0002\u0010\u0019&tW-\u0019:T-\u000e\u0003\u0016M]1ngB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0005kRLG.\u0003\u0002%C\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011I\u0014\u0002\u0007ULG-F\u0001)!\tIsF\u0004\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3&\u0001\u0004Qe\u0016$WMZ\u0005\u0003aE\u0012aa\u0015;sS:<'B\u0001\u0018,Q\r)3'\u000f\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0019\t!\"\u00198o_R\fG/[8o\u0013\tATGA\u0003TS:\u001cW-I\u0001;\u0003\u0015\u0011dF\r\u00181\u0011!a\u0004A!A!\u0002\u0013A\u0013\u0001B;jI\u0002B3aO\u001a:\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u0019a\u0014N\\5u}Q\u0011\u0001$\u0011\u0005\u0006My\u0002\r\u0001\u000b\u0015\u0004\u0003NJ\u0004f\u0001 4s!)q\b\u0001C\u0001\u000bR\t\u0001\u0004K\u0002EgeBQ\u0001\u0013\u0001\u0005\u0002%\u000b1b]3u%\u0016<\u0007+\u0019:b[R\u0011!jS\u0007\u0002\u0001!)Aj\u0012a\u0001\u001b\u0006)a/\u00197vKB\u0011!FT\u0005\u0003\u001f.\u0012a\u0001R8vE2,\u0007fA$4s!)!\u000b\u0001C\u0001'\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005)#\u0006\"\u0002'R\u0001\u0004)\u0006C\u0001\u0016W\u0013\t96FA\u0002J]RD3!U\u001a:\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HC\u0001&]\u0011\u0015a\u0015\f1\u0001^!\tQc,\u0003\u0002`W\t9!i\\8mK\u0006t\u0007fA-4s!)!\r\u0001C\u0001G\u000611/\u001a;U_2$\"A\u00133\t\u000b1\u000b\u0007\u0019A')\u0007\u0005\u001c\u0014\bC\u0003h\u0001\u0011\u0005\u0001.\u0001\ntKR\u001cF/\u00198eCJ$\u0017N_1uS>tGC\u0001&j\u0011\u0015ae\r1\u0001^Q\r17'\u000f\u0005\u0006Y\u0002!\t!\\\u0001\rg\u0016$x+Z5hQR\u001cu\u000e\u001c\u000b\u0003\u0015:DQ\u0001T6A\u0002!B3a[\u001a:\u0011\u0015\t\b\u0001\"\u0001s\u00031\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7e)\tQ5\u000fC\u0003Ma\u0002\u0007Q\nK\u0002qgeBQA\u001e\u0001\u0005\u0002]\f1c]3u\u0003\u001e<'/Z4bi&|g\u000eR3qi\"$\"A\u0013=\t\u000b1+\b\u0019A+)\u0007U\u001c\u0014\bC\u0003|\u0001\u0011\u0005C0\u0001\u0003d_BLHC\u0001\r~\u0011\u0015q(\u00101\u0001\u0000\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003\t\u0005)\u0001/\u0019:b[&!\u0011\u0011BA\u0002\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001>4s!9\u0011q\u0002\u0001\u0005R\u0005E\u0011!\u0002;sC&tGcA\r\u0002\u0014!A\u0011QCA\u0007\u0001\u0004\t9\"A\u0004eCR\f7/\u001a;1\t\u0005e\u0011\u0011\u0006\t\u0007\u00037\t\t#!\n\u000e\u0005\u0005u!bAA\u0010\r\u0005\u00191/\u001d7\n\t\u0005\r\u0012Q\u0004\u0002\b\t\u0006$\u0018m]3u!\u0011\t9#!\u000b\r\u0001\u0011a\u00111FA\n\u0003\u0003\u0005\tQ!\u0001\u0002.\t\u0019q\fJ\u0019\u0012\t\u0005=\u0012Q\u0007\t\u0004U\u0005E\u0012bAA\u001aW\t9aj\u001c;iS:<\u0007c\u0001\u0016\u00028%\u0019\u0011\u0011H\u0016\u0003\u0007\u0005s\u0017\u0010K\u0002\u0001\u0003{\u00012\u0001NA \u0013\r\t\t%\u000e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001MJtaBA$\u0005!\u0005\u0011\u0011J\u0001\n\u0019&tW-\u0019:T-\u000e\u00032aDA&\r\u0019\t!\u0001#\u0001\u0002NMA\u00111JA(\u0003+\nY\u0006E\u0002+\u0003#J1!a\u0015,\u0005\u0019\te.\u001f*fMB!\u0001%a\u0016\u0019\u0013\r\tI&\t\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\rQ\u0013QL\u0005\u0004\u0003?Z#\u0001D*fe&\fG.\u001b>bE2,\u0007bB \u0002L\u0011\u0005\u00111\r\u000b\u0003\u0003\u0013B\u0001\"a\u001a\u0002L\u0011\u0005\u0013\u0011N\u0001\u0005Y>\fG\rF\u0002\u0019\u0003WBq!!\u001c\u0002f\u0001\u0007\u0001&\u0001\u0003qCRD\u0007\u0006BA3geB!\"a\u001d\u0002L\u0005\u0005I\u0011BA;\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0002\u0006!!.\u0019<b\u0013\u0011\t))a\u001f\u0003\r=\u0013'.Z2uQ\u0011\tYeM\u001d)\t\u0005\u00153'\u000f")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam threshold;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    public static LinearSVC load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public double getThreshold() {
        return LinearSVCParams$class.getThreshold(this);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        Tuple2 tuple2;
        block7: {
            Option<Object> option;
            block10: {
                int n;
                int numFeaturesPlusIntercept;
                int numFeatures;
                long numInvalid;
                MultivariateOnlineSummarizer summarizer;
                Instrumentation<LinearSVC> instr;
                RDD instances;
                block9: {
                    double[] histogram2;
                    block8: {
                        Tuple2 tuple22;
                        Column w2 = this.isDefined(this.weightCol()) && !this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
                        instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w2, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Instance apply(Row x0$1) {
                                Row row = x0$1;
                                Some some = Row$.MODULE$.unapplySeq(row);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                                    Object label = ((SeqLike)some.get()).apply(0);
                                    Object weight = ((SeqLike)some.get()).apply(1);
                                    Object features = ((SeqLike)some.get()).apply(2);
                                    if (label instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                        if (weight instanceof Double) {
                                            double d2 = BoxesRunTime.unboxToDouble((Object)weight);
                                            if (features instanceof Vector) {
                                                Vector vector = (Vector)features;
                                                Instance instance = new Instance(d, d2, vector);
                                                return instance;
                                            }
                                        }
                                    }
                                }
                                throw new MatchError((Object)row);
                            }
                        }, ClassTag$.MODULE$.apply(Instance.class));
                        instr = Instrumentation$.MODULE$.create(this, instances);
                        instr.logParams((Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth()}));
                        Serializable seqOp = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Instance instance) {
                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
                            }
                        };
                        Serializable combOp = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                                return new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
                            }
                        };
                        tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
                        if (tuple2 == null) break block7;
                        MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple2._1();
                        MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)summarizer2, (Object)labelSummarizer);
                        summarizer = (MultivariateOnlineSummarizer)tuple23._1();
                        MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
                        histogram2 = labelSummarizer2.histogram();
                        numInvalid = labelSummarizer2.countInvalid();
                        numFeatures = summarizer.mean().size();
                        numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
                        option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        int n2 = BoxesRunTime.unboxToInt((Object)some.x());
                        int n3 = n2;
                        Predef$.MODULE$.require(n3 >= histogram2.length, (Function0)new Serializable(this, histogram2, n3){
                            public static final long serialVersionUID = 0L;
                            private final double[] histogram$1;
                            private final int x3$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified number of classes ", " was "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x3$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"less than the number of unique labels ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.histogram$1.length)}))).toString();
                            }
                            {
                                this.histogram$1 = histogram$1;
                                this.x3$1 = x3$1;
                            }
                        });
                        n = n3;
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Object> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    n = histogram2.length;
                }
                int numClasses = n;
                Predef$.MODULE$.require(numClasses == 2, (Function0)new Serializable(this, numClasses){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ LinearSVC $outer;
                    private final int numClasses$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LinearSVC only supports binary classification."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " classes detected in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1), this.$outer.labelCol()}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.numClasses$1 = numClasses$1;
                    }
                });
                instr.logNumClasses(numClasses);
                instr.logNumFeatures(numFeatures);
                if (numInvalid != 0L) {
                    String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in [0 to ", "]. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                    this.logError((Function0<String>)new $anonfun$9(this, msg));
                    throw new SparkException(msg);
                }
                double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer.variance().toArray()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return package$.MODULE$.sqrt(x);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                double regParamL2 = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                LinearSVCCostFun costFun = new LinearSVCCostFun((RDD<Instance>)instances, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), (Broadcast<double[]>)bcFeaturesStd, regParamL2, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())));
                OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                Vector initialCoefWithIntercept = Vectors$.MODULE$.zeros(numFeaturesPlusIntercept);
                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefWithIntercept.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
                ArrayBuilder scaledObjectiveHistory = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                FirstOrderMinimizer.State state = null;
                while (states.hasNext()) {
                    state = (FirstOrderMinimizer.State)states.next();
                    scaledObjectiveHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                }
                bcFeaturesStd.destroy(false);
                if (state == null) {
                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                    this.logError((Function0<String>)new $anonfun$10(this, msg));
                    throw new SparkException(msg);
                }
                double[] rawCoefficients = ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double());
                double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)new Serializable(this, featuresStd, rawCoefficients){
                    public static final long serialVersionUID = 0L;
                    private final double[] featuresStd$1;
                    private final double[] rawCoefficients$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return this.featuresStd$1[i] != 0.0 ? this.rawCoefficients$1[i] / this.featuresStd$1[i] : 0.0;
                    }
                    {
                        this.featuresStd$1 = featuresStd$1;
                        this.rawCoefficients$1 = rawCoefficients$1;
                    }
                }, ClassTag$.MODULE$.Double());
                double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? rawCoefficients[numFeaturesPlusIntercept - 1] : 0.0;
                Tuple3 tuple3 = new Tuple3((Object)Vectors$.MODULE$.dense(coefficientArray), (Object)BoxesRunTime.boxToDouble((double)intercept), scaledObjectiveHistory.result());
                if (tuple3 != null) {
                    Tuple3 tuple32;
                    Vector coefficientVector = (Vector)tuple3._1();
                    double interceptVector = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    double[] objectiveHistory = (double[])tuple3._3();
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)coefficientVector, (Object)BoxesRunTime.boxToDouble((double)interceptVector), (Object)objectiveHistory);
                    Vector coefficientVector2 = (Vector)tuple33._1();
                    double interceptVector2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
                    double[] objectiveHistory2 = (double[])tuple33._3();
                    LinearSVCModel model = this.copyValues(new LinearSVCModel(this.uid(), coefficientVector2, interceptVector2), this.copyValues$default$2());
                    instr.logSuccess(model);
                    return model;
                }
                throw new MatchError((Object)tuple3);
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Function1 regParamL1Fun$1() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(int index2) {
                return this.apply$mcDI$sp(index2);
            }

            public double apply$mcDI$sp(int index2) {
                return 0.0;
            }
        };
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        LinearSVCParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

