/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0005\u001b\t\u0019B*\u001b8fCJ\u001cfkQ!hOJ,w-\u0019;pe*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011a\u0001!\u0011!Q\u0001\ne\taBY2D_\u00164g-[2jK:$8\u000fE\u0002\u001b;}i\u0011a\u0007\u0006\u00039\u0019\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005yY\"!\u0003\"s_\u0006$7-Y:u!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0004mS:\fGnZ\u0005\u0003I\u0005\u0012aAV3di>\u0014\b\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001b\t\u001cg)Z1ukJ,7o\u0015;e!\rQR\u0004\u000b\t\u0004\u001f%Z\u0013B\u0001\u0016\u0011\u0005\u0015\t%O]1z!\tyA&\u0003\u0002.!\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\rM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\t\u0003\u001fEJ!A\r\t\u0003\u000f\t{w\u000e\\3b]\")A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"BA\u000e\u001d:uA\u0011q\u0007A\u0007\u0002\u0005!)\u0001d\ra\u00013!)ae\ra\u0001O!)qf\ra\u0001a!9A\b\u0001b\u0001\n\u0013i\u0014a\u00038v[\u001a+\u0017\r^;sKN,\u0012A\u0010\t\u0003\u001f}J!\u0001\u0011\t\u0003\u0007%sG\u000f\u0003\u0004C\u0001\u0001\u0006IAP\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0005\b\t\u0002\u0011\r\u0011\"\u0003>\u0003aqW/\u001c$fCR,(/Z:QYV\u001c\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002 \u000239,XNR3biV\u0014Xm\u001d)mkNLe\u000e^3sG\u0016\u0004H\u000f\t\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0003%9X-[4iiN+X.F\u0001,\u0011\u001dY\u0005\u00011A\u0005\n1\u000bQb^3jO\"$8+^7`I\u0015\fHCA'Q!\tya*\u0003\u0002P!\t!QK\\5u\u0011\u001d\t&*!AA\u0002-\n1\u0001\u001f\u00132\u0011\u0019\u0019\u0006\u0001)Q\u0005W\u0005Qq/Z5hQR\u001cV/\u001c\u0011\t\u000fU\u0003\u0001\u0019!C\u0005\u0013\u00069An\\:t'Vl\u0007bB,\u0001\u0001\u0004%I\u0001W\u0001\fY>\u001c8oU;n?\u0012*\u0017\u000f\u0006\u0002N3\"9\u0011KVA\u0001\u0002\u0004Y\u0003BB.\u0001A\u0003&1&\u0001\u0005m_N\u001c8+^7!\u0011!i\u0006\u0001#b\u0001\n\u0013q\u0016!E2pK\u001a4\u0017nY5f]R\u001c\u0018I\u001d:bsV\t\u0001\u0006\u0003\u0005a\u0001!\u0005\t\u0015)\u0003)\u0003I\u0019w.\u001a4gS\u000eLWM\u001c;t\u0003J\u0014\u0018-\u001f\u0011)\u0005}\u0013\u0007CA\bd\u0013\t!\u0007CA\u0005ue\u0006t7/[3oi\"Aa\r\u0001EC\u0002\u0013%a,\u0001\the\u0006$\u0017.\u001a8u'Vl\u0017I\u001d:bs\"A\u0001\u000e\u0001E\u0001B\u0003&\u0001&A\the\u0006$\u0017.\u001a8u'Vl\u0017I\u001d:bs\u0002BQA\u001b\u0001\u0005\u0002-\f1!\u00193e)\taW.D\u0001\u0001\u0011\u0015q\u0017\u000e1\u0001p\u0003!Ign\u001d;b]\u000e,\u0007C\u00019t\u001b\u0005\t(B\u0001:\u0005\u0003\u001d1W-\u0019;ve\u0016L!\u0001^9\u0003\u0011%s7\u000f^1oG\u0016DQA\u001e\u0001\u0005\u0002]\fQ!\\3sO\u0016$\"\u0001\u001c=\t\u000be,\b\u0019\u0001\u001c\u0002\u000b=$\b.\u001a:\t\u000bm\u0004A\u0011A%\u0002\t1|7o\u001d\u0005\u0006{\u0002!\tA`\u0001\tOJ\fG-[3oiV\tq\u0004")
public class LinearSVCAggregator
implements Serializable {
    private final Broadcast<Vector> bcCoefficients;
    private final Broadcast<double[]> bcFeaturesStd;
    private final boolean fitIntercept;
    private final int numFeatures;
    private final int numFeaturesPlusIntercept;
    private double weightSum;
    private double lossSum;
    private transient double[] coefficientsArray;
    private double[] gradientSumArray;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    private double[] coefficientsArray$lzycompute() {
        LinearSVCAggregator linearSVCAggregator = this;
        synchronized (linearSVCAggregator) {
            block5: {
                if (!this.bitmap$trans$0) {
                    double[] values;
                    DenseVector denseVector;
                    Option option;
                    Vector vector = (Vector)this.bcCoefficients.value();
                    if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block5;
                    double[] dArray = values = (double[])option.get();
                    this.coefficientsArray = dArray;
                    this.bitmap$trans$0 = true;
                }
                return this.coefficientsArray;
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients only supports dense vector"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bcCoefficients.value().getClass()}))).toString());
        }
    }

    private double[] gradientSumArray$lzycompute() {
        LinearSVCAggregator linearSVCAggregator = this;
        synchronized (linearSVCAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = new double[this.numFeaturesPlusIntercept()];
                this.bitmap$0 = true;
            }
            return this.gradientSumArray;
        }
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    private int numFeaturesPlusIntercept() {
        return this.numFeaturesPlusIntercept;
    }

    private double weightSum() {
        return this.weightSum;
    }

    private void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] coefficientsArray() {
        return this.bitmap$trans$0 ? this.coefficientsArray : this.coefficientsArray$lzycompute();
    }

    private double[] gradientSumArray() {
        return this.bitmap$0 ? this.gradientSumArray : this.gradientSumArray$lzycompute();
    }

    public LinearSVCAggregator add(Instance instance) {
        Instance instance2 = instance;
        if (instance2 != null) {
            double dotProduct;
            double labelScaled;
            double loss2;
            double label = instance2.label();
            double weight = instance2.weight();
            Vector features = instance2.features();
            if (weight == 0.0) {
                return this;
            }
            double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
            double[] localCoefficients = this.coefficientsArray();
            double[] localGradientSumArray = this.gradientSumArray();
            DoubleRef sum = new DoubleRef(0.0);
            features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localCoefficients, sum){
                public static final long serialVersionUID = 0L;
                private final double[] localFeaturesStd$1;
                private final double[] localCoefficients$1;
                private final DoubleRef sum$2;

                public final void apply(int index2, double value) {
                    this.apply$mcVID$sp(index2, value);
                }

                public void apply$mcVID$sp(int index2, double value) {
                    if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                        this.sum$2.elem += this.localCoefficients$1[index2] * value / this.localFeaturesStd$1[index2];
                    }
                }
                {
                    this.localFeaturesStd$1 = localFeaturesStd$1;
                    this.localCoefficients$1 = localCoefficients$1;
                    this.sum$2 = sum$2;
                }
            });
            if (this.fitIntercept) {
                sum.elem += localCoefficients[this.numFeaturesPlusIntercept() - 1];
            }
            double d = loss2 = 1.0 > (labelScaled = (double)2 * label - 1.0) * (dotProduct = sum.elem) ? weight * (1.0 - labelScaled * dotProduct) : 0.0;
            if (1.0 > labelScaled * dotProduct) {
                double gradientScale = -labelScaled * weight;
                features.foreachActive((Function2)new Serializable(this, localFeaturesStd, localGradientSumArray, gradientScale){
                    public static final long serialVersionUID = 0L;
                    private final double[] localFeaturesStd$1;
                    private final double[] localGradientSumArray$1;
                    private final double gradientScale$1;

                    public final void apply(int index2, double value) {
                        this.apply$mcVID$sp(index2, value);
                    }

                    public void apply$mcVID$sp(int index2, double value) {
                        if (this.localFeaturesStd$1[index2] != 0.0 && value != 0.0) {
                            this.localGradientSumArray$1[index2] = this.localGradientSumArray$1[index2] + value * this.gradientScale$1 / this.localFeaturesStd$1[index2];
                        }
                    }
                    {
                        this.localFeaturesStd$1 = localFeaturesStd$1;
                        this.localGradientSumArray$1 = localGradientSumArray$1;
                        this.gradientScale$1 = gradientScale$1;
                    }
                });
                if (this.fitIntercept) {
                    int n = localGradientSumArray.length - 1;
                    localGradientSumArray[n] = localGradientSumArray[n] + gradientScale;
                }
            }
            this.lossSum_$eq(this.lossSum() + loss2);
            this.weightSum_$eq(this.weightSum() + weight);
            LinearSVCAggregator linearSVCAggregator = this;
            return linearSVCAggregator;
        }
        throw new MatchError((Object)instance2);
    }

    public LinearSVCAggregator merge(LinearSVCAggregator other) {
        if (other.weightSum() != 0.0) {
            this.weightSum_$eq(this.weightSum() + other.weightSum());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            double[] localThisGradientSumArray = this.gradientSumArray();
            double[] localOtherGradientSumArray = other.gradientSumArray();
            int len = localThisGradientSumArray.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                localThisGradientSumArray[n] = localThisGradientSumArray[n] + localOtherGradientSumArray[i];
            }
        }
        return this;
    }

    public double loss() {
        return this.weightSum() != 0.0 ? this.lossSum() / this.weightSum() : 0.0;
    }

    /*
     * WARNING - void declaration
     */
    public Vector gradient() {
        Vector vector;
        if (this.weightSum() != 0.0) {
            void var1_1;
            Vector result = Vectors$.MODULE$.dense((double[])this.gradientSumArray().clone());
            BLAS$.MODULE$.scal(1.0 / this.weightSum(), result);
            vector = var1_1;
        } else {
            vector = Vectors$.MODULE$.dense(new double[this.numFeaturesPlusIntercept()]);
        }
        return vector;
    }

    public LinearSVCAggregator(Broadcast<Vector> bcCoefficients, Broadcast<double[]> bcFeaturesStd, boolean fitIntercept) {
        this.bcCoefficients = bcCoefficients;
        this.bcFeaturesStd = bcFeaturesStd;
        this.fitIntercept = fitIntercept;
        this.numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.numFeaturesPlusIntercept = fitIntercept ? this.numFeatures() + 1 : this.numFeatures();
        this.weightSum = 0.0;
        this.lossSum = 0.0;
    }
}

