/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import java.io.OutputStream;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.impl.GLMClassificationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.pmml.PMMLExportable;
import org.apache.spark.mllib.pmml.PMMLExportable$class;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.util.Saveable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0019\u0001a\u0002\u0006\r\u001fIA\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u000be\u0016<'/Z:tS>t\u0017BA\n\u0011\u0005Y9UM\\3sC2L'0\u001a3MS:,\u0017M]'pI\u0016d\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005M\u0019E.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0003vi&d\u0017BA\u0012!\u0005!\u0019\u0016M^3bE2,\u0007CA\u0013)\u001b\u00051#BA\u0014\u0005\u0003\u0011\u0001X.\u001c7\n\u0005%2#A\u0004)N\u001b2+\u0005\u0010]8si\u0006\u0014G.\u001a\u0005\tW\u0001\u0011)\u0019!C!Y\u00059q/Z5hQR\u001cX#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0011A\u00027j]\u0006dw-\u0003\u00023_\t1a+Z2u_JD3A\u000b\u001b;!\t)\u0004(D\u00017\u0015\t9d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000f\u001c\u0003\u000bMKgnY3\"\u0003m\nQ!\r\u00181]AB\u0011\"\u0010\u0001\u0003\u0002\u0003\u0006I!\f \u0002\u0011],\u0017n\u001a5ug\u0002J!a\u000b\n)\u0007q\"$\b\u0003\u0005B\u0001\t\u0015\r\u0011\"\u0011C\u0003%Ig\u000e^3sG\u0016\u0004H/F\u0001D!\tIB)\u0003\u0002F5\t1Ai\\;cY\u0016D3\u0001\u0011\u001b;\u0011%A\u0005A!A!\u0002\u0013\u0019\u0015*\u0001\u0006j]R,'oY3qi\u0002J!!\u0011\n)\u0007\u001d#$\b\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0001N\u0003-qW/\u001c$fCR,(/Z:\u0016\u00039\u0003\"!G(\n\u0005AS\"aA%oi\"\u001a1\n\u000e*\"\u0003M\u000bQ!\r\u00184]AB\u0001\"\u0016\u0001\u0003\u0002\u0003\u0006IAT\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0015\u0004)R\u0012\u0006\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A'\u0002\u00159,Xn\u00117bgN,7\u000fK\u0002XiIC\u0001b\u0017\u0001\u0003\u0002\u0003\u0006IAT\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005K\u0002[iICQA\u0018\u0001\u0005\u0002}\u000ba\u0001P5oSRtD#\u00021bG\u0016<\u0007CA\u000b\u0001\u0011\u0015YS\f1\u0001.Q\r\tGG\u000f\u0005\u0006\u0003v\u0003\ra\u0011\u0015\u0004GRR\u0004\"\u0002'^\u0001\u0004q\u0005fA35%\")\u0001,\u0018a\u0001\u001d\"\u001aq\r\u000e*)\u0007u#$\u000bC\u0004l\u0001\t\u0007I\u0011B'\u0002!\u0011\fG/Y,ji\"\u0014\u0015.Y:TSj,\u0007BB7\u0001A\u0003%a*A\teCR\fw+\u001b;i\u0005&\f7oU5{K\u0002Bqa\u001c\u0001C\u0002\u0013%\u0001/\u0001\u0007xK&<\u0007\u000e^:BeJ\f\u00170F\u0001r!\rI\"oQ\u0005\u0003gj\u0011Q!\u0011:sCfDa!\u001e\u0001!\u0002\u0013\t\u0018!D<fS\u001eDGo]!se\u0006L\b\u0005C\u0003_\u0001\u0011\u0005q\u000fF\u0002aqfDQa\u000b<A\u00025BQ!\u0011<A\u0002\rC3A\u001e\u001b;\u0011\u001da\b\u00011A\u0005\nu\f\u0011\u0002\u001e5sKNDw\u000e\u001c3\u0016\u0003y\u00042!G@D\u0013\r\t\tA\u0007\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0011!\u0004;ie\u0016\u001c\bn\u001c7e?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA\r\u0002\f%\u0019\u0011Q\u0002\u000e\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#\t\u0019!!AA\u0002y\f1\u0001\u001f\u00132\u0011\u001d\t)\u0002\u0001Q!\ny\f!\u0002\u001e5sKNDw\u000e\u001c3!\u0011\u001d\tI\u0002\u0001C\u0001\u00037\tAb]3u)\"\u0014Xm\u001d5pY\u0012$B!!\b\u0002 5\t\u0001\u0001\u0003\u0004}\u0003/\u0001\ra\u0011\u0015\u0005\u0003/!$\b\u0003\u0004\u0002&\u0001!\t!`\u0001\rO\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0005\u0003G!$\u000bC\u0004\u0002,\u0001!\t!!\f\u0002\u001d\rdW-\u0019:UQJ,7\u000f[8mIR\u0011\u0011Q\u0004\u0015\u0005\u0003S!$\bC\u0004\u00024\u0001!\t&!\u000e\u0002\u0019A\u0014X\rZ5diB{\u0017N\u001c;\u0015\u000f\r\u000b9$a\u000f\u0002@!9\u0011\u0011HA\u0019\u0001\u0004i\u0013A\u00033bi\u0006l\u0015\r\u001e:jq\"9\u0011QHA\u0019\u0001\u0004i\u0013\u0001D<fS\u001eDG/T1ue&D\bBB!\u00022\u0001\u00071\tC\u0004\u0002D\u0001!\t%!\u0012\u0002\tM\fg/\u001a\u000b\u0007\u0003\u0013\t9%a\u0015\t\u0011\u0005%\u0013\u0011\ta\u0001\u0003\u0017\n!a]2\u0011\t\u00055\u0013qJ\u0007\u0002\r%\u0019\u0011\u0011\u000b\u0004\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\u0011\u0005U\u0013\u0011\ta\u0001\u0003/\nA\u0001]1uQB!\u0011\u0011LA0\u001d\rI\u00121L\u0005\u0004\u0003;R\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002b\u0005\r$AB*ue&twMC\u0002\u0002^iAC!!\u00115%\"9\u0011\u0011\u000e\u0001\u0005R\u0005-\u0014!\u00044pe6\fGOV3sg&|g.\u0006\u0002\u0002X!9\u0011q\u000e\u0001\u0005B\u0005E\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0003\u0006\u0002\u00015\u0003k\n#!a\u001e\u0002\u000bAr\u0003H\f\u0019\b\u000f\u0005m$\u0001#\u0001\u0002~\u00059Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0004+\u0005}dAB\u0001\u0003\u0011\u0003\t\tiE\u0004\u0002\u0000\u0005\r\u0015\u0011\u0012\r\u0011\u0007e\t))C\u0002\u0002\bj\u0011a!\u00118z%\u00164\u0007\u0003B\u0010\u0002\f\u0002L1!!$!\u0005\u0019au.\u00193fe\"9a,a \u0005\u0002\u0005EECAA?\u0011!\t)*a \u0005B\u0005]\u0015\u0001\u00027pC\u0012$R\u0001YAM\u00037C\u0001\"!\u0013\u0002\u0014\u0002\u0007\u00111\n\u0005\t\u0003+\n\u0019\n1\u0001\u0002X!\"\u00111\u0013\u001bS\u0011)\t\t+a \u0002\u0002\u0013%\u00111U\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002&B!\u0011qUAY\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016\u0001\u00027b]\u001eT!!a,\u0002\t)\fg/Y\u0005\u0005\u0003g\u000bIK\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003\u007f\"$\u000b\u000b\u0003\u0002zQ\u0012\u0006")
public class LogisticRegressionModel
extends GeneralizedLinearModel
implements ClassificationModel,
Saveable,
PMMLExportable {
    private final int numFeatures;
    private final int numClasses;
    private final int org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize;
    private final double[] org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray;
    private Option<Object> threshold;

    public static LogisticRegressionModel load(SparkContext sparkContext, String string) {
        return LogisticRegressionModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public void toPMML(String localPath) {
        PMMLExportable$class.toPMML((PMMLExportable)this, localPath);
    }

    @Override
    public void toPMML(SparkContext sc, String path) {
        PMMLExportable$class.toPMML(this, sc, path);
    }

    @Override
    public void toPMML(OutputStream outputStream) {
        PMMLExportable$class.toPMML((PMMLExportable)this, outputStream);
    }

    @Override
    public String toPMML() {
        return PMMLExportable$class.toPMML(this);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    @Override
    public Vector weights() {
        return super.weights();
    }

    @Override
    public double intercept() {
        return super.intercept();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public int numClasses() {
        return this.numClasses;
    }

    public int org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize;
    }

    public double[] org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray() {
        return this.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray;
    }

    private Option<Object> threshold() {
        return this.threshold;
    }

    private void threshold_$eq(Option<Object> x$1) {
        this.threshold = x$1;
    }

    public LogisticRegressionModel setThreshold(double threshold) {
        this.threshold_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)threshold)));
        return this;
    }

    public Option<Object> getThreshold() {
        return this.threshold();
    }

    public LogisticRegressionModel clearThreshold() {
        this.threshold_$eq((Option<Object>)None$.MODULE$);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double predictPoint(Vector dataMatrix, Vector weightMatrix, double intercept) {
        double d;
        Predef$.MODULE$.require(dataMatrix.size() == this.numFeatures());
        if (this.numClasses() == 2) {
            double margin = BLAS$.MODULE$.dot(weightMatrix, dataMatrix) + intercept;
            double score = 1.0 / (1.0 + package$.MODULE$.exp(-margin));
            Option<Object> option = this.threshold();
            if (option instanceof Some) {
                Some some = (Some)option;
                double t = BoxesRunTime.unboxToDouble((Object)some.x());
                if (!(score > t)) return 0.0;
                return 1.0;
            }
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (none$ == null) {
                if (option2 != null) {
                    throw new MatchError(option);
                }
            } else if (!none$.equals(option2)) throw new MatchError(option);
            double d2 = score;
            d = d2;
            return d;
        }
        IntRef bestClass = new IntRef(0);
        DoubleRef maxMargin = new DoubleRef(0.0);
        boolean withBias = dataMatrix.size() + 1 == this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numClasses() - 1).foreach$mVc$sp((Function1)new Serializable(this, dataMatrix, bestClass, maxMargin, withBias){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;
            private final Vector dataMatrix$1;
            private final IntRef bestClass$1;
            private final DoubleRef maxMargin$1;
            private final boolean withBias$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                DoubleRef margin = new DoubleRef(0.0);
                this.dataMatrix$1.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, margin, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$predictPoint$1 $outer;
                    private final DoubleRef margin$1;
                    private final int i$1;

                    public final void apply(int index2, double value) {
                        this.apply$mcVID$sp(index2, value);
                    }

                    public void apply$mcVID$sp(int index2, double value) {
                        if (value != 0.0) {
                            this.margin$1.elem += value * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer().org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray()[this.i$1 * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer().org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() + index2];
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.margin$1 = margin$1;
                        this.i$1 = i$1;
                    }
                });
                if (this.withBias$1) {
                    margin.elem += this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray()[i * this.$outer.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize() + this.dataMatrix$1.size()];
                }
                if (margin.elem > this.maxMargin$1.elem) {
                    this.maxMargin$1.elem = margin.elem;
                    this.bestClass$1.elem = i + 1;
                }
            }

            public /* synthetic */ LogisticRegressionModel org$apache$spark$mllib$classification$LogisticRegressionModel$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataMatrix$1 = dataMatrix$1;
                this.bestClass$1 = bestClass$1;
                this.maxMargin$1 = maxMargin$1;
                this.withBias$1 = withBias$1;
            }
        });
        d = bestClass.elem;
        return d;
    }

    @Override
    public void save(SparkContext sc, String path) {
        GLMClassificationModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getClass().getName(), this.numFeatures(), this.numClasses(), this.weights(), this.intercept(), this.threshold());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", numClasses = ", ", threshold = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{super.toString(), BoxesRunTime.boxToInteger((int)this.numClasses()), this.threshold().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "None";
            }
        })}));
    }

    public LogisticRegressionModel(Vector weights, double intercept, int numFeatures, int numClasses) {
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        super(weights, intercept);
        ClassificationModel$class.$init$(this);
        PMMLExportable$class.$init$(this);
        if (numClasses == 2) {
            Predef$.MODULE$.require(weights.size() == numFeatures, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel with numClasses = 2 was given non-matching values:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numFeatures = ", ", but weights.size = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numFeatures()), BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        } else {
            int weightsSizeWithoutIntercept = (numClasses - 1) * numFeatures;
            int weightsSizeWithIntercept = (numClasses - 1) * (numFeatures + 1);
            Predef$.MODULE$.require(weights.size() == weightsSizeWithoutIntercept || weights.size() == weightsSizeWithIntercept, (Function0)new Serializable(this, weightsSizeWithoutIntercept, weightsSizeWithIntercept){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogisticRegressionModel $outer;
                private final int weightsSizeWithoutIntercept$1;
                private final int weightsSizeWithIntercept$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LogisticRegressionModel.load with numClasses = ", " and numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.$outer.numFeatures())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" expected weights of length ", " (without intercept)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithoutIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" or ", " (with intercept),"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.weightsSizeWithIntercept$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but was given weights of length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.weights().size())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.weightsSizeWithoutIntercept$1 = weightsSizeWithoutIntercept$1;
                    this.weightsSizeWithIntercept$1 = weightsSizeWithIntercept$1;
                }
            });
        }
        this.org$apache$spark$mllib$classification$LogisticRegressionModel$$dataWithBiasSize = weights.size() / (numClasses - 1);
        Vector vector = weights;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            double[] dArray = denseVector.values();
            this.org$apache$spark$mllib$classification$LogisticRegressionModel$$weightsArray = dArray;
            this.threshold = new Some((Object)BoxesRunTime.boxToDouble((double)0.5));
            return;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"weights only supports dense vector but got type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{weights.getClass()})));
    }

    public LogisticRegressionModel(Vector weights, double intercept) {
        this(weights, intercept, weights.size(), 2);
    }
}

