/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV2_0$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEf\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qA\u0003G\u000e\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u00103%\u0011!\u0004\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00039}i\u0011!\b\u0006\u0003=\u0011\tA!\u001e;jY&\u0011\u0001%\b\u0002\t'\u00064X-\u00192mK\"A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0004mC\n,Gn]\u000b\u0002IA\u0019q\"J\u0014\n\u0005\u0019\u0002\"!B!se\u0006L\bCA\b)\u0013\tI\u0003C\u0001\u0004E_V\u0014G.\u001a\u0015\u0004C-\n\u0004C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003a5\u0012QaU5oG\u0016\f\u0013AM\u0001\u0006c9\u0002d\u0006\r\u0005\ti\u0001\u0011\t\u0011)A\u0005I\u00059A.\u00192fYN\u0004\u0003fA\u001a,c!Aq\u0007\u0001BC\u0002\u0013\u00051%\u0001\u0002qS\"\u001aagK\u001d\"\u0003i\nQ\u0001\r\u0018:]AB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0004a&\u0004\u0003fA\u001e,s!Aq\b\u0001BC\u0002\u0013\u0005\u0001)A\u0003uQ\u0016$\u0018-F\u0001B!\ryQ\u0005\n\u0015\u0004}-J\u0004\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\rQDW\r^1!Q\r\u00195&\u000f\u0005\t\u000f\u0002\u0011)\u0019!C\u0001\u0011\u0006IQn\u001c3fYRK\b/Z\u000b\u0002\u0013B\u0011!*\u0014\b\u0003\u001f-K!\u0001\u0014\t\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019BA3AR\u0016RC\u0005\u0011\u0016!B\u0019/i9\u0002\u0004\u0002\u0003+\u0001\u0005\u0003\u0005\u000b\u0011B%\u0002\u00155|G-\u001a7UsB,\u0007\u0005K\u0002TWECaa\u0016\u0001\u0005\u0002\u0019A\u0016A\u0002\u001fj]&$h\bF\u0003Z5rs\u0006\r\u0005\u0002\u0016\u0001!)!E\u0016a\u0001I!\u001a!lK\u0019\t\u000b]2\u0006\u0019\u0001\u0013)\u0007q[\u0013\bC\u0003@-\u0002\u0007\u0011\tK\u0002_WeBQa\u0012,A\u0002%C3\u0001Y\u0016R\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\f\u0001\u0002]5WK\u000e$xN]\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eB\u0001\u0007Y&t\u0017\r\\4\n\u0005)<'a\u0003#f]N,g+Z2u_JDa\u0001\u001c\u0001!\u0002\u0013)\u0017!\u00039j-\u0016\u001cGo\u001c:!\u0011\u001dq\u0007A1A\u0005\n=\f1\u0002\u001e5fi\u0006l\u0015\r\u001e:jqV\t\u0001\u000f\u0005\u0002gc&\u0011!o\u001a\u0002\f\t\u0016t7/Z'biJL\u0007\u0010\u0003\u0004u\u0001\u0001\u0006I\u0001]\u0001\ri\",G/Y'biJL\u0007\u0010\t\u0005\u0007/\u0002!\t\u0001\u0002<\u0015\te;\b0\u001f\u0005\u0006EU\u0004\r\u0001\n\u0005\u0006oU\u0004\r\u0001\n\u0005\u0006\u007fU\u0004\r!\u0011\u0005\u0007/\u0002!\t\u0001B>\u0015\rec\u00181BA\u0007\u0011\u0015\u0011#\u00101\u0001~!\u0011q\u0018qA\u0014\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A.\u00198h\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\nA\u0011\n^3sC\ndW\rC\u00038u\u0002\u0007Q\u0010\u0003\u0004@u\u0002\u0007\u0011q\u0002\t\u0005}\u0006\u001dQ\u0010C\u0005\u0002\u0014\u0001\t\t\u0015!\u0003\u0002\u0016\u0005\u0019\u0001\u0010\n\u001a\u0011\u000f=\t9\"a\u0007\u0002\"%\u0019\u0011\u0011\u0004\t\u0003\rQ+\b\u000f\\33!\u0011y\u0011Q\u00049\n\u0007\u0005}\u0001C\u0001\u0004PaRLwN\u001c\t\u0005\u001f\u0005uQ\rC\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(\u0005\u0011B\u000f[3uC6Kg.^:OK\u001e$\u0006.\u001a;b+\t\tY\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u000e\u0003M!\b.\u001a;b\u001b&tWo\u001d(fORCW\r^1!\u0011%\ty\u0003\u0001b\u0001\n\u0013\t\t$A\u0006oK\u001e$\u0006.\u001a;b'VlWCAA\u0011\u0011!\t)\u0004\u0001Q\u0001\n\u0005\u0005\u0012\u0001\u00048fORCW\r^1Tk6\u0004\u0003bBA\u001d\u0001\u0011\u0005\u00131H\u0001\baJ,G-[2u)\u0011\ti$!\u0013\u0011\u000b\u0005}\u0012QI\u0014\u000e\u0005\u0005\u0005#bAA\"\r\u0005\u0019!\u000f\u001a3\n\t\u0005\u001d\u0013\u0011\t\u0002\u0004%\u0012#\u0005\u0002CA&\u0003o\u0001\r!!\u0014\u0002\u0011Q,7\u000f\u001e#bi\u0006\u0004b!a\u0010\u0002F\u0005=\u0003c\u00014\u0002R%\u0019\u00111K4\u0003\rY+7\r^8sQ\u0011\t9dK\u0019\t\u000f\u0005e\u0002\u0001\"\u0011\u0002ZQ\u0019q%a\u0017\t\u0011\u0005-\u0013q\u000ba\u0001\u0003\u001fBC!a\u0016,c!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014\u0001\u00069sK\u0012L7\r\u001e)s_\n\f'-\u001b7ji&,7\u000f\u0006\u0003\u0002N\u0005\u0015\u0004\u0002CA&\u0003?\u0002\r!!\u0014)\u000b\u0005}3&!\u001b\"\u0005\u0005-\u0014!B\u0019/k9\u0002\u0004bBA1\u0001\u0011\u0005\u0011q\u000e\u000b\u0005\u0003\u001f\n\t\b\u0003\u0005\u0002L\u00055\u0004\u0019AA(Q\u0015\tigKA5\u0011\u001d\t9\b\u0001C\u0005\u0003s\na#\\;mi&tw.\\5bY\u000e\u000bGnY;mCRLwN\u001c\u000b\u0004K\u0006m\u0004\u0002CA&\u0003k\u0002\r!a\u0014\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u0006!\"-\u001a:o_VdG.[\"bY\u000e,H.\u0019;j_:$2!ZAB\u0011!\tY%! A\u0002\u0005=\u0003bBAD\u0001\u0011%\u0011\u0011R\u0001\u0017a>\u001cH/\u001a:j_J\u0004&o\u001c2bE&d\u0017\u000e^5fgR\u0019Q-a#\t\u000f\u00055\u0015Q\u0011a\u0001K\u00069An\\4Qe>\u0014\u0007bBAI\u0001\u0011\u0005\u00131S\u0001\u0005g\u00064X\r\u0006\u0004\u0002\u0016\u0006m\u0015q\u0015\t\u0004\u001f\u0005]\u0015bAAM!\t!QK\\5u\u0011!\ti*a$A\u0002\u0005}\u0015AA:d!\u0011\t\t+a)\u000e\u0003\u0019I1!!*\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u001d\tI+a$A\u0002%\u000bA\u0001]1uQ\"*\u0011qR\u0016\u0002.\u0006\u0012\u0011qV\u0001\u0006c9\u001ad\u0006\r\u0005\u0007\u0003g\u0003A\u0011\u000b%\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8oQ\r\u00011&O\u0004\b\u0003s\u0013\u0001\u0012AA^\u0003=q\u0015-\u001b<f\u0005\u0006LXm]'pI\u0016d\u0007cA\u000b\u0002>\u001a1\u0011A\u0001E\u0001\u0003\u007f\u001bb!!0\u000f\u0003\u0003D\u0002\u0003\u0002\u000f\u0002DfK1!!2\u001e\u0005\u0019au.\u00193fe\"9q+!0\u0005\u0002\u0005%GCAA^\u000f%\ti-!0\t\u0002\u0011\ty-\u0001\u0007TCZ,Gj\\1e-Jz\u0006\u0007\u0005\u0003\u0002R\u0006MWBAA_\r%\t).!0\t\u0002\u0011\t9N\u0001\u0007TCZ,Gj\\1e-Jz\u0006gE\u0002\u0002T:AqaVAj\t\u0003\tY\u000e\u0006\u0002\u0002P\"9\u0011q\\Aj\t\u0003A\u0015!\u0005;iSN4uN]7biZ+'o]5p]\"9\u00111]Aj\t\u0003A\u0015!\u0004;iSN\u001cE.Y:t\u001d\u0006lWMB\u0004\u0002h\u0006M\u0007)!;\u0003\t\u0011\u000bG/Y\n\u0007\u0003Kt\u00111\u001e\r\u0011\u0007=\ti/C\u0002\u0002pB\u0011q\u0001\u0015:pIV\u001cG\u000fC\u0005#\u0003K\u0014)\u001a!C\u0001G!IA'!:\u0003\u0012\u0003\u0006I\u0001\n\u0005\no\u0005\u0015(Q3A\u0005\u0002\rB\u0011\u0002PAs\u0005#\u0005\u000b\u0011\u0002\u0013\t\u0013}\n)O!f\u0001\n\u0003\u0001\u0005\"\u0003#\u0002f\nE\t\u0015!\u0003B\u0011%9\u0015Q\u001dBK\u0002\u0013\u0005\u0001\nC\u0005U\u0003K\u0014\t\u0012)A\u0005\u0013\"9q+!:\u0005\u0002\t\rAC\u0003B\u0003\u0005\u0013\u0011YA!\u0004\u0003\u0010A!!qAAs\u001b\t\t\u0019\u000e\u0003\u0004#\u0005\u0003\u0001\r\u0001\n\u0005\u0007o\t\u0005\u0001\u0019\u0001\u0013\t\r}\u0012\t\u00011\u0001B\u0011\u00199%\u0011\u0001a\u0001\u0013\"Q!1CAs\u0003\u0003%\tA!\u0006\u0002\t\r|\u0007/\u001f\u000b\u000b\u0005\u000b\u00119B!\u0007\u0003\u001c\tu\u0001\u0002\u0003\u0012\u0003\u0012A\u0005\t\u0019\u0001\u0013\t\u0011]\u0012\t\u0002%AA\u0002\u0011B\u0001b\u0010B\t!\u0003\u0005\r!\u0011\u0005\t\u000f\nE\u0001\u0013!a\u0001\u0013\"Q!\u0011EAs#\u0003%\tAa\t\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0005\u0016\u0004I\t\u001d2F\u0001B\u0015!\u0011\u0011YCa\r\u000e\u0005\t5\"\u0002\u0002B\u0018\u0005c\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00059\u0002\u0012\u0002\u0002B\u001b\u0005[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011I$!:\u0012\u0002\u0013\u0005!1E\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011i$!:\u0012\u0002\u0013\u0005!qH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tEK\u0002B\u0005OA!B!\u0012\u0002fF\u0005I\u0011\u0001B$\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"A!\u0013+\u0007%\u00139\u0003\u0003\u0006\u0003N\u0005\u0015\u0018\u0011!C!\u0005\u001f\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B)!\rq(1K\u0005\u0003\u001d~D!Ba\u0016\u0002f\u0006\u0005I\u0011\u0001B-\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011Y\u0006E\u0002\u0010\u0005;J1Aa\u0018\u0011\u0005\rIe\u000e\u001e\u0005\u000b\u0005G\n)/!A\u0005\u0002\t\u0015\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0012i\u0007E\u0002\u0010\u0005SJ1Aa\u001b\u0011\u0005\r\te.\u001f\u0005\u000b\u0005_\u0012\t'!AA\u0002\tm\u0013a\u0001=%c!Q!1OAs\u0003\u0003%\tE!\u001e\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u001e\u0011\r\te$q\u0010B4\u001b\t\u0011YHC\u0002\u0003~A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\tIa\u001f\u0003\u0011%#XM]1u_JD!B!\"\u0002f\u0006\u0005I\u0011\u0001BD\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BE\u0005\u001f\u00032a\u0004BF\u0013\r\u0011i\t\u0005\u0002\b\u0005>|G.Z1o\u0011)\u0011yGa!\u0002\u0002\u0003\u0007!q\r\u0005\u000b\u0005'\u000b)/!A\u0005B\tU\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\tm\u0003B\u0003BM\u0003K\f\t\u0011\"\u0011\u0003\u001c\u0006AAo\\*ue&tw\r\u0006\u0002\u0003R!Q!qTAs\u0003\u0003%\tE!)\u0002\r\u0015\fX/\u00197t)\u0011\u0011IIa)\t\u0015\t=$QTA\u0001\u0002\u0004\u00119g\u0002\u0006\u0003(\u0006M\u0017\u0011!E\u0001\u0005S\u000bA\u0001R1uCB!!q\u0001BV\r)\t9/a5\u0002\u0002#\u0005!QV\n\u0006\u0005W\u0013y\u000b\u0007\t\u000b\u0005c\u00139\f\n\u0013B\u0013\n\u0015QB\u0001BZ\u0015\r\u0011)\fE\u0001\beVtG/[7f\u0013\u0011\u0011ILa-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007C\u0004X\u0005W#\tA!0\u0015\u0005\t%\u0006B\u0003BM\u0005W\u000b\t\u0011\"\u0012\u0003\u001c\"Q!1\u0019BV\u0003\u0003%\tI!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0015\t\u0015!q\u0019Be\u0005\u0017\u0014i\r\u0003\u0004#\u0005\u0003\u0004\r\u0001\n\u0005\u0007o\t\u0005\u0007\u0019\u0001\u0013\t\r}\u0012\t\r1\u0001B\u0011\u00199%\u0011\u0019a\u0001\u0013\"Q!\u0011\u001bBV\u0003\u0003%\tIa5\u0002\u000fUt\u0017\r\u001d9msR!!Q\u001bBo!\u0015y\u0011Q\u0004Bl!\u001dy!\u0011\u001c\u0013%\u0003&K1Aa7\u0011\u0005\u0019!V\u000f\u001d7fi!Q!q\u001cBh\u0003\u0003\u0005\rA!\u0002\u0002\u0007a$\u0003\u0007\u0003\u0006\u0003d\n-\u0016\u0011!C\u0005\u0005K\f1B]3bIJ+7o\u001c7wKR\u0011!q\u001d\t\u0004}\n%\u0018b\u0001Bv\u007f\n1qJ\u00196fGRD\u0001\"!%\u0002T\u0012\u0005!q\u001e\u000b\t\u0003+\u0013\tPa=\u0003v\"A\u0011Q\u0014Bw\u0001\u0004\ty\nC\u0004\u0002*\n5\b\u0019A%\t\u0011\t](Q\u001ea\u0001\u0005\u000b\tA\u0001Z1uC\"A!1`Aj\t\u0003\u0011i0\u0001\u0003m_\u0006$G#B-\u0003\u0000\u000e\u0005\u0001\u0002CAO\u0005s\u0004\r!a(\t\u000f\u0005%&\u0011 a\u0001\u0013\"*!\u0011`\u0016\u0002.\u001eI1qAA_\u0011\u0003!1\u0011B\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0003#\u001cYAB\u0005\u0004\u000e\u0005u\u0006\u0012\u0001\u0003\u0004\u0010\ta1+\u0019<f\u0019>\fGMV\u0019`aM\u001911\u0002\b\t\u000f]\u001bY\u0001\"\u0001\u0004\u0014Q\u00111\u0011\u0002\u0005\b\u0003?\u001cY\u0001\"\u0001I\u0011\u001d\t\u0019oa\u0003\u0005\u0002!3q!a:\u0004\f\u0001\u001bYb\u0005\u0004\u0004\u001a9\tY\u000f\u0007\u0005\nE\re!Q3A\u0005\u0002\rB\u0011\u0002NB\r\u0005#\u0005\u000b\u0011\u0002\u0013\t\u0013]\u001aIB!f\u0001\n\u0003\u0019\u0003\"\u0003\u001f\u0004\u001a\tE\t\u0015!\u0003%\u0011%y4\u0011\u0004BK\u0002\u0013\u0005\u0001\tC\u0005E\u00073\u0011\t\u0012)A\u0005\u0003\"9qk!\u0007\u0005\u0002\r-B\u0003CB\u0017\u0007c\u0019\u0019d!\u000e\u0011\t\r=2\u0011D\u0007\u0003\u0007\u0017AaAIB\u0015\u0001\u0004!\u0003BB\u001c\u0004*\u0001\u0007A\u0005\u0003\u0004@\u0007S\u0001\r!\u0011\u0005\u000b\u0005'\u0019I\"!A\u0005\u0002\reB\u0003CB\u0017\u0007w\u0019ida\u0010\t\u0011\t\u001a9\u0004%AA\u0002\u0011B\u0001bNB\u001c!\u0003\u0005\r\u0001\n\u0005\t\u007f\r]\u0002\u0013!a\u0001\u0003\"Q!\u0011EB\r#\u0003%\tAa\t\t\u0015\te2\u0011DI\u0001\n\u0003\u0011\u0019\u0003\u0003\u0006\u0003>\re\u0011\u0013!C\u0001\u0005\u007fA!B!\u0014\u0004\u001a\u0005\u0005I\u0011\tB(\u0011)\u00119f!\u0007\u0002\u0002\u0013\u0005!\u0011\f\u0005\u000b\u0005G\u001aI\"!A\u0005\u0002\r5C\u0003\u0002B4\u0007\u001fB!Ba\u001c\u0004L\u0005\u0005\t\u0019\u0001B.\u0011)\u0011\u0019h!\u0007\u0002\u0002\u0013\u0005#Q\u000f\u0005\u000b\u0005\u000b\u001bI\"!A\u0005\u0002\rUC\u0003\u0002BE\u0007/B!Ba\u001c\u0004T\u0005\u0005\t\u0019\u0001B4\u0011)\u0011\u0019j!\u0007\u0002\u0002\u0013\u0005#Q\u0013\u0005\u000b\u00053\u001bI\"!A\u0005B\tm\u0005B\u0003BP\u00073\t\t\u0011\"\u0011\u0004`Q!!\u0011RB1\u0011)\u0011yg!\u0018\u0002\u0002\u0003\u0007!qM\u0004\u000b\u0005O\u001bY!!A\t\u0002\r\u0015\u0004\u0003BB\u0018\u0007O2!\"a:\u0004\f\u0005\u0005\t\u0012AB5'\u0015\u00199ga\u001b\u0019!%\u0011\tl!\u001c%I\u0005\u001bi#\u0003\u0003\u0004p\tM&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9qka\u001a\u0005\u0002\rMDCAB3\u0011)\u0011Ija\u001a\u0002\u0002\u0013\u0015#1\u0014\u0005\u000b\u0005\u0007\u001c9'!A\u0005\u0002\u000eeD\u0003CB\u0017\u0007w\u001aiha \t\r\t\u001a9\b1\u0001%\u0011\u001994q\u000fa\u0001I!1qha\u001eA\u0002\u0005C!B!5\u0004h\u0005\u0005I\u0011QBB)\u0011\u0019)i!$\u0011\u000b=\tiba\"\u0011\r=\u0019I\t\n\u0013B\u0013\r\u0019Y\t\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\t}7\u0011QA\u0001\u0002\u0004\u0019i\u0003\u0003\u0006\u0003d\u000e\u001d\u0014\u0011!C\u0005\u0005KD\u0001\"!%\u0004\f\u0011\u000511\u0013\u000b\t\u0003+\u001b)ja&\u0004\u001a\"A\u0011QTBI\u0001\u0004\ty\nC\u0004\u0002*\u000eE\u0005\u0019A%\t\u0011\t]8\u0011\u0013a\u0001\u0007[A\u0001Ba?\u0004\f\u0011\u00051Q\u0014\u000b\u00063\u000e}5\u0011\u0015\u0005\t\u0003;\u001bY\n1\u0001\u0002 \"9\u0011\u0011VBN\u0001\u0004I\u0005\u0002\u0003B~\u0003{#\te!*\u0015\u000be\u001b9k!+\t\u0011\u0005u51\u0015a\u0001\u0003?Cq!!+\u0004$\u0002\u0007\u0011\n\u0003\u0006\u0003d\u0006u\u0016\u0011!C\u0005\u0005KDS!!0,\u0003[CS!a.,\u0003[\u0003")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final String modelType;
    private final DenseVector piVector;
    private final DenseMatrix thetaMatrix;
    private final Tuple2<Option<DenseMatrix>, Option<DenseVector>> x$2;
    private final Option<DenseMatrix> thetaMinusNegTheta;
    private final Option<DenseVector> negThetaSum;

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    public String modelType() {
        return this.modelType;
    }

    private DenseVector piVector() {
        return this.piVector;
    }

    private DenseMatrix thetaMatrix() {
        return this.thetaMatrix;
    }

    private Option<DenseMatrix> thetaMinusNegTheta() {
        return this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return this.negThetaSum;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1)new Serializable(this, bcModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcModel$1;

            public final Iterator<Object> apply(Iterator<Vector> iter) {
                NaiveBayesModel model = (NaiveBayesModel)this.bcModel$1.value();
                return iter.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$1;

                    public final double apply(Vector testData) {
                        return this.model$1.predict(testData);
                    }
                    {
                        this.model$1 = model$1;
                    }
                });
            }
            {
                this.bcModel$1 = bcModel$1;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        String string;
        block4: {
            double d;
            block3: {
                block2: {
                    string = this.modelType();
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    d = this.labels()[this.multinomialCalculation(testData).argmax()];
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                d = this.labels()[this.bernoulliCalculation(testData).argmax()];
            }
            return d;
        }
        throw new MatchError((Object)string);
    }

    public RDD<Vector> predictProbabilities(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1)new Serializable(this, bcModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcModel$2;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                NaiveBayesModel model = (NaiveBayesModel)this.bcModel$2.value();
                return iter.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$2;

                    public final Vector apply(Vector testData) {
                        return this.model$2.predictProbabilities(testData);
                    }
                    {
                        this.model$2 = model$2;
                    }
                });
            }
            {
                this.bcModel$2 = bcModel$2;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
    }

    public Vector predictProbabilities(Vector testData) {
        String string;
        block4: {
            DenseVector denseVector;
            block3: {
                block2: {
                    string = this.modelType();
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    denseVector = this.posteriorProbabilities(this.multinomialCalculation(testData));
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                denseVector = this.posteriorProbabilities(this.bernoulliCalculation(testData));
            }
            return denseVector;
        }
        throw new MatchError((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector testData) {
        void var2_2;
        DenseVector prob2 = this.thetaMatrix().multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob2);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector testData) {
        void var2_2;
        testData.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, testData){
            public static final long serialVersionUID = 0L;
            private final Vector testData$1;

            public final void apply(int x$3, double value) {
                this.apply$mcVID$sp(x$3, value);
            }

            public void apply$mcVID$sp(int x$3, double value) {
                if (value != 0.0 && value != 1.0) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.testData$1})));
                }
            }
            {
                this.testData$1 = testData$1;
            }
        });
        DenseVector prob2 = ((Matrix)this.thetaMinusNegTheta().get()).multiply(testData);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.piVector(), (Vector)prob2);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob2);
        return var2_2;
    }

    private DenseVector posteriorProbabilities(DenseVector logProb) {
        double[] logProbArray = logProb.toArray();
        double maxLog = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(logProbArray).max((Ordering)Ordering.Double$.MODULE$));
        double[] scaledProbs = (double[])Predef$.MODULE$.doubleArrayOps(logProbArray).map((Function1)new Serializable(this, maxLog){
            public static final long serialVersionUID = 0L;
            private final double maxLog$1;

            public final double apply(double lp) {
                return this.apply$mcDD$sp(lp);
            }

            public double apply$mcDD$sp(double lp) {
                return package$.MODULE$.exp(lp - this.maxLog$1);
            }
            {
                this.maxLog$1 = maxLog$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double probSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(scaledProbs).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return new DenseVector((double[])Predef$.MODULE$.doubleArrayOps(scaledProbs).map((Function1)new Serializable(this, probSum){
            public static final long serialVersionUID = 0L;
            private final double probSum$1;

            public final double apply(double x$4) {
                return this.apply$mcDD$sp(x$4);
            }

            public double apply$mcDD$sp(double x$4) {
                return x$4 / this.probSum$1;
            }
            {
                this.probSum$1 = probSum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV2_0.Data data = new SaveLoadV2_0.Data(this.labels(), this.pi(), this.theta(), this.modelType());
        NaiveBayesModel$SaveLoadV2_0$.MODULE$.save(sc, path, data);
    }

    @Override
    public String formatVersion() {
        return "2.0";
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta, String modelType) {
        block6: {
            Tuple2 tuple2;
            block5: {
                String string;
                block4: {
                    this.labels = labels;
                    this.pi = pi;
                    this.theta = theta;
                    this.modelType = modelType;
                    ClassificationModel$class.$init$(this);
                    this.piVector = new DenseVector(pi);
                    this.thetaMatrix = new DenseMatrix(labels.length, theta[0].length, (double[])Predef$.MODULE$.refArrayOps((Object[])theta).flatten((Function1)new $anonfun$6(this), ClassTag$.MODULE$.Double()), true);
                    Predef$.MODULE$.require(NaiveBayes$.MODULE$.supportedModelTypes().contains((Object)modelType), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ NaiveBayesModel $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType ", ". Supported modelTypes are ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.modelType(), NaiveBayes$.MODULE$.supportedModelTypes()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    string = modelType;
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block4;
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                    break block5;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block6;
                Matrix negTheta = this.thetaMatrix().map((Function1)new $anonfun$1(this));
                DenseVector ones2 = new DenseVector((double[])Array$.MODULE$.fill(this.thetaMatrix().numCols(), (Function0)new $anonfun$2(this), ClassTag$.MODULE$.Double()));
                Matrix thetaMinusNegTheta = this.thetaMatrix().map((Function1)new $anonfun$3(this));
                tuple2 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)((DenseMatrix)negTheta).multiply(ones2)));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Option thetaMinusNegTheta = (Option)tuple22._1();
                Option negThetaSum = (Option)tuple22._2();
                this.x$2 = tuple23 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
                this.thetaMinusNegTheta = (Option)this.x$2._1();
                this.negThetaSum = (Option)this.x$2._2();
                return;
            }
            throw new MatchError((Object)tuple22);
        }
        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modelType})));
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this(labels, pi, theta, NaiveBayes$.MODULE$.Multinomial());
    }

    public NaiveBayesModel(Iterable<Object> labels, Iterable<Object> pi, Iterable<Iterable<Object>> theta) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(labels).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(pi).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[][])Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(theta).asScala()).toArray(ClassTag$.MODULE$.apply(Iterable.class))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(Iterable<Object> x$1) {
                return (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).toArray(ClassTag$.MODULE$.Double());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))));
    }
}

