/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\ruc\u0001B\u0001\u0003\u00015\u0011!\u0002\u0015:fM&D8\u000b]1o\u0015\t\u0019A!A\u0002ga6T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQQ\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007CA\b\u001c\u0013\ta\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001f\u0001\t\u0005\r\u0011\"\u0003 \u0003)i\u0017N\\*vaB|'\u000f^\u000b\u0002AA\u0011q\"I\u0005\u0003EA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0013\u0001\u0005\u0003\u0007I\u0011B\u0013\u0002\u001d5LgnU;qa>\u0014Ho\u0018\u0013fcR\u0011a%\u000b\t\u0003\u001f\u001dJ!\u0001\u000b\t\u0003\tUs\u0017\u000e\u001e\u0005\bU\r\n\t\u00111\u0001!\u0003\rAH%\r\u0005\tY\u0001\u0011\t\u0011)Q\u0005A\u0005YQ.\u001b8TkB\u0004xN\u001d;!\u0011!q\u0003A!a\u0001\n\u0013y\u0013\u0001E7bqB\u000bG\u000f^3s]2+gn\u001a;i+\u0005\u0001\u0004CA\b2\u0013\t\u0011\u0004CA\u0002J]RD\u0001\u0002\u000e\u0001\u0003\u0002\u0004%I!N\u0001\u0015[\u0006D\b+\u0019;uKJtG*\u001a8hi\"|F%Z9\u0015\u0005\u00192\u0004b\u0002\u00164\u0003\u0003\u0005\r\u0001\r\u0005\tq\u0001\u0011\t\u0011)Q\u0005a\u0005\tR.\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u0011\t\u0011i\u0002!\u00111A\u0005\nm\n!#\\1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KV\tA\b\u0005\u0002\u0010{%\u0011a\b\u0005\u0002\u0005\u0019>tw\r\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0003Yi\u0017\r\u001f'pG\u0006d\u0007K]8k\t\n\u001b\u0016N_3`I\u0015\fHC\u0001\u0014C\u0011\u001dQs(!AA\u0002qB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006K\u0001P\u0001\u0014[\u0006DHj\\2bYB\u0013xN\u001b#C'&TX\r\t\u0005\u0006\r\u0002!IaR\u0001\u0007y%t\u0017\u000e\u001e \u0015\t!S5\n\u0014\t\u0003\u0013\u0002i\u0011A\u0001\u0005\u0006=\u0015\u0003\r\u0001\t\u0005\u0006]\u0015\u0003\r\u0001\r\u0005\u0006u\u0015\u0003\r\u0001\u0010\u0005\u0006\r\u0002!\tA\u0014\u000b\u0002\u0011\"\u001aQ\n\u0015,\u0011\u0005E#V\"\u0001*\u000b\u0005M3\u0011AC1o]>$\u0018\r^5p]&\u0011QK\u0015\u0002\u0006'&t7-Z\u0011\u0002/\u0006)\u0011GL\u001b/a!)\u0011\f\u0001C\u0001?\u0005iq-\u001a;NS:\u001cV\u000f\u001d9peRD3\u0001\u0017)W\u0011\u0015a\u0006\u0001\"\u0001^\u00035\u0019X\r^'j]N+\b\u000f]8siR\u0011alX\u0007\u0002\u0001!)ad\u0017a\u0001A!\u001a1\f\u0015,\t\u000b\t\u0004A\u0011A\u0018\u0002'\u001d,G/T1y!\u0006$H/\u001a:o\u0019\u0016tw\r\u001e5)\u0007\u0005\u0004f\u000bC\u0003f\u0001\u0011\u0005a-A\ntKRl\u0015\r\u001f)biR,'O\u001c'f]\u001e$\b\u000e\u0006\u0002_O\")a\u0006\u001aa\u0001a!\u001aA\r\u0015,\t\u000b)\u0004A\u0011A\u001e\u0002+\u001d,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{K\"\u001a\u0011\u000e\u0015,\t\u000b5\u0004A\u0011\u00018\u0002+M,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KR\u0011al\u001c\u0005\u0006u1\u0004\r\u0001\u0010\u0015\u0004YB3\u0006\"\u0002:\u0001\t\u0003\u0019\u0018a\u0001:v]V\u0011Ao\u001f\u000b\u0004k\u0006eAc\u0001<\u0002\nA\u0019\u0011j^=\n\u0005a\u0014!a\u0004)sK\u001aL\u0007p\u00159b]6{G-\u001a7\u0011\u0005i\\H\u0002\u0001\u0003\u0006yF\u0014\r! \u0002\u0005\u0013R,W.E\u0002\u007f\u0003\u0007\u0001\"aD@\n\u0007\u0005\u0005\u0001CA\u0004O_RD\u0017N\\4\u0011\u0007=\t)!C\u0002\u0002\bA\u00111!\u00118z\u0011%\tY!]A\u0001\u0002\b\ti!\u0001\u0006fm&$WM\\2fIE\u0002R!a\u0004\u0002\u0016el!!!\u0005\u000b\u0007\u0005M\u0001#A\u0004sK\u001adWm\u0019;\n\t\u0005]\u0011\u0011\u0003\u0002\t\u00072\f7o\u001d+bO\"9\u00111D9A\u0002\u0005u\u0011\u0001\u00023bi\u0006\u0004b!a\b\u0002&\u0005%RBAA\u0011\u0015\r\t\u0019CB\u0001\u0004e\u0012$\u0017\u0002BA\u0014\u0003C\u00111A\u0015#E!\u0015y\u00111FA\u0018\u0013\r\ti\u0003\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005\u001f\u0005-\u0012\u0010K\u0002r!ZCaA\u001d\u0001\u0005\u0002\u0005UR\u0003CA\u001c\u0003{\tI'a\u0015\u0015\t\u0005e\u0012q\b\t\u0005\u0013^\fY\u0004E\u0002{\u0003{!a\u0001`A\u001a\u0005\u0004i\b\u0002CA\u000e\u0003g\u0001\r!!\u0011\u0011\r\u0005\r\u0013QJA)\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00026bm\u0006T1!a\u0013\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\n)EA\u0004KCZ\f'\u000b\u0012#\u0011\u0007i\f\u0019\u0006\u0002\u0005\u0002V\u0005M\"\u0019AA,\u0005!\u0019V-];f]\u000e,\u0017c\u0001@\u0002ZA1\u00111LA2\u0003Oj!!!\u0018\u000b\t\u0005}\u0013\u0011M\u0001\u0005Y\u0006twM\u0003\u0002\u0002H%!\u0011QMA/\u0005!IE/\u001a:bE2,\u0007c\u0001>\u0002j\u0011A\u00111NA\u001a\u0005\u0004\tiGA\u0004Ji\u0016l7/\u001a;\u0012\u0007y\fy\u0007\u0005\u0004\u0002\\\u0005\r\u00141\b\u0015\u0005\u0003g\u0001f\u000bK\u0002\u0001!Z;q!a\u001e\u0003\u0011\u0003\tI(\u0001\u0006Qe\u00164\u0017\u000e_*qC:\u00042!SA>\r\u0019\t!\u0001#\u0001\u0002~M)\u00111\u0010\b\u00155!9a)a\u001f\u0005\u0002\u0005\u0005ECAA=\u0011%\t))a\u001f\u0005\u0002\t\t9)A\tgS:$gI]3rk\u0016tG/\u0013;f[N,B!!#\u0002\u0012R1\u00111RAM\u0003?#B!!$\u0002\u0014B)q\"a\u000b\u0002\u0010B\u0019!0!%\u0005\rq\f\u0019I1\u0001~\u0011)\t)*a!\u0002\u0002\u0003\u000f\u0011qS\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA\b\u0003+\ty\t\u0003\u0005\u0002\u001c\u0005\r\u0005\u0019AAN!\u0019\ty\"!\n\u0002\u001eB)q\"a\u000b\u0002\u000e\"9\u0011\u0011UAB\u0001\u0004a\u0014\u0001C7j]\u000e{WO\u001c;\t\u0013\u0005\u0015\u00161\u0010C\u0001\u0005\u0005\u001d\u0016A\u0006;p\t\u0006$\u0018MY1tK&sG/\u001a:oC2\u0014V\r\u001d:\u0016\t\u0005%\u0016\u0011\u0018\u000b\u0007\u0003W\u000bY,a1\u0015\t\u00055\u0016\u0011\u0017\t\u0007\u0003?\t)#a,\u0011\t=\tY\u0003\r\u0005\u000b\u0003g\u000b\u0019+!AA\u0004\u0005U\u0016AC3wS\u0012,gnY3%gA1\u0011qBA\u000b\u0003o\u00032A_A]\t\u0019a\u00181\u0015b\u0001{\"A\u00111DAR\u0001\u0004\ti\f\u0005\u0004\u0002 \u0005\u0015\u0012q\u0018\t\u0006\u001f\u0005-\u0012\u0011\u0019\t\u0006\u001f\u0005-\u0012q\u0017\u0005\t\u0003\u000b\f\u0019\u000b1\u0001\u0002H\u0006I\u0011\u000e^3n)>Le\u000e\u001e\t\b\u0003\u0013\fy-a.1\u001d\ry\u00111Z\u0005\u0004\u0003\u001b\u0004\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0006M'aA'ba*\u0019\u0011Q\u001a\t\t\u0013\u0005]\u00171\u0010C\u0001\u0005\u0005e\u0017aD4f]\u001a\u0013X-\u001d)biR,'O\\:\u0015\u0015\u0005m\u00171]As\u0003O\fI\u000f\u0005\u0004\u0002 \u0005\u0015\u0012Q\u001c\t\u0007\u001f\u0005}\u0017q\u0016\u001f\n\u0007\u0005\u0005\bC\u0001\u0004UkBdWM\r\u0005\t\u00037\t)\u000e1\u0001\u0002.\"9\u0011\u0011UAk\u0001\u0004a\u0004B\u0002\u0018\u0002V\u0002\u0007\u0001\u0007\u0003\u0004;\u0003+\u0004\r\u0001\u0010\u0004\t\u0003[\fY\b\u0001\u0002\u0002p\n1\u0001K]3gSb\u001cB!a;\u000f5!Y\u00111_Av\u0005\u000b\u0007I\u0011AA{\u0003\u0015IG/Z7t+\t\ty\u000bC\u0006\u0002z\u0006-(\u0011!Q\u0001\n\u0005=\u0016AB5uK6\u001c\b\u0005\u0003\u0006\u0002~\u0006-(Q1A\u0005\u0002=\na\u0001\\3oORD\u0007B\u0003B\u0001\u0003W\u0014\t\u0011)A\u0005a\u00059A.\u001a8hi\"\u0004\u0003b\u0002$\u0002l\u0012%!Q\u0001\u000b\u0007\u0005\u000f\u0011YA!\u0004\u0011\t\t%\u00111^\u0007\u0003\u0003wB\u0001\"a=\u0003\u0004\u0001\u0007\u0011q\u0016\u0005\b\u0003{\u0014\u0019\u00011\u00011\u0011%\u0011\t\"a;C\u0002\u0013\u0005q&\u0001\u0002jI\"A!QCAvA\u0003%\u0001'A\u0002jI\u0002B\u0001B!\u0007\u0002l\u0012\u0005!1D\u0001\fI\r|Gn\u001c8%a2,8\u000f\u0006\u0003\u0003\b\tu\u0001b\u0002B\u0010\u0005/\u0001\r\u0001M\u0001\u0005SR,WnB\u0005\u0003$\u0005m\u0004\u0012\u0001\u0002\u0003&\u00051\u0001K]3gSb\u0004BA!\u0003\u0003(\u0019I\u0011Q^A>\u0011\u0003\u0011!\u0011F\n\u0005\u0005Oq!\u0004C\u0004G\u0005O!\tA!\f\u0015\u0005\t\u0015\u0002B\u0003B\u0019\u0005O\u0011\r\u0011\"\u0003\u00034\u000591m\\;oi\u0016\u0014XC\u0001B\u001b!\u0011\u00119D!\u0012\u000e\u0005\te\"\u0002\u0002B\u001e\u0005{\ta!\u0019;p[&\u001c'\u0002\u0002B \u0005\u0003\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\u0011\u0019%!\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u000f\u0012IDA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\n\u0005\u0017\u00129\u0003)A\u0005\u0005k\t\u0001bY8v]R,'\u000f\t\u0005\b\u0005\u001f\u00129\u0003\"\u00030\u0003\u0019qW\r\u001f;JI\"Q!1\u000bB\u0014\u0005\u0004%\tA!\u0016\u0002\u000b\u0015l\u0007\u000f^=\u0016\u0005\t\u001d\u0001\"\u0003B-\u0005O\u0001\u000b\u0011\u0002B\u0004\u0003\u0019)W\u000e\u001d;zA!Q!Q\fB\u0014\u0003\u0003%IAa\u0018\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005C\u0002B!a\u0017\u0003d%!!QMA/\u0005\u0019y%M[3di\u001aA!\u0011NA>\u0001\t\u0011YGA\u0004Q_N$h-\u001b=\u0014\t\t\u001ddB\u0007\u0005\f\u0003g\u00149G!b\u0001\n\u0003\t)\u0010C\u0006\u0002z\n\u001d$\u0011!Q\u0001\n\u0005=\u0006B\u0003B:\u0005O\u0012)\u0019!C\u0001_\u0005)1\u000f^1si\"Q!q\u000fB4\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\rM$\u0018M\u001d;!\u0011-\u0011YHa\u001a\u0003\u0006\u0004%\t!!>\u0002\u001bA\f'\u000f^5bYN#\u0018M\u001d;t\u0011-\u0011yHa\u001a\u0003\u0002\u0003\u0006I!a,\u0002\u001dA\f'\u000f^5bYN#\u0018M\u001d;tA!9aIa\u001a\u0005\u0002\t\rE\u0003\u0003BC\u0005\u000f\u0013IIa#\u0011\t\t%!q\r\u0005\t\u0003g\u0014\t\t1\u0001\u00020\"I!1\u000fBA!\u0003\u0005\r\u0001\r\u0005\u000b\u0005w\u0012\t\t%AA\u0002\u0005=\u0006\u0002\u0003BH\u0005O\u0002K\u0011B\u0018\u0002\u0013\u0019,H\u000e\\*uCJ$\b\u0002\u0003BJ\u0005O\"\tA!&\u0002\u001d\u001d,g\u000e\u0015:fM&D\u0018\n^3ngV\u0011!q\u0013\t\u0007\u00053\u0013IKa,\u000f\t\tm%Q\u0015\b\u0005\u0005;\u0013\u0019+\u0004\u0002\u0003 *\u0019!\u0011\u0015\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012b\u0001BT!\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002BV\u0005[\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0005O\u0003\u0002#B\b\u0002`Bb\u0004\u0002\u0003BZ\u0005O\"\tA!.\u0002\u00119|g.R7qif,\"Aa.\u0011\u0007=\u0011I,C\u0002\u0003<B\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0003@\n\u001dD\u0011\u0001Ba\u0003\u001d\u0001(o\u001c6fGR$BA!\"\u0003D\"9!Q\u0019B_\u0001\u0004\u0001\u0014A\u00029sK\u001aL\u0007\u0010\u0003\u0005\u0003@\n\u001dD\u0011\u0002Be)\u0011\u0011)Ia3\t\u0011\t\u0015'q\u0019a\u0001\u0003_C\u0001Ba0\u0003h\u0011\u0005!q\u001a\u000b\u0005\u0005\u000b\u0013\t\u000e\u0003\u0005\u0003F\n5\u0007\u0019\u0001B\u0004\u0011!\u0011)Na\u001a\u0005\u0002\t]\u0017AC2p[B\u0014Xm]:fIV\u0011!QQ\u0004\f\u00057\fY(!A\t\u0002\t\u0011i.A\u0004Q_N$h-\u001b=\u0011\t\t%!q\u001c\u0004\f\u0005S\nY(!A\t\u0002\t\u0011\to\u0005\u0003\u0003`:Q\u0002b\u0002$\u0003`\u0012\u0005!Q\u001d\u000b\u0003\u0005;D!B!;\u0003`F\u0005I\u0011\u0001Bv\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001e\u0016\u0004a\t=8F\u0001By!\u0011\u0011\u0019Pa?\u000e\u0005\tU(\u0002\u0002B|\u0005s\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005M\u0003\u0012\u0002\u0002B\u007f\u0005k\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0019\tAa8\u0012\u0002\u0013\u000511A\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r\u0015!\u0006BAX\u0005_D!B!\u0018\u0003`\u0006\u0005I\u0011\u0002B0\r\u001d\u0019Y!a\u001f\u0001\u0007\u001b\u0011AB\u0012:fcN+\u0017/^3oG\u0016,Baa\u0004\u0004\u001eM!1\u0011\u0002\b\u001b\u0011-\u0019\u0019b!\u0003\u0003\u0006\u0004%\ta!\u0006\u0002\u0011M,\u0017/^3oG\u0016,\"aa\u0006\u0011\u000b=\tYc!\u0007\u0011\u000b=\tYca\u0007\u0011\u0007i\u001ci\u0002\u0002\u0004}\u0007\u0013\u0011\r! \u0015\u0005\u0007#\u0001f\u000bC\u0006\u0004$\r%!\u0011!Q\u0001\n\r]\u0011!C:fcV,gnY3!Q\u0011\u0019\t\u0003\u0015,\t\u0015\r%2\u0011\u0002BC\u0002\u0013\u00051(\u0001\u0003ge\u0016\f\b\u0006BB\u0014!ZC!ba\f\u0004\n\t\u0005\t\u0015!\u0003=\u0003\u00151'/Z9!Q\u0011\u0019i\u0003\u0015,\t\u000f\u0019\u001bI\u0001\"\u0001\u00046Q11qGB\u001d\u0007{\u0001bA!\u0003\u0004\n\rm\u0001\u0002CB\n\u0007g\u0001\raa\u0006)\t\re\u0002K\u0016\u0005\b\u0007S\u0019\u0019\u00041\u0001=Q\u0011\u0019i\u0004\u0015,)\t\rM\u0002K\u0016\u0005\t\u0007\u000b\u001aI\u0001\"\u0001\u0004H\u0005a!.\u0019<b'\u0016\fX/\u001a8dKV\u00111\u0011\n\t\u0007\u0007\u0017\u001aie!\u0015\u000e\u0005\t\u0005\u0013\u0002BB(\u0005\u0003\u0012A\u0001T5tiB111JB'\u00077ACaa\u0011Q-\"\"1\u0011\u0002)W\u0011)\u0011i&a\u001f\u0002\u0002\u0013%!q\f\u0015\u0005\u0003w\u0002f\u000b\u000b\u0003\u0002vA3\u0006")
public class PrefixSpan
implements Logging,
Serializable {
    private double minSupport;
    private int maxPatternLength;
    private long maxLocalProjDBSize;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int maxPatternLength() {
        return this.maxPatternLength;
    }

    private void maxPatternLength_$eq(int x$1) {
        this.maxPatternLength = x$1;
    }

    private long maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    private void maxLocalProjDBSize_$eq(long x$1) {
        this.maxLocalProjDBSize = x$1;
    }

    public double getMinSupport() {
        return this.minSupport();
    }

    public PrefixSpan setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0)new Serializable(this, minSupport){
            public static final long serialVersionUID = 0L;
            private final double minSupport$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum support value must be in [0, 1], but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minSupport$1)}));
            }
            {
                this.minSupport$1 = minSupport$1;
            }
        });
        this.minSupport_$eq(minSupport);
        return this;
    }

    public int getMaxPatternLength() {
        return this.maxPatternLength();
    }

    public PrefixSpan setMaxPatternLength(int maxPatternLength) {
        Predef$.MODULE$.require(maxPatternLength >= 1, (Function0)new Serializable(this, maxPatternLength){
            public static final long serialVersionUID = 0L;
            private final int maxPatternLength$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The maximum pattern length value must be greater than 0, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxPatternLength$1)}));
            }
            {
                this.maxPatternLength$1 = maxPatternLength$1;
            }
        });
        this.maxPatternLength_$eq(maxPatternLength);
        return this;
    }

    public long getMaxLocalProjDBSize() {
        return this.maxLocalProjDBSize();
    }

    public PrefixSpan setMaxLocalProjDBSize(long maxLocalProjDBSize) {
        Predef$.MODULE$.require(maxLocalProjDBSize >= 0L, (Function0)new Serializable(this, maxLocalProjDBSize){
            public static final long serialVersionUID = 0L;
            private final long maxLocalProjDBSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The maximum local projected database size must be nonnegative, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxLocalProjDBSize$1)}));
            }
            {
                this.maxLocalProjDBSize$1 = maxLocalProjDBSize$1;
            }
        });
        this.maxLocalProjDBSize_$eq(maxLocalProjDBSize);
        return this;
    }

    public <Item> PrefixSpanModel<Item> run(RDD<Object[]> data, ClassTag<Item> evidence$1) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Input data is not cached.";
                }
            });
        }
        long totalCount = data.count();
        this.logInfo((Function0<String>)new Serializable(this, totalCount){
            public static final long serialVersionUID = 0L;
            private final long totalCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of sequences: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.totalCount$1)}));
            }
            {
                this.totalCount$1 = totalCount$1;
            }
        });
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)totalCount);
        this.logInfo((Function0<String>)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final long minCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minimum count for a frequent pattern: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.minCount$1)}));
            }
            {
                this.minCount$1 = minCount$1;
            }
        });
        Object freqItems = PrefixSpan$.MODULE$.findFrequentItems(data, minCount, evidence$1);
        this.logInfo((Function0<String>)new Serializable(this, freqItems){
            public static final long serialVersionUID = 0L;
            private final Object freqItems$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of frequent items: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(this.freqItems$1))}));
            }
            {
                this.freqItems$1 = freqItems$1;
            }
        });
        Map itemToInt = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        RDD dataInternalRepr = PrefixSpan$.MODULE$.toDatabaseInternalRepr(data, itemToInt, evidence$1).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD<Tuple2<int[], Object>> results = PrefixSpan$.MODULE$.genFreqPatterns((RDD<int[]>)dataInternalRepr, minCount, this.maxPatternLength(), this.maxLocalProjDBSize());
        RDD freqSequences = results.map((Function1)new Serializable(this, evidence$1, freqItems){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrefixSpan $outer;
            private final ClassTag evidence$1$1;
            private final Object freqItems$1;

            public final FreqSequence<Item> apply(Tuple2<int[], Object> x0$1) {
                Tuple2<int[], Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int[] seq = (int[])tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    if (seq != null) {
                        int[] nArray = seq;
                        long l = count;
                        FreqSequence<Item> freqSequence = new FreqSequence<Item>(this.$outer.org$apache$spark$mllib$fpm$PrefixSpan$$toPublicRepr$1(nArray, this.evidence$1$1, this.freqItems$1), l);
                        return freqSequence;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.evidence$1$1 = evidence$1$1;
                this.freqItems$1 = freqItems$1;
            }
        }, ClassTag$.MODULE$.apply(FreqSequence.class));
        return new PrefixSpanModel(freqSequences);
    }

    public <Item, Itemset extends Iterable<Item>, Sequence extends Iterable<Itemset>> PrefixSpanModel<Item> run(JavaRDD<Sequence> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object[]>)data.rdd().map((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            public final ClassTag tag$1;

            public final Object[] apply(Sequence x$1) {
                return (Object[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$run$5 $outer;

                    public final Object apply(Itemset x$2) {
                        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$2).asScala()).toArray(this.$outer.tag$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(this.tag$1.runtimeClass())));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass())))), tag);
    }

    public final Object[] org$apache$spark$mllib$fpm$PrefixSpan$$toPublicRepr$1(int[] pattern, ClassTag evidence$1$1, Object freqItems$1) {
        ArrayBuilder sequenceBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1$1.runtimeClass())));
        ArrayBuilder itemsetBuilder = ArrayBuilder$.MODULE$.make(evidence$1$1);
        int n = pattern.length;
        for (int i = 1; i < n; ++i) {
            BoxedUnit boxedUnit;
            int x = pattern[i];
            if (x == 0) {
                sequenceBuilder.$plus$eq(itemsetBuilder.result());
                itemsetBuilder.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = itemsetBuilder.$plus$eq(ScalaRunTime$.MODULE$.array_apply(freqItems$1, x - 1));
        }
        return (Object[])sequenceBuilder.result();
    }

    private PrefixSpan(double minSupport, int maxPatternLength, long maxLocalProjDBSize) {
        this.minSupport = minSupport;
        this.maxPatternLength = maxPatternLength;
        this.maxLocalProjDBSize = maxLocalProjDBSize;
        Logging.class.$init$((Logging)this);
    }

    public PrefixSpan() {
        this(0.1, 10, 32000000L);
    }

    public static class Prefix
    implements Serializable {
        private final int[] items;
        private final int length;
        private final int id;

        public int[] items() {
            return this.items;
        }

        public int length() {
            return this.length;
        }

        public int id() {
            return this.id;
        }

        public Prefix $colon$plus(int item) {
            Predef$.MODULE$.require(item != 0);
            return item < 0 ? new Prefix((int[])Predef$.MODULE$.intArrayOps(this.items()).$colon$plus((Object)BoxesRunTime.boxToInteger((int)(-item)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1) : new Prefix((int[])Predef$.MODULE$.intArrayOps(this.items()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(new int[]{0, item}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1);
        }

        public Prefix(int[] items, int length) {
            this.items = items;
            this.length = length;
            this.id = PrefixSpan$Prefix$.MODULE$.org$apache$spark$mllib$fpm$PrefixSpan$Prefix$$nextId();
        }
    }

    public static class Postfix
    implements Serializable {
        private final int[] items;
        private final int start;
        private final int[] partialStarts;

        public int[] items() {
            return this.items;
        }

        public int start() {
            return this.start;
        }

        public int[] partialStarts() {
            return this.partialStarts;
        }

        /*
         * WARNING - void declaration
         */
        private int fullStart() {
            void var1_1;
            int i = this.start();
            while (this.items()[i] != 0) {
                ++i;
            }
            return (int)var1_1;
        }

        public Iterator<Tuple2<Object, Object>> genPrefixItems() {
            int n1 = this.items().length - 1;
            scala.collection.mutable.Map prefixes = Map$.MODULE$.empty();
            Predef$.MODULE$.intArrayOps(this.partialStarts()).foreach((Function1)new Serializable(this, n1, prefixes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;
                private final int n1$1;
                private final scala.collection.mutable.Map prefixes$1;

                public final void apply(int start2) {
                    this.apply$mcVI$sp(start2);
                }

                public void apply$mcVI$sp(int start2) {
                    int i = start2;
                    int x = -this.$outer.items()[i];
                    while (x != 0) {
                        if (!this.prefixes$1.contains((Object)BoxesRunTime.boxToInteger((int)x))) {
                            this.prefixes$1.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(this.n1$1 - i)));
                        }
                        x = -this.$outer.items()[++i];
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.n1$1 = n1$1;
                    this.prefixes$1 = prefixes$1;
                }
            });
            for (int i = this.fullStart(); i < n1; ++i) {
                int x = this.items()[i];
                if (x == 0 || prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) continue;
                prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
            }
            return prefixes.toIterator();
        }

        public boolean nonEmpty() {
            return this.items().length > this.start() + 1;
        }

        public Postfix project(int prefix) {
            Predef$.MODULE$.require(prefix != 0);
            int n1 = this.items().length - 1;
            BooleanRef matched = new BooleanRef(false);
            IntRef newStart = new IntRef(n1);
            ArrayBuilder newPartialStarts = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            if (prefix < 0) {
                int target = -prefix;
                Predef$.MODULE$.intArrayOps(this.partialStarts()).foreach((Function1)new Serializable(this, matched, newStart, newPartialStarts, target){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Postfix $outer;
                    private final BooleanRef matched$1;
                    private final IntRef newStart$1;
                    private final ArrayBuilder newPartialStarts$1;
                    private final int target$1;

                    public final Object apply(int start2) {
                        Object object;
                        int i = start2;
                        int x = this.$outer.items()[i];
                        while (x != this.target$1 && x != 0) {
                            x = this.$outer.items()[++i];
                        }
                        if (x == this.target$1) {
                            ++i;
                            if (!this.matched$1.elem) {
                                this.newStart$1.elem = i;
                                this.matched$1.elem = true;
                            }
                            object = this.$outer.items()[i] != 0 ? this.newPartialStarts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.matched$1 = matched$1;
                        this.newStart$1 = newStart$1;
                        this.newPartialStarts$1 = newPartialStarts$1;
                        this.target$1 = target$1;
                    }
                });
            } else {
                int target = prefix;
                for (int i = this.fullStart(); i < n1; ++i) {
                    BoxedUnit boxedUnit;
                    int x = this.items()[i];
                    if (x == target) {
                        if (!matched.elem) {
                            newStart.elem = i;
                            matched.elem = true;
                        }
                        if (this.items()[i + 1] != 0) {
                            boxedUnit = newPartialStarts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return new Postfix(this.items(), newStart.elem, (int[])newPartialStarts.result());
        }

        /*
         * WARNING - void declaration
         */
        private Postfix project(int[] prefix) {
            void var3_3;
            boolean partial = true;
            Postfix cur = this;
            int np = prefix.length;
            for (int i = 0; i < np && cur.nonEmpty(); ++i) {
                int x = prefix[i];
                if (x == 0) {
                    partial = false;
                    continue;
                }
                if (partial) {
                    cur = cur.project(-x);
                    continue;
                }
                cur = cur.project(x);
                partial = true;
            }
            return var3_3;
        }

        public Postfix project(Prefix prefix) {
            return this.project(prefix.items());
        }

        public Postfix compressed() {
            return this.start() > 0 ? new Postfix((int[])Predef$.MODULE$.intArrayOps(this.items()).slice(this.start(), this.items().length), 0, (int[])Predef$.MODULE$.intArrayOps(this.partialStarts()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;

                public final int apply(int x$9) {
                    return this.apply$mcII$sp(x$9);
                }

                public int apply$mcII$sp(int x$9) {
                    return x$9 - this.$outer.start();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : this;
        }

        public Postfix(int[] items, int start2, int[] partialStarts) {
            this.items = items;
            this.start = start2;
            this.partialStarts = partialStarts;
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(items).last()) == 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The last item in a postfix must be zero, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(this.$outer.items()).last()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (Predef$.MODULE$.intArrayOps(partialStarts).nonEmpty()) {
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(partialStarts).head()) >= start2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Postfix $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"The first partial start cannot be smaller than the start index,").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got partialStarts.head = ", " < start = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(this.$outer.partialStarts()).head(), BoxesRunTime.boxToInteger((int)this.$outer.start())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
    }

    public static class FreqSequence<Item>
    implements Serializable {
        private final Object[] sequence;
        private final long freq;

        public Object[] sequence() {
            return this.sequence;
        }

        public long freq() {
            return this.freq;
        }

        public List<List<Item>> javaSequence() {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.sequence()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final List<Item> apply(Object x$10) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(x$10).toList()).asJava();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)))).toList()).asJava();
        }

        public FreqSequence(Object[] sequence, long freq) {
            this.sequence = sequence;
            this.freq = freq;
        }
    }
}

