/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.random;

import org.apache.commons.math3.distribution.WeibullDistribution;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.random.RandomDataGenerator;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u001b\t\u0001r+Z5ck2dw)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\taA]1oI>l'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rE\u0002\u0016-ai\u0011AA\u0005\u0003/\t\u00111CU1oI>lG)\u0019;b\u000f\u0016tWM]1u_J\u0004\"aD\r\n\u0005i\u0001\"A\u0002#pk\ndW\r\u0003\u0005\u001d\u0001\t\u0015\r\u0011\"\u0001\u001e\u0003\u0015\tG\u000e\u001d5b+\u0005A\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\r\u0005d\u0007\u000f[1!\u0011!\t\u0003A!b\u0001\n\u0003i\u0012\u0001\u00022fi\u0006D\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0006E\u0016$\u0018\r\t\u0005\u0006K\u0001!\tAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u001dB\u0013\u0006\u0005\u0002\u0016\u0001!)A\u0004\na\u00011!)\u0011\u0005\na\u00011!91\u0006\u0001b\u0001\n\u0013a\u0013a\u0001:oOV\tQ\u0006\u0005\u0002/k5\tqF\u0003\u00021c\u0005aA-[:ue&\u0014W\u000f^5p]*\u0011!gM\u0001\u0006[\u0006$\bn\r\u0006\u0003i!\tqaY8n[>t7/\u0003\u00027_\t\u0019r+Z5ck2dG)[:ue&\u0014W\u000f^5p]\"1\u0001\b\u0001Q\u0001\n5\nAA\u001d8hA!)!\b\u0001C!w\u0005Ia.\u001a=u-\u0006dW/\u001a\u000b\u00021!)Q\b\u0001C!}\u000591/\u001a;TK\u0016$GCA C!\ty\u0001)\u0003\u0002B!\t!QK\\5u\u0011\u0015\u0019E\b1\u0001E\u0003\u0011\u0019X-\u001a3\u0011\u0005=)\u0015B\u0001$\u0011\u0005\u0011auN\\4\t\u000b!\u0003A\u0011I%\u0002\t\r|\u0007/\u001f\u000b\u0002O!\u0012\u0001a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u001a\t!\"\u00198o_R\fG/[8o\u0013\t\u0001VJ\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class WeibullGenerator
implements RandomDataGenerator<Object> {
    private final double alpha;
    private final double beta;
    private final WeibullDistribution rng;

    public double alpha() {
        return this.alpha;
    }

    public double beta() {
        return this.beta;
    }

    private WeibullDistribution rng() {
        return this.rng;
    }

    @Override
    public double nextValue() {
        return this.rng().sample();
    }

    public void setSeed(long seed) {
        this.rng().reseedRandomGenerator(seed);
    }

    public WeibullGenerator copy() {
        return new WeibullGenerator(this.alpha(), this.beta());
    }

    public WeibullGenerator(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
        this.rng = new WeibullDistribution(alpha, beta);
    }
}

