/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.stat;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u00015\u0011A$T;mi&4\u0018M]5bi\u0016|e\u000e\\5oKN+X.\\1sSj,'O\u0003\u0002\u0004\t\u0005!1\u000f^1u\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003=5+H\u000e^5wCJL\u0017\r^3Ti\u0006$\u0018n\u001d;jG\u0006d7+^7nCJL\bCA\b\u001a\u0013\tQ\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011Q\u0003\u0001\u0005\bA\u0001\u0001\r\u0011\"\u0003\"\u0003\u0005qW#\u0001\u0012\u0011\u0005=\u0019\u0013B\u0001\u0013\u0011\u0005\rIe\u000e\u001e\u0005\bM\u0001\u0001\r\u0011\"\u0003(\u0003\u0015qw\fJ3r)\tA3\u0006\u0005\u0002\u0010S%\u0011!\u0006\u0005\u0002\u0005+:LG\u000fC\u0004-K\u0005\u0005\t\u0019\u0001\u0012\u0002\u0007a$\u0013\u0007\u0003\u0004/\u0001\u0001\u0006KAI\u0001\u0003]\u0002B\u0011\u0002\r\u0001A\u0002\u0003\u0007I\u0011B\u0019\u0002\u0011\r,(O]'fC:,\u0012A\r\t\u0004\u001fM*\u0014B\u0001\u001b\u0011\u0005\u0015\t%O]1z!\tya'\u0003\u00028!\t1Ai\\;cY\u0016D\u0011\"\u000f\u0001A\u0002\u0003\u0007I\u0011\u0002\u001e\u0002\u0019\r,(O]'fC:|F%Z9\u0015\u0005!Z\u0004b\u0002\u00179\u0003\u0003\u0005\rA\r\u0005\u0007{\u0001\u0001\u000b\u0015\u0002\u001a\u0002\u0013\r,(O]'fC:\u0004\u0003\"C \u0001\u0001\u0004\u0005\r\u0011\"\u00032\u0003\u001d\u0019WO\u001d:Ne9D\u0011\"\u0011\u0001A\u0002\u0003\u0007I\u0011\u0002\"\u0002\u0017\r,(O]'3]~#S-\u001d\u000b\u0003Q\rCq\u0001\f!\u0002\u0002\u0003\u0007!\u0007\u0003\u0004F\u0001\u0001\u0006KAM\u0001\tGV\u0014(/\u0014\u001aoA!Iq\t\u0001a\u0001\u0002\u0004%I!M\u0001\u0007GV\u0014(/\u0014\u001a\t\u0013%\u0003\u0001\u0019!a\u0001\n\u0013Q\u0015AC2veJl%g\u0018\u0013fcR\u0011\u0001f\u0013\u0005\bY!\u000b\t\u00111\u00013\u0011\u0019i\u0005\u0001)Q\u0005e\u000591-\u001e:s\u001bJ\u0002\u0003\"C(\u0001\u0001\u0004\u0005\r\u0011\"\u00032\u0003\u0019\u0019WO\u001d:Mc!I\u0011\u000b\u0001a\u0001\u0002\u0004%IAU\u0001\u000bGV\u0014(\u000fT\u0019`I\u0015\fHC\u0001\u0015T\u0011\u001da\u0003+!AA\u0002IBa!\u0016\u0001!B\u0013\u0011\u0014aB2veJd\u0015\u0007\t\u0005\b/\u0002\u0001\r\u0011\"\u0003Y\u0003!!x\u000e^1m\u0007:$X#A-\u0011\u0005=Q\u0016BA.\u0011\u0005\u0011auN\\4\t\u000fu\u0003\u0001\u0019!C\u0005=\u0006aAo\u001c;bY\u000esGo\u0018\u0013fcR\u0011\u0001f\u0018\u0005\bYq\u000b\t\u00111\u0001Z\u0011\u0019\t\u0007\u0001)Q\u00053\u0006IAo\u001c;bY\u000esG\u000f\t\u0005\bG\u0002\u0001\r\u0011\"\u0003e\u00039!x\u000e^1m/\u0016Lw\r\u001b;Tk6,\u0012!\u000e\u0005\bM\u0002\u0001\r\u0011\"\u0003h\u0003I!x\u000e^1m/\u0016Lw\r\u001b;Tk6|F%Z9\u0015\u0005!B\u0007b\u0002\u0017f\u0003\u0003\u0005\r!\u000e\u0005\u0007U\u0002\u0001\u000b\u0015B\u001b\u0002\u001fQ|G/\u00197XK&<\u0007\u000e^*v[\u0002Bq\u0001\u001c\u0001A\u0002\u0013%A-A\bxK&<\u0007\u000e^*rk\u0006\u0014XmU;n\u0011\u001dq\u0007\u00011A\u0005\n=\f1c^3jO\"$8+];be\u0016\u001cV/\\0%KF$\"\u0001\u000b9\t\u000f1j\u0017\u0011!a\u0001k!1!\u000f\u0001Q!\nU\n\u0001c^3jO\"$8+];be\u0016\u001cV/\u001c\u0011\t\u0013Q\u0004\u0001\u0019!a\u0001\n\u0013\t\u0014!C<fS\u001eDGoU;n\u0011%1\b\u00011AA\u0002\u0013%q/A\u0007xK&<\u0007\u000e^*v[~#S-\u001d\u000b\u0003QaDq\u0001L;\u0002\u0002\u0003\u0007!\u0007\u0003\u0004{\u0001\u0001\u0006KAM\u0001\u000bo\u0016Lw\r\u001b;Tk6\u0004\u0003\"\u0003?\u0001\u0001\u0004\u0005\r\u0011\"\u0003~\u0003\rqgN_\u000b\u0002}B\u0019qbM-\t\u0017\u0005\u0005\u0001\u00011AA\u0002\u0013%\u00111A\u0001\b]:Tx\fJ3r)\rA\u0013Q\u0001\u0005\bY}\f\t\u00111\u0001\u007f\u0011\u001d\tI\u0001\u0001Q!\ny\fAA\u001c8{A!Q\u0011Q\u0002\u0001A\u0002\u0003\u0007I\u0011B\u0019\u0002\u000f\r,(O]'bq\"Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0007I\u0011BA\n\u0003-\u0019WO\u001d:NCb|F%Z9\u0015\u0007!\n)\u0002\u0003\u0005-\u0003\u001f\t\t\u00111\u00013\u0011\u001d\tI\u0002\u0001Q!\nI\n\u0001bY;se6\u000b\u0007\u0010\t\u0005\u000b\u0003;\u0001\u0001\u0019!a\u0001\n\u0013\t\u0014aB2veJl\u0015N\u001c\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019#A\u0006dkJ\u0014X*\u001b8`I\u0015\fHc\u0001\u0015\u0002&!AA&a\b\u0002\u0002\u0003\u0007!\u0007C\u0004\u0002*\u0001\u0001\u000b\u0015\u0002\u001a\u0002\u0011\r,(O]'j]\u0002Bq!!\f\u0001\t\u0003\ty#A\u0002bI\u0012$B!!\r\u000245\t\u0001\u0001\u0003\u0005\u00026\u0005-\u0002\u0019AA\u001c\u0003\u0019\u0019\u0018-\u001c9mKB!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>\u0011\ta\u0001\\5oC2<\u0017\u0002BA!\u0003w\u0011aAV3di>\u0014\bFBA\u0016\u0003\u000b\n\t\u0006\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tYEB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA(\u0003\u0013\u0012QaU5oG\u0016\f#!a\u0015\u0002\u000bEr\u0013G\f\u0019\t\u0011\u00055\u0002\u0001\"\u0001\u0007\u0003/\"b!!\r\u0002Z\u0005u\u0003\u0002CA.\u0003+\u0002\r!a\u000e\u0002\u0011%t7\u000f^1oG\u0016Dq!a\u0018\u0002V\u0001\u0007Q'\u0001\u0004xK&<\u0007\u000e\u001e\u0005\b\u0003G\u0002A\u0011AA3\u0003\u0015iWM]4f)\u0011\t\t$a\u001a\t\u000f\u0005%\u0014\u0011\ra\u0001=\u0005)q\u000e\u001e5fe\"2\u0011\u0011MA#\u0003#Bq!a\u001c\u0001\t\u0003\n\t(\u0001\u0003nK\u0006tWCAA\u001cQ\u0019\ti'!\u0012\u0002R!9\u0011q\u000f\u0001\u0005B\u0005E\u0014\u0001\u0003<be&\fgnY3)\r\u0005U\u0014QIA)\u0011\u0019\ti\b\u0001C!1\u0006)1m\\;oi\"2\u00111PA#\u0003#Bq!a!\u0001\t\u0003\n\t(A\u0006ok6tuN\u001c>fe>\u001c\bFBAA\u0003\u000b\n\t\u0006C\u0004\u0002\n\u0002!\t%!\u001d\u0002\u00075\f\u0007\u0010\u000b\u0004\u0002\b\u0006\u0015\u0013\u0011\u000b\u0005\b\u0003\u001f\u0003A\u0011IA9\u0003\ri\u0017N\u001c\u0015\u0007\u0003\u001b\u000b)%!\u0015\t\u000f\u0005U\u0005\u0001\"\u0011\u0002r\u00051an\u001c:n\u0019JBc!a%\u0002F\u0005e\u0015EAAN\u0003\u0015\tdF\r\u00181\u0011\u001d\ty\n\u0001C!\u0003c\naA\\8s[2\u000b\u0004FBAO\u0003\u000b\nI\nK\u0002\u0001\u0003K\u0003B!a\u0012\u0002(&!\u0011\u0011VA%\u00051!UM^3m_B,'/\u00119jQ\u0015\u0001\u0011QIA)\u0001")
public class MultivariateOnlineSummarizer
implements MultivariateStatisticalSummary,
Serializable {
    private int org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n = 0;
    private double[] currMean;
    private double[] currM2n;
    private double[] currM2;
    private double[] currL1;
    private long totalCnt = 0L;
    private double totalWeightSum = 0.0;
    private double weightSquareSum = 0.0;
    private double[] weightSum;
    private long[] nnz;
    private double[] currMax;
    private double[] currMin;

    public int org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n() {
        return this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n;
    }

    private void org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n_$eq(int x$1) {
        this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n = x$1;
    }

    private double[] currMean() {
        return this.currMean;
    }

    private void currMean_$eq(double[] x$1) {
        this.currMean = x$1;
    }

    private double[] currM2n() {
        return this.currM2n;
    }

    private void currM2n_$eq(double[] x$1) {
        this.currM2n = x$1;
    }

    private double[] currM2() {
        return this.currM2;
    }

    private void currM2_$eq(double[] x$1) {
        this.currM2 = x$1;
    }

    private double[] currL1() {
        return this.currL1;
    }

    private void currL1_$eq(double[] x$1) {
        this.currL1 = x$1;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double totalWeightSum() {
        return this.totalWeightSum;
    }

    private void totalWeightSum_$eq(double x$1) {
        this.totalWeightSum = x$1;
    }

    private double weightSquareSum() {
        return this.weightSquareSum;
    }

    private void weightSquareSum_$eq(double x$1) {
        this.weightSquareSum = x$1;
    }

    private double[] weightSum() {
        return this.weightSum;
    }

    private void weightSum_$eq(double[] x$1) {
        this.weightSum = x$1;
    }

    private long[] nnz() {
        return this.nnz;
    }

    private void nnz_$eq(long[] x$1) {
        this.nnz = x$1;
    }

    private double[] currMax() {
        return this.currMax;
    }

    private void currMax_$eq(double[] x$1) {
        this.currMax = x$1;
    }

    private double[] currMin() {
        return this.currMin;
    }

    private void currMin_$eq(double[] x$1) {
        this.currMin = x$1;
    }

    public MultivariateOnlineSummarizer add(Vector sample) {
        return this.add(sample, 1.0);
    }

    public MultivariateOnlineSummarizer add(Vector instance, double weight) {
        Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
            public static final long serialVersionUID = 0L;
            private final double weight$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sample weight, ", " has to be >= 0.0"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$1)}));
            }
            {
                this.weight$1 = weight$1;
            }
        });
        if (weight == 0.0) {
            return this;
        }
        if (this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n() == 0) {
            Predef$.MODULE$.require(instance.size() > 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Vector should have dimension larger than zero."})).s((Seq)Nil$.MODULE$);
                }
            });
            this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n_$eq(instance.size());
            this.currMean_$eq((double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double()));
            this.currM2n_$eq((double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double()));
            this.currM2_$eq((double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double()));
            this.currL1_$eq((double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double()));
            this.weightSum_$eq((double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double()));
            this.nnz_$eq((long[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Long()));
            this.currMax_$eq((double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return Double$.MODULE$.MinValue();
                }
            }, ClassTag$.MODULE$.Double()));
            this.currMin_$eq((double[])Array$.MODULE$.fill(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return Double.MAX_VALUE;
                }
            }, ClassTag$.MODULE$.Double()));
        }
        Predef$.MODULE$.require(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n() == instance.size(), (Function0)new Serializable(this, instance){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultivariateOnlineSummarizer $outer;
            private final Vector instance$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when adding new sample."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n()), BoxesRunTime.boxToInteger((int)this.instance$1.size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.instance$1 = instance$1;
            }
        });
        double[] localCurrMean = this.currMean();
        double[] localCurrM2n = this.currM2n();
        double[] localCurrM2 = this.currM2();
        double[] localCurrL1 = this.currL1();
        double[] localWeightSum = this.weightSum();
        long[] localNumNonzeros = this.nnz();
        double[] localCurrMax = this.currMax();
        double[] localCurrMin = this.currMin();
        instance.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, weight, localCurrMean, localCurrM2n, localCurrM2, localCurrL1, localWeightSum, localNumNonzeros, localCurrMax, localCurrMin){
            public static final long serialVersionUID = 0L;
            private final double weight$1;
            private final double[] localCurrMean$1;
            private final double[] localCurrM2n$1;
            private final double[] localCurrM2$1;
            private final double[] localCurrL1$1;
            private final double[] localWeightSum$1;
            private final long[] localNumNonzeros$1;
            private final double[] localCurrMax$1;
            private final double[] localCurrMin$1;

            public final void apply(int index2, double value) {
                this.apply$mcVID$sp(index2, value);
            }

            public void apply$mcVID$sp(int index2, double value) {
                if (value != 0.0) {
                    if (this.localCurrMax$1[index2] < value) {
                        this.localCurrMax$1[index2] = value;
                    }
                    if (this.localCurrMin$1[index2] > value) {
                        this.localCurrMin$1[index2] = value;
                    }
                    double prevMean = this.localCurrMean$1[index2];
                    double diff = value - prevMean;
                    this.localCurrMean$1[index2] = prevMean + this.weight$1 * diff / (this.localWeightSum$1[index2] + this.weight$1);
                    this.localCurrM2n$1[index2] = this.localCurrM2n$1[index2] + this.weight$1 * (value - this.localCurrMean$1[index2]) * diff;
                    this.localCurrM2$1[index2] = this.localCurrM2$1[index2] + this.weight$1 * value * value;
                    this.localCurrL1$1[index2] = this.localCurrL1$1[index2] + this.weight$1 * package$.MODULE$.abs(value);
                    this.localWeightSum$1[index2] = this.localWeightSum$1[index2] + this.weight$1;
                    this.localNumNonzeros$1[index2] = this.localNumNonzeros$1[index2] + 1L;
                }
            }
            {
                this.weight$1 = weight$1;
                this.localCurrMean$1 = localCurrMean$1;
                this.localCurrM2n$1 = localCurrM2n$1;
                this.localCurrM2$1 = localCurrM2$1;
                this.localCurrL1$1 = localCurrL1$1;
                this.localWeightSum$1 = localWeightSum$1;
                this.localNumNonzeros$1 = localNumNonzeros$1;
                this.localCurrMax$1 = localCurrMax$1;
                this.localCurrMin$1 = localCurrMin$1;
            }
        });
        this.totalWeightSum_$eq(this.totalWeightSum() + weight);
        this.weightSquareSum_$eq(this.weightSquareSum() + weight * weight);
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public MultivariateOnlineSummarizer merge(MultivariateOnlineSummarizer other) {
        if (this.totalWeightSum() != 0.0 && other.totalWeightSum() != 0.0) {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n() == other.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), (Function0)new Serializable(this, other){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ MultivariateOnlineSummarizer $outer;
                private final MultivariateOnlineSummarizer other$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimensions mismatch when merging with another summarizer. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n()), BoxesRunTime.boxToInteger((int)this.other$1.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n())}))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.other$1 = other$1;
                }
            });
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.totalWeightSum_$eq(this.totalWeightSum() + other.totalWeightSum());
            this.weightSquareSum_$eq(this.weightSquareSum() + other.weightSquareSum());
            for (int i = 0; i < this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(); ++i) {
                double thisNnz = this.weightSum()[i];
                double otherNnz = other.weightSum()[i];
                double totalNnz = thisNnz + otherNnz;
                long totalCnnz = this.nnz()[i] + other.nnz()[i];
                if (totalNnz != 0.0) {
                    double deltaMean = other.currMean()[i] - this.currMean()[i];
                    double[] dArray = this.currMean();
                    int n = i;
                    dArray[n] = dArray[n] + deltaMean * otherNnz / totalNnz;
                    double[] dArray2 = this.currM2n();
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + (other.currM2n()[i] + deltaMean * deltaMean * thisNnz * otherNnz / totalNnz);
                    double[] dArray3 = this.currM2();
                    int n3 = i;
                    dArray3[n3] = dArray3[n3] + other.currM2()[i];
                    double[] dArray4 = this.currL1();
                    int n4 = i;
                    dArray4[n4] = dArray4[n4] + other.currL1()[i];
                    this.currMax()[i] = package$.MODULE$.max(this.currMax()[i], other.currMax()[i]);
                    this.currMin()[i] = package$.MODULE$.min(this.currMin()[i], other.currMin()[i]);
                }
                this.weightSum()[i] = totalNnz;
                this.nnz()[i] = totalCnnz;
            }
        } else if (this.totalWeightSum() == 0.0 && other.totalWeightSum() != 0.0) {
            this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n_$eq(other.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n());
            this.currMean_$eq((double[])other.currMean().clone());
            this.currM2n_$eq((double[])other.currM2n().clone());
            this.currM2_$eq((double[])other.currM2().clone());
            this.currL1_$eq((double[])other.currL1().clone());
            this.totalCnt_$eq(other.totalCnt());
            this.totalWeightSum_$eq(other.totalWeightSum());
            this.weightSquareSum_$eq(other.weightSquareSum());
            this.weightSum_$eq((double[])other.weightSum().clone());
            this.nnz_$eq((long[])other.nnz().clone());
            this.currMax_$eq((double[])other.currMax().clone());
            this.currMin_$eq((double[])other.currMin().clone());
        }
        return this;
    }

    @Override
    public Vector mean() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        double[] realMean = (double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double());
        for (int i = 0; i < this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(); ++i) {
            realMean[i] = this.currMean()[i] * (this.weightSum()[i] / this.totalWeightSum());
        }
        return Vectors$.MODULE$.dense(realMean);
    }

    @Override
    public Vector variance() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        double[] realVariance = (double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double());
        double denominator = this.totalWeightSum() - this.weightSquareSum() / this.totalWeightSum();
        if (denominator > 0.0) {
            double[] deltaMean = this.currMean();
            int len = this.currM2n().length;
            for (int i = 0; i < len; ++i) {
                realVariance[i] = (this.currM2n()[i] + deltaMean[i] * deltaMean[i] * this.weightSum()[i] * (this.totalWeightSum() - this.weightSum()[i]) / this.totalWeightSum()) / denominator;
            }
        }
        return Vectors$.MODULE$.dense(realVariance);
    }

    @Override
    public long count() {
        return this.totalCnt();
    }

    @Override
    public Vector numNonzeros() {
        Predef$.MODULE$.require(this.totalCnt() > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.longArrayOps(this.nnz()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(long x$1) {
                return this.apply$mcDJ$sp(x$1);
            }

            public double apply$mcDJ$sp(long x$1) {
                return x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    @Override
    public Vector max() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        for (int i = 0; i < this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMax()[i] < 0.0)) continue;
            this.currMax()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMax());
    }

    @Override
    public Vector min() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        for (int i = 0; i < this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(); ++i) {
            if (this.nnz()[i] >= this.totalCnt() || !(this.currMin()[i] > 0.0)) continue;
            this.currMin()[i] = 0.0;
        }
        return Vectors$.MODULE$.dense(this.currMin());
    }

    @Override
    public Vector normL2() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        double[] realMagnitude = (double[])Array$.MODULE$.ofDim(this.org$apache$spark$mllib$stat$MultivariateOnlineSummarizer$$n(), ClassTag$.MODULE$.Double());
        int len = this.currM2().length;
        for (int i = 0; i < len; ++i) {
            realMagnitude[i] = package$.MODULE$.sqrt(this.currM2()[i]);
        }
        return Vectors$.MODULE$.dense(realMagnitude);
    }

    @Override
    public Vector normL1() {
        Predef$.MODULE$.require(this.totalWeightSum() > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Nothing has been added to this summarizer."})).s((Seq)Nil$.MODULE$);
            }
        });
        return Vectors$.MODULE$.dense(this.currL1());
    }
}

