/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.tree.RandomForestParams$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.RandomForest;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.QuantileStrategy$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.configuration.Strategy$;
import org.apache.spark.mllib.tree.impurity.Impurities$;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;

public final class RandomForest$
implements Serializable,
Logging {
    public static final RandomForest$ MODULE$;
    private final String[] supportedFeatureSubsetStrategies;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RandomForest$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0)new Serializable(strategy){
            public static final long serialVersionUID = 0L;
            private final Strategy strategy$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest.trainClassifier given Strategy with invalid algo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.strategy$1.algo()}));
            }
            {
                this.strategy$1 = strategy$1;
            }
        });
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainClassifier(RDD<LabeledPoint> input, int numClasses, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Classification(), impurityType, maxDepth, numClasses, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return this.trainClassifier(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainClassifier(JavaRDD<LabeledPoint> input, int numClasses, java.util.Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainClassifier((RDD<LabeledPoint>)input.rdd(), numClasses, (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainClassifier$default$9() {
        return Utils$.MODULE$.random().nextInt();
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        Enumeration.Value value = strategy.algo();
        Enumeration.Value value2 = Algo$.MODULE$.Regression();
        Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0)new Serializable(strategy){
            public static final long serialVersionUID = 0L;
            private final Strategy strategy$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest.trainRegressor given Strategy with invalid algo: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.strategy$2.algo()}));
            }
            {
                this.strategy$2 = strategy$2;
            }
        });
        RandomForest rf = new RandomForest(strategy, numTrees, featureSubsetStrategy, seed);
        return rf.run(input);
    }

    public RandomForestModel trainRegressor(RDD<LabeledPoint> input, Map<Object, Object> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        Impurity impurityType = Impurities$.MODULE$.fromString(impurity);
        Strategy strategy = new Strategy(Algo$.MODULE$.Regression(), impurityType, maxDepth, 0, maxBins, QuantileStrategy$.MODULE$.Sort(), categoricalFeaturesInfo, Strategy$.MODULE$.$lessinit$greater$default$8(), Strategy$.MODULE$.$lessinit$greater$default$9(), Strategy$.MODULE$.$lessinit$greater$default$10(), Strategy$.MODULE$.$lessinit$greater$default$11(), Strategy$.MODULE$.$lessinit$greater$default$12(), Strategy$.MODULE$.$lessinit$greater$default$13());
        return this.trainRegressor(input, strategy, numTrees, featureSubsetStrategy, seed);
    }

    public RandomForestModel trainRegressor(JavaRDD<LabeledPoint> input, java.util.Map<Integer, Integer> categoricalFeaturesInfo, int numTrees, String featureSubsetStrategy, String impurity, int maxDepth, int maxBins, int seed) {
        return this.trainRegressor((RDD<LabeledPoint>)input.rdd(), (Map<Object, Object>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(categoricalFeaturesInfo).asScala()).toMap(Predef$.MODULE$.conforms()), numTrees, featureSubsetStrategy, impurity, maxDepth, maxBins, seed);
    }

    public int trainRegressor$default$8() {
        return Utils$.MODULE$.random().nextInt();
    }

    public String[] supportedFeatureSubsetStrategies() {
        return this.supportedFeatureSubsetStrategies;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private RandomForest$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.supportedFeatureSubsetStrategies = RandomForestParams$.MODULE$.supportedFeatureSubsetStrategies();
    }
}

