/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import org.apache.spark.ml.clustering.GaussianMixture;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.DefaultParamsReadable$class;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import scala.Serializable;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class GaussianMixture$
implements DefaultParamsReadable<GaussianMixture>,
Serializable {
    public static final GaussianMixture$ MODULE$;
    private final int MAX_NUM_FEATURES;

    static {
        new GaussianMixture$();
    }

    @Override
    public MLReader<GaussianMixture> read() {
        return DefaultParamsReadable$class.read(this);
    }

    public int MAX_NUM_FEATURES() {
        return this.MAX_NUM_FEATURES;
    }

    @Override
    public GaussianMixture load(String path) {
        return (GaussianMixture)MLReadable$class.load(this, path);
    }

    public boolean shouldDistributeGaussians(int numClusters, int numFeatures) {
        return ((double)numClusters - 1.0) / (double)numClusters * (double)numFeatures > 25.0;
    }

    public DenseMatrix unpackUpperTriangularMatrix(int n, double[] triangularValues) {
        double[] symmetricValues = new double[n * n];
        int r = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= i; ++j) {
                symmetricValues[i * n + j] = triangularValues[r];
                symmetricValues[j * n + i] = triangularValues[r];
                ++r;
            }
        }
        return new DenseMatrix(n, n, symmetricValues);
    }

    public Tuple2<Object, Tuple2<DenseVector, DenseVector>> updateWeightsAndGaussians(DenseVector mean2, DenseVector cov, double weight, double sumWeights) {
        BLAS$.MODULE$.scal(1.0 / weight, (Vector)mean2);
        BLAS$.MODULE$.spr(-weight, (Vector)mean2, cov);
        BLAS$.MODULE$.scal(1.0 / weight, (Vector)cov);
        double newWeight = weight / sumWeights;
        Tuple2 newGaussian = new Tuple2((Object)mean2, (Object)cov);
        return new Tuple2((Object)BoxesRunTime.boxToDouble((double)newWeight), (Object)newGaussian);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GaussianMixture$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
        DefaultParamsReadable$class.$init$(this);
        this.MAX_NUM_FEATURES = (int)package$.MODULE$.sqrt(2.147483647E9);
    }
}

