/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3Q!\u0001\u0002\u0001\t1\u0011\u0011dV3jO\"$X\r\u001a'fCN$8+];be\u0016\u001cXj\u001c3fY*\u00111\u0001B\u0001\u0006_B$\u0018.\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0014!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011a\u0002F\u0005\u0003+=\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001b\u0006\u0001\u0003\u0006\u0004%\t!G\u0001\rG>,gMZ5dS\u0016tGo]\u0002\u0001+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0004\b\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003\u001b\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!A1\u0005\u0001BC\u0002\u0013\u0005A%A\u0005j]R,'oY3qiV\tQ\u0005\u0005\u0002\u000fM%\u0011qe\u0004\u0002\u0007\t>,(\r\\3\t\u0011%\u0002!\u0011!Q\u0001\n\u0015\n!\"\u001b8uKJ\u001cW\r\u001d;!\u0011!Y\u0003A!b\u0001\n\u0003I\u0012a\u00033jC\u001eLeN^!u/\u0006C\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAG\u0001\rI&\fw-\u00138w\u0003R<\u0016\t\t\u0005\t_\u0001\u0011)\u0019!C\u0001a\u0005\u0001rN\u00196fGRLg/\u001a%jgR|'/_\u000b\u0002cA\u0019aBM\u0013\n\u0005Mz!!B!se\u0006L\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002#=\u0014'.Z2uSZ,\u0007*[:u_JL\b\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0006smbTH\u0010\t\u0003u\u0001i\u0011A\u0001\u0005\u0006/Y\u0002\rA\u0007\u0005\u0006GY\u0002\r!\n\u0005\u0006WY\u0002\rA\u0007\u0005\u0006_Y\u0002\r!\r\u0005\u0006\u0001\u0002!\t!Q\u0001\baJ,G-[2u)\t)#\tC\u0003D\u007f\u0001\u0007A)\u0001\u0005gK\u0006$XO]3t!\tYR)\u0003\u0002G9\t1a+Z2u_J\u0004")
public class WeightedLeastSquaresModel
implements Serializable {
    private final DenseVector coefficients;
    private final double intercept;
    private final DenseVector diagInvAtWA;
    private final double[] objectiveHistory;

    public DenseVector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public DenseVector diagInvAtWA() {
        return this.diagInvAtWA;
    }

    public double[] objectiveHistory() {
        return this.objectiveHistory;
    }

    public double predict(Vector features) {
        return BLAS$.MODULE$.dot((Vector)this.coefficients(), features) + this.intercept();
    }

    public WeightedLeastSquaresModel(DenseVector coefficients2, double intercept, DenseVector diagInvAtWA, double[] objectiveHistory) {
        this.coefficients = coefficients2;
        this.intercept = intercept;
        this.diagInvAtWA = diagInvAtWA;
        this.objectiveHistory = objectiveHistory;
    }
}

