/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegression$FamilyAndLink$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionBase$class;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionSummary;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r\u0005c\u0001B\u0001\u0003\u00015\u0011\u0001eR3oKJ\fG.\u001b>fI2Kg.Z1s%\u0016<'/Z:tS>tWj\u001c3fY*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u001a9A!q\u0002\u0005\n\u0019\u001b\u0005\u0011\u0011BA\t\u0003\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\u0010HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\"bg\u0016\u0004\"!\b\u0011\u000e\u0003yQ!a\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Cy\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!\u0019\u0003A!b\u0001\n\u0003\"\u0013aA;jIV\tQ\u0005\u0005\u0002'Y9\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\u00051\u0001K]3eK\u001aL!!\f\u0018\u0003\rM#(/\u001b8h\u0015\tY\u0003\u0006K\u0002#aY\u0002\"!\r\u001b\u000e\u0003IR!a\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00026e\t)1+\u001b8dK\u0006\nq'A\u00033]Ar\u0003\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003&\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007a\u0002d\u0007\u0003\u0005=\u0001\t\u0015\r\u0011\"\u0001>\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005\u0011\u0002fA\u001e1m!A\u0001\t\u0001B\u0001B\u0003%!#A\u0007d_\u00164g-[2jK:$8\u000f\t\u0015\u0004\u007fA2\u0004\u0002C\"\u0001\u0005\u000b\u0007I\u0011\u0001#\u0002\u0013%tG/\u001a:dKB$X#A#\u0011\u0005\u001d2\u0015BA$)\u0005\u0019!u.\u001e2mK\"\u001a!\t\r\u001c\t\u0011)\u0003!\u0011!Q\u0001\n\u0015\u000b!\"\u001b8uKJ\u001cW\r\u001d;!Q\rI\u0005G\u000e\u0005\u0007\u001b\u0002!\t\u0001\u0002(\u0002\rqJg.\u001b;?)\u0011Ar*U*\t\u000b\rb\u0005\u0019A\u0013)\u0007=\u0003d\u0007C\u0003=\u0019\u0002\u0007!\u0003K\u0002RaYBQa\u0011'A\u0002\u0015C3a\u0015\u00197\u0011\u00151\u0006\u0001\"\u0001X\u0003Q\u0019X\r\u001e'j].\u0004&/\u001a3jGRLwN\\\"pYR\u0011\u0001,W\u0007\u0002\u0001!)!,\u0016a\u0001K\u0005)a/\u00197vK\"\u001aQ\u000b\r\u001c\t\u0011u\u0003\u0001R1A\u0005\ny\u000bQBZ1nS2L\u0018I\u001c3MS:\\W#A0\u0011\u0005\u0001\u001cgBA\bb\u0013\t\u0011'!A\u000eHK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\\u0005\u0003I\u0016\u0014QBR1nS2L\u0018I\u001c3MS:\\'B\u00012\u0003\u0011!9\u0007\u0001#A!B\u0013y\u0016A\u00044b[&d\u00170\u00118e\u0019&t7\u000e\t\u0005\u0006S\u0002!\tF[\u0001\baJ,G-[2u)\t)5\u000eC\u0003mQ\u0002\u0007!#\u0001\u0005gK\u0006$XO]3t\u0011\u0015q\u0007\u0001\"\u0003p\u0003-\u0001(/\u001a3jGRd\u0015N\\6\u0015\u0005\u0015\u0003\b\"\u00027n\u0001\u0004\u0011\u0002\"\u0002:\u0001\t\u0003\u001a\u0018!\u0003;sC:\u001chm\u001c:n)\r!\u0018\u0011\u0003\t\u0004k\u0006-ab\u0001<\u0002\u00069\u0019q/!\u0001\u000f\u0005a|hBA=\u007f\u001d\tQX0D\u0001|\u0015\taH\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I1!a\u0001\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u000f\tI!A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005\ra!\u0003\u0003\u0002\u000e\u0005=!!\u0003#bi\u00064%/Y7f\u0015\u0011\t9!!\u0003\t\u000f\u0005M\u0011\u000f1\u0001\u0002\u0016\u00059A-\u0019;bg\u0016$\b\u0007BA\f\u0003G\u0001b!!\u0007\u0002\u001c\u0005}QBAA\u0005\u0013\u0011\ti\"!\u0003\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011EA\u0012\u0019\u0001!A\"!\n\u0002\u0012\u0005\u0005\t\u0011!B\u0001\u0003O\u00111a\u0018\u00133#\u0011\tI#a\f\u0011\u0007\u001d\nY#C\u0002\u0002.!\u0012qAT8uQ&tw\rE\u0002(\u0003cI1!a\r)\u0005\r\te.\u001f\u0005\b\u0003o\u0001A\u0011KA\u001d\u00035!(/\u00198tM>\u0014X.S7qYR\u0019A/a\u000f\t\u0011\u0005M\u0011Q\u0007a\u0001\u0003{\u0001D!a\u0010\u0002DA1\u0011\u0011DA\u000e\u0003\u0003\u0002B!!\t\u0002D\u0011a\u0011QIA\u001e\u0003\u0003\u0005\tQ!\u0001\u0002(\t\u0019q\fJ\u001a\t\u0013\u0005%\u0003\u00011A\u0005\n\u0005-\u0013a\u0004;sC&t\u0017N\\4Tk6l\u0017M]=\u0016\u0005\u00055\u0003#B\u0014\u0002P\u0005M\u0013bAA)Q\t1q\n\u001d;j_:\u00042aDA+\u0013\r\t9F\u0001\u0002+\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:z\u0011%\tY\u0006\u0001a\u0001\n\u0013\ti&A\nue\u0006Lg.\u001b8h'VlW.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002`\u0005\u0015\u0004cA\u0014\u0002b%\u0019\u00111\r\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003O\nI&!AA\u0002\u00055\u0013a\u0001=%c!A\u00111\u000e\u0001!B\u0013\ti%\u0001\tue\u0006Lg.\u001b8h'VlW.\u0019:zA!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014aB:v[6\f'/_\u000b\u0003\u0003'BC!!\u001c1m!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0014A\u00035bgN+X.\\1ssV\u0011\u00111\u0010\t\u0004O\u0005u\u0014bAA@Q\t9!i\\8mK\u0006t\u0007\u0006BA;aYB\u0001\"!\"\u0001\t\u0003\u0011\u0011qQ\u0001\u000bg\u0016$8+^7nCJLHc\u0001-\u0002\n\"A\u0011qNAB\u0001\u0004\ti\u0005C\u0004\u0002\u000e\u0002!\t!a$\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!!%\u0002\u0018B\u0019q\"a%\n\u0007\u0005U%A\u0001\u0012HK:,'/\u00197ju\u0016$G*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\t\u0003'\tY\t1\u0001\u0002\u001aB\"\u00111TAP!\u0019\tI\"a\u0007\u0002\u001eB!\u0011\u0011EAP\t1\t\t+a&\u0002\u0002\u0003\u0005)\u0011AA\u0014\u0005\ryF\u0005\u000e\u0015\u0005\u0003\u0017\u0003d\u0007C\u0004\u0002(\u0002!\t%!+\u0002\t\r|\u0007/\u001f\u000b\u00041\u0005-\u0006\u0002CAW\u0003K\u0003\r!a,\u0002\u000b\u0015DHO]1\u0011\t\u0005E\u0016qW\u0007\u0003\u0003gS1!!.\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tI,a-\u0003\u0011A\u000b'/Y7NCBDC!!*1m!9\u0011q\u0018\u0001\u0005B\u0005\u0005\u0017!B<sSR,WCAAb!\ri\u0012QY\u0005\u0004\u0003\u000ft\"\u0001C'M/JLG/\u001a:)\t\u0005u\u0006G\u000e\u0005\n\u0003\u001b\u0004!\u0019!C!\u0003\u001f\f1B\\;n\r\u0016\fG/\u001e:fgV\u0011\u0011\u0011\u001b\t\u0004O\u0005M\u0017bAAkQ\t\u0019\u0011J\u001c;\t\u0011\u0005e\u0007\u0001)A\u0005\u0003#\fAB\\;n\r\u0016\fG/\u001e:fg\u0002B3\u0001\u0001\u00197Q\r\u0001\u0011q\u001c\t\u0004c\u0005\u0005\u0018bAAre\taQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011q\u001d\u0002\t\u0002\u0005%\u0018\u0001I$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3beJ+wM]3tg&|g.T8eK2\u00042aDAv\r\u0019\t!\u0001#\u0001\u0002nNA\u00111^Ax\u0003k\fY\u0010E\u0002(\u0003cL1!a=)\u0005\u0019\te.\u001f*fMB!Q$a>\u0019\u0013\r\tIP\b\u0002\u000b\u001b2\u0013V-\u00193bE2,\u0007cA\u0014\u0002~&\u0019\u0011q \u0015\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f5\u000bY\u000f\"\u0001\u0003\u0004Q\u0011\u0011\u0011\u001e\u0005\t\u0005\u000f\tY\u000f\"\u0011\u0003\n\u0005!!/Z1e+\t\u0011Y\u0001\u0005\u0003\u001e\u0005\u001bA\u0012b\u0001B\b=\tAQ\n\u0014*fC\u0012,'\u000f\u000b\u0003\u0003\u0006A2\u0004\u0002\u0003B\u000b\u0003W$\tEa\u0006\u0002\t1|\u0017\r\u001a\u000b\u00041\te\u0001b\u0002B\u000e\u0005'\u0001\r!J\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0003\u0014A2d!\u0003B\u0011\u0003W\u0004\u00111\u001eB\u0012\u0005\u0019:UM\\3sC2L'0\u001a3MS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0007\u0005?\t\u0019M!\n\u0011\t\t\u001d\"QF\u0007\u0003\u0005SQ1Aa\u000b\u0007\u0003!Ig\u000e^3s]\u0006d\u0017\u0002\u0002B\u0018\u0005S\u0011q\u0001T8hO&tw\r\u0003\u0006\u00034\t}!\u0011!Q\u0001\na\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\b\u001b\n}A\u0011\u0001B\u001c)\u0011\u0011ID!\u0010\u0011\t\tm\"qD\u0007\u0003\u0003WDqAa\r\u00036\u0001\u0007\u0001DB\u0004\u0003B\t}AIa\u0011\u0003\t\u0011\u000bG/Y\n\t\u0005\u007f\tyO!\u0012\u0002|B\u0019qEa\u0012\n\u0007\t%\u0003FA\u0004Qe>$Wo\u0019;\t\u0013\r\u0013yD!f\u0001\n\u0003!\u0005\"\u0003&\u0003@\tE\t\u0015!\u0003F\u0011%a$q\bBK\u0002\u0013\u0005Q\bC\u0005A\u0005\u007f\u0011\t\u0012)A\u0005%!9QJa\u0010\u0005\u0002\tUCC\u0002B,\u00057\u0012i\u0006\u0005\u0003\u0003Z\t}RB\u0001B\u0010\u0011\u0019\u0019%1\u000ba\u0001\u000b\"1AHa\u0015A\u0002IA!\"a*\u0003@\u0005\u0005I\u0011\u0001B1)\u0019\u00119Fa\u0019\u0003f!A1Ia\u0018\u0011\u0002\u0003\u0007Q\t\u0003\u0005=\u0005?\u0002\n\u00111\u0001\u0013\u0011)\u0011IGa\u0010\u0012\u0002\u0013\u0005!1N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iGK\u0002F\u0005_Z#A!\u001d\u0011\t\tM$1P\u0007\u0003\u0005kRAAa\u001e\u0003z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003g!JAA! \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t\u0005%qHI\u0001\n\u0003\u0011\u0019)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015%f\u0001\n\u0003p!Q!\u0011\u0012B \u0003\u0003%\tEa#\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011i\t\u0005\u0003\u0003\u0010\neUB\u0001BI\u0015\u0011\u0011\u0019J!&\u0002\t1\fgn\u001a\u0006\u0003\u0005/\u000bAA[1wC&\u0019QF!%\t\u0015\tu%qHA\u0001\n\u0003\ty-\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0003\"\n}\u0012\u0011!C\u0001\u0005G\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\t\u0015\u0006BCA4\u0005?\u000b\t\u00111\u0001\u0002R\"Q!\u0011\u0016B \u0003\u0003%\tEa+\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!,\u0011\r\t=&QWA\u0018\u001b\t\u0011\tLC\u0002\u00034\"\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\u00119L!-\u0003\u0011%#XM]1u_JD!Ba/\u0003@\u0005\u0005I\u0011\u0001B_\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA>\u0005\u007fC!\"a\u001a\u0003:\u0006\u0005\t\u0019AA\u0018\u0011)\u0011\u0019Ma\u0010\u0002\u0002\u0013\u0005#QY\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011\u001b\u0005\u000b\u0005\u0013\u0014y$!A\u0005B\t-\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t5\u0005B\u0003Bh\u0005\u007f\t\t\u0011\"\u0011\u0003R\u00061Q-];bYN$B!a\u001f\u0003T\"Q\u0011q\rBg\u0003\u0003\u0005\r!a\f\b\u0015\t]'qDA\u0001\u0012\u0013\u0011I.\u0001\u0003ECR\f\u0007\u0003\u0002B-\u000574!B!\u0011\u0003 \u0005\u0005\t\u0012\u0002Bo'\u0019\u0011YNa8\u0002|BA!\u0011\u001dBt\u000bJ\u00119&\u0004\u0002\u0003d*\u0019!Q\u001d\u0015\u0002\u000fI,h\u000e^5nK&!!\u0011\u001eBr\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b\u001b\nmG\u0011\u0001Bw)\t\u0011I\u000e\u0003\u0006\u0003J\nm\u0017\u0011!C#\u0005\u0017D!Ba=\u0003\\\u0006\u0005I\u0011\u0011B{\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u00119Fa>\u0003z\"11I!=A\u0002\u0015Ca\u0001\u0010By\u0001\u0004\u0011\u0002B\u0003B\u007f\u00057\f\t\u0011\"!\u0003\u0000\u00069QO\\1qa2LH\u0003BB\u0001\u0007\u0013\u0001RaJA(\u0007\u0007\u0001RaJB\u0003\u000bJI1aa\u0002)\u0005\u0019!V\u000f\u001d7fe!Q11\u0002B~\u0003\u0003\u0005\rAa\u0016\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004\u0010\tm\u0017\u0011!C\u0005\u0007#\t1B]3bIJ+7o\u001c7wKR\u001111\u0003\t\u0005\u0005\u001f\u001b)\"\u0003\u0003\u0004\u0018\tE%AB(cU\u0016\u001cG\u000f\u0003\u0005\u0004\u001c\t}A\u0011KB\u000f\u0003!\u0019\u0018M^3J[BdG\u0003BA0\u0007?AqAa\u0007\u0004\u001a\u0001\u0007QEB\u0004\u0004$\u0005-Ha!\n\u0003M\u001d+g.\u001a:bY&TX\r\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o\u001b>$W\r\u001c*fC\u0012,'o\u0005\u0003\u0004\"\t-\u0001bB'\u0004\"\u0011\u00051\u0011\u0006\u000b\u0003\u0007W\u0001BAa\u000f\u0004\"!Q1qFB\u0011\u0005\u0004%IAa#\u0002\u0013\rd\u0017m]:OC6,\u0007\"CB\u001a\u0007C\u0001\u000b\u0011\u0002BG\u0003)\u0019G.Y:t\u001d\u0006lW\r\t\u0005\t\u0005+\u0019\t\u0003\"\u0011\u00048Q\u0019\u0001d!\u000f\t\u000f\tm1Q\u0007a\u0001K!Q1qBAv\u0003\u0003%Ia!\u0005)\t\u0005-\bG\u000e\u0015\u0005\u0003K\u0004d\u0007")
public class GeneralizedLinearRegressionModel
extends RegressionModel<Vector, GeneralizedLinearRegressionModel>
implements GeneralizedLinearRegressionBase,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private GeneralizedLinearRegression.FamilyAndLink familyAndLink;
    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> family;
    private final DoubleParam variancePower;
    private final Param<String> link;
    private final DoubleParam linkPower;
    private final Param<String> linkPredictionCol;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final DoubleParam regParam;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final BooleanParam fitIntercept;
    private volatile boolean bitmap$0;

    public static GeneralizedLinearRegressionModel load(String string) {
        return GeneralizedLinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<GeneralizedLinearRegressionModel> read() {
        return GeneralizedLinearRegressionModel$.MODULE$.read();
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink$lzycompute() {
        GeneralizedLinearRegressionModel generalizedLinearRegressionModel = this;
        synchronized (generalizedLinearRegressionModel) {
            if (!this.bitmap$0) {
                this.familyAndLink = GeneralizedLinearRegression$FamilyAndLink$.MODULE$.apply(this);
                this.bitmap$0 = true;
            }
            return this.familyAndLink;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public final DoubleParam variancePower() {
        return this.variancePower;
    }

    @Override
    public final Param<String> link() {
        return this.link;
    }

    @Override
    public final DoubleParam linkPower() {
        return this.linkPower;
    }

    @Override
    public final Param<String> linkPredictionCol() {
        return this.linkPredictionCol;
    }

    @Override
    public StructType org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$variancePower_$eq(DoubleParam x$1) {
        this.variancePower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$link_$eq(Param x$1) {
        this.link = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPower_$eq(DoubleParam x$1) {
        this.linkPower = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$GeneralizedLinearRegressionBase$_setter_$linkPredictionCol_$eq(Param x$1) {
        this.linkPredictionCol = x$1;
    }

    @Override
    public String getFamily() {
        return GeneralizedLinearRegressionBase$class.getFamily(this);
    }

    @Override
    public double getVariancePower() {
        return GeneralizedLinearRegressionBase$class.getVariancePower(this);
    }

    @Override
    public String getLink() {
        return GeneralizedLinearRegressionBase$class.getLink(this);
    }

    @Override
    public double getLinkPower() {
        return GeneralizedLinearRegressionBase$class.getLinkPower(this);
    }

    @Override
    public String getLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.getLinkPredictionCol(this);
    }

    @Override
    public boolean hasLinkPredictionCol() {
        return GeneralizedLinearRegressionBase$class.hasLinkPredictionCol(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return GeneralizedLinearRegressionBase$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public GeneralizedLinearRegressionModel setLinkPredictionCol(String value) {
        return (GeneralizedLinearRegressionModel)this.set(this.linkPredictionCol(), value);
    }

    private GeneralizedLinearRegression.FamilyAndLink familyAndLink() {
        return this.bitmap$0 ? this.familyAndLink : this.familyAndLink$lzycompute();
    }

    @Override
    public double predict(Vector features) {
        double eta = this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features);
        return this.familyAndLink().fitted(eta);
    }

    public double org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema());
        return this.transformImpl(dataset);
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModel.class.getClassLoader());
        public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(GeneralizedLinearRegressionModel $outer) {
            }
        }
        UserDefinedFunction predictLinkUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearRegressionModel $outer;

            public final double apply(Vector features) {
                return this.$outer.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$$predictLink(features);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$$typecreator2$1(this)));
        Dataset output = dataset;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            output = output.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
        }
        if (this.hasLinkPredictionCol()) {
            output = output.withColumn(this.$(this.linkPredictionCol()), predictLinkUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
        }
        return output.toDF();
    }

    private Option<GeneralizedLinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GeneralizedLinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GeneralizedLinearRegressionTrainingSummary summary() {
        return (GeneralizedLinearRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this GeneralizedLinearRegressionModel");
            }
        });
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GeneralizedLinearRegressionModel setSummary(Option<GeneralizedLinearRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public GeneralizedLinearRegressionSummary evaluate(Dataset<?> dataset) {
        return new GeneralizedLinearRegressionSummary(dataset, this);
    }

    @Override
    public GeneralizedLinearRegressionModel copy(ParamMap extra) {
        GeneralizedLinearRegressionModel copied = this.copyValues(new GeneralizedLinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        return (GeneralizedLinearRegressionModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new GeneralizedLinearRegressionModelWriter(this);
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public GeneralizedLinearRegressionModel(String uid, Vector coefficients2, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients2;
        this.intercept = intercept;
        HasFitIntercept$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasRegParam$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        GeneralizedLinearRegressionBase$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients2.size();
    }

    public static class GeneralizedLinearRegressionModelWriter
    extends MLWriter {
        private final GeneralizedLinearRegressionModel instance;
        private volatile GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() {
            GeneralizedLinearRegressionModelWriter generalizedLinearRegressionModelWriter = this;
            synchronized (generalizedLinearRegressionModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GeneralizedLinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.regression.GeneralizedLinearRegressionModel.GeneralizedLinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(GeneralizedLinearRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$$typecreator3$1(this))).repartition(1).write().parquet(dataPath);
        }

        public GeneralizedLinearRegressionModelWriter(GeneralizedLinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ GeneralizedLinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients2) {
                return new Data(this.org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer(), intercept, coefficients2);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GeneralizedLinearRegressionModelWriter org$apache$spark$ml$regression$GeneralizedLinearRegressionModel$GeneralizedLinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GeneralizedLinearRegressionModelWriter $outer, double intercept, Vector coefficients2) {
                this.intercept = intercept;
                this.coefficients = coefficients2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class GeneralizedLinearRegressionModelReader
    extends MLReader<GeneralizedLinearRegressionModel> {
        private final String className = GeneralizedLinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GeneralizedLinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = (Row)this.sparkSession().read().parquet(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients2 = (Vector)data.getAs(1);
            GeneralizedLinearRegressionModel model = new GeneralizedLinearRegressionModel(metadata.uid(), coefficients2, intercept);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

