/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree;

import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.InternalNode;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DecisionTreeModelReadWrite$ {
    public static final DecisionTreeModelReadWrite$ MODULE$;

    static {
        new DecisionTreeModelReadWrite$();
    }

    public Node loadTreeNodes(String path, DefaultParamsReader.Metadata metadata, SparkSession sparkSession) {
        DefaultFormats$ format2 = DefaultFormats$.MODULE$;
        JsonAST.JValue impurityJson = metadata.getParamValue("impurity");
        String impurityType = (String)Param$.MODULE$.jsonDecode(JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(impurityJson, (Formats)format2)));
        String dataPath = new Path(path, "data").toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator2$1() {
            }
        }
        Dataset data = sparkSession.read().parquet(dataPath).as(sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_tree_DecisionTreeModelReadWrite$$typecreator2$1())));
        return this.buildTreeFromNodes((DecisionTreeModelReadWrite.NodeData[])data.collect(), impurityType);
    }

    public Node buildTreeFromNodes(DecisionTreeModelReadWrite.NodeData[] data, String impurityType) {
        DecisionTreeModelReadWrite.NodeData[] nodes = (DecisionTreeModelReadWrite.NodeData[])Predef$.MODULE$.refArrayOps((Object[])data).sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(DecisionTreeModelReadWrite.NodeData x$16) {
                return x$16.id();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)Predef$.MODULE$.refArrayOps((Object[])nodes).head()).id() == 0, (Function0)new Serializable(nodes){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeModelReadWrite.NodeData[] nodes$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decision Tree load failed.  Expected smallest node ID to be 0,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((DecisionTreeModelReadWrite.NodeData)Predef$.MODULE$.refArrayOps((Object[])this.nodes$1).head()).id())}))).toString();
            }
            {
                this.nodes$1 = nodes$1;
            }
        });
        Predef$.MODULE$.assert(((DecisionTreeModelReadWrite.NodeData)Predef$.MODULE$.refArrayOps((Object[])nodes).last()).id() == nodes.length - 1, (Function0)new Serializable(nodes){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeModelReadWrite.NodeData[] nodes$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decision Tree load failed.  Expected largest"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" node ID to be ", ", but found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.nodes$1.length - 1)), BoxesRunTime.boxToInteger((int)((DecisionTreeModelReadWrite.NodeData)Predef$.MODULE$.refArrayOps((Object[])this.nodes$1).last()).id())}))).toString();
            }
            {
                this.nodes$1 = nodes$1;
            }
        });
        Node[] finalNodes = new Node[nodes.length];
        Predef$.MODULE$.refArrayOps((Object[])nodes).reverseIterator().foreach((Function1)new Serializable(impurityType, finalNodes){
            public static final long serialVersionUID = 0L;
            private final String impurityType$1;
            private final Node[] finalNodes$1;

            public final void apply(DecisionTreeModelReadWrite.NodeData x0$3) {
                DecisionTreeModelReadWrite.NodeData nodeData = x0$3;
                if (nodeData != null) {
                    Node node;
                    DecisionTreeModelReadWrite.NodeData nodeData2 = nodeData;
                    ImpurityCalculator impurityStats = ImpurityCalculator$.MODULE$.getCalculator(this.impurityType$1, nodeData2.impurityStats());
                    if (nodeData2.leftChild() != -1) {
                        Node leftChild = this.finalNodes$1[nodeData2.leftChild()];
                        Node rightChild = this.finalNodes$1[nodeData2.rightChild()];
                        node = new InternalNode(nodeData2.prediction(), nodeData2.impurity(), nodeData2.gain(), leftChild, rightChild, nodeData2.split().getSplit(), impurityStats);
                    } else {
                        node = new LeafNode(nodeData2.prediction(), nodeData2.impurity(), impurityStats);
                    }
                    LeafNode node2 = node;
                    this.finalNodes$1[nodeData2.id()] = node2;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)nodeData);
            }
            {
                this.impurityType$1 = impurityType$1;
                this.finalNodes$1 = finalNodes$1;
            }
        });
        return (Node)Predef$.MODULE$.refArrayOps((Object[])finalNodes).head();
    }

    private DecisionTreeModelReadWrite$() {
        MODULE$ = this;
    }
}

