/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.DoubleAccumulator;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeqLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015b\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!DB\u0001\tS:$XM\u001d8bY&\u0011A$\u0007\u0002\b\u0019><w-\u001b8h\u0011!q\u0002A!a\u0001\n\u0013y\u0012!A6\u0016\u0003\u0001\u0002\"aD\u0011\n\u0005\t\u0002\"aA%oi\"AA\u0005\u0001BA\u0002\u0013%Q%A\u0003l?\u0012*\u0017\u000f\u0006\u0002'SA\u0011qbJ\u0005\u0003QA\u0011A!\u00168ji\"9!fIA\u0001\u0002\u0004\u0001\u0013a\u0001=%c!AA\u0006\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!Aa\u0006\u0001BA\u0002\u0013%q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\ta\u0001\u0011\t\u0019!C\u0005c\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0019\u0012\u0004b\u0002\u00160\u0003\u0003\u0005\r\u0001\t\u0005\ti\u0001\u0011\t\u0011)Q\u0005A\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002%%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-Z\u000b\u0002qA\u0011\u0011\b\u0010\b\u0003\u001fiJ!a\u000f\t\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wAA\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!Q\u0001\u0017S:LG/[1mSj\fG/[8o\u001b>$Wm\u0018\u0013fcR\u0011aE\u0011\u0005\bU}\n\t\u00111\u00019\u0011!!\u0005A!A!B\u0013A\u0014aE5oSRL\u0017\r\\5{CRLwN\\'pI\u0016\u0004\u0003\u0002\u0003$\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]N#X\r]:\t\u0011!\u0003!\u00111A\u0005\n%\u000bq#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faN|F%Z9\u0015\u0005\u0019R\u0005b\u0002\u0016H\u0003\u0003\u0005\r\u0001\t\u0005\t\u0019\u0002\u0011\t\u0011)Q\u0005A\u0005!\u0012N\\5uS\u0006d\u0017N_1uS>t7\u000b^3qg\u0002B\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\bKB\u001c\u0018\u000e\\8o+\u0005\u0001\u0006CA\bR\u0013\t\u0011\u0006C\u0001\u0004E_V\u0014G.\u001a\u0005\t)\u0002\u0011\t\u0019!C\u0005+\u0006YQ\r]:jY>tw\fJ3r)\t1c\u000bC\u0004+'\u0006\u0005\t\u0019\u0001)\t\u0011a\u0003!\u0011!Q!\nA\u000b\u0001\"\u001a9tS2|g\u000e\t\u0005\t5\u0002\u0011\t\u0019!C\u00057\u0006!1/Z3e+\u0005a\u0006CA\b^\u0013\tq\u0006C\u0001\u0003M_:<\u0007\u0002\u00031\u0001\u0005\u0003\u0007I\u0011B1\u0002\u0011M,W\rZ0%KF$\"A\n2\t\u000f)z\u0016\u0011!a\u00019\"AA\r\u0001B\u0001B\u0003&A,A\u0003tK\u0016$\u0007\u0005C\u0003g\u0001\u0011%q-\u0001\u0004=S:LGO\u0010\u000b\bQ*\\G.\u001c8p!\tI\u0007!D\u0001\u0003\u0011\u0015qR\r1\u0001!\u0011\u0015qS\r1\u0001!\u0011\u00151T\r1\u00019\u0011\u00151U\r1\u0001!\u0011\u0015qU\r1\u0001Q\u0011\u0015QV\r1\u0001]\u0011\u00151\u0007\u0001\"\u0001r)\u0005A\u0007f\u00019tsB\u0011Ao^\u0007\u0002k*\u0011aOB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001=v\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0018!\u0002\u0019/q9\u0002\u0004\"\u0002?\u0001\t\u0003y\u0012\u0001B4fi.C3a_:\u007fC\u0005y\u0018!B\u0019/i9\u0002\u0004bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0005g\u0016$8\n\u0006\u0003\u0002\b\u0005%Q\"\u0001\u0001\t\ry\t\t\u00011\u0001!Q\u0011\t\ta]=\t\r\u0005=\u0001\u0001\"\u0001 \u0003A9W\r^'bq&#XM]1uS>t7\u000f\u000b\u0003\u0002\u000eMt\bbBA\u000b\u0001\u0011\u0005\u0011qC\u0001\u0011g\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]N$B!a\u0002\u0002\u001a!1a&a\u0005A\u0002\u0001BC!a\u0005ts\"1\u0011q\u0004\u0001\u0005\u0002]\nQcZ3u\u0013:LG/[1mSj\fG/[8o\u001b>$W\r\u000b\u0003\u0002\u001eMt\bbBA\u0013\u0001\u0011\u0005\u0011qE\u0001\u0016g\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>tWj\u001c3f)\u0011\t9!!\u000b\t\rY\n\u0019\u00031\u00019Q\u0011\t\u0019c]=\t\r\u0005=\u0002\u0001\"\u0001 \u0003\u001d9W\r\u001e*v]ND\u0003\"!\f\u00024\u0005e\u0012Q\b\t\u0004\u001f\u0005U\u0012bAA\u001c!\tQA-\u001a9sK\u000e\fG/\u001a3\"\u0005\u0005m\u0012a\n+iSN\u0004\u0003.Y:!]>\u0004SM\u001a4fGR\u0004\u0013M\u001c3!C2<\u0018-_:!e\u0016$XO\u001d8tAE\n#!a\u0010\u0002\u000bIr\u0013G\f\u0019)\t\u000552O \u0005\b\u0003\u000b\u0002A\u0011AA$\u0003\u001d\u0019X\r\u001e*v]N$B!a\u0002\u0002J!9\u00111JA\"\u0001\u0004\u0001\u0013\u0001\u0002:v]ND\u0003\"a\u0011\u00024\u0005=\u0013QH\u0011\u0003\u0003#\n!\u0003\u00165jg\u0002B\u0017m\u001d\u0011o_\u0002*gMZ3di\"\"\u00111I:z\u0011\u0019\t9\u0006\u0001C\u0001?\u00051r-\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\u000b\u0003\u0002VMt\bbBA/\u0001\u0011\u0005\u0011qL\u0001\u0017g\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>t7\u000b^3qgR!\u0011qAA1\u0011\u00191\u00151\fa\u0001A!\"\u00111L:z\u0011\u0019\t9\u0007\u0001C\u0001\u001f\u0006Qq-\u001a;FaNLGn\u001c8)\t\u0005\u00154O \u0005\b\u0003[\u0002A\u0011AA8\u0003)\u0019X\r^#qg&dwN\u001c\u000b\u0005\u0003\u000f\t\t\b\u0003\u0004O\u0003W\u0002\r\u0001\u0015\u0015\u0005\u0003W\u001a\u0018\u0010\u0003\u0004\u0002x\u0001!\taW\u0001\bO\u0016$8+Z3eQ\u0011\t)h\u001d@\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u000591/\u001a;TK\u0016$G\u0003BA\u0004\u0003\u0003CaAWA>\u0001\u0004a\u0006\u0006BA>gzD\u0011\"a\"\u0001\u0001\u0004%I!!#\u0002\u0019%t\u0017\u000e^5bY6{G-\u001a7\u0016\u0005\u0005-\u0005#B\b\u0002\u000e\u0006E\u0015bAAH!\t1q\n\u001d;j_:\u00042![AJ\u0013\r\t)J\u0001\u0002\f\u00176+\u0017M\\:N_\u0012,G\u000eC\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002\u001c\u0006\u0001\u0012N\\5uS\u0006dWj\u001c3fY~#S-\u001d\u000b\u0004M\u0005u\u0005\"\u0003\u0016\u0002\u0018\u0006\u0005\t\u0019AAF\u0011!\t\t\u000b\u0001Q!\n\u0005-\u0015!D5oSRL\u0017\r\\'pI\u0016d\u0007\u0005C\u0004\u0002&\u0002!\t!a*\u0002\u001fM,G/\u00138ji&\fG.T8eK2$B!a\u0002\u0002*\"A\u00111VAR\u0001\u0004\t\t*A\u0003n_\u0012,G\u000e\u000b\u0003\u0002$Nt\bbBAY\u0001\u0011\u0005\u00111W\u0001\u0004eVtG\u0003BAI\u0003kC\u0001\"a.\u00020\u0002\u0007\u0011\u0011X\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0002<\u0006\u0005\u0017QY\u0007\u0003\u0003{S1!a0\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0007\fiLA\u0002S\t\u0012\u0003B!a2\u0002N6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017$\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002P\u0006%'A\u0002,fGR|'\u000f\u000b\u0003\u00020NL\b\u0002CAY\u0001\u0011\u0005a!!6\u0015\r\u0005E\u0015q[Am\u0011!\t9,a5A\u0002\u0005e\u0006\u0002CAn\u0003'\u0004\r!!8\u0002\u000b%t7\u000f\u001e:\u0011\u000b=\ti)a8\u0011\r\u0005\u0005\u00181^Ax\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018\u0001B;uS2T1!!;\u0007\u0003\tiG.\u0003\u0003\u0002n\u0006\r(aD%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0011\t\u0005E\u0018Q_\u0007\u0003\u0003gT1aAAt\u0013\r\t\u00111\u001f\u0005\b\u0003s\u0004A\u0011BA~\u00031\u0011XO\\!mO>\u0014\u0018\u000e\u001e5n)\u0019\t\t*!@\u0003\b!A\u0011qWA|\u0001\u0004\ty\u0010\u0005\u0004\u0002<\u0006\u0005'\u0011\u0001\t\u0004S\n\r\u0011b\u0001B\u0003\u0005\tqa+Z2u_J<\u0016\u000e\u001e5O_Jl\u0007\u0002CAn\u0003o\u0004\r!!8\t\u000f\t-\u0001\u0001\"\u0003\u0003\u000e\u0005Q\u0011N\\5u%\u0006tGm\\7\u0015\t\t=!Q\u0003\t\u0006\u001f\tE!\u0011A\u0005\u0004\u0005'\u0001\"!B!se\u0006L\b\u0002CA\\\u0005\u0013\u0001\r!a@\t\u0011\te\u0001\u0001\"\u0001\u0003\u00057\t!#\u001b8ji.kU-\u00198t!\u0006\u0014\u0018\r\u001c7fYR!!q\u0002B\u000f\u0011!\t9La\u0006A\u0002\u0005}\bf\u0001\u0001ts\u001e9!1\u0005\u0002\t\u0002\t\u0015\u0012AB&NK\u0006t7\u000fE\u0002j\u0005O1a!\u0001\u0002\t\u0002\t%2\u0003\u0002B\u0014\u001dQAqA\u001aB\u0014\t\u0003\u0011i\u0003\u0006\u0002\u0003&!Q!\u0011\u0007B\u0014\u0005\u0004%\tAa\r\u0002\rI\u000be\nR(N+\t\u0011)\u0004\u0005\u0003\u00038\t\u0005SB\u0001B\u001d\u0015\u0011\u0011YD!\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0005\u007f\tAA[1wC&\u0019QH!\u000f)\t\t=2/\u001f\u0005\n\u0005\u000f\u00129\u0003)A\u0005\u0005k\tqAU!O\t>k\u0005\u0005\u000b\u0003\u0003FML\bB\u0003B'\u0005O\u0011\r\u0011\"\u0001\u00034\u0005\u00012jX'F\u0003:\u001bv\fU!S\u00032cU\t\u0014\u0015\u0005\u0005\u0017\u001a\u0018\u0010C\u0005\u0003T\t\u001d\u0002\u0015!\u0003\u00036\u0005\t2jX'F\u0003:\u001bv\fU!S\u00032cU\t\u0014\u0011)\t\tE3/\u001f\u0005\t\u00053\u00129\u0003\"\u0001\u0003\\\u0005)AO]1j]Ra\u0011\u0011\u0013B/\u0005?\u0012\tGa\u0019\u0003f!A\u0011q\u0017B,\u0001\u0004\tI\f\u0003\u0004\u001f\u0005/\u0002\r\u0001\t\u0005\u0007]\t]\u0003\u0019\u0001\u0011\t\rY\u00129\u00061\u00019\u0011\u0019Q&q\u000ba\u00019\"*!qK:\u0002>!A!\u0011\fB\u0014\t\u0003\u0011Y\u0007\u0006\u0006\u0002\u0012\n5$q\u000eB9\u0005gB\u0001\"a.\u0003j\u0001\u0007\u0011\u0011\u0018\u0005\u0007=\t%\u0004\u0019\u0001\u0011\t\r9\u0012I\u00071\u0001!\u0011\u00191$\u0011\u000ea\u0001q!*!\u0011N:\u0002>!A!\u0011\fB\u0014\t\u0003\u0011I\b\u0006\b\u0002\u0012\nm$Q\u0010B@\u0005\u0003\u0013\u0019I!\"\t\u0011\u0005]&q\u000fa\u0001\u0003sCaA\bB<\u0001\u0004\u0001\u0003B\u0002\u0018\u0003x\u0001\u0007\u0001\u0005C\u0004\u0002L\t]\u0004\u0019\u0001\u0011\t\rY\u00129\b1\u00019\u0011\u0019Q&q\u000fa\u00019\"B!qOA\u001a\u0005\u0013\u000bi$\t\u0002\u0003\f\u0006yRk]3!iJ\f\u0017N\u001c\u0011nKRDw\u000e\u001a\u0011xSRDw.\u001e;!OI,hn]\u0014)\u000b\t]4Oa$\"\u0005\tE\u0015!B\u0019/g9\u0002\u0004\u0002\u0003B-\u0005O!\tA!&\u0015\u0019\u0005E%q\u0013BM\u00057\u0013iJa(\t\u0011\u0005]&1\u0013a\u0001\u0003sCaA\bBJ\u0001\u0004\u0001\u0003B\u0002\u0018\u0003\u0014\u0002\u0007\u0001\u0005C\u0004\u0002L\tM\u0005\u0019\u0001\u0011\t\rY\u0012\u0019\n1\u00019Q!\u0011\u0019*a\r\u0003\n\u0006u\u0002\u0006\u0002BJgfD\u0001B!\u0017\u0003(\u0011\u0005!q\u0015\u000b\t\u0003#\u0013IKa+\u0003.\"A\u0011q\u0017BS\u0001\u0004\tI\f\u0003\u0004\u001f\u0005K\u0003\r\u0001\t\u0005\u0007]\t\u0015\u0006\u0019\u0001\u0011)\t\t\u00156/\u001f\u0005\t\u00053\u00129\u0003\"\u0001\u00034RQ\u0011\u0011\u0013B[\u0005o\u0013ILa/\t\u0011\u0005]&\u0011\u0017a\u0001\u0003sCaA\bBY\u0001\u0004\u0001\u0003B\u0002\u0018\u00032\u0002\u0007\u0001\u0005C\u0004\u0002L\tE\u0006\u0019\u0001\u0011)\u0011\tE\u00161\u0007BE\u0003{ACA!-ts\"I!1\u0019B\u0014\t\u0003!!QY\u0001\fM&tGm\u00117pg\u0016\u001cH\u000f\u0006\u0004\u0003H\n5'\u0011\u001e\t\u0006\u001f\t%\u0007\u0005U\u0005\u0004\u0005\u0017\u0004\"A\u0002+va2,'\u0007\u0003\u0005\u0003P\n\u0005\u0007\u0019\u0001Bi\u0003\u001d\u0019WM\u001c;feN\u0004bAa5\u0003d\n\u0005a\u0002\u0002Bk\u0005?tAAa6\u0003^6\u0011!\u0011\u001c\u0006\u0004\u00057d\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\r\u0011\t\u000fE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Oa:\u0003\u001fQ\u0013\u0018M^3sg\u0006\u0014G.Z(oG\u0016T1A!9\u0011\u0011!\u0011YO!1A\u0002\t\u0005\u0011!\u00029pS:$\b\"\u0003Bx\u0005O!\t\u0001\u0002By\u0003%\u0001x.\u001b8u\u0007>\u001cH\u000fF\u0003Q\u0005g\u0014)\u0010\u0003\u0005\u0003P\n5\b\u0019\u0001Bi\u0011!\u0011YO!<A\u0002\t\u0005\u0001\"\u0003B}\u0005O!\tA\u0001B~\u0003M1\u0017m\u001d;TcV\f'/\u001a3ESN$\u0018M\\2f)\u0015\u0001&Q`B\u0001\u0011!\u0011yPa>A\u0002\t\u0005\u0011A\u0001<2\u0011!\u0019\u0019Aa>A\u0002\t\u0005\u0011A\u0001<3\u0011%\u00199Aa\n\u0005\u0002\u0019\u0019I!\u0001\twC2LG-\u0019;f\u0013:LG/T8eKR!11BB\t!\ry1QB\u0005\u0004\u0007\u001f\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0007'\u0019)\u00011\u00019\u0003!Ig.\u001b;N_\u0012,\u0007BCB\f\u0005O\t\t\u0011\"\u0003\u0004\u001a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0002\u0005\u0003\u00038\ru\u0011\u0002BB\u0010\u0005s\u0011aa\u00142kK\u000e$\b\u0006\u0002B\u0014gfDCA!\tts\u0002")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private long seed;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k();
    }

    public KMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of clusters must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0)new Serializable(this, maxIterations){
            public static final long serialVersionUID = 0L;
            private final int maxIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIterations$1)}));
            }
            {
                this.maxIterations$1 = maxIterations$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return 1;
    }

    public KMeans setRuns(int runs) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Setting number of runs has no effect since Spark 2.0.0.";
            }
        });
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        Predef$.MODULE$.require(initializationSteps > 0, (Function0)new Serializable(this, initializationSteps){
            public static final long serialVersionUID = 0L;
            private final int initializationSteps$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of initialization steps must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.initializationSteps$1)}));
            }
            {
                this.initializationSteps$1 = initializationSteps$1;
            }
        });
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        Predef$.MODULE$.require(epsilon >= 0.0, (Function0)new Serializable(this, epsilon){
            public static final long serialVersionUID = 0L;
            private final double epsilon$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Distance threshold must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.epsilon$1)}));
            }
            {
                this.epsilon$1 = epsilon$1;
            }
        });
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.org$apache$spark$mllib$clustering$KMeans$$k(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mismatched cluster count";
            }
        });
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        return this.run(data, (Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>>)None$.MODULE$);
    }

    public KMeansModel run(RDD<Vector> data, Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>> instr) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector x$1) {
                return Vectors$.MODULE$.norm(x$1, 2.0);
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector v = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        KMeansModel model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData, instr);
        norms.unpersist(norms.unpersist$default$1());
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data, Option<Instrumentation<org.apache.spark.ml.clustering.KMeans>> instr) {
        Option<KMeansModel> option;
        block8: {
            VectorWithNorm[] vectorWithNormArray;
            long initStartTime;
            SparkContext sc;
            block7: {
                block6: {
                    sc = data.sparkContext();
                    initStartTime = System.nanoTime();
                    option = this.initialModel();
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    KMeansModel kMeansCenters = (KMeansModel)some.x();
                    vectorWithNormArray = (VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Vector x$2) {
                            return new VectorWithNorm(x$2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<KMeansModel> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                String string2 = KMeans$.MODULE$.RANDOM();
                vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data);
            }
            VectorWithNorm[] centers = vectorWithNormArray;
            double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final double initTimeInSeconds$1;

                public final String apply() {
                    String arg$1 = this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                    double arg$2 = this.initTimeInSeconds$1;
                    return new StringOps(Predef$.MODULE$.augmentString("Initialization with %s took %.3f seconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$1, BoxesRunTime.boxToDouble((double)arg$2)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.initTimeInSeconds$1 = initTimeInSeconds$1;
                }
            });
            BooleanRef converged = new BooleanRef(false);
            DoubleRef cost = new DoubleRef(0.0);
            IntRef iteration = new IntRef(0);
            long iterationStartTime = System.nanoTime();
            instr.foreach((Function1)new Serializable(this, centers){
                public static final long serialVersionUID = 0L;
                private final VectorWithNorm[] centers$1;

                public final void apply(Instrumentation<org.apache.spark.ml.clustering.KMeans> x$3) {
                    x$3.logNumFeatures(((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])this.centers$1).head()).vector().size());
                }
                {
                    this.centers$1 = centers$1;
                }
            });
            while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !converged.elem) {
                DoubleAccumulator costAccum = sc.doubleAccumulator();
                Broadcast bcCenters = sc.broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
                Map totalContribs = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, costAccum, bcCenters){
                    public static final long serialVersionUID = 0L;
                    public final DoubleAccumulator costAccum$1;
                    private final Broadcast bcCenters$1;

                    public final Iterator<Tuple2<Object, Tuple2<Vector, Object>>> apply(Iterator<VectorWithNorm> points) {
                        VectorWithNorm[] thisCenters = (VectorWithNorm[])this.bcCenters$1.value();
                        int dims = ((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])thisCenters).head()).vector().size();
                        Vector[] sums = (Vector[])Array$.MODULE$.fill(thisCenters.length, (Function0)new Serializable(this, dims){
                            public static final long serialVersionUID = 0L;
                            private final int dims$1;

                            public final Vector apply() {
                                return Vectors$.MODULE$.zeros(this.dims$1);
                            }
                            {
                                this.dims$1 = dims$1;
                            }
                        }, ClassTag$.MODULE$.apply(Vector.class));
                        long[] counts = (long[])Array$.MODULE$.fill(thisCenters.length, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }, ClassTag$.MODULE$.Long());
                        points.foreach((Function1)new Serializable(this, thisCenters, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final VectorWithNorm[] thisCenters$1;
                            private final Vector[] sums$1;
                            private final long[] counts$1;

                            public final void apply(VectorWithNorm point) {
                                Tuple2<Object, Object> tuple2 = KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.thisCenters$1), point);
                                if (tuple2 != null) {
                                    Tuple2.mcID.sp sp2;
                                    int bestCenter = tuple2._1$mcI$sp();
                                    double cost = tuple2._2$mcD$sp();
                                    Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                    int bestCenter2 = sp3._1$mcI$sp();
                                    double cost2 = sp3._2$mcD$sp();
                                    this.$outer.costAccum$1.add(cost2);
                                    Vector sum = this.sums$1[bestCenter2];
                                    BLAS$.MODULE$.axpy(1.0, point.vector(), sum);
                                    this.counts$1[bestCenter2] = this.counts$1[bestCenter2] + 1L;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.thisCenters$1 = thisCenters$1;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        });
                        return ((IndexedSeqLike)((TraversableLike)Predef$.MODULE$.longArrayOps(counts).indices().filter((Function1)new Serializable(this, counts){
                            public static final long serialVersionUID = 0L;
                            private final long[] counts$1;

                            public final boolean apply(int x$5) {
                                return this.apply$mcZI$sp(x$5);
                            }

                            public boolean apply$mcZI$sp(int x$5) {
                                return this.counts$1[x$5] > 0L;
                            }
                            {
                                this.counts$1 = counts$1;
                            }
                        })).map((Function1)new Serializable(this, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final Vector[] sums$1;
                            private final long[] counts$1;

                            public final Tuple2<Object, Tuple2<Vector, Object>> apply(int j) {
                                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple2((Object)this.sums$1[j], (Object)BoxesRunTime.boxToLong((long)this.counts$1[j])));
                            }
                            {
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).iterator();
                    }
                    {
                        this.costAccum$1 = costAccum$1;
                        this.bcCenters$1 = bcCenters$1;
                    }
                }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> x0$2, Tuple2<Vector, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Tuple2 tuple23 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Vector sum1 = (Vector)tuple22._1();
                                long count1 = tuple22._2$mcJ$sp();
                                if (tuple23 != null) {
                                    Vector sum2 = (Vector)tuple23._1();
                                    long count2 = tuple23._2$mcJ$sp();
                                    BLAS$.MODULE$.axpy(1.0, sum2, sum1);
                                    Tuple2 tuple24 = new Tuple2((Object)sum1, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
                                    return tuple24;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
                bcCenters.destroy(false);
                converged.elem = true;
                totalContribs.foreach((Function1)new Serializable(this, centers, converged){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;
                    private final VectorWithNorm[] centers$1;
                    private final BooleanRef converged$1;

                    public final void apply(Tuple2<Object, Tuple2<Vector, Object>> x0$3) {
                        Tuple2<Object, Tuple2<Vector, Object>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            int j = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Vector sum = (Vector)tuple22._1();
                                long count = tuple22._2$mcJ$sp();
                                BLAS$.MODULE$.scal(1.0 / (double)count, sum);
                                VectorWithNorm newCenter = new VectorWithNorm(sum);
                                if (this.converged$1.elem && KMeans$.MODULE$.fastSquaredDistance(newCenter, this.centers$1[j]) > this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon() * this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon()) {
                                    this.converged$1.elem = false;
                                }
                                this.centers$1[j] = newCenter;
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.centers$1 = centers$1;
                        this.converged$1 = converged$1;
                    }
                });
                cost.elem = Predef$.MODULE$.Double2double(costAccum.value());
                ++iteration.elem;
            }
            double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final double iterationTimeInSeconds$1;

                public final String apply() {
                    double arg$3 = this.iterationTimeInSeconds$1;
                    return new StringOps(Predef$.MODULE$.augmentString("Iterations took %.3f seconds.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$3)}));
                }
                {
                    this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
                }
            });
            if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this, iteration){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iteration$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                    }
                    {
                        this.iteration$1 = iteration$1;
                    }
                });
            }
            this.logInfo((Function0<String>)new Serializable(this, cost){
                public static final long serialVersionUID = 0L;
                private final DoubleRef cost$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.cost$1.elem)}));
                }
                {
                    this.cost$1 = cost$1;
                }
            });
            return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(VectorWithNorm x$6) {
                    return x$6.vector();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))));
        }
        throw new MatchError(option);
    }

    private VectorWithNorm[] initRandom(RDD<VectorWithNorm> data) {
        return (VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])data.takeSample(false, this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom(this.seed()).nextInt())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(VectorWithNorm x$7) {
                return x$7.vector();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)))).distinct()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$8) {
                return new VectorWithNorm(x$8);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)));
    }

    public VectorWithNorm[] initKMeansParallel(RDD<VectorWithNorm> data) {
        VectorWithNorm[] vectorWithNormArray;
        RDD costs = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(VectorWithNorm x$9) {
                return Double.POSITIVE_INFINITY;
            }
        }, ClassTag$.MODULE$.Double());
        int seed = new XORShiftRandom(this.seed()).nextInt();
        VectorWithNorm[] sample = (VectorWithNorm[])data.takeSample(false, 1, (long)seed);
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])sample).nonEmpty(), (Function0)new Serializable(this, data){
            public static final long serialVersionUID = 0L;
            private final RDD data$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No samples available from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.data$1}));
            }
            {
                this.data$1 = data$1;
            }
        });
        ArrayBuffer centers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Seq newCenters = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)Predef$.MODULE$.refArrayOps((Object[])sample).head()).toDense()}));
        centers.$plus$plus$eq((TraversableOnce)newCenters);
        IntRef step = new IntRef(0);
        ArrayBuffer bcNewCentersList = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(Seq.class));
            bcNewCentersList.$plus$eq((Object)bcNewCenters);
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this, bcNewCenters){
                public static final long serialVersionUID = 0L;
                private final Broadcast bcNewCenters$1;

                public final double apply(Tuple2<VectorWithNorm, Object> x0$4) {
                    Tuple2<VectorWithNorm, Object> tuple2 = x0$4;
                    if (tuple2 != null) {
                        VectorWithNorm point = (VectorWithNorm)tuple2._1();
                        double cost = tuple2._2$mcD$sp();
                        double d = package$.MODULE$.min(KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcNewCenters$1.value()), point), cost);
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.bcNewCenters$1 = bcNewCenters$1;
                }
            }, ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double sumCosts = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(costs).sum();
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.Double());
            Serializable x$17 = new Serializable(this, seed, step, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                private final IntRef step$1;
                public final double sumCosts$1;

                public final Iterator<VectorWithNorm> apply(int index2, Iterator<Tuple2<VectorWithNorm, Object>> pointCosts) {
                    XORShiftRandom rand2 = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index2));
                    return pointCosts.filter((Function1)new Serializable(this, rand2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$10 $outer;
                        private final XORShiftRandom rand$1;

                        public final boolean apply(Tuple2<VectorWithNorm, Object> x0$5) {
                            Tuple2<VectorWithNorm, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                double c = tuple2._2$mcD$sp();
                                boolean bl = this.rand$1.nextDouble() < 2.0 * c * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / this.$outer.sumCosts$1;
                                return bl;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Tuple2<VectorWithNorm, Object> x$10) {
                            return (VectorWithNorm)x$10._1();
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.step$1 = step$1;
                    this.sumCosts$1 = sumCosts$1;
                }
            };
            boolean x$18 = qual$1.mapPartitionsWithIndex$default$2();
            VectorWithNorm[] chosen = (VectorWithNorm[])qual$1.mapPartitionsWithIndex((Function2)x$17, x$18, ClassTag$.MODULE$.apply(VectorWithNorm.class)).collect();
            newCenters = (Seq)Predef$.MODULE$.refArrayOps((Object[])chosen).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final VectorWithNorm apply(VectorWithNorm x$11) {
                    return x$11.toDense();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            centers.$plus$plus$eq((TraversableOnce)newCenters);
            ++step.elem;
        }
        costs.unpersist(false);
        bcNewCentersList.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Broadcast<?> x$12) {
                x$12.destroy(false);
            }
        });
        ArrayBuffer distinctCenters = (ArrayBuffer)((TraversableLike)((SeqLike)centers.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Vector apply(VectorWithNorm x$13) {
                return x$13.vector();
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom())).distinct()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$14) {
                return new VectorWithNorm(x$14);
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        if (distinctCenters.size() <= this.org$apache$spark$mllib$clustering$KMeans$$k()) {
            vectorWithNormArray = (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
        } else {
            Broadcast bcCenters = data.context().broadcast((Object)distinctCenters, ClassTag$.MODULE$.apply(ArrayBuffer.class));
            Map countMap = data.map((Function1)new Serializable(this, bcCenters){
                public static final long serialVersionUID = 0L;
                private final Broadcast bcCenters$2;

                public final int apply(VectorWithNorm x$15) {
                    return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCenters$2.value()), x$15)._1$mcI$sp();
                }
                {
                    this.bcCenters$2 = bcCenters$2;
                }
            }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
            bcCenters.destroy(false);
            double[] myWeights = (double[])((TraversableOnce)distinctCenters.indices().map((Function1)new Serializable(this, countMap){
                public static final long serialVersionUID = 0L;
                private final Map countMap$1;

                public final double apply(int x$16) {
                    return this.apply$mcDI$sp(x$16);
                }

                public double apply$mcDI$sp(int x$16) {
                    return BoxesRunTime.unboxToLong((Object)this.countMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)x$16), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }));
                }
                {
                    this.countMap$1 = countMap$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            vectorWithNormArray = LocalKMeans$.MODULE$.kMeansPlusPlus(0, (VectorWithNorm[])distinctCenters.toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class)), myWeights, this.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
        }
        return vectorWithNormArray;
    }

    private KMeans(int k, int maxIterations, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    public KMeans() {
        this(2, 20, KMeans$.MODULE$.K_MEANS_PARALLEL(), 2, 1.0E-4, Utils$.MODULE$.random().nextLong());
    }
}

