/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005%b!B\u0001\u0003\u0003\u0003Y!a\u0004)sK\u0012L7\r^5p]6{G-\u001a7\u000b\u0005\r!\u0011AA7m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0004\u0019y\u00192c\u0001\u0001\u000eIA\u0019abD\t\u000e\u0003\tI!\u0001\u0005\u0002\u0003\u000b5{G-\u001a7\u0011\u0005I\u0019B\u0002\u0001\u0003\u0006)\u0001\u0011\r!\u0006\u0002\u0002\u001bF\u0011a\u0003\b\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\b\u001d>$\b.\u001b8h!\u0011q\u0001!H\t\u0011\u0005IqB!B\u0010\u0001\u0005\u0004\u0001#\u0001\u0004$fCR,(/Z:UsB,\u0017C\u0001\f\"!\t9\"%\u0003\u0002$1\t\u0019\u0011I\\=\u0011\u00059)\u0013B\u0001\u0014\u0003\u0005=\u0001&/\u001a3jGR|'\u000fU1sC6\u001c\b\"\u0002\u0015\u0001\t\u0003I\u0013A\u0002\u001fj]&$h\bF\u0001\u001d\u0011\u0015Y\u0003\u0001\"\u0001-\u00039\u0019X\r\u001e$fCR,(/Z:D_2$\"!E\u0017\t\u000b9R\u0003\u0019A\u0018\u0002\u000bY\fG.^3\u0011\u0005A:dBA\u00196!\t\u0011\u0004$D\u00014\u0015\t!$\"\u0001\u0004=e>|GOP\u0005\u0003ma\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001d:\u0005\u0019\u0019FO]5oO*\u0011a\u0007\u0007\u0005\u0006w\u0001!\t\u0001P\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"!E\u001f\t\u000b9R\u0004\u0019A\u0018\t\u000b}\u0002A\u0011\u0001!\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002\u0003B\u0011qCQ\u0005\u0003\u0007b\u00111!\u00138uQ\rqTi\u0013\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\t!\"\u00198o_R\fG/[8o\u0013\tQuIA\u0003TS:\u001cW-I\u0001M\u0003\u0015\tdF\u000e\u00181\u0011\u0015q\u0005\u0001\"\u0005P\u0003A1W-\u0019;ve\u0016\u001cH)\u0019;b)f\u0004X-F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0003usB,7O\u0003\u0002V\t\u0005\u00191/\u001d7\n\u0005]\u0013&\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000be\u0003A\u0011\t.\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$\"a\u00170\u0011\u0005Ec\u0016BA/S\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006?b\u0003\raW\u0001\u0007g\u000eDW-\\1\t\u000b\u0005\u0004A\u0011\t2\u0002\u0013Q\u0014\u0018M\\:g_JlGCA2s!\t!wN\u0004\u0002f[:\u0011a\r\u001c\b\u0003O.t!\u0001\u001b6\u000f\u0005IJ\u0017\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t)F!\u0003\u0002o)\u00069\u0001/Y2lC\u001e,\u0017B\u00019r\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002o)\")1\u000f\u0019a\u0001i\u00069A-\u0019;bg\u0016$\bGA;{!\r1x/_\u0007\u0002)&\u0011\u0001\u0010\u0016\u0002\b\t\u0006$\u0018m]3u!\t\u0011\"\u0010B\u0005|e\u0006\u0005\t\u0011!B\u0001A\t\u0019q\f\n\u001b\t\u000bu\u0004A\u0011\u0003@\u0002\u001bQ\u0014\u0018M\\:g_Jl\u0017*\u001c9m)\t\u0019w\u0010\u0003\u0004ty\u0002\u0007\u0011\u0011\u0001\u0019\u0005\u0003\u0007\t9\u0001\u0005\u0003wo\u0006\u0015\u0001c\u0001\n\u0002\b\u0011Q\u0011\u0011B@\u0002\u0002\u0003\u0005)\u0011\u0001\u0011\u0003\u0007}#S\u0007C\u0004\u0002\u000e\u00011\t!a\u0004\u0002\u000fA\u0014X\rZ5diR!\u0011\u0011CA\f!\r9\u00121C\u0005\u0004\u0003+A\"A\u0002#pk\ndW\rC\u0004\u0002\u001a\u0005-\u0001\u0019A\u000f\u0002\u0011\u0019,\u0017\r^;sKNDS!a\u0003F\u0003;\t#!a\b\u0002\u000bIrCG\f\u0019)\u0007\u0001\t\u0019\u0003E\u0002G\u0003KI1!a\nH\u00051!UM^3m_B,'/\u00119j\u0001")
public abstract class PredictionModel<FeaturesType, M extends PredictionModel<FeaturesType, M>>
extends Model<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    public M setFeaturesCol(String value) {
        return (M)((PredictionModel)this.set(this.featuresCol(), value));
    }

    public M setPredictionCol(String value) {
        return (M)((PredictionModel)this.set(this.predictionCol(), value));
    }

    public int numFeatures() {
        return -1;
    }

    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false, this.featuresDataType());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        this.transformSchema(dataset.schema(), true);
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            dataset2 = this.transformImpl(dataset);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append(this.uid()).append(": Predictor.transform() was called as NOOP").append(" since no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    public abstract double predict(FeaturesType var1);

    public PredictionModel() {
        HasLabelCol.$init$(this);
        HasFeaturesCol.$init$(this);
        HasPredictionCol.$init$(this);
        PredictorParams.$init$(this);
    }
}

