/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Mb!B\u0001\u0003\u0003\u0003Y!!\u0003)sK\u0012L7\r^8s\u0015\t\u0019A!\u0001\u0002nY*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0016\t1\u0001cfE\n\u0004\u000151\u0003c\u0001\b\u0010#5\t!!\u0003\u0002\u0011\u0005\tIQi\u001d;j[\u0006$xN\u001d\t\u0003%Ma\u0001\u0001B\u0003\u0015\u0001\t\u0007QCA\u0001N#\t1B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0004O_RD\u0017N\\4\u0011\t9ir$E\u0005\u0003=\t\u0011q\u0002\u0015:fI&\u001cG/[8o\u001b>$W\r\u001c\t\u0003%\u0001\"Q!\t\u0001C\u0002\t\u0012ABR3biV\u0014Xm\u001d+za\u0016\f\"AF\u0012\u0011\u0005]!\u0013BA\u0013\u0019\u0005\r\te.\u001f\t\u0003\u001d\u001dJ!\u0001\u000b\u0002\u0003\u001fA\u0013X\rZ5di>\u0014\b+\u0019:b[NDQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtD#\u0001\u0017\u0011\u000b9\u0001q$L\t\u0011\u0005IqC!B\u0018\u0001\u0005\u0004\u0001$a\u0002'fCJtWM]\t\u0003-1BQA\r\u0001\u0005\u0002M\n1b]3u\u0019\u0006\u0014W\r\\\"pYR\u0011Q\u0006\u000e\u0005\u0006kE\u0002\rAN\u0001\u0006m\u0006dW/\u001a\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005eBR\"\u0001\u001e\u000b\u0005mR\u0011A\u0002\u001fs_>$h(\u0003\u0002>1\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\ti\u0004\u0004C\u0003C\u0001\u0011\u00051)\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\u00055\"\u0005\"B\u001bB\u0001\u00041\u0004\"\u0002$\u0001\t\u00039\u0015\u0001E:fiB\u0013X\rZ5di&|gnQ8m)\ti\u0003\nC\u00036\u000b\u0002\u0007a\u0007C\u0003K\u0001\u0011\u00053*A\u0002gSR$\"!\u0005'\t\u000b5K\u0005\u0019\u0001(\u0002\u000f\u0011\fG/Y:fiB\u0012qJ\u0016\t\u0004!N+V\"A)\u000b\u0005I#\u0011aA:rY&\u0011A+\u0015\u0002\b\t\u0006$\u0018m]3u!\t\u0011b\u000bB\u0005X\u0019\u0006\u0005\t\u0011!B\u0001E\t\u0019q\fJ\u0019\t\u000be\u0003a\u0011\t.\u0002\t\r|\u0007/\u001f\u000b\u0003[mCQ\u0001\u0018-A\u0002u\u000bQ!\u001a=ue\u0006\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0002\u0002\u000bA\f'/Y7\n\u0005\t|&\u0001\u0003)be\u0006lW*\u00199\t\u000b\u0011\u0004a\u0011C3\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0005E1\u0007\"B'd\u0001\u00049\u0007G\u00015k!\r\u00016+\u001b\t\u0003%)$\u0011b\u001b4\u0002\u0002\u0003\u0005)\u0011\u0001\u0012\u0003\u0007}##\u0007\u0003\u0004n\u0001\u0011\u0005!A\\\u0001\u0011M\u0016\fG/\u001e:fg\u0012\u000bG/\u0019+za\u0016,\u0012a\u001c\t\u0003aNl\u0011!\u001d\u0006\u0003eF\u000bQ\u0001^=qKNL!\u0001^9\u0003\u0011\u0011\u000bG/\u0019+za\u0016DQA\u001e\u0001\u0005B]\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0003qn\u0004\"\u0001]=\n\u0005i\f(AC*ueV\u001cG\u000fV=qK\")A0\u001ea\u0001q\u000611o\u00195f[\u0006DQA \u0001\u0005\u0012}\fA#\u001a=ue\u0006\u001cG\u000fT1cK2,G\rU8j]R\u001cH\u0003BA\u0001\u00033\u0001b!a\u0001\u0002\n\u00055QBAA\u0003\u0015\r\t9\u0001B\u0001\u0004e\u0012$\u0017\u0002BA\u0006\u0003\u000b\u00111A\u0015#E!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\n\u0005\u00059a-Z1ukJ,\u0017\u0002BA\f\u0003#\u0011A\u0002T1cK2,G\rU8j]RDa!T?A\u0002\u0005m\u0001\u0007BA\u000f\u0003C\u0001B\u0001U*\u0002 A\u0019!#!\t\u0005\u0017\u0005\r\u0012\u0011DA\u0001\u0002\u0003\u0015\tA\t\u0002\u0004?\u0012\u001a\u0004f\u0001\u0001\u0002(A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.\u0011\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t$a\u000b\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5")
public abstract class Predictor<FeaturesType, Learner extends Predictor<FeaturesType, Learner, M>, M extends PredictionModel<FeaturesType, M>>
extends Estimator<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    public Learner setLabelCol(String value) {
        return (Learner)((Predictor)this.set(this.labelCol(), value));
    }

    public Learner setFeaturesCol(String value) {
        return (Learner)((Predictor)this.set(this.featuresCol(), value));
    }

    public Learner setPredictionCol(String value) {
        return (Learner)((Predictor)this.set(this.predictionCol(), value));
    }

    @Override
    public M fit(Dataset<?> dataset) {
        Dataset dataset2;
        this.transformSchema(dataset.schema(), true);
        Metadata labelMeta = dataset.schema().apply(this.$(this.labelCol())).metadata();
        Dataset labelCasted = dataset.withColumn(this.$(this.labelCol()), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), labelMeta);
        Predictor predictor = this;
        if (predictor instanceof HasWeightCol) {
            Dataset dataset3;
            Predictor predictor2 = predictor;
            if (this.isDefined(((HasWeightCol)((Object)predictor2)).weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(((HasWeightCol)((Object)predictor2)).weightCol()))).nonEmpty()) {
                Metadata weightMeta = dataset.schema().apply(this.$(((HasWeightCol)((Object)predictor2)).weightCol())).metadata();
                dataset3 = labelCasted.withColumn(this.$(((HasWeightCol)((Object)predictor2)).weightCol()), functions$.MODULE$.col(this.$(((HasWeightCol)((Object)predictor2)).weightCol())).cast((DataType)DoubleType$.MODULE$), weightMeta);
            } else {
                dataset3 = labelCasted;
            }
            dataset2 = dataset3;
        } else {
            dataset2 = labelCasted;
        }
        Dataset casted = dataset2;
        return (M)((PredictionModel)this.copyValues(((Model)this.train(casted)).setParent(this), this.copyValues$default$2()));
    }

    public abstract Learner copy(ParamMap var1);

    public abstract M train(Dataset<?> var1);

    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true, this.featuresDataType());
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset) {
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public Predictor() {
        HasLabelCol.$init$(this);
        HasFeaturesCol.$init$(this);
        HasPredictionCol.$init$(this);
        PredictorParams.$init$(this);
    }
}

