/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.attribute.UnresolvedAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00015\u0011a\"\u0011;ue&\u0014W\u000f^3He>,\bO\u0003\u0002\u0004\t\u0005I\u0011\r\u001e;sS\n,H/\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u0003\u0011q\u0017-\\3\u0016\u0003i\u0001\"a\u0007\u0012\u000f\u0005q\u0001\u0003CA\u000f\u0011\u001b\u0005q\"BA\u0010\r\u0003\u0019a$o\\8u}%\u0011\u0011\u0005E\u0001\u0007!J,G-\u001a4\n\u0005\r\"#AB*ue&twM\u0003\u0002\"!!Aa\u0005\u0001B\u0001B\u0003%!$A\u0003oC6,\u0007\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001*\u00035qW/\\!uiJL'-\u001e;fgV\t!\u0006E\u0002\u0010W5J!\u0001\f\t\u0003\r=\u0003H/[8o!\tya&\u0003\u00020!\t\u0019\u0011J\u001c;\t\u0011E\u0002!\u0011!Q\u0001\n)\naB\\;n\u0003R$(/\u001b2vi\u0016\u001c\b\u0005\u0003\u00054\u0001\t\u0005\t\u0015!\u00035\u0003\u0015\tG\u000f\u001e:t!\ry1&\u000e\t\u0004\u001fYB\u0014BA\u001c\u0011\u0005\u0015\t%O]1z!\tI$(D\u0001\u0003\u0013\tY$AA\u0005BiR\u0014\u0018NY;uK\")Q\b\u0001C\u0005}\u00051A(\u001b8jiz\"Ba\u0010!B\u0005B\u0011\u0011\b\u0001\u0005\u00061q\u0002\rA\u0007\u0005\u0006Qq\u0002\rA\u000b\u0005\u0006gq\u0002\r\u0001\u000e\u0005\u0006{\u0001!\t\u0001\u0012\u000b\u0003\u007f\u0015CQ\u0001G\"A\u0002iAQ!\u0010\u0001\u0005\u0002\u001d#2a\u0010%J\u0011\u0015Ab\t1\u0001\u001b\u0011\u0015Ac\t1\u0001.\u0011\u0015i\u0004\u0001\"\u0001L)\ryD*\u0014\u0005\u00061)\u0003\rA\u0007\u0005\u0006g)\u0003\r!\u000e\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0003)\tG\u000f\u001e:jEV$Xm]\u000b\u0002i!1!\u000b\u0001Q\u0001\nQ\n1\"\u0019;ue&\u0014W\u000f^3tA!AA\u000b\u0001EC\u0002\u0013%Q+A\u0006oC6,Gk\\%oI\u0016DX#\u0001,\u0011\tm9&$L\u0005\u00031\u0012\u00121!T1q\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0011\u0019\u0018N_3\u0016\u00035BQ!\u0018\u0001\u0005\u0002y\u000bq\u0001[1t\u0003R$(\u000f\u0006\u0002`EB\u0011q\u0002Y\u0005\u0003CB\u0011qAQ8pY\u0016\fg\u000eC\u0003d9\u0002\u0007!$\u0001\u0005biR\u0014h*Y7f\u0011\u0015)\u0007\u0001\"\u0001g\u0003\u001dIg\u000eZ3y\u001f\u001a$\"!L4\t\u000b\r$\u0007\u0019\u0001\u000e\t\u000b%\u0004A\u0011\u00016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005aZ\u0007\"B2i\u0001\u0004Q\u0002\"B7\u0001\t\u0003q\u0017aB4fi\u0006#HO\u001d\u000b\u0003q=DQa\u00197A\u0002iAQ!\u001b\u0001\u0005\u0002E$\"\u0001\u000f:\t\u000bM\u0004\b\u0019A\u0017\u0002\u0013\u0005$HO]%oI\u0016D\b\"B7\u0001\t\u0003)HC\u0001\u001dw\u0011\u0015\u0019H\u000f1\u0001.\u0011\u0019A\b\u0001\"\u0001\u0003s\u0006qAo\\'fi\u0006$\u0017\r^1J[BdW#\u0001>\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0003usB,7O\u0003\u0002\u0000\r\u0005\u00191/\u001d7\n\u0007\u0005\rAP\u0001\u0005NKR\fG-\u0019;b\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t!\u0002^8NKR\fG-\u0019;b)\rQ\u00181\u0002\u0005\b\u0003\u001b\t)\u00011\u0001{\u0003A)\u00070[:uS:<W*\u001a;bI\u0006$\u0018\rC\u0004\u0002\b\u0001!\t!!\u0005\u0015\u0003iDq!!\u0006\u0001\t\u0003\t9\"A\u0007u_N#(/^2u\r&,G\u000e\u001a\u000b\u0005\u00033\ty\u0002E\u0002|\u00037I1!!\b}\u0005-\u0019FO];di\u001aKW\r\u001c3\t\u000f\u00055\u00111\u0003a\u0001u\"9\u0011Q\u0003\u0001\u0005\u0002\u0005\rBCAA\r\u0011\u001d\t9\u0003\u0001C!\u0003S\ta!Z9vC2\u001cHcA0\u0002,!A\u0011QFA\u0013\u0001\u0004\ty#A\u0003pi\",'\u000fE\u0002\u0010\u0003cI1!a\r\u0011\u0005\r\te.\u001f\u0005\b\u0003o\u0001A\u0011IA\u001d\u0003!A\u0017m\u001d5D_\u0012,G#A\u0017\t\u000f\u0005u\u0002\u0001\"\u0011\u0002@\u0005AAo\\*ue&tw\rF\u0001\u001bQ\r\u0001\u00111\t\t\u0005\u0003\u000b\nY%\u0004\u0002\u0002H)\u0019\u0011\u0011\n\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0005\u001d#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BLwaBA)\u0005!\u0005\u00111K\u0001\u000f\u0003R$(/\u001b2vi\u0016<%o\\;q!\rI\u0014Q\u000b\u0004\u0007\u0003\tA\t!a\u0016\u0014\t\u0005Uc\u0002\u0006\u0005\b{\u0005UC\u0011AA.)\t\t\u0019\u0006C\u0005\u0002`\u0005UC\u0011\u0001\u0002\u0002b\u0005aaM]8n\u001b\u0016$\u0018\rZ1uCR)q(a\u0019\u0002h!9\u0011QMA/\u0001\u0004Q\u0018\u0001C7fi\u0006$\u0017\r^1\t\ra\ti\u00061\u0001\u001b\u0011!\tY'!\u0016\u0005\u0002\u00055\u0014a\u00044s_6\u001cFO];di\u001aKW\r\u001c3\u0015\u0007}\ny\u0007\u0003\u0005\u0002r\u0005%\u0004\u0019AA\r\u0003\u00151\u0017.\u001a7e\u0011)\t)(!\u0016\u0002\u0002\u0013%\u0011qO\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001\u00027b]\u001eT!!a!\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\u000biH\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003+\n\u0019\u0005\u000b\u0003\u0002P\u0005\r\u0003")
public class AttributeGroup
implements scala.Serializable {
    private Map<String, Object> nameToIndex;
    private final String name;
    private final Option<Object> numAttributes;
    private final Option<Attribute[]> attributes;
    private volatile boolean bitmap$0;

    public static AttributeGroup fromStructField(StructField structField) {
        return AttributeGroup$.MODULE$.fromStructField(structField);
    }

    public String name() {
        return this.name;
    }

    public Option<Object> numAttributes() {
        return this.numAttributes;
    }

    public Option<Attribute[]> attributes() {
        return this.attributes;
    }

    private Map<String, Object> nameToIndex$lzycompute() {
        AttributeGroup attributeGroup = this;
        synchronized (attributeGroup) {
            if (!this.bitmap$0) {
                this.nameToIndex = (Map)this.attributes().map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).view().flatMap((Function1 & Serializable & scala.Serializable)attr -> Option$.MODULE$.option2Iterable(attr.name().map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$3), attr.index().get()))), IndexedSeqView$.MODULE$.arrCanBuildFrom())).toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
                this.bitmap$0 = true;
            }
        }
        return this.nameToIndex;
    }

    private Map<String, Object> nameToIndex() {
        return !this.bitmap$0 ? this.nameToIndex$lzycompute() : this.nameToIndex;
    }

    public int size() {
        return this.numAttributes().isDefined() ? BoxesRunTime.unboxToInt((Object)this.numAttributes().get()) : (this.attributes().isDefined() ? ((Attribute[])this.attributes().get()).length : -1);
    }

    public boolean hasAttr(String attrName) {
        return this.nameToIndex().contains((Object)attrName);
    }

    public int indexOf(String attrName) {
        return BoxesRunTime.unboxToInt((Object)this.nameToIndex().apply((Object)attrName));
    }

    public Attribute apply(String attrName) {
        return ((Attribute[])this.attributes().get())[this.indexOf(attrName)];
    }

    public Attribute getAttr(String attrName) {
        return this.apply(attrName);
    }

    public Attribute apply(int attrIndex) {
        return ((Attribute[])this.attributes().get())[attrIndex];
    }

    public Attribute getAttr(int attrIndex) {
        return this.apply(attrIndex);
    }

    public Metadata toMetadataImpl() {
        Object object;
        MetadataBuilder bldr = new MetadataBuilder();
        if (this.attributes().isDefined()) {
            ArrayBuffer numericMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer nominalMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            ArrayBuffer binaryMetadata = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.attributes().get())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ArrayBuffer arrayBuffer;
                Attribute attribute = x0$2;
                if (attribute instanceof NumericAttribute) {
                    NumericAttribute numericAttribute = (NumericAttribute)attribute;
                    NumericAttribute numericAttribute2 = numericAttribute.withoutIndex();
                    NumericAttribute numericAttribute3 = NumericAttribute$.MODULE$.defaultAttr();
                    arrayBuffer = (numericAttribute2 == null ? numericAttribute3 != null : !((Object)numericAttribute2).equals(numericAttribute3)) ? numericMetadata.$plus$eq((Object)numericAttribute.toMetadataImpl(false)) : BoxedUnit.UNIT;
                } else if (attribute instanceof NominalAttribute) {
                    NominalAttribute nominalAttribute = (NominalAttribute)attribute;
                    arrayBuffer = nominalMetadata.$plus$eq((Object)nominalAttribute.toMetadataImpl(false));
                } else if (attribute instanceof BinaryAttribute) {
                    BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
                    arrayBuffer = binaryMetadata.$plus$eq((Object)binaryAttribute.toMetadataImpl(false));
                } else if (UnresolvedAttribute$.MODULE$.equals(attribute)) {
                    arrayBuffer = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)attribute);
                }
                return arrayBuffer;
            });
            MetadataBuilder attrBldr = new MetadataBuilder();
            Object object2 = numericMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Numeric().name(), (Metadata[])numericMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object3 = nominalMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Nominal().name(), (Metadata[])nominalMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            Object object4 = binaryMetadata.nonEmpty() ? attrBldr.putMetadataArray(AttributeType$.MODULE$.Binary().name(), (Metadata[])binaryMetadata.toArray(ClassTag$.MODULE$.apply(Metadata.class))) : BoxedUnit.UNIT;
            bldr.putMetadata(AttributeKeys$.MODULE$.ATTRIBUTES(), attrBldr.build());
            object = bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)((Attribute[])this.attributes().get()).length);
        } else {
            object = this.numAttributes().isDefined() ? bldr.putLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES(), (long)BoxesRunTime.unboxToInt((Object)this.numAttributes().get())) : BoxedUnit.UNIT;
        }
        return bldr.build();
    }

    public Metadata toMetadata(Metadata existingMetadata) {
        return new MetadataBuilder().withMetadata(existingMetadata).putMetadata(AttributeKeys$.MODULE$.ML_ATTR(), this.toMetadataImpl()).build();
    }

    public Metadata toMetadata() {
        return this.toMetadata(Metadata$.MODULE$.empty());
    }

    public StructField toStructField(Metadata existingMetadata) {
        return new StructField(this.name(), (DataType)new VectorUDT(), false, this.toMetadata(existingMetadata));
    }

    public StructField toStructField() {
        return this.toStructField(Metadata$.MODULE$.empty());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof AttributeGroup)) return false;
        AttributeGroup attributeGroup = (AttributeGroup)object;
        String string = this.name();
        String string2 = attributeGroup.name();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<Object> option = this.numAttributes();
        Option<Object> option2 = attributeGroup.numAttributes();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option option3 = this.attributes().map((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$4)).toSeq());
        Option option4 = attributeGroup.attributes().map((Function1 & Serializable & scala.Serializable)x$5 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5)).toSeq());
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int sum = 17;
        sum = 37 * sum + this.name().hashCode();
        sum = 37 * sum + this.numAttributes().hashCode();
        sum = 37 * sum + this.attributes().map((Function1 & Serializable & scala.Serializable)x$6 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$6)).toSeq()).hashCode();
        return (int)var1_1;
    }

    public String toString() {
        return this.toMetadata().toString();
    }

    private AttributeGroup(String name, Option<Object> numAttributes, Option<Attribute[]> attrs) {
        this.name = name;
        this.numAttributes = numAttributes;
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(name)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot have an empty string for name.");
        Predef$.MODULE$.require(!numAttributes.isDefined() || !attrs.isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Cannot have both numAttributes and attrs defined.");
        this.attributes = attrs.map((Function1 & Serializable & scala.Serializable)x$1 -> (Attribute[])((TraversableOnce)((TraversableViewLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Attribute attribute = attr.withIndex(i);
            return attribute;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Attribute.class)));
    }

    public AttributeGroup(String name) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, int numAttributes) {
        this(name, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numAttributes)), (Option<Attribute[]>)None$.MODULE$);
    }

    public AttributeGroup(String name, Attribute[] attrs) {
        this(name, (Option<Object>)None$.MODULE$, (Option<Attribute[]>)new Some((Object)attrs));
    }
}

