/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0003\u0003i!AC\"mCN\u001c\u0018NZ5fe*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0016\t9)\"\u0005K\n\u0004\u0001=q\u0003#\u0002\t\u0012'\u0005:S\"\u0001\u0003\n\u0005I!!!\u0003)sK\u0012L7\r^8s!\t!R\u0003\u0004\u0001\u0005\u000bY\u0001!\u0019A\f\u0003\u0019\u0019+\u0017\r^;sKN$\u0016\u0010]3\u0012\u0005aq\u0002CA\r\u001d\u001b\u0005Q\"\"A\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uQ\"a\u0002(pi\"Lgn\u001a\t\u00033}I!\u0001\t\u000e\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u0015E\u0011)1\u0005\u0001b\u0001I\t\tQ)\u0005\u0002\u0019KA)a\u0005A\n\"O5\t!\u0001\u0005\u0002\u0015Q\u0011)\u0011\u0006\u0001b\u0001U\t\tQ*\u0005\u0002\u0019WA!a\u0005L\n(\u0013\ti#AA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002'_%\u0011\u0001G\u0001\u0002\u0011\u00072\f7o]5gS\u0016\u0014\b+\u0019:b[NDQA\r\u0001\u0005\u0002M\na\u0001P5oSRtD#A\u0013\t\u000bU\u0002A\u0011\u0001\u001c\u0002'M,GOU1x!J,G-[2uS>t7i\u001c7\u0015\u0005\u0005:\u0004\"\u0002\u001d5\u0001\u0004I\u0014!\u0002<bYV,\u0007C\u0001\u001eB\u001d\tYt\b\u0005\u0002=55\tQH\u0003\u0002?\u0019\u00051AH]8pizJ!\u0001\u0011\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u00115I\u0001\u0004TiJLgn\u001a\u0006\u0003\u0001jAQ!\u0012\u0001\u0005\u0012\u0019\u000bA#\u001a=ue\u0006\u001cG\u000fT1cK2,G\rU8j]R\u001cHcA$T?B\u0019\u0001jS'\u000e\u0003%S!A\u0013\u0004\u0002\u0007I$G-\u0003\u0002M\u0013\n\u0019!\u000b\u0012#\u0011\u00059\u000bV\"A(\u000b\u0005A#\u0011a\u00024fCR,(/Z\u0005\u0003%>\u0013A\u0002T1cK2,G\rU8j]RDQ\u0001\u0016#A\u0002U\u000bq\u0001Z1uCN,G\u000f\r\u0002W;B\u0019qK\u0017/\u000e\u0003aS!!\u0017\u0004\u0002\u0007M\fH.\u0003\u0002\\1\n9A)\u0019;bg\u0016$\bC\u0001\u000b^\t%q6+!A\u0001\u0002\u000b\u0005qCA\u0002`IEBQ\u0001\u0019#A\u0002\u0005\f!B\\;n\u00072\f7o]3t!\tI\"-\u0003\u0002d5\t\u0019\u0011J\u001c;\t\u000b\u0015\u0004A\u0011\u00034\u0002\u001b\u001d,GOT;n\u00072\f7o]3t)\r\tw-\u001c\u0005\u0006)\u0012\u0004\r\u0001\u001b\u0019\u0003S.\u00042a\u0016.k!\t!2\u000eB\u0005mO\u0006\u0005\t\u0011!B\u0001/\t\u0019q\f\n\u001a\t\u000f9$\u0007\u0013!a\u0001C\u0006iQ.\u0019=Ok6\u001cE.Y:tKNDq\u0001\u001d\u0001\u0012\u0002\u0013E\u0011/A\fhKRtU/\\\"mCN\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\t!O\u000b\u0002bg.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003sj\t!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D#\u0001A?\u0011\u0007y\f\t!D\u0001\u0000\u0015\tIh!C\u0002\u0002\u0004}\u0014A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public abstract class Classifier<FeaturesType, E extends Classifier<FeaturesType, E, M>, M extends ClassificationModel<FeaturesType, M>>
extends Predictor<FeaturesType, E, M>
implements ClassifierParams {
    private final Param<String> rawPredictionCol;

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    public E setRawPredictionCol(String value) {
        return (E)((Classifier)this.set(this.rawPredictionCol(), value));
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
        Predef$.MODULE$.require(numClasses > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Classifier (in extractLabeledPoints) found numClasses =").append(new StringBuilder(31).append(" ").append(numClasses).append(", but requires numClasses > 0.").toString()).toString());
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            Predef$.MODULE$.require(d % 1.0 == 0.0 && d >= 0.0 && d < (double)numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Classifier was given").append(new StringBuilder(63).append(" dataset with invalid label ").append(d).append(".  Labels must be integers in range").toString()).append(new StringBuilder(7).append(" [0, ").append(numClasses).append(").").toString()).toString());
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int getNumClasses(Dataset<?> dataset, int maxNumClasses) {
        int n;
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
        if (option instanceof Some) {
            int n2;
            int n3;
            Some some = (Some)option;
            n = n3 = (n2 = BoxesRunTime.unboxToInt((Object)some.value()));
        } else if (None$.MODULE$.equals(option)) {
            Row[] maxLabelRow = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.$(this.labelCol()))})).take(1);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).isEmpty() || maxLabelRow[0].get(0) == null) {
                throw new SparkException("ML algorithm was given empty dataset.");
            }
            double maxDoubleLabel = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow)).head()).getDouble(0);
            Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Classifier found max label value =").append(new StringBuilder(42).append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString()).toString());
            int numClasses = (int)maxDoubleLabel + 1;
            Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(158).append("Classifier inferred ").append(numClasses).append(" from label values").append(new StringBuilder(60).append(" in column ").append(this.labelCol()).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").toString()).append(new StringBuilder(68).append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).toString()).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.getClass().getCanonicalName()).append(new StringBuilder(22).append(" inferred ").append(numClasses).append(" classes for").toString()).append(new StringBuilder(69).append(" labelCol=").append(this.labelCol()).append(" since numClasses was not specified in the column metadata.").toString()).toString());
            n = numClasses;
        } else {
            throw new MatchError(option);
        }
        return n;
    }

    public int getNumClasses$default$2() {
        return 100;
    }

    public Classifier() {
        HasRawPredictionCol.$init$(this);
        ClassifierParams.$init$(this);
    }
}

