/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import com.github.fommil.netlib.BLAS;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTClassifierParams;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.ClassificationLoss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-a\u0001B\u0001\u0003\u00015\u0011ac\u0012\"U\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0002\u0001\u000f3}Ac\u0006\u0005\u0003\u0010!IAR\"\u0001\u0002\n\u0005E\u0011!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\r1Lg.\u00197h\u0013\t9BC\u0001\u0004WK\u000e$xN\u001d\t\u0003\u001f\u0001\u0001\"AG\u000f\u000e\u0003mQ!\u0001\b\u0003\u0002\tQ\u0014X-Z\u0005\u0003=m\u00111c\u0012\"U\u00072\f7o]5gS\u0016\u0014\b+\u0019:b[N\u00042A\u0007\u0011#\u0013\t\t3DA\tUe\u0016,WI\\:f[\ndW-T8eK2\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002(I\tYB)Z2jg&|g\u000e\u0016:fKJ+wM]3tg&|g.T8eK2\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003[)\u0012!\"\u0014'Xe&$\u0018M\u00197f!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!)\u0004A!b\u0001\n\u00032\u0014aA;jIV\tq\u0007\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003uAj\u0011a\u000f\u0006\u0003y1\ta\u0001\u0010:p_Rt\u0014B\u0001 1\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0002\u0004f\u0001\u001bD\u0013B\u0011AiR\u0007\u0002\u000b*\u0011aIB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001%F\u0005\u0015\u0019\u0016N\\2fC\u0005Q\u0015!B\u0019/m9\u0002\u0004\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\u0002\tULG\r\t\u0015\u0004\u0017\u000eK\u0005\u0002C(\u0001\u0005\u000b\u0007I\u0011\u0002)\u0002\r}#(/Z3t+\u0005\t\u0006cA\u0018SE%\u00111\u000b\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\t+\u0002\u0011\t\u0011)A\u0005#\u00069q\f\u001e:fKN\u0004\u0003\u0002C,\u0001\u0005\u000b\u0007I\u0011\u0002-\u0002\u0019}#(/Z3XK&<\u0007\u000e^:\u0016\u0003e\u00032a\f*[!\ty3,\u0003\u0002]a\t1Ai\\;cY\u0016D\u0001B\u0018\u0001\u0003\u0002\u0003\u0006I!W\u0001\u000e?R\u0014X-Z,fS\u001eDGo\u001d\u0011\t\u0011\u0001\u0004!Q1A\u0005B\u0005\f1B\\;n\r\u0016\fG/\u001e:fgV\t!\r\u0005\u00020G&\u0011A\r\r\u0002\u0004\u0013:$\bfA0D\u0013\"Aq\r\u0001B\u0001B\u0003%!-\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005K\u0002g\u0007&C\u0001B\u001b\u0001\u0003\u0006\u0004%\t%Y\u0001\u000b]Vl7\t\\1tg\u0016\u001c\bfA5DY\u0006\nQ.A\u00033]Ir\u0003\u0007\u0003\u0005p\u0001\t\u0005\t\u0015!\u0003c\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u00079\u001cE\u000e\u0003\u0004s\u0001\u0011\u0005Aa]\u0001\u0007y%t\u0017\u000e\u001e \u0015\ra!ho\u001e={\u0011\u0015)\u0014\u000f1\u00018Q\r!8)\u0013\u0005\u0006\u001fF\u0004\r!\u0015\u0005\u0006/F\u0004\r!\u0017\u0005\u0006AF\u0004\rA\u0019\u0015\u0004q\u000eK\u0005\"\u00026r\u0001\u0004\u0011\u0007f\u0001>DY\"1!\u000f\u0001C\u0001\tu$r\u0001\u0007@\u0000\u0003\u0003\t\u0019\u0001C\u00036y\u0002\u0007q\u0007C\u0003Py\u0002\u0007\u0011\u000bC\u0003Xy\u0002\u0007\u0011\fC\u0003ay\u0002\u0007!\r\u0003\u0004s\u0001\u0011\u0005\u0011q\u0001\u000b\b1\u0005%\u00111BA\u0007\u0011\u0019)\u0014Q\u0001a\u0001o!1q*!\u0002A\u0002ECaaVA\u0003\u0001\u0004I\u0006\u0006BA\u0003\u0007&Ca!a\u0005\u0001\t\u0003\u0002\u0016!\u0002;sK\u0016\u001c\b&BA\t\u0007\u0006]\u0011EAA\r\u0003\u0015\td\u0006\u000e\u00181\u0011!\ti\u0002\u0001b\u0001\n\u0003\t\u0017aC4fi:+X\u000e\u0016:fKNDS!a\u0007D\u0003C\t#!a\t\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005\u001d\u0002\u0001)A\u0005E\u0006aq-\u001a;Ok6$&/Z3tA!*\u0011QE\"\u0002\"!1\u0011Q\u0006\u0001\u0005Ba\u000b1\u0002\u001e:fK^+\u0017n\u001a5ug\"*\u00111F\"\u0002\u0018!9\u00111\u0007\u0001\u0005R\u0005U\u0012!\u0004;sC:\u001chm\u001c:n\u00136\u0004H\u000e\u0006\u0003\u00028\u0005e\u0003\u0003BA\u001d\u0003'rA!a\u000f\u0002N9!\u0011QHA%\u001d\u0011\ty$a\u0012\u000f\t\u0005\u0005\u0013Q\t\b\u0004u\u0005\r\u0013\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\r\tYEB\u0001\u0004gFd\u0017\u0002BA(\u0003#\nq\u0001]1dW\u0006<WMC\u0002\u0002L\u0019IA!!\u0016\u0002X\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0005\u0003\u001f\n\t\u0006\u0003\u0005\u0002\\\u0005E\u0002\u0019AA/\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0018\u0002lA1\u0011\u0011MA2\u0003Oj!!!\u0015\n\t\u0005\u0015\u0014\u0011\u000b\u0002\b\t\u0006$\u0018m]3u!\u0011\tI'a\u001b\r\u0001\u0011a\u0011QNA-\u0003\u0003\u0005\tQ!\u0001\u0002p\t\u0019q\fJ\u001a\u0012\t\u0005E\u0014q\u000f\t\u0004_\u0005M\u0014bAA;a\t9aj\u001c;iS:<\u0007cA\u0018\u0002z%\u0019\u00111\u0010\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0000\u0001!\t%!!\u0002\u000fA\u0014X\rZ5diR\u0019!,a!\t\u000f\u0005\u0015\u0015Q\u0010a\u0001%\u0005Aa-Z1ukJ,7\u000fC\u0004\u0002\n\u0002!\t&a#\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002\u0013\u0003\u001bCq!!\"\u0002\b\u0002\u0007!\u0003C\u0004\u0002\u0012\u0002!\t&a%\u0002-I\fwO\r9s_\n\f'-\u001b7jifLe\u000e\u00157bG\u0016$2AEAK\u0011\u001d\t9*a$A\u0002I\tQB]1x!J,G-[2uS>t\u0007\u0002CAN\u0001\t\u0007I\u0011A1\u0002\u00119,X\u000e\u0016:fKNDq!a(\u0001A\u0003%!-A\u0005ok6$&/Z3tA!9\u00111\u0015\u0001\u0005B\u0005\u0015\u0016\u0001B2paf$2\u0001GAT\u0011!\tI+!)A\u0002\u0005-\u0016!B3yiJ\f\u0007\u0003BAW\u0003gk!!a,\u000b\u0007\u0005EF!A\u0003qCJ\fW.\u0003\u0003\u00026\u0006=&\u0001\u0003)be\u0006lW*\u00199)\u000b\u0005\u00056)a\u0006\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\u0006AAo\\*ue&tw\rF\u00018Q\u0015\tIlQA\f\u0011)\t\u0019\r\u0001EC\u0002\u0013\u0005\u0011QY\u0001\u0013M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7/F\u0001\u0013Q\u0015\t\tmQA\u0011\u0011\u001d\tY\r\u0001C\u0005\u0003\u001b\fa!\\1sO&tGc\u0001.\u0002P\"9\u0011QQAe\u0001\u0004\u0011\u0002\u0002CAj\u0001\u0011\u0005A!!6\u0002\u000bQ|w\n\u001c3\u0016\u0005\u0005]\u0007\u0003BAm\u0003Kl!!a7\u000b\t\u0005u\u0017q\\\u0001\u0006[>$W\r\u001c\u0006\u00049\u0005\u0005(bAAr\r\u0005)Q\u000e\u001c7jE&!\u0011q]An\u0005e9%/\u00193jK:$(i\\8ti\u0016$GK]3fg6{G-\u001a7\t\u0013\u0005-\bA1A\u0005\n\u00055\u0018\u0001\u00027pgN,\"!a<\u0011\t\u0005E\u0018Q_\u0007\u0003\u0003gTA!a;\u0002`&!\u0011q_Az\u0005I\u0019E.Y:tS\u001aL7-\u0019;j_:dun]:\t\u0011\u0005m\b\u0001)A\u0005\u0003_\fQ\u0001\\8tg\u0002Bq!a@\u0001\t\u0003\u0011\t!A\u000bfm\u0006dW/\u0019;f\u000b\u0006\u001c\u0007.\u0013;fe\u0006$\u0018n\u001c8\u0015\u0007e\u0013\u0019\u0001\u0003\u0005\u0002\\\u0005u\b\u0019\u0001B\u0003a\u0011\u00119Aa\u0003\u0011\r\u0005\u0005\u00141\rB\u0005!\u0011\tIGa\u0003\u0005\u0019\t5!1AA\u0001\u0002\u0003\u0015\t!a\u001c\u0003\u0007}#C\u0007K\u0003\u0002~\u000e\u0013\t\"\t\u0002\u0003\u0014\u0005)!G\f\u001b/a!9!q\u0003\u0001\u0005B\te\u0011!B<sSR,WC\u0001B\u000e!\rI#QD\u0005\u0004\u0005?Q#\u0001C'M/JLG/\u001a:)\u000b\tU1)!\t)\u0007\u0001\u0019\u0015jB\u0004\u0003(\tA\tA!\u000b\u0002-\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2\u00042a\u0004B\u0016\r\u0019\t!\u0001#\u0001\u0003.M9!1\u0006B\u0018\u0005kq\u0003cA\u0018\u00032%\u0019!1\u0007\u0019\u0003\r\u0005s\u0017PU3g!\u0011I#q\u0007\r\n\u0007\te\"F\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016DqA\u001dB\u0016\t\u0003\u0011i\u0004\u0006\u0002\u0003*!I!\u0011\tB\u0016\u0005\u0004%IAN\u0001\u000f]Vlg)Z1ukJ,7oS3z\u0011!\u0011)Ea\u000b!\u0002\u00139\u0014a\u00048v[\u001a+\u0017\r^;sKN\\U-\u001f\u0011\t\u0013\t%#1\u0006b\u0001\n\u00131\u0014a\u00038v[R\u0013X-Z:LKfD\u0001B!\u0014\u0003,\u0001\u0006IaN\u0001\r]VlGK]3fg.+\u0017\u0010\t\u0005\t\u0005#\u0012Y\u0003\"\u0011\u0003T\u0005!!/Z1e+\t\u0011)\u0006\u0005\u0003*\u0005/B\u0012b\u0001B-U\tAQ\n\u0014*fC\u0012,'\u000fK\u0003\u0003P\r\u000b\t\u0003\u0003\u0005\u0003`\t-B\u0011\tB1\u0003\u0011aw.\u00193\u0015\u0007a\u0011\u0019\u0007C\u0004\u0003f\tu\u0003\u0019A\u001c\u0002\tA\fG\u000f\u001b\u0015\u0006\u0005;\u001a\u0015\u0011\u0005\u0004\n\u0005W\u0012Y\u0003\u0001B\u0016\u0005[\u0012Ad\u0012\"U\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\\,sSR,'o\u0005\u0003\u0003j\tm\u0001B\u0003B9\u0005S\u0012\t\u0011)A\u00051\u0005A\u0011N\\:uC:\u001cW\rC\u0004s\u0005S\"\tA!\u001e\u0015\t\t]$1\u0010\t\u0005\u0005s\u0012I'\u0004\u0002\u0003,!9!\u0011\u000fB:\u0001\u0004A\u0002\u0002\u0003B@\u0005S\"\tF!!\u0002\u0011M\fg/Z%na2$BAa!\u0003\nB\u0019qF!\"\n\u0007\t\u001d\u0005G\u0001\u0003V]&$\bb\u0002B3\u0005{\u0002\ra\u000e\u0004\b\u0005\u001b\u0013Y\u0003\u0002BH\u0005q9%\tV\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001cBAa#\u0003V!9!Oa#\u0005\u0002\tMEC\u0001BK!\u0011\u0011IHa#\t\u0015\te%1\u0012b\u0001\n\u0013\u0011Y*A\u0005dY\u0006\u001c8OT1nKV\u0011!Q\u0014\t\u0005\u0005?\u0013I+\u0004\u0002\u0003\"*!!1\u0015BS\u0003\u0011a\u0017M\\4\u000b\u0005\t\u001d\u0016\u0001\u00026bm\u0006L1\u0001\u0011BQ\u0011%\u0011iKa#!\u0002\u0013\u0011i*\u0001\u0006dY\u0006\u001c8OT1nK\u0002B!B!-\u0003\f\n\u0007I\u0011\u0002BN\u00035!(/Z3DY\u0006\u001c8OT1nK\"I!Q\u0017BFA\u0003%!QT\u0001\u000fiJ,Wm\u00117bgNt\u0015-\\3!\u0011!\u0011yFa#\u0005B\teFc\u0001\r\u0003<\"9!Q\rB\\\u0001\u00049\u0004\"\u0003B`\u0005W!\t\u0001\u0002Ba\u0003\u001d1'o\\7PY\u0012$2\u0002\u0007Bb\u0005\u000f\u0014\tNa7\u0003^\"A!Q\u0019B_\u0001\u0004\t9.\u0001\u0005pY\u0012lu\u000eZ3m\u0011!\u0011IM!0A\u0002\t-\u0017A\u00029be\u0016tG\u000fE\u0002\u0010\u0005\u001bL1Aa4\u0003\u000559%\tV\"mCN\u001c\u0018NZ5fe\"A!1\u001bB_\u0001\u0004\u0011).A\ndCR,wm\u001c:jG\u0006dg)Z1ukJ,7\u000fE\u00039\u0005/\u0014'-C\u0002\u0003Z\u0006\u00131!T1q\u0011!\u0001'Q\u0018I\u0001\u0002\u0004\u0011\u0007\u0002\u00036\u0003>B\u0005\t\u0019\u00012\t\u0017\t\u0005(1FI\u0001\n\u0003!!1]\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012\"TC\u0001BsU\r\u0011'q]\u0016\u0003\u0005S\u0004BAa;\u0003t6\u0011!Q\u001e\u0006\u0005\u0005_\u0014\t0A\u0005v]\u000eDWmY6fI*\u0011a\tM\u0005\u0005\u0005k\u0014iOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D1B!?\u0003,E\u0005I\u0011\u0001\u0003\u0003d\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000fJ\u001b\t\u0015\tu(1FA\u0001\n\u0013\u0011y0A\u0006sK\u0006$'+Z:pYZ,GCAB\u0001!\u0011\u0011yja\u0001\n\t\r\u0015!\u0011\u0015\u0002\u0007\u001f\nTWm\u0019;)\u000b\t-2)!\t)\u000b\t\u00152)!\t")
public class GBTClassificationModel
extends ProbabilisticClassificationModel<Vector, GBTClassificationModel>
implements GBTClassifierParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int numClasses;
    private final int getNumTrees;
    private final int numTrees;
    private final ClassificationLoss loss;
    private int totalNumNodes;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam validationTol;
    private final DoubleParam stepSize;
    private final Param<String> validationIndicatorCol;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static /* bridge */ Object load(String string) {
        return GBTClassificationModel$.MODULE$.load(string);
    }

    public static GBTClassificationModel load(String string) {
        return GBTClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<GBTClassificationModel> read() {
        return GBTClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public String getLossType() {
        return GBTClassifierParams.getLossType$(this);
    }

    @Override
    public ClassificationLoss getOldLossType() {
        return GBTClassifierParams.getOldLossType$(this);
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public GBTParams setMaxIter(int value) {
        return GBTParams.setMaxIter$(this, value);
    }

    @Override
    public GBTParams setStepSize(double value) {
        return GBTParams.setStepSize$(this, value);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTClassifierParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public double predict(Vector features) {
        return this.isDefined(this.thresholds()) ? super.predict(features) : (this.margin(features) > 0.0 ? 1.0 : 0.0);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double prediction = this.margin(features);
        return Vectors$.MODULE$.dense(new double[]{-prediction, prediction});
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in GBTClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        denseVector.values()[0] = this.loss().computeProbability(denseVector.values()[0]);
        denseVector.values()[1] = 1.0 - denseVector.values()[0];
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    public int numTrees() {
        return this.numTrees;
    }

    @Override
    public GBTClassificationModel copy(ParamMap extra) {
        return (GBTClassificationModel)((Model)this.copyValues(new GBTClassificationModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(41).append("GBTClassificationModel (uid=").append(this.uid()).append(") with ").append(this.numTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTClassificationModel gBTClassificationModel = this;
        synchronized (gBTClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    private double margin(Vector features) {
        double[] treePredictions = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)GBTClassificationModel.$anonfun$margin$1(features, x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return BLAS.getInstance().ddot(this.numTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))), this._treeWeights());
    }

    private ClassificationLoss loss() {
        return this.loss;
    }

    public double[] evaluateEachIteration(Dataset<?> dataset) {
        RDD data = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    row = x0$2;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqLike)some.get()).apply(0);
                    features = ((SeqLike)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration((RDD<LabeledPoint>)data, this.trees(), this.treeWeights(), this.loss(), Algo$.MODULE$.Classification());
    }

    @Override
    public MLWriter write() {
        return new GBTClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((GBTClassificationModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ double $anonfun$margin$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeClassifierParams.$init$(this);
        GBTClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "GBTClassificationModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("GBTClassificationModel given trees, treeWeights").append(new StringBuilder(44).append(" of non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString()).toString());
        this.getNumTrees = this.trees().length;
        this.numTrees = this.trees().length;
        this.loss = this.getOldLossType();
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this(uid, _trees, _treeWeights, numFeatures, 2);
    }

    public GBTClassificationModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1, 2);
    }

    public static class GBTClassificationModelReader
    extends MLReader<GBTClassificationModel> {
        private final String className = GBTClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTClassificationModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash(GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey())).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData)).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("GBTClassificationModel.load expected ").append(numTrees).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            GBTClassificationModel model = new GBTClassificationModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTClassificationModelWriter
    extends MLWriter {
        private final GBTClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numFeaturesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)GBTClassificationModel$.MODULE$.org$apache$spark$ml$classification$GBTClassificationModel$$numTreesKey()), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTClassificationModelWriter(GBTClassificationModel instance) {
            this.instance = instance;
        }
    }
}

