/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.HingeAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u00015\u0011\u0011\u0002T5oK\u0006\u00148KV\"\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dqy\u0002#B\b\u0011%aIR\"\u0001\u0002\n\u0005E\u0011!AC\"mCN\u001c\u0018NZ5feB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011a\u0002T5oK\u0006\u00148KV\"N_\u0012,G\u000e\u0005\u0002\u0010;%\u0011aD\u0001\u0002\u0010\u0019&tW-\u0019:T-\u000e\u0003\u0016M]1ngB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0005kRLG.\u0003\u0002%C\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011I\u0014\u0002\u0007ULG-F\u0001)!\tI#G\u0004\u0002+aA\u00111FL\u0007\u0002Y)\u0011Q\u0006D\u0001\u0007yI|w\u000e\u001e \u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c9B3!\n\u001c=!\t9$(D\u00019\u0015\tId!\u0001\u0006b]:|G/\u0019;j_:L!a\u000f\u001d\u0003\u000bMKgnY3\"\u0003u\nQA\r\u00183]AB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0005k&$\u0007\u0005K\u0002?mqBQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtDC\u0001\rE\u0011\u00151\u0013\t1\u0001)Q\r!e\u0007\u0010\u0015\u0004\u0003Zb\u0004\"\u0002\"\u0001\t\u0003AE#\u0001\r)\u0007\u001d3D\bC\u0003L\u0001\u0011\u0005A*A\u0006tKR\u0014Vm\u001a)be\u0006lGCA'O\u001b\u0005\u0001\u0001\"B(K\u0001\u0004\u0001\u0016!\u0002<bYV,\u0007CA)S\u001b\u0005q\u0013BA*/\u0005\u0019!u.\u001e2mK\"\u001a!J\u000e\u001f\t\u000bY\u0003A\u0011A,\u0002\u0015M,G/T1y\u0013R,'\u000f\u0006\u0002N1\")q*\u0016a\u00013B\u0011\u0011KW\u0005\u00037:\u00121!\u00138uQ\r)f\u0007\u0010\u0005\u0006=\u0002!\taX\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011Q\n\u0019\u0005\u0006\u001fv\u0003\r!\u0019\t\u0003#\nL!a\u0019\u0018\u0003\u000f\t{w\u000e\\3b]\"\u001aQL\u000e\u001f\t\u000b\u0019\u0004A\u0011A4\u0002\rM,G\u000fV8m)\ti\u0005\u000eC\u0003PK\u0002\u0007\u0001\u000bK\u0002fmqBQa\u001b\u0001\u0005\u00021\f!c]3u'R\fg\u000eZ1sI&T\u0018\r^5p]R\u0011Q*\u001c\u0005\u0006\u001f*\u0004\r!\u0019\u0015\u0004UZb\u0004\"\u00029\u0001\t\u0003\t\u0018\u0001D:fi^+\u0017n\u001a5u\u0007>dGCA's\u0011\u0015yu\u000e1\u0001)Q\ryg\u0007\u0010\u0005\u0006k\u0002!\tA^\u0001\rg\u0016$H\u000b\u001b:fg\"|G\u000e\u001a\u000b\u0003\u001b^DQa\u0014;A\u0002AC3\u0001\u001e\u001c=\u0011\u0015Q\b\u0001\"\u0001|\u0003M\u0019X\r^!hOJ,w-\u0019;j_:$U\r\u001d;i)\tiE\u0010C\u0003Ps\u0002\u0007\u0011\fK\u0002zmqBaa \u0001\u0005B\u0005\u0005\u0011\u0001B2paf$2\u0001GA\u0002\u0011\u001d\t)A a\u0001\u0003\u000f\tQ!\u001a=ue\u0006\u0004B!!\u0003\u0002\u00105\u0011\u00111\u0002\u0006\u0004\u0003\u001b!\u0011!\u00029be\u0006l\u0017\u0002BA\t\u0003\u0017\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004}Zb\u0004bBA\f\u0001\u0011E\u0013\u0011D\u0001\u0006iJ\f\u0017N\u001c\u000b\u00043\u0005m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011EA\u0019!\u0019\t\u0019#!\u000b\u0002.5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0011aA:rY&!\u00111FA\u0013\u0005\u001d!\u0015\r^1tKR\u0004B!a\f\u000221\u0001A\u0001DA\u001a\u00037\t\t\u0011!A\u0003\u0002\u0005U\"aA0%cE!\u0011qGA\u001f!\r\t\u0016\u0011H\u0005\u0004\u0003wq#a\u0002(pi\"Lgn\u001a\t\u0004#\u0006}\u0012bAA!]\t\u0019\u0011I\\=)\u0007\u0001\t)\u0005E\u00028\u0003\u000fJ1!!\u00139\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\r\u0001a\u0007P\u0004\b\u0003\u001f\u0012\u0001\u0012AA)\u0003%a\u0015N\\3beN36\tE\u0002\u0010\u0003'2a!\u0001\u0002\t\u0002\u0005U3\u0003CA*\u0003/\ni&a\u0019\u0011\u0007E\u000bI&C\u0002\u0002\\9\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0011\u0002`aI1!!\u0019\"\u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042!UA3\u0013\r\t9G\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0005\u0006MC\u0011AA6)\t\t\t\u0006\u0003\u0005\u0002p\u0005MC\u0011IA9\u0003\u0011aw.\u00193\u0015\u0007a\t\u0019\bC\u0004\u0002v\u00055\u0004\u0019\u0001\u0015\u0002\tA\fG\u000f\u001b\u0015\u0005\u0003[2D\b\u0003\u0006\u0002|\u0005M\u0013\u0011!C\u0005\u0003{\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0010\t\u0005\u0003\u0003\u000bY)\u0004\u0002\u0002\u0004*!\u0011QQAD\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0015\u0001\u00026bm\u0006LA!!$\u0002\u0004\n1qJ\u00196fGRDC!a\u00157y!\"\u0011Q\n\u001c=\u0001")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam threshold;
    private final IntParam aggregationDepth;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam regParam;

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    public static LinearSVC load(String string) {
        return LinearSVC$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        return (LinearSVCModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            None$ none$;
            int n;
            Column w = !this.isDefined(this.weightCol()) || this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()));
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double d;
                double d2;
                Object features;
                block3: {
                    Row row;
                    block2: {
                        row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                        Object label = ((SeqLike)some.get()).apply(0);
                        Object weight = ((SeqLike)some.get()).apply(1);
                        features = ((SeqLike)some.get()).apply(2);
                        if (!(label instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (!(weight instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)weight);
                        if (features instanceof Vector) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                Vector vector = (Vector)features;
                Instance instance = new Instance(d2, d, vector);
                return instance;
            }, ClassTag$.MODULE$.apply(Instance.class));
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth()}));
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, instance) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
            Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            Tuple2 tuple23 = tuple22;
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
            Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
            if (option instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Specified number of classes ").append(n3).append(" was ").append(new StringBuilder(39).append("less than the number of unique labels ").append(histogram.length).append(".").toString()).toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            Predef$.MODULE$.require(numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("LinearSVC only supports binary classification.").append(new StringBuilder(22).append(" ").append(numClasses).append(" classes detected in ").append(this.labelCol()).toString()).toString());
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(44).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append(new StringBuilder(22).append("Found ").append(numInvalid).append(" invalid labels.").toString()).toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> featuresStd[j];
            double regParamL2 = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            if (regParamL2 != 0.0) {
                JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures;
                none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ regularization = none$;
            Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$2 -> new HingeAggregator((Broadcast<double[]>)bcFeaturesStd, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$2);
            RDDLossFunction costFun = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(HingeAggregator.class));
            OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearSVC.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            Vector initialCoefWithIntercept = Vectors$.MODULE$.zeros(numFeaturesPlusIntercept);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialCoefWithIntercept.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder scaledObjectiveHistory = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                scaledObjectiveHistory.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            bcFeaturesStd.destroy(false);
            if (state == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] rawCoefficients = ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double());
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> featuresStd[i] != 0.0 ? rawCoefficients[i] / featuresStd[i] : 0.0, ClassTag$.MODULE$.Double());
            double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? rawCoefficients[numFeaturesPlusIntercept - 1] : 0.0;
            Tuple3 tuple3 = new Tuple3((Object)Vectors$.MODULE$.dense(coefficientArray), (Object)BoxesRunTime.boxToDouble((double)intercept), scaledObjectiveHistory.result());
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Vector coefficientVector = (Vector)tuple3._1();
            double interceptVector = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double[] objectiveHistory = (double[])tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)coefficientVector, (Object)BoxesRunTime.boxToDouble((double)interceptVector), (Object)objectiveHistory);
            Tuple3 tuple33 = tuple32;
            Vector coefficientVector2 = (Vector)tuple33._1();
            double interceptVector2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
            double[] objectiveHistory2 = (double[])tuple33._3();
            return this.copyValues(new LinearSVCModel(this.uid(), coefficientVector2, interceptVector2), this.copyValues$default$2());
        });
    }

    private static final Function1 regParamL1Fun$1() {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> 0.0;
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

