/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.LBFGSB;
import breeze.optimize.LBFGSB$;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummaryImpl;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.LogisticAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qAdH\u0013\u0011\u000b=\u0001\"\u0003G\r\u000e\u0003\tI!!\u0005\u0002\u0003/A\u0013xNY1cS2L7\u000f^5d\u00072\f7o]5gS\u0016\u0014\bCA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0003\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001b\u0013\tY\"AA\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011q\"H\u0005\u0003=\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003vi&d\u0017B\u0001\u0013\"\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0004\u0002\u0011%tG/\u001a:oC2L!AK\u0014\u0003\u000f1{wmZ5oO\"AA\u0006\u0001BC\u0002\u0013\u0005S&A\u0002vS\u0012,\u0012A\f\t\u0003_ar!\u0001\r\u001c\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mb\u0011A\u0002\u001fs_>$hHC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9D'\u0001\u0004Qe\u0016$WMZ\u0005\u0003si\u0012aa\u0015;sS:<'BA\u001c5Q\rYCH\u0011\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\teHA\u0003TS:\u001cW-I\u0001D\u0003\u0015\td\u0006\u000e\u00181\u0011!)\u0005A!A!\u0002\u0013q\u0013\u0001B;jI\u0002B3\u0001\u0012\u001fC\u0011\u0015A\u0005\u0001\"\u0001J\u0003\u0019a\u0014N\\5u}Q\u0011\u0001D\u0013\u0005\u0006Y\u001d\u0003\rA\f\u0015\u0004\u0015r\u0012\u0005fA$=\u001b\u0006\na*A\u00032]Ir\u0003\u0007C\u0003I\u0001\u0011\u0005\u0001\u000bF\u0001\u0019Q\ryEH\u0011\u0005\u0006'\u0002!\t\u0001V\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0002V-6\t\u0001\u0001C\u0003X%\u0002\u0007\u0001,A\u0003wC2,X\r\u0005\u0002Z56\tA'\u0003\u0002\\i\t1Ai\\;cY\u0016D3A\u0015\u001fN\u0011\u0015q\u0006\u0001\"\u0001`\u0003I\u0019X\r^#mCN$\u0018n\u0019(fiB\u000b'/Y7\u0015\u0005U\u0003\u0007\"B,^\u0001\u0004A\u0006fA/=\u0005\")1\r\u0001C\u0001I\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005U+\u0007\"B,c\u0001\u00041\u0007CA-h\u0013\tAGGA\u0002J]RD3A\u0019\u001fN\u0011\u0015Y\u0007\u0001\"\u0001m\u0003\u0019\u0019X\r\u001e+pYR\u0011Q+\u001c\u0005\u0006/*\u0004\r\u0001\u0017\u0015\u0004Ur\u0012\u0005\"\u00029\u0001\t\u0003\t\u0018aD:fi\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0015\u0005U\u0013\b\"B,p\u0001\u0004\u0019\bCA-u\u0013\t)HGA\u0004C_>dW-\u00198)\u0007=d$\tC\u0003y\u0001\u0011\u0005\u00110A\u0005tKR4\u0015-\\5msR\u0011QK\u001f\u0005\u0006/^\u0004\rA\f\u0015\u0004orb\u0018%A?\u0002\u000bIr\u0013G\f\u0019\t\r}\u0004A\u0011AA\u0001\u0003I\u0019X\r^*uC:$\u0017M\u001d3ju\u0006$\u0018n\u001c8\u0015\u0007U\u000b\u0019\u0001C\u0003X}\u0002\u00071\u000f\u000b\u0003\u007fy\u0005\u001d\u0011EAA\u0005\u0003\u0015\td&\u000e\u00181\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\tAb]3u)\"\u0014Xm\u001d5pY\u0012$2!VA\t\u0011\u00199\u00161\u0002a\u00011\"*\u00111\u0002\u001f\u0002\b!9\u0011q\u0003\u0001\u0005B\u0005e\u0011\u0001D4fiRC'/Z:i_2$W#\u0001-)\u000b\u0005UA(a\u0002\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005a1/\u001a;XK&<\u0007\u000e^\"pYR\u0019Q+a\t\t\r]\u000bi\u00021\u0001/Q\u0015\ti\u0002PA\u0014C\t\tI#A\u00032]Yr\u0003\u0007C\u0004\u0002.\u0001!\t%a\f\u0002\u001bM,G\u000f\u00165sKNDw\u000e\u001c3t)\r)\u0016\u0011\u0007\u0005\b/\u0006-\u0002\u0019AA\u001a!\u0011I\u0016Q\u0007-\n\u0007\u0005]BGA\u0003BeJ\f\u0017\u0010K\u0003\u0002,q\n9\u0001C\u0004\u0002>\u0001!\t%a\u0010\u0002\u001b\u001d,G\u000f\u00165sKNDw\u000e\u001c3t+\t\t\u0019\u0004K\u0003\u0002<q\n9\u0001C\u0004\u0002F\u0001!\t!a\u0012\u0002'M,G/Q4he\u0016<\u0017\r^5p]\u0012+\u0007\u000f\u001e5\u0015\u0007U\u000bI\u0005\u0003\u0004X\u0003\u0007\u0002\rA\u001a\u0015\u0005\u0003\u0007bD\u0010C\u0004\u0002P\u0001!\t!!\u0015\u00029M,G\u000fT8xKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ugR\u0019Q+a\u0015\t\u000f]\u000bi\u00051\u0001\u0002VA\u00191#a\u0016\n\u0007\u0005eCC\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0015\u0006\u0003\u001bb\u0014QL\u0011\u0003\u0003?\nQA\r\u00183]ABq!a\u0019\u0001\t\u0003\t)'\u0001\u000ftKR,\u0006\u000f]3s\u0005>,h\u000eZ:P]\u000e{WM\u001a4jG&,g\u000e^:\u0015\u0007U\u000b9\u0007C\u0004X\u0003C\u0002\r!!\u0016)\u000b\u0005\u0005D(!\u0018\t\u000f\u00055\u0004\u0001\"\u0001\u0002p\u0005Q2/\u001a;M_^,'OQ8v]\u0012\u001cxJ\\%oi\u0016\u00148-\u001a9ugR\u0019Q+!\u001d\t\r]\u000bY\u00071\u0001\u0013Q\u0015\tY\u0007PA/\u0011\u001d\t9\b\u0001C\u0001\u0003s\n!d]3u+B\u0004XM\u001d\"pk:$7o\u00148J]R,'oY3qiN$2!VA>\u0011\u00199\u0016Q\u000fa\u0001%!*\u0011Q\u000f\u001f\u0002^!9\u0011\u0011\u0011\u0001\u0005\n\u0005\r\u0015!L1tg\u0016\u0014HOQ8v]\u0012\u001cuN\\:ue\u0006Lg.\u001a3PaRLW.\u001b>bi&|g\u000eU1sC6\u001ch+\u00197jIR1\u0011QQAF\u0003\u001f\u00032!WAD\u0013\r\tI\t\u000e\u0002\u0005+:LG\u000fC\u0004\u0002\u000e\u0006}\u0004\u0019\u00014\u0002%9,XnQ8fM\u001aL7-[3oiN+Go\u001d\u0005\b\u0003#\u000by\b1\u0001g\u0003-qW/\u001c$fCR,(/Z:\t\u0013\u0005U\u0005\u00011A\u0005\n\u0005]\u0015aD8qi&s\u0017\u000e^5bY6{G-\u001a7\u0016\u0005\u0005e\u0005\u0003B-\u0002\u001cfI1!!(5\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111U\u0001\u0014_B$\u0018J\\5uS\u0006dWj\u001c3fY~#S-\u001d\u000b\u0005\u0003\u000b\u000b)\u000b\u0003\u0006\u0002(\u0006}\u0015\u0011!a\u0001\u00033\u000b1\u0001\u001f\u00132\u0011!\tY\u000b\u0001Q!\n\u0005e\u0015\u0001E8qi&s\u0017\u000e^5bY6{G-\u001a7!\u0011!\ty\u000b\u0001C\u0001\r\u0005E\u0016aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\u0007U\u000b\u0019\fC\u0004\u00026\u00065\u0006\u0019A\r\u0002\u000b5|G-\u001a7\t\u0011\u0005e\u0006\u0001\"\u0015\u0007\u0003w\u000bQ\u0001\u001e:bS:$2!GA_\u0011!\ty,a.A\u0002\u0005\u0005\u0017a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u0007\f\u0019\u000e\u0005\u0004\u0002F\u0006-\u0017qZ\u0007\u0003\u0003\u000fT1!!3\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u001b\f9MA\u0004ECR\f7/\u001a;\u0011\t\u0005E\u00171\u001b\u0007\u0001\t1\t).!0\u0002\u0002\u0003\u0005)\u0011AAl\u0005\ryF%M\t\u0005\u00033\fy\u000eE\u0002Z\u00037L1!!85\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!WAq\u0013\r\t\u0019\u000f\u000e\u0002\u0004\u0003:L\b\u0002CA]\u0001\u0011Ea!a:\u0015\u000be\tI/!>\t\u0011\u0005}\u0016Q\u001da\u0001\u0003W\u0004D!!<\u0002rB1\u0011QYAf\u0003_\u0004B!!5\u0002r\u0012a\u00111_Au\u0003\u0003\u0005\tQ!\u0001\u0002X\n\u0019q\f\n\u001a\t\u000f\u0005]\u0018Q\u001da\u0001g\u0006\t\u0002.\u00198eY\u0016\u0004VM]:jgR,gnY3\t\u000f\u0005m\b\u0001\"\u0011\u0002~\u0006!1m\u001c9z)\rA\u0012q \u0005\t\u0005\u0003\tI\u00101\u0001\u0003\u0004\u0005)Q\r\u001f;sCB!!Q\u0001B\u0006\u001b\t\u00119AC\u0002\u0003\n\u0011\tQ\u0001]1sC6LAA!\u0004\u0003\b\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002zr\u0012\u0005f\u0001\u0001=\u001b\u001e9!Q\u0003\u0002\t\u0002\t]\u0011A\u0005'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u00042a\u0004B\r\r\u0019\t!\u0001#\u0001\u0003\u001cMA!\u0011\u0004B\u000f\u0005G\u0011I\u0003E\u0002Z\u0005?I1A!\t5\u0005\u0019\te.\u001f*fMB!\u0001E!\n\u0019\u0013\r\u00119#\t\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\rI&1F\u0005\u0004\u0005[!$\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002%\u0003\u001a\u0011\u0005!\u0011\u0007\u000b\u0003\u0005/A\u0001B!\u000e\u0003\u001a\u0011\u0005#qG\u0001\u0005Y>\fG\rF\u0002\u0019\u0005sAqAa\u000f\u00034\u0001\u0007a&\u0001\u0003qCRD\u0007&\u0002B\u001ay\u0005\u001d\u0002b\u0003B!\u00053\u0011\r\u0011\"\u0001\u0003\u0005\u0007\nAc];qa>\u0014H/\u001a3GC6LG.\u001f(b[\u0016\u001cXC\u0001B#!\u0015I\u0016Q\u0007B$!\u0011\u0011IEa\u0015\u000e\u0005\t-#\u0002\u0002B'\u0005\u001f\nA\u0001\\1oO*\u0011!\u0011K\u0001\u0005U\u00064\u0018-C\u0002:\u0005\u0017B\u0011Ba\u0016\u0003\u001a\u0001\u0006IA!\u0012\u0002+M,\b\u000f]8si\u0016$g)Y7jYft\u0015-\\3tA!Q!1\fB\r\u0003\u0003%IA!\u0018\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005?\u0002BA!\u0013\u0003b%!!1\rB&\u0005\u0019y%M[3di\"*!\u0011\u0004\u001f\u0002(!*!1\u0003\u001f\u0002(\u0001")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private Option<LogisticRegressionModel> optInitialModel;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static MLReader<LogisticRegression> read() {
        return LogisticRegression$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    public static LogisticRegression load(String string) {
        return LogisticRegression$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setFamily(String value) {
        return (LogisticRegression)this.set(this.family(), value);
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    public LogisticRegression setWeightCol(String value) {
        return (LogisticRegression)this.set(this.weightCol(), value);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    public LogisticRegression setAggregationDepth(int value) {
        return (LogisticRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setLowerBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnCoefficients(), value);
    }

    public LogisticRegression setUpperBoundsOnCoefficients(Matrix value) {
        return (LogisticRegression)this.set(this.upperBoundsOnCoefficients(), value);
    }

    public LogisticRegression setLowerBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.lowerBoundsOnIntercepts(), value);
    }

    public LogisticRegression setUpperBoundsOnIntercepts(Vector value) {
        return (LogisticRegression)this.set(this.upperBoundsOnIntercepts(), value);
    }

    private void assertBoundConstrainedOptimizationParamsValid(int numCoefficientSets, int numFeatures) {
        block5: {
            if (this.isSet(this.lowerBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.lowerBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(194).append("The shape of LowerBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getLowerBoundsOnCoefficients().numRows()).append(", ").append(this.getLowerBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnCoefficients()).numRows() == numCoefficientSets && this.$(this.upperBoundsOnCoefficients()).numCols() == numFeatures, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(194).append("The shape of upperBoundsOnCoefficients must be compatible with (1, number of features) for binomial regression, or (number of classes, number of features) for multinomial regression, but found: ").append(new StringBuilder(5).append("(").append(this.getUpperBoundsOnCoefficients().numRows()).append(", ").append(this.getUpperBoundsOnCoefficients().numCols()).append(").").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.lowerBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("The size of lowerBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getLowerBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.upperBoundsOnIntercepts())) {
                Predef$.MODULE$.require(this.$(this.upperBoundsOnIntercepts()).size() == numCoefficientSets, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("The size of upperBoundsOnIntercepts must be equal to 1 for binomial regression, or the number of ").append(new StringBuilder(48).append("classes for multinomial regression, but found: ").append(this.getUpperBoundsOnIntercepts().size()).append(".").toString()).toString());
            }
            if (this.isSet(this.lowerBoundsOnCoefficients()) && this.isSet(this.upperBoundsOnCoefficients())) {
                Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnCoefficients()).toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnCoefficients()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$6(x))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("LowerBoundsOnCoefficients should always be less than or equal to upperBoundsOnCoefficients, but found: ").append(new StringBuilder(30).append("lowerBoundsOnCoefficients = ").append(this.getLowerBoundsOnCoefficients()).append(", ").toString()).append(new StringBuilder(29).append("upperBoundsOnCoefficients = ").append(this.getUpperBoundsOnCoefficients()).append(".").toString()).toString());
            }
            if (!this.isSet(this.lowerBoundsOnIntercepts()) || !this.isSet(this.upperBoundsOnIntercepts())) break block5;
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.$(this.lowerBoundsOnIntercepts()).toArray())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.$(this.upperBoundsOnIntercepts()).toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogisticRegression.$anonfun$assertBoundConstrainedOptimizationParamsValid$8(x))), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append("LowerBoundsOnIntercepts should always be less than or equal to upperBoundsOnIntercepts, but found: ").append(new StringBuilder(28).append("lowerBoundsOnIntercepts = ").append(this.getLowerBoundsOnIntercepts()).append(", ").toString()).append(new StringBuilder(27).append("upperBoundsOnIntercepts = ").append(this.getUpperBoundsOnIntercepts()).append(".").toString()).toString());
        }
    }

    private Option<LogisticRegressionModel> optInitialModel() {
        return this.optInitialModel;
    }

    private void optInitialModel_$eq(Option<LogisticRegressionModel> x$1) {
        this.optInitialModel = x$1;
    }

    public LogisticRegression setInitialModel(LogisticRegressionModel model) {
        this.optInitialModel_$eq((Option<LogisticRegressionModel>)new Some((Object)model));
        return this;
    }

    @Override
    public LogisticRegressionModel train(Dataset<?> dataset) {
        StorageLevel storageLevel = dataset.storageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        return this.train(dataset, handlePersistence);
    }

    public LogisticRegressionModel train(Dataset<?> dataset, boolean handlePersistence) {
        return (LogisticRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Tuple3 tuple3;
            Tuple3 tuple32;
            boolean isConstantLabel;
            int numCoefficientSets;
            boolean bl;
            int n;
            Column w = !this.isDefined(this.weightCol()) || this.$(this.weightCol()).isEmpty() ? functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0)) : functions$.MODULE$.col(this.$(this.weightCol()));
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), w, functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double d;
                double d2;
                Object features;
                block3: {
                    Row row;
                    block2: {
                        row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                        Object label = ((SeqLike)some.get()).apply(0);
                        Object weight = ((SeqLike)some.get()).apply(1);
                        features = ((SeqLike)some.get()).apply(2);
                        if (!(label instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (!(weight instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)weight);
                        if (features instanceof Vector) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                Vector vector = (Vector)features;
                Instance instance = new Instance(d2, d, vector);
                return instance;
            }, ClassTag$.MODULE$.apply(Instance.class));
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.regParam(), this.elasticNetParam(), this.standardization(), this.threshold(), this.maxIter(), this.tol(), this.fitIntercept()}));
            Function2 & Serializable & scala.Serializable seqOp = (Function2 & Serializable & scala.Serializable)(c, instance) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c._1()).add(VectorImplicits$.MODULE$.mlVectorToMLlibVector(instance.features()), instance.weight()), (Object)((MultiClassSummarizer)c._2()).add(instance.label(), instance.weight()));
            Function2 & Serializable & scala.Serializable combOp = (Function2 & Serializable & scala.Serializable)(c1, c2) -> new Tuple2((Object)((MultivariateOnlineSummarizer)c1._1()).merge((MultivariateOnlineSummarizer)c2._1()), (Object)((MultiClassSummarizer)c1._2()).merge((MultiClassSummarizer)c2._2()));
            Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer()), (Function2)seqOp, (Function2)combOp, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Tuple2.class));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            Tuple2 tuple23 = tuple22;
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).min((Ordering)Ordering.Double$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(labelSummarizer2.histogram())).max((Ordering)Ordering.Double$.MODULE$).toString());
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            int numFeaturesPlusIntercept = this.getFitIntercept() ? numFeatures + 1 : numFeatures;
            Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
            if (option instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Specified number of classes ").append(n3).append(" was ").append(new StringBuilder(39).append("less than the number of unique labels ").append(histogram.length).append(".").toString()).toString());
                n = n3;
            } else if (None$.MODULE$.equals(option)) {
                n = histogram.length;
            } else {
                throw new MatchError(option);
            }
            int numClasses = n;
            String string = this.getFamily().toLowerCase(Locale.ROOT);
            if ("binomial".equals(string)) {
                Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Binomial family only supports 1 or 2 ").append(new StringBuilder(27).append("outcome classes but found ").append(numClasses).append(".").toString()).toString());
                bl = false;
            } else if ("multinomial".equals(string)) {
                bl = true;
            } else if ("auto".equals(string)) {
                bl = numClasses > 2;
            } else {
                throw new IllegalArgumentException(new StringBuilder(20).append("Unsupported family: ").append(string).toString());
            }
            boolean isMultinomial = bl;
            int n4 = numCoefficientSets = isMultinomial ? numClasses : 1;
            if (this.usingBoundConstrainedOptimization()) {
                this.assertBoundConstrainedOptimizationParamsValid(numCoefficientSets, numFeatures);
            }
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == numClasses, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append(this.getClass().getSimpleName()).append(".train() called with non-matching numClasses and thresholds.length.").append(new StringBuilder(40).append(" numClasses=").append(numClasses).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString()).toString());
            }
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                String msg = new StringBuilder(44).append("Classification labels should be in [0 to ").append(numClasses - 1).append("]. ").append(new StringBuilder(22).append("Found ").append(numInvalid).append(" invalid labels.").toString()).toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            boolean bl2 = isConstantLabel = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(histogram)).count((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 != 0.0) == 1;
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel && !this.usingBoundConstrainedOptimization()) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("All labels are the same value and fitIntercept=true, so the ").append("coefficients will be zeros. Training is not needed.").toString());
                int constantLabelIndex = Vectors$.MODULE$.dense(histogram).argmax();
                Matrix coefMatrix = new SparseMatrix(numCoefficientSets, numFeatures, new int[numCoefficientSets + 1], (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), true).compressed();
                Vector interceptVec = isMultinomial ? Vectors$.MODULE$.sparse(numClasses, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(constantLabelIndex, Double.POSITIVE_INFINITY)}))) : Vectors$.MODULE$.dense(numClasses == 2 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                tuple32 = new Tuple3((Object)coefMatrix, (Object)interceptVec, Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            } else {
                boolean bl3;
                Object object2;
                Tuple2 tuple24;
                Tuple2 tuple25;
                None$ none$;
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isConstantLabel) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("All labels belong to a single class and fitIntercept=false. It's a ").append("dangerous ground, so the algorithm may not converge.").toString());
                }
                double[] featuresMean = summarizer2.mean().toArray();
                double[] featuresStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.sqrt(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && featuresMean[i] != 0.0)) {
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting LogisticRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is the same as R glmnet but different from LIBSVM.");
                }
                double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
                Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$3 -> new LogisticAggregator((Broadcast<double[]>)bcFeaturesStd, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), isMultinomial, (Broadcast<Vector>)x$3);
                JFunction1.mcDI.sp & Serializable & scala.Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable & scala.Serializable)j -> j >= 0 && j < numCoefficientSets * numFeatures ? featuresStd[j / numCoefficientSets] : 0.0;
                if (regParamL2 != 0.0) {
                    JFunction1.mcZI.sp & Serializable & scala.Serializable shouldApply = (JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> idx >= 0 && idx < numFeatures * numCoefficientSets;
                    none$ = new Some((Object)new L2Regularization(regParamL2, (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
                } else {
                    none$ = None$.MODULE$;
                }
                None$ regularization = none$;
                RDDLossFunction costFun = new RDDLossFunction(instances, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(Instance.class), ClassTag$.MODULE$.apply(LogisticAggregator.class));
                int numCoeffsPlusIntercepts = numFeaturesPlusIntercept * numCoefficientSets;
                if (this.usingBoundConstrainedOptimization()) {
                    double[] lowerBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NEGATIVE_INFINITY, ClassTag$.MODULE$.Double());
                    double[] upperBounds = (double[])Array$.MODULE$.fill(numCoeffsPlusIntercepts, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.POSITIVE_INFINITY, ClassTag$.MODULE$.Double());
                    boolean isSetLowerBoundsOnCoefficients = this.isSet(this.lowerBoundsOnCoefficients());
                    boolean isSetUpperBoundsOnCoefficients = this.isSet(this.upperBoundsOnCoefficients());
                    boolean isSetLowerBoundsOnIntercepts = this.isSet(this.lowerBoundsOnIntercepts());
                    boolean isSetUpperBoundsOnIntercepts = this.isSet(this.upperBoundsOnIntercepts());
                    for (int i2 = 0; i2 < numCoeffsPlusIntercepts; ++i2) {
                        int coefficientSetIndex = i2 % numCoefficientSets;
                        int featureIndex2 = i2 / numCoefficientSets;
                        if (featureIndex2 < numFeatures) {
                            if (isSetLowerBoundsOnCoefficients) {
                                lowerBounds[i2] = this.$(this.lowerBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex2) * featuresStd[featureIndex2];
                            }
                            if (!isSetUpperBoundsOnCoefficients) continue;
                            upperBounds[i2] = this.$(this.upperBoundsOnCoefficients()).apply(coefficientSetIndex, featureIndex2) * featuresStd[featureIndex2];
                            continue;
                        }
                        if (isSetLowerBoundsOnIntercepts) {
                            lowerBounds[i2] = this.$(this.lowerBoundsOnIntercepts()).apply(coefficientSetIndex);
                        }
                        if (!isSetUpperBoundsOnIntercepts) continue;
                        upperBounds[i2] = this.$(this.upperBoundsOnIntercepts()).apply(coefficientSetIndex);
                    }
                    tuple25 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                } else {
                    tuple25 = tuple24 = new Tuple2(null, null);
                }
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                double[] lowerBounds = (double[])tuple24._1();
                double[] upperBounds = (double[])tuple24._2();
                Tuple2 tuple26 = new Tuple2((Object)lowerBounds, (Object)upperBounds);
                Tuple2 tuple27 = tuple26;
                double[] lowerBounds2 = (double[])tuple27._1();
                double[] upperBounds2 = (double[])tuple27._2();
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0) {
                    object2 = lowerBounds2 != null && upperBounds2 != null ? new LBFGSB(DenseVector$.MODULE$.apply((Object)lowerBounds2), DenseVector$.MODULE$.apply((Object)upperBounds2), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), LBFGSB$.MODULE$.$lessinit$greater$default$6(), LBFGSB$.MODULE$.$lessinit$greater$default$7()) : new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double());
                } else {
                    boolean standardizationParam = BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization()));
                    object2 = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, numCoefficientSets, featuresStd, regParamL1, standardizationParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
                }
                LBFGS optimizer = object2;
                Matrix initialCoefWithInterceptMatrix = Matrices$.MODULE$.zeros(numCoefficientSets, numFeaturesPlusIntercept);
                Option<LogisticRegressionModel> option2 = this.optInitialModel();
                if (option2 instanceof Some) {
                    boolean modelIsValid;
                    Some some = (Some)option2;
                    LogisticRegressionModel _initialModel = (LogisticRegressionModel)some.value();
                    Matrix providedCoefs = _initialModel.coefficientMatrix();
                    boolean bl4 = modelIsValid = providedCoefs.numRows() == numCoefficientSets && providedCoefs.numCols() == numFeatures && _initialModel.interceptVector().size() == numCoefficientSets && _initialModel.getFitIntercept() == BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()));
                    if (!modelIsValid) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Initial coefficients will be ignored! Its dimensions ").append(new StringBuilder(23).append("(").append(providedCoefs.numRows()).append(", ").append(providedCoefs.numCols()).append(") did not match the ").toString()).append(new StringBuilder(18).append("expected size (").append(numCoefficientSets).append(", ").append(numFeatures).append(")").toString()).toString());
                    }
                    bl3 = modelIsValid;
                } else if (None$.MODULE$.equals(option2)) {
                    bl3 = false;
                } else {
                    throw new MatchError(option2);
                }
                boolean initialModelIsValid = bl3;
                if (initialModelIsValid) {
                    Matrix providedCoef = ((LogisticRegressionModel)this.optInitialModel().get()).coefficientMatrix();
                    providedCoef.foreachActive((Function3 & Serializable & scala.Serializable)(classIndex, featureIndex, value) -> {
                        initialCoefWithInterceptMatrix.update(BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value) * featuresStd[BoxesRunTime.unboxToInt((Object)featureIndex)]);
                        return BoxedUnit.UNIT;
                    });
                    if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                        ((LogisticRegressionModel)this.optInitialModel().get()).interceptVector().foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(classIndex, value) -> initialCoefWithInterceptMatrix.update(classIndex, numFeatures, value));
                    }
                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial) {
                    double[] rawIntercepts = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(histogram)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> package$.MODULE$.log1p(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    double rawMean = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)rawIntercepts.length;
                    new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(rawIntercepts)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> initialCoefWithInterceptMatrix.update(i, numFeatures, rawIntercepts[i] - rawMean));
                } else if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                    initialCoefWithInterceptMatrix.update(0, numFeatures, package$.MODULE$.log(histogram[1] / histogram[0]));
                }
                if (this.usingBoundConstrainedOptimization()) {
                    for (int i3 = 0; i3 < numCoeffsPlusIntercepts; ++i3) {
                        int coefficientSetIndex = i3 % numCoefficientSets;
                        int featureIndex3 = i3 / numCoefficientSets;
                        if (initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex3) < lowerBounds2[i3]) {
                            initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex3, lowerBounds2[i3]);
                            continue;
                        }
                        if (!(initialCoefWithInterceptMatrix.apply(coefficientSetIndex, featureIndex3) > upperBounds2[i3])) continue;
                        initialCoefWithInterceptMatrix.update(coefficientSetIndex, featureIndex3, upperBounds2[i3]);
                    }
                }
                Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialCoefWithInterceptMatrix.toArray()));
                ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                FirstOrderMinimizer.State state = null;
                while (states.hasNext()) {
                    state = (FirstOrderMinimizer.State)states.next();
                    arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
                }
                bcFeaturesStd.destroy(false);
                if (state == null) {
                    String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                    instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                    throw new SparkException(msg);
                }
                double[] allCoefficients = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
                DenseMatrix allCoefMatrix = new DenseMatrix(numCoefficientSets, numFeaturesPlusIntercept, allCoefficients);
                DenseMatrix denseCoefficientMatrix = new DenseMatrix(numCoefficientSets, numFeatures, new double[numCoefficientSets * numFeatures], true);
                Vector interceptVec = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) || !isMultinomial ? Vectors$.MODULE$.zeros(numCoefficientSets) : Vectors$.MODULE$.sparse(numCoefficientSets, (Seq)Seq$.MODULE$.empty());
                allCoefMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(classIndex, featureIndex, value) -> {
                    LogisticRegression.$anonfun$train$27(this, numFeatures, featuresStd, denseCoefficientMatrix, interceptVec, BoxesRunTime.unboxToInt((Object)classIndex), BoxesRunTime.unboxToInt((Object)featureIndex), BoxesRunTime.unboxToDouble((Object)value));
                    return BoxedUnit.UNIT;
                });
                if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] centers = (double[])Array$.MODULE$.fill(numFeatures, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(x0$2, x1$1, x2$1) -> {
                        LogisticRegression.$anonfun$train$29(centers, BoxesRunTime.unboxToInt((Object)x0$2), BoxesRunTime.unboxToInt((Object)x1$1), BoxesRunTime.unboxToDouble((Object)x2$1));
                        return BoxedUnit.UNIT;
                    });
                    Predef$.MODULE$.wrapDoubleArray(centers).transform((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$5 -> x$5 / (double)numCoefficientSets);
                    denseCoefficientMatrix.foreachActive((Function3 & Serializable & scala.Serializable)(x0$3, x1$2, x2$2) -> {
                        LogisticRegression.$anonfun$train$31(denseCoefficientMatrix, centers, BoxesRunTime.unboxToInt((Object)x0$3), BoxesRunTime.unboxToInt((Object)x1$2), BoxesRunTime.unboxToDouble((Object)x2$2));
                        return BoxedUnit.UNIT;
                    });
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && isMultinomial && !this.usingBoundConstrainedOptimization()) {
                    double[] interceptArray = interceptVec.toArray();
                    double interceptMean = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(interceptArray)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)interceptArray.length;
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), interceptVec.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                        interceptArray$1[i] = interceptArray[i] - interceptMean;
                    });
                }
                tuple32 = tuple3 = new Tuple3((Object)denseCoefficientMatrix.compressed(), (Object)interceptVec.compressed(), arrayBuilder.result());
            }
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Matrix coefficientMatrix = (Matrix)tuple3._1();
            Vector interceptVector = (Vector)tuple3._2();
            double[] objectiveHistory = (double[])tuple3._3();
            Tuple3 tuple33 = new Tuple3((Object)coefficientMatrix, (Object)interceptVector, (Object)objectiveHistory);
            Tuple3 tuple34 = tuple33;
            Matrix coefficientMatrix2 = (Matrix)tuple34._1();
            Vector interceptVector2 = (Vector)tuple34._2();
            double[] objectiveHistory2 = (double[])tuple34._3();
            Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), coefficientMatrix2, interceptVector2, numClasses, isMultinomial), this.copyValues$default$2());
            Tuple3<LogisticRegressionModel, String, String> tuple35 = model.findSummaryModel();
            if (tuple35 == null) {
                throw new MatchError(tuple35);
            }
            LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple35._1();
            String probabilityColName = (String)tuple35._2();
            String predictionColName = (String)tuple35._3();
            Tuple3 tuple36 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
            Tuple3 tuple37 = tuple36;
            LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple37._1();
            String probabilityColName2 = (String)tuple37._2();
            String predictionColName2 = (String)tuple37._3();
            LogisticRegressionSummaryImpl logRegSummary = numClasses <= 2 ? new BinaryLogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2) : new LogisticRegressionTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
            return model.setSummary((Option<LogisticRegressionTrainingSummary>)new Some((Object)logRegSummary));
        });
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$6(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    public static final /* synthetic */ boolean $anonfun$assertBoundConstrainedOptimizationParamsValid$8(Tuple2 x) {
        return x._1$mcD$sp() <= x._2$mcD$sp();
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, int numCoefficientSets$1, double[] featuresStd$1, double regParamL1$1, boolean standardizationParam$1) {
        return (JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> {
            int featureIndex;
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && index >= numFeatures$1 * numCoefficientSets$1;
            return isIntercept ? 0.0 : (standardizationParam$1 ? regParamL1$1 : (featuresStd$1[featureIndex = index / numCoefficientSets$1] != 0.0 ? regParamL1$1 / featuresStd$1[featureIndex] : 0.0));
        };
    }

    public static final /* synthetic */ void $anonfun$train$27(LogisticRegression $this, int numFeatures$1, double[] featuresStd$1, DenseMatrix denseCoefficientMatrix$1, Vector interceptVec$1, int classIndex, int featureIndex, double value) {
        block1: {
            boolean isIntercept;
            boolean bl = isIntercept = BoxesRunTime.unboxToBoolean((Object)$this.$($this.fitIntercept())) && featureIndex == numFeatures$1;
            if (!isIntercept && featuresStd$1[featureIndex] != 0.0) {
                denseCoefficientMatrix$1.update(classIndex, featureIndex, value / featuresStd$1[featureIndex]);
            }
            if (!isIntercept) break block1;
            interceptVec$1.toArray()[classIndex] = value;
        }
    }

    public static final /* synthetic */ void $anonfun$train$29(double[] centers$1, int x0$2, int x1$1, double x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$2), (Object)BoxesRunTime.boxToInteger((int)x1$1), (Object)BoxesRunTime.boxToDouble((double)x2$1));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        centers$1[j] = centers$1[j] + v;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$train$31(DenseMatrix denseCoefficientMatrix$1, double[] centers$1, int x0$3, int x1$2, double x2$2) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)x0$3), (Object)BoxesRunTime.boxToInteger((int)x1$2), (Object)BoxesRunTime.boxToDouble((double)x2$2));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple3._2());
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        denseCoefficientMatrix$1.update(i, j, v - centers$1[j]);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.family().$minus$greater("auto")}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.5))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aggregationDepth().$minus$greater(BoxesRunTime.boxToInteger((int)2))}));
        this.optInitialModel = None$.MODULE$;
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

