/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.PredictionModel;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionSummaryImpl;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r%h\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dea\u0002\u0003B\b\u0011%ai\u0011AA\u0005\u0003#\t\u0011\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u0019!C!I\u0005\u0019Q/\u001b3\u0016\u0003\u0015\u0002\"AJ\u0018\u000f\u0005\u001dj\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\r\u0003\u0019a$o\\8u})\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq3\u0006K\u0002#ge\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00029k\t)1+\u001b8dK\u0006\n!(A\u00032]Qr\u0003\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003&\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007m\u001a\u0014\b\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0003E\u0019w.\u001a4gS\u000eLWM\u001c;NCR\u0014\u0018\u000e_\u000b\u0002\u0003B\u00111CQ\u0005\u0003\u0007R\u0011a!T1ue&D\bf\u0001 4\u000b\u0006\na)A\u00033]Er\u0003\u0007\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003B\u0003I\u0019w.\u001a4gS\u000eLWM\u001c;NCR\u0014\u0018\u000e\u001f\u0011)\u0007\u001d\u001bT\t\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001M\u0003=Ig\u000e^3sG\u0016\u0004HOV3di>\u0014X#\u0001\n)\u0007)\u001bT\t\u0003\u0005P\u0001\t\u0005\t\u0015!\u0003\u0013\u0003AIg\u000e^3sG\u0016\u0004HOV3di>\u0014\b\u0005K\u0002Og\u0015C\u0001B\u0015\u0001\u0003\u0006\u0004%\teU\u0001\u000b]Vl7\t\\1tg\u0016\u001cX#\u0001+\u0011\u0005U3V\"A\u0016\n\u0005][#aA%oi\"\u001a\u0011kM-\"\u0003i\u000bQ!\r\u00184]AB\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I\u0001V\u0001\f]Vl7\t\\1tg\u0016\u001c\b\u0005K\u0002\\geC\u0001b\u0018\u0001\u0003\u0006\u0004%I\u0001Y\u0001\u000eSNlU\u000f\u001c;j]>l\u0017.\u00197\u0016\u0003\u0005\u0004\"!\u00162\n\u0005\r\\#a\u0002\"p_2,\u0017M\u001c\u0005\tK\u0002\u0011\t\u0011)A\u0005C\u0006q\u0011n]'vYRLgn\\7jC2\u0004\u0003BB4\u0001\t\u00031\u0001.\u0001\u0004=S:LGO\u0010\u000b\u00071%\\Wn\\9\t\u000b\r2\u0007\u0019A\u0013)\u0007%\u001c\u0014\bC\u0003@M\u0002\u0007\u0011\tK\u0002lg\u0015CQa\u00134A\u0002IA3!\\\u001aF\u0011\u0015\u0011f\r1\u0001UQ\ry7'\u0017\u0005\u0006?\u001a\u0004\r!\u0019\u0005\u0007O\u0002!\tAB:\u0015\ta!Xo\u001e\u0005\u0006GI\u0004\r!\n\u0005\u0006mJ\u0004\rAE\u0001\rG>,gMZ5dS\u0016tGo\u001d\u0005\u0006qJ\u0004\r!_\u0001\nS:$XM]2faR\u0004\"!\u0016>\n\u0005m\\#A\u0002#pk\ndW\rC\u0003w\u0001\u0011\u0005A\nK\u0002}gy\f\u0013a`\u0001\u0006e9\u0002d\u0006\r\u0005\n\u0003\u0007\u0001\u0001R1A\u0005\n1\u000bQbX2pK\u001a4\u0017nY5f]R\u001c\bB\u0002=\u0001\t\u0003\t9!F\u0001zQ\u0011\t)aM-\t\u0015\u00055\u0001\u0001#b\u0001\n\u0013\t9!\u0001\u0006`S:$XM]2faRDq!!\u0005\u0001\t\u0003\n\u0019\"\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0003\u0002\u0016\u0005]Q\"\u0001\u0001\t\u000f\u0005e\u0011q\u0002a\u0001s\u0006)a/\u00197vK\"*\u0011qB\u001a\u0002\u001e\u0005\u0012\u0011qD\u0001\u0006c9*d\u0006\r\u0005\b\u0003G\u0001A\u0011IA\u0004\u000319W\r\u001e+ie\u0016\u001c\bn\u001c7eQ\u0015\t\tcMA\u000f\u0011\u001d\tI\u0003\u0001C!\u0003W\tQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cH\u0003BA\u000b\u0003[A\u0001\"!\u0007\u0002(\u0001\u0007\u0011q\u0006\t\u0005+\u0006E\u00120C\u0002\u00024-\u0012Q!\u0011:sCfDS!a\n4\u0003;Aq!!\u000f\u0001\t\u0003\nY$A\u0007hKR$\u0006N]3tQ>dGm]\u000b\u0003\u0003_AS!a\u000e4\u0003;A\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\u0002\r5\f'oZ5o+\t\t)\u0005E\u0003V\u0003\u000f\u0012\u00120C\u0002\u0002J-\u0012\u0011BR;oGRLwN\\\u0019\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u000b\nq!\\1sO&t\u0007\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002T\u00059Q.\u0019:hS:\u001cXCAA+!\u0015)\u0016q\t\n\u0013\u0011!\tI\u0006\u0001Q\u0001\n\u0005U\u0013\u0001C7be\u001eLgn\u001d\u0011\t\u0013\u0005u\u0003A1A\u0005\n\u0005\r\u0013!B:d_J,\u0007\u0002CA1\u0001\u0001\u0006I!!\u0012\u0002\rM\u001cwN]3!\u0011!\t)\u0007\u0001b\u0001\n\u0003\u001a\u0016a\u00038v[\u001a+\u0017\r^;sKNDS!a\u00194\u0003S\n#!a\u001b\u0002\u000bErcG\f\u0019\t\u000f\u0005=\u0004\u0001)A\u0005)\u0006aa.^7GK\u0006$XO]3tA!*\u0011QN\u001a\u0002j!I\u0011Q\u000f\u0001A\u0002\u0013%\u0011qO\u0001\u0010iJ\f\u0017N\\5oON+X.\\1ssV\u0011\u0011\u0011\u0010\t\u0006+\u0006m\u0014qP\u0005\u0004\u0003{Z#AB(qi&|g\u000eE\u0002\u0010\u0003\u0003K1!a!\u0003\u0005\u0005bunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Ue\u0006Lg.\u001b8h'VlW.\u0019:z\u0011%\t9\t\u0001a\u0001\n\u0013\tI)A\nue\u0006Lg.\u001b8h'VlW.\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002\f\u0006E\u0005cA+\u0002\u000e&\u0019\u0011qR\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0003'\u000b))!AA\u0002\u0005e\u0014a\u0001=%c!A\u0011q\u0013\u0001!B\u0013\tI(\u0001\tue\u0006Lg.\u001b8h'VlW.\u0019:zA!9\u00111\u0014\u0001\u0005\u0002\u0005u\u0015aB:v[6\f'/_\u000b\u0003\u0003\u007fBS!!'4\u0003;Aq!a)\u0001\t\u0003\t)+A\u0007cS:\f'/_*v[6\f'/_\u000b\u0003\u0003O\u00032aDAU\u0013\r\tYK\u0001\u0002(\u0005&t\u0017M]=M_\u001eL7\u000f^5d%\u0016<'/Z:tS>tGK]1j]&twmU;n[\u0006\u0014\u0018\u0010K\u0003\u0002\"N\ny+\t\u0002\u00022\u0006)!GL\u001a/a!A\u0011Q\u0017\u0001\u0005\u0002\t\t9,\u0001\tgS:$7+^7nCJLXj\u001c3fYR\u0011\u0011\u0011\u0018\t\u0007+\u0006m\u0006$J\u0013\n\u0007\u0005u6F\u0001\u0004UkBdWm\r\u0005\t\u0003\u0003\u0004A\u0011\u0001\u0002\u0002D\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\t\u0005U\u0011Q\u0019\u0005\t\u00037\u000by\f1\u0001\u0002z!1\u0011\u0011\u001a\u0001\u0005\u0002\u0001\f!\u0002[1t'VlW.\u0019:zQ\u0015\t9mMA\u000f\u0011\u001d\ty\r\u0001C\u0001\u0003#\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u0003'\fI\u000eE\u0002\u0010\u0003+L1!a6\u0003\u0005eaunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8Tk6l\u0017M]=\t\u0011\u0005m\u0017Q\u001aa\u0001\u0003;\fq\u0001Z1uCN,G\u000f\r\u0003\u0002`\u0006=\bCBAq\u0003O\fY/\u0004\u0002\u0002d*\u0019\u0011Q\u001d\u0004\u0002\u0007M\fH.\u0003\u0003\u0002j\u0006\r(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003[\fy\u000f\u0004\u0001\u0005\u0019\u0005E\u0018\u0011\\A\u0001\u0002\u0003\u0015\t!a=\u0003\u0007}#3'\u0005\u0003\u0002v\u0006m\bcA+\u0002x&\u0019\u0011\u0011`\u0016\u0003\u000f9{G\u000f[5oOB\u0019Q+!@\n\u0007\u0005}8FA\u0002B]fDC!!44}\"9!Q\u0001\u0001\u0005B\t\u001d\u0011a\u00029sK\u0012L7\r\u001e\u000b\u0004s\n%\u0001b\u0002B\u0006\u0005\u0007\u0001\rAE\u0001\tM\u0016\fG/\u001e:fg\"9!q\u0002\u0001\u0005R\tE\u0011A\u0006:boJ\u0002(o\u001c2bE&d\u0017\u000e^=J]Bc\u0017mY3\u0015\u0007I\u0011\u0019\u0002C\u0004\u0003\u0016\t5\u0001\u0019\u0001\n\u0002\u001bI\fw\u000f\u0015:fI&\u001cG/[8o\u0011\u001d\u0011I\u0002\u0001C)\u00057\t!\u0002\u001d:fI&\u001cGOU1x)\r\u0011\"Q\u0004\u0005\b\u0005\u0017\u00119\u00021\u0001\u0013\u0011\u001d\u0011\t\u0003\u0001C!\u0005G\tAaY8qsR\u0019\u0001D!\n\t\u0011\t\u001d\"q\u0004a\u0001\u0005S\tQ!\u001a=ue\u0006\u0004BAa\u000b\u000325\u0011!Q\u0006\u0006\u0004\u0005_!\u0011!\u00029be\u0006l\u0017\u0002\u0002B\u001a\u0005[\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0005\u0005?\u0019\u0014\bC\u0004\u0003:\u0001!\tFa\u000f\u0002\u001dI\fwO\r9sK\u0012L7\r^5p]R\u0019\u0011P!\u0010\t\u000f\tU!q\u0007a\u0001%!9!\u0011\t\u0001\u0005R\t\r\u0013A\u00069s_\n\f'-\u001b7jif\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\u0007e\u0014)\u0005C\u0004\u0003H\t}\u0002\u0019\u0001\n\u0002\u0017A\u0014xNY1cS2LG/\u001f\u0005\b\u0005\u0017\u0002A\u0011\tB'\u0003\u00159(/\u001b;f+\t\u0011y\u0005E\u0002\u001e\u0005#J1Aa\u0015\u001f\u0005!iEj\u0016:ji\u0016\u0014\b&\u0002B%g\u0005%\u0004b\u0002B-\u0001\u0011\u0005#1L\u0001\ti>\u001cFO]5oOR\tQ\u0005K\u0002\u0001ge:qA!\u0019\u0003\u0011\u0003\u0011\u0019'A\fM_\u001eL7\u000f^5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0019qB!\u001a\u0007\r\u0005\u0011\u0001\u0012\u0001B4'!\u0011)G!\u001b\u0003p\tU\u0004cA+\u0003l%\u0019!QN\u0016\u0003\r\u0005s\u0017PU3g!\u0011i\"\u0011\u000f\r\n\u0007\tMdD\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042!\u0016B<\u0013\r\u0011Ih\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bO\n\u0015D\u0011\u0001B?)\t\u0011\u0019\u0007\u0003\u0005\u0003\u0002\n\u0015D\u0011\tBB\u0003\u0011\u0011X-\u00193\u0016\u0005\t\u0015\u0005\u0003B\u000f\u0003\bbI1A!#\u001f\u0005!iEJU3bI\u0016\u0014\b&\u0002B@g\u0005%\u0004\u0002\u0003BH\u0005K\"\tE!%\u0002\t1|\u0017\r\u001a\u000b\u00041\tM\u0005b\u0002BK\u0005\u001b\u0003\r!J\u0001\u0005a\u0006$\b\u000eK\u0003\u0003\u000eN\nIGB\u0005\u0003\u001c\n\u0015\u0004A!\u001a\u0003\u001e\niBj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\\,sSR,'o\u0005\u0004\u0003\u001a\n=#q\u0014\t\u0005\u0005C\u00139+\u0004\u0002\u0003$*\u0019!Q\u0015\u0004\u0002\u0011%tG/\u001a:oC2LAA!+\u0003$\n9Aj\\4hS:<\u0007B\u0003BW\u00053\u0013\t\u0011)A\u00051\u0005A\u0011N\\:uC:\u001cW\rC\u0004h\u00053#\tA!-\u0015\t\tM&q\u0017\t\u0005\u0005k\u0013I*\u0004\u0002\u0003f!9!Q\u0016BX\u0001\u0004Aba\u0002B^\u00053#%Q\u0018\u0002\u0005\t\u0006$\u0018m\u0005\u0005\u0003:\n%$q\u0018B;!\r)&\u0011Y\u0005\u0004\u0005\u0007\\#a\u0002)s_\u0012,8\r\u001e\u0005\n%\ne&Q3A\u0005\u0002MC\u0011\u0002\u0018B]\u0005#\u0005\u000b\u0011\u0002+\t\u0015\u0005\u0015$\u0011\u0018BK\u0002\u0013\u00051\u000b\u0003\u0006\u0002p\te&\u0011#Q\u0001\nQC\u0011b\u0013B]\u0005+\u0007I\u0011\u0001'\t\u0013=\u0013IL!E!\u0002\u0013\u0011\u0002\"C \u0003:\nU\r\u0011\"\u0001A\u0011%A%\u0011\u0018B\tB\u0003%\u0011\tC\u0005`\u0005s\u0013)\u001a!C\u0001A\"IQM!/\u0003\u0012\u0003\u0006I!\u0019\u0005\bO\neF\u0011\u0001Bn)1\u0011iN!9\u0003d\n\u0015(q\u001dBu!\u0011\u0011yN!/\u000e\u0005\te\u0005B\u0002*\u0003Z\u0002\u0007A\u000bC\u0004\u0002f\te\u0007\u0019\u0001+\t\r-\u0013I\u000e1\u0001\u0013\u0011\u0019y$\u0011\u001ca\u0001\u0003\"1qL!7A\u0002\u0005D!B!\t\u0003:\u0006\u0005I\u0011\u0001Bw)1\u0011iNa<\u0003r\nM(Q\u001fB|\u0011!\u0011&1\u001eI\u0001\u0002\u0004!\u0006\"CA3\u0005W\u0004\n\u00111\u0001U\u0011!Y%1\u001eI\u0001\u0002\u0004\u0011\u0002\u0002C \u0003lB\u0005\t\u0019A!\t\u0011}\u0013Y\u000f%AA\u0002\u0005D!Ba?\u0003:F\u0005I\u0011\u0001B\u007f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa@+\u0007Q\u001b\ta\u000b\u0002\u0004\u0004A!1QAB\u0007\u001b\t\u00199A\u0003\u0003\u0004\n\r-\u0011!C;oG\",7m[3e\u0015\t14&\u0003\u0003\u0004\u0010\r\u001d!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q11\u0003B]#\u0003%\tA!@\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q1q\u0003B]#\u0003%\ta!\u0007\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0004\u0016\u0004%\r\u0005\u0001BCB\u0010\u0005s\u000b\n\u0011\"\u0001\u0004\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAB\u0012U\r\t5\u0011\u0001\u0005\u000b\u0007O\u0011I,%A\u0005\u0002\r%\u0012AD2paf$C-\u001a4bk2$H%N\u000b\u0003\u0007WQ3!YB\u0001\u0011)\u0019yC!/\u0002\u0002\u0013\u00053\u0011G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\rM\u0002\u0003BB\u001b\u0007\u007fi!aa\u000e\u000b\t\re21H\u0001\u0005Y\u0006twM\u0003\u0002\u0004>\u0005!!.\u0019<b\u0013\r\u00014q\u0007\u0005\n\u0007\u0007\u0012I,!A\u0005\u0002M\u000bA\u0002\u001d:pIV\u001cG/\u0011:jifD!ba\u0012\u0003:\u0006\u0005I\u0011AB%\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a?\u0004L!I\u00111SB#\u0003\u0003\u0005\r\u0001\u0016\u0005\u000b\u0007\u001f\u0012I,!A\u0005B\rE\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\rM\u0003CBB+\u00077\nY0\u0004\u0002\u0004X)\u00191\u0011L\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004^\r]#\u0001C%uKJ\fGo\u001c:\t\u0015\r\u0005$\u0011XA\u0001\n\u0003\u0019\u0019'\u0001\u0005dC:,\u0015/^1m)\r\t7Q\r\u0005\u000b\u0003'\u001by&!AA\u0002\u0005m\bBCB5\u0005s\u000b\t\u0011\"\u0011\u0004l\u0005A\u0001.Y:i\u0007>$W\rF\u0001U\u0011)\u0011IF!/\u0002\u0002\u0013\u00053q\u000e\u000b\u0003\u0007gA!ba\u001d\u0003:\u0006\u0005I\u0011IB;\u0003\u0019)\u0017/^1mgR\u0019\u0011ma\u001e\t\u0015\u0005M5\u0011OA\u0001\u0002\u0004\tYp\u0002\u0006\u0004|\te\u0015\u0011!E\u0005\u0007{\nA\u0001R1uCB!!q\\B@\r)\u0011YL!'\u0002\u0002#%1\u0011Q\n\u0007\u0007\u007f\u001a\u0019I!\u001e\u0011\u0017\r\u001551\u0012+U%\u0005\u000b'Q\\\u0007\u0003\u0007\u000fS1a!#,\u0003\u001d\u0011XO\u001c;j[\u0016LAa!$\u0004\b\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000f\u001d\u001cy\b\"\u0001\u0004\u0012R\u00111Q\u0010\u0005\u000b\u00053\u001ay(!A\u0005F\r=\u0004BCBL\u0007\u007f\n\t\u0011\"!\u0004\u001a\u0006)\u0011\r\u001d9msRa!Q\\BN\u0007;\u001byj!)\u0004$\"1!k!&A\u0002QCq!!\u001a\u0004\u0016\u0002\u0007A\u000b\u0003\u0004L\u0007+\u0003\rA\u0005\u0005\u0007\u007f\rU\u0005\u0019A!\t\r}\u001b)\n1\u0001b\u0011)\u00199ka \u0002\u0002\u0013\u00055\u0011V\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019Yka-\u0011\u000bU\u000bYh!,\u0011\u0011U\u001by\u000b\u0016+\u0013\u0003\u0006L1a!-,\u0005\u0019!V\u000f\u001d7fk!Q1QWBS\u0003\u0003\u0005\rA!8\u0002\u0007a$\u0003\u0007\u0003\u0005\u0004:\neE\u0011KB^\u0003!\u0019\u0018M^3J[BdG\u0003BAF\u0007{CqA!&\u00048\u0002\u0007QEB\u0004\u0004B\n\u0015Daa1\u0003;1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d'+Z1eKJ\u001cBaa0\u0003\u0006\"9qma0\u0005\u0002\r\u001dGCABe!\u0011\u0011)la0\t\u0015\r57q\u0018b\u0001\n\u0013\u0019\t$A\u0005dY\u0006\u001c8OT1nK\"I1\u0011[B`A\u0003%11G\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0003\u0002\u0003BH\u0007\u007f#\te!6\u0015\u0007a\u00199\u000eC\u0004\u0003\u0016\u000eM\u0007\u0019A\u0013\t\u0015\rm'QMA\u0001\n\u0013\u0019i.A\u0006sK\u0006$'+Z:pYZ,GCABp!\u0011\u0019)d!9\n\t\r\r8q\u0007\u0002\u0007\u001f\nTWm\u0019;)\u000b\t\u00154'!\u001b)\u000b\t}3'!\u001b")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private Vector _coefficients;
    private double _intercept;
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private final Function1<Vector, Object> margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final Param<Matrix> lowerBoundsOnCoefficients;
    private final Param<Matrix> upperBoundsOnCoefficients;
    private final Param<Vector> lowerBoundsOnIntercepts;
    private final Param<Vector> upperBoundsOnIntercepts;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static /* bridge */ Object load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams.getFamily$(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams.checkThresholdConsistency$(this);
    }

    @Override
    public Matrix getLowerBoundsOnCoefficients() {
        return LogisticRegressionParams.getLowerBoundsOnCoefficients$(this);
    }

    @Override
    public Matrix getUpperBoundsOnCoefficients() {
        return LogisticRegressionParams.getUpperBoundsOnCoefficients$(this);
    }

    @Override
    public Vector getLowerBoundsOnIntercepts() {
        return LogisticRegressionParams.getLowerBoundsOnIntercepts$(this);
    }

    @Override
    public Vector getUpperBoundsOnIntercepts() {
        return LogisticRegressionParams.getUpperBoundsOnIntercepts$(this);
    }

    @Override
    public boolean usingBoundConstrainedOptimization() {
        return LogisticRegressionParams.usingBoundConstrainedOptimization$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam.getElasticNetParam$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public Param<Matrix> lowerBoundsOnCoefficients() {
        return this.lowerBoundsOnCoefficients;
    }

    @Override
    public Param<Matrix> upperBoundsOnCoefficients() {
        return this.upperBoundsOnCoefficients;
    }

    @Override
    public Param<Vector> lowerBoundsOnIntercepts() {
        return this.lowerBoundsOnIntercepts;
    }

    @Override
    public Param<Vector> upperBoundsOnIntercepts() {
        return this.upperBoundsOnIntercepts;
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> x$1) {
        this.family = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.lowerBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> x$1) {
        this.upperBoundsOnCoefficients = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.lowerBoundsOnIntercepts = x$1;
    }

    @Override
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> x$1) {
        this.upperBoundsOnIntercepts = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this._coefficients();
    }

    private Vector _coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0 & Serializable & scala.Serializable)() -> "LogisticRegressionModel coefficients should be row major for binomial model.");
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else if (matrix instanceof SparseMatrix) {
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                } else {
                    throw new MatchError((Object)matrix);
                }
                this._coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._coefficients;
    }

    private Vector _coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._coefficients$lzycompute() : this._coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this._intercept();
    }

    private double _intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this._intercept = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.interceptVector().toArray())).head());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this._intercept;
    }

    private double _intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this._intercept$lzycompute() : this._intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThreshold$(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams.getThreshold$(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams.setThresholds$(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams.getThresholds$(this);
    }

    private Function1<Vector, Object> margin() {
        return this.margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new SparkException("No training summary available for this LogisticRegressionModel");
        });
    }

    public BinaryLogisticRegressionTrainingSummary binarySummary() {
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary;
        LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = this.summary();
        if (!(logisticRegressionTrainingSummary instanceof BinaryLogisticRegressionTrainingSummary)) {
            throw new RuntimeException(new StringBuilder(53).append("Cannot create a binary summary for a non-binary model").append(new StringBuilder(35).append("(numClasses=").append(this.numClasses()).append("), use summary instead.").toString()).toString());
        }
        BinaryLogisticRegressionTrainingSummary binaryLogisticRegressionTrainingSummary2 = binaryLogisticRegressionTrainingSummary = (BinaryLogisticRegressionTrainingSummary)logisticRegressionTrainingSummary;
        return binaryLogisticRegressionTrainingSummary2;
    }

    public Tuple3<LogisticRegressionModel, String, String> findSummaryModel() {
        LogisticRegressionModel model = this.$(this.probabilityCol()).isEmpty() && this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)((PredictionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString())).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.probabilityCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(new StringBuilder(12).append("probability_").append(UUID.randomUUID().toString()).toString()) : (this.$(this.predictionCol()).isEmpty() ? (LogisticRegressionModel)this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(new StringBuilder(11).append("prediction_").append(UUID.randomUUID().toString()).toString()) : this));
        return new Tuple3((Object)model, (Object)model.getProbabilityCol(), (Object)model.getPredictionCol());
    }

    public LogisticRegressionModel setSummary(Option<LogisticRegressionTrainingSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple3<LogisticRegressionModel, String, String> tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        Tuple3 tuple33 = tuple32;
        LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple33._1();
        String probabilityColName2 = (String)tuple33._2();
        String predictionColName2 = (String)tuple33._3();
        return this.numClasses() > 2 ? new LogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol())) : new BinaryLogisticRegressionSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        DenseVector denseVector;
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector2 = (DenseVector)vector;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                int size = denseVector2.size();
                double[] values = denseVector2.values();
                int maxMarginIndex = rawPrediction.argmax();
                double maxMargin = rawPrediction.apply(maxMarginIndex);
                if (maxMargin == Double.POSITIVE_INFINITY) {
                    for (int k = 0; k < size; ++k) {
                        values[k] = k == maxMarginIndex ? 1.0 : 0.0;
                    }
                } else {
                    double temp = 0.0;
                    for (int k = 0; k < this.numClasses(); ++k) {
                        values[k] = maxMargin > 0.0 ? scala.math.package$.MODULE$.exp(values[k] - maxMargin) : scala.math.package$.MODULE$.exp(values[k]);
                        temp += values[k];
                    }
                    double sum = temp;
                    BLAS$.MODULE$.scal(1.0 / sum, (Vector)denseVector2);
                }
                denseVector = denseVector2;
            } else {
                int size = denseVector2.size();
                for (int i = 0; i < size; ++i) {
                    denseVector2.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector2.values()[i]));
                }
                denseVector = denseVector2;
            }
        } else {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector3 = denseVector;
        return denseVector3;
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double d;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            d = super.raw2prediction(rawPrediction);
        } else {
            double t = this.getThreshold();
            double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
            d = rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return new StringBuilder(25).append("LogisticRegressionModel: ").append(new StringBuilder(37).append("uid = ").append(Identifiable.toString$(this)).append(", numClasses = ").append(this.numClasses()).append(", numFeatures = ").append(this.numFeatures()).toString()).toString();
    }

    public static final /* synthetic */ double $anonfun$margin$1(LogisticRegressionModel $this, Vector features) {
        return BLAS$.MODULE$.dot(features, $this._coefficients()) + $this._intercept();
    }

    public static final /* synthetic */ double $anonfun$score$1(LogisticRegressionModel $this, Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)$this.margin().apply((Object)features));
        return 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-m));
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        HasRegParam.$init$(this);
        HasElasticNetParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasThreshold.$init$(this);
        HasAggregationDepth.$init$(this);
        LogisticRegressionParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dimension mismatch! Expected ").append(new StringBuilder(59).append("coefficientMatrix.numRows == interceptVector.size, but ").append(this.coefficientMatrix().numRows()).append(" != ").toString()).append(String.valueOf(BoxesRunTime.boxToInteger((int)this.interceptVector().size()))).toString());
        this.margin = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$margin$1(this, features));
        this.margins = (Function1 & Serializable & scala.Serializable)features -> {
            void var2_2;
            DenseVector m = this.interceptVector().toDense().copy();
            BLAS$.MODULE$.gemv(1.0, this.coefficientMatrix(), features, 1.0, m);
            return var2_2;
        };
        this.score = (Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)LogisticRegressionModel.$anonfun$score$1(this, features));
        this.numFeatures = coefficientMatrix.numCols();
        this.trainingSummary = None$.MODULE$;
    }

    public LogisticRegressionModel(String uid, Vector coefficients, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients.size(), coefficients.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            LogisticRegressionModel logisticRegressionModel;
            DefaultParamsReader.Metadata metadata;
            block10: {
                Matrix matrix;
                Vector vector;
                int n;
                int n2;
                Object isMultinomial;
                block12: {
                    Row row;
                    block11: {
                        Dataset data;
                        block7: {
                            double d;
                            int n3;
                            int n4;
                            Object coefficients;
                            block9: {
                                Row row2;
                                block8: {
                                    metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                    Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    int major = tuple2._1$mcI$sp();
                                    int minor = tuple2._2$mcI$sp();
                                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
                                    Tuple2.mcII.sp sp3 = sp2;
                                    int major2 = sp3._1$mcI$sp();
                                    int minor2 = sp3._2$mcI$sp();
                                    String dataPath = new Path(path, "data").toString();
                                    data = this.sparkSession().read().format("parquet").load(dataPath);
                                    if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block7;
                                    row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                    Some some = Row$.MODULE$.unapplySeq(row2);
                                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block8;
                                    Object numClasses = ((SeqLike)some.get()).apply(0);
                                    Object numFeatures = ((SeqLike)some.get()).apply(1);
                                    Object intercept = ((SeqLike)some.get()).apply(2);
                                    coefficients = ((SeqLike)some.get()).apply(3);
                                    if (!(numClasses instanceof Integer)) break block8;
                                    n4 = BoxesRunTime.unboxToInt((Object)numClasses);
                                    if (!(numFeatures instanceof Integer)) break block8;
                                    n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                    if (!(intercept instanceof Double)) break block8;
                                    d = BoxesRunTime.unboxToDouble((Object)intercept);
                                    if (coefficients instanceof Vector) break block9;
                                }
                                throw new MatchError((Object)row2);
                            }
                            Vector vector2 = (Vector)coefficients;
                            Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n4), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector2);
                            Tuple4 tuple42 = tuple4;
                            int numClasses = BoxesRunTime.unboxToInt((Object)tuple42._1());
                            int numFeatures = BoxesRunTime.unboxToInt((Object)tuple42._2());
                            double intercept = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                            Vector coefficients2 = (Vector)tuple42._4();
                            DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true);
                            Vector interceptVector = Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                            logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses, false);
                            break block10;
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block11;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block11;
                        n2 = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block11;
                        n = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block11;
                        vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block11;
                        matrix = (Matrix)coefficientMatrix;
                        if (isMultinomial instanceof Boolean) break block12;
                    }
                    throw new MatchError((Object)row);
                }
                boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToInteger((int)n), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                Tuple5 tuple52 = tuple5;
                int numClasses = BoxesRunTime.unboxToInt((Object)tuple52._1());
                int numFeatures = BoxesRunTime.unboxToInt((Object)tuple52._2());
                Vector interceptVector = (Vector)tuple52._3();
                Matrix coefficientMatrix = (Matrix)tuple52._4();
                boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix, interceptVector, numClasses, isMultinomial2);
            }
            LogisticRegressionModel model = logisticRegressionModel;
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;
        private final LogisticRegressionModel instance;

        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                }
            }
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() != this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

