/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001C\u0001\u0003!\u0003\r\tA\u0001\u0007\u000311{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\u001c)be\u0006l7O\u0003\u0002\u0004\t\u0005q1\r\\1tg&4\u0017nY1uS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'1\u0001QbE\f E\u0015B3FL\u00195!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fMB\u0011A#F\u0007\u0002\u0005%\u0011aC\u0001\u0002\u001e!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ngB\u0011\u0001$H\u0007\u00023)\u0011!dG\u0001\u0007g\"\f'/\u001a3\u000b\u0005q!\u0011!\u00029be\u0006l\u0017B\u0001\u0010\u001a\u0005-A\u0015m\u001d*fOB\u000b'/Y7\u0011\u0005a\u0001\u0013BA\u0011\u001a\u0005IA\u0015m]#mCN$\u0018n\u0019(fiB\u000b'/Y7\u0011\u0005a\u0019\u0013B\u0001\u0013\u001a\u0005)A\u0015m]'bq&#XM\u001d\t\u00031\u0019J!aJ\r\u0003\u001f!\u000b7OR5u\u0013:$XM]2faR\u0004\"\u0001G\u0015\n\u0005)J\"A\u0002%bgR{G\u000e\u0005\u0002\u0019Y%\u0011Q&\u0007\u0002\u0013\u0011\u0006\u001c8\u000b^1oI\u0006\u0014H-\u001b>bi&|g\u000e\u0005\u0002\u0019_%\u0011\u0001'\u0007\u0002\r\u0011\u0006\u001cx+Z5hQR\u001cu\u000e\u001c\t\u00031IJ!aM\r\u0003\u0019!\u000b7\u000f\u00165sKNDw\u000e\u001c3\u0011\u0005a)\u0014B\u0001\u001c\u001a\u0005MA\u0015m]!hOJ,w-\u0019;j_:$U\r\u001d;i\u0011\u0015A\u0004\u0001\"\u0001;\u0003\u0019!\u0013N\\5uI\r\u0001A#A\u001e\u0011\u00059a\u0014BA\u001f\u0010\u0005\u0011)f.\u001b;\t\u000b}\u0002A\u0011\u0001!\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\u0005\u0005\u0013U\"\u0001\u0001\t\u000b\rs\u0004\u0019\u0001#\u0002\u000bY\fG.^3\u0011\u00059)\u0015B\u0001$\u0010\u0005\u0019!u.\u001e2mK\"9\u0001\n\u0001b\u0001\n\u000bI\u0015A\u00024b[&d\u00170F\u0001K!\rYEJT\u0007\u00027%\u0011Qj\u0007\u0002\u0006!\u0006\u0014\u0018-\u001c\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005E{Q\"\u0001*\u000b\u0005MK\u0014A\u0002\u001fs_>$h(\u0003\u0002V\u001f\u00051\u0001K]3eK\u001aL!a\u0016-\u0003\rM#(/\u001b8h\u0015\t)v\u0002K\u0002H5\u0002\u0004\"a\u00170\u000e\u0003qS!!\u0018\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002`9\n)1+\u001b8dK\u0006\n\u0011-A\u00033]Er\u0003\u0007C\u0003d\u0001\u0011\u0005A-A\u0005hKR4\u0015-\\5msV\ta\nK\u0002c5\u0002DQa\u001a\u0001\u0005B!\fAbZ3u)\"\u0014Xm\u001d5pY\u0012,\u0012\u0001\u0012\u0005\u0006U\u0002!\ta[\u0001\u000eg\u0016$H\u000b\u001b:fg\"|G\u000eZ:\u0015\u0005\u0005c\u0007\"B\"j\u0001\u0004i\u0007c\u0001\bo\t&\u0011qn\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006c\u0002!\tE]\u0001\u000eO\u0016$H\u000b\u001b:fg\"|G\u000eZ:\u0016\u00035DQ\u0001\u001e\u0001\u0005\u0012i\n\u0011d\u00195fG.$\u0006N]3tQ>dGmQ8og&\u001cH/\u001a8ds\"9a\u000f\u0001b\u0001\n\u00039\u0018!\u00077po\u0016\u0014(i\\;oIN|enQ8fM\u001aL7-[3oiN,\u0012\u0001\u001f\t\u0004\u00172K\bC\u0001>~\u001b\u0005Y(B\u0001?\u0005\u0003\u0019a\u0017N\\1mO&\u0011ap\u001f\u0002\u0007\u001b\u0006$(/\u001b=)\tUT\u0016\u0011A\u0011\u0003\u0003\u0007\tQA\r\u00183]ABq!a\u0002\u0001\t\u0003\tI!\u0001\u000fhKRdun^3s\u0005>,h\u000eZ:P]\u000e{WM\u001a4jG&,g\u000e^:\u0016\u0003eDS!!\u0002[\u0003\u0003A\u0001\"a\u0004\u0001\u0005\u0004%\ta^\u0001\u001akB\u0004XM\u001d\"pk:$7o\u00148D_\u00164g-[2jK:$8\u000fK\u0003\u0002\u000ei\u000b\t\u0001C\u0004\u0002\u0016\u0001!\t!!\u0003\u00029\u001d,G/\u00169qKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ug\"*\u00111\u0003.\u0002\u0002!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011QD\u0001\u0018Y><XM\u001d\"pk:$7o\u00148J]R,'oY3qiN,\"!a\b\u0011\t-c\u0015\u0011\u0005\t\u0004u\u0006\r\u0012bAA\u0013w\n1a+Z2u_JDS!!\u0007[\u0003\u0003Aq!a\u000b\u0001\t\u0003\ti#\u0001\u000ehKRdun^3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8/\u0006\u0002\u0002\"!*\u0011\u0011\u0006.\u0002\u0002!I\u00111\u0007\u0001C\u0002\u0013\u0005\u0011QD\u0001\u0018kB\u0004XM\u001d\"pk:$7o\u00148J]R,'oY3qiNDS!!\r[\u0003\u0003Aq!!\u000f\u0001\t\u0003\ti#\u0001\u000ehKR,\u0006\u000f]3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8\u000fK\u0003\u00028i\u000b\t\u0001C\u0004\u0002@\u0001!\t\"!\u0011\u0002CU\u001c\u0018N\\4C_VtGmQ8ogR\u0014\u0018-\u001b8fI>\u0003H/[7ju\u0006$\u0018n\u001c8\u0016\u0005\u0005\r\u0003c\u0001\b\u0002F%\u0019\u0011qI\b\u0003\u000f\t{w\u000e\\3b]\"9\u00111\n\u0001\u0005R\u00055\u0013A\u0007<bY&$\u0017\r^3B]\u0012$&/\u00198tM>\u0014XnU2iK6\fG\u0003CA(\u0003?\n\u0019'a\u001a\u0011\t\u0005E\u00131L\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005)A/\u001f9fg*\u0019\u0011\u0011\f\u0004\u0002\u0007M\fH.\u0003\u0003\u0002^\u0005M#AC*ueV\u001cG\u000fV=qK\"A\u0011\u0011MA%\u0001\u0004\ty%\u0001\u0004tG\",W.\u0019\u0005\t\u0003K\nI\u00051\u0001\u0002D\u00059a-\u001b;uS:<\u0007\u0002CA5\u0003\u0013\u0002\r!a\u001b\u0002!\u0019,\u0017\r^;sKN$\u0015\r^1UsB,\u0007\u0003BA)\u0003[JA!a\u001c\u0002T\tAA)\u0019;b)f\u0004X\r\u0003\b\u0002t\u0001\u0001\n1!A\u0001\n\u0013\t)(! \u0002AM,\b/\u001a:%m\u0006d\u0017\u000eZ1uK\u0006sG\r\u0016:b]N4wN]7TG\",W.\u0019\u000b\t\u0003\u001f\n9(!\u001f\u0002|!A\u0011\u0011MA9\u0001\u0004\ty\u0005\u0003\u0005\u0002f\u0005E\u0004\u0019AA\"\u0011!\tI'!\u001dA\u0002\u0005-\u0014bAA&+\u0001")
public interface LogisticRegressionParams
extends ProbabilisticClassifierParams,
HasRegParam,
HasElasticNetParam,
HasMaxIter,
HasFitIntercept,
HasTol,
HasStandardization,
HasWeightCol,
HasThreshold,
HasAggregationDepth {
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> var1);

    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType var1, boolean var2, DataType var3);

    public static /* synthetic */ LogisticRegressionParams setThreshold$(LogisticRegressionParams $this, double value) {
        return $this.setThreshold(value);
    }

    default public LogisticRegressionParams setThreshold(double value) {
        Object object = this.isSet(this.thresholds()) ? this.clear(this.thresholds()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public Param<String> family();

    public static /* synthetic */ String getFamily$(LogisticRegressionParams $this) {
        return $this.getFamily();
    }

    default public String getFamily() {
        return this.$(this.family());
    }

    public static /* synthetic */ double getThreshold$(LogisticRegressionParams $this) {
        return $this.getThreshold();
    }

    @Override
    default public double getThreshold() {
        double d;
        this.checkThresholdConsistency();
        if (this.isSet(this.thresholds())) {
            double[] ts = this.$(this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Logistic Regression getThreshold only applies to binary classification, but thresholds has length != 2.  thresholds: ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ts)).mkString(",")).toString());
            d = 1.0 / (1.0 + ts[0] / ts[1]);
        } else {
            d = BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
        }
        return d;
    }

    public static /* synthetic */ LogisticRegressionParams setThresholds$(LogisticRegressionParams $this, double[] value) {
        return $this.setThresholds(value);
    }

    default public LogisticRegressionParams setThresholds(double[] value) {
        Object object = this.isSet(this.threshold()) ? this.clear(this.threshold()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)this.set(this.thresholds(), value);
    }

    public static /* synthetic */ double[] getThresholds$(LogisticRegressionParams $this) {
        return $this.getThresholds();
    }

    @Override
    default public double[] getThresholds() {
        double[] dArray;
        this.checkThresholdConsistency();
        if (!this.isSet(this.thresholds()) && this.isSet(this.threshold())) {
            double t = BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0 - t;
            dArray = dArray2;
            dArray2[1] = t;
        } else {
            dArray = this.$(this.thresholds());
        }
        return dArray;
    }

    public static /* synthetic */ void checkThresholdConsistency$(LogisticRegressionParams $this) {
        $this.checkThresholdConsistency();
    }

    default public void checkThresholdConsistency() {
        block0: {
            if (!this.isSet(this.threshold()) || !this.isSet(this.thresholds())) break block0;
            double[] ts = this.$(this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("Logistic Regression found inconsistent values for threshold and").append(new StringBuilder(58).append(" thresholds.  Param threshold is set (").append(this.$(this.threshold())).append("), indicating binary").toString()).append(new StringBuilder(58).append(" classification, but Param thresholds is set with length ").append(ts.length).append(".").toString()).append(" Clear one Param value to fix this problem.").toString());
            double t = 1.0 / (1.0 + ts[0] / ts[1]);
            Predef$.MODULE$.require(package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)this.$(this.threshold())) - t) < 1.0E-5, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Logistic Regression getThreshold found").append(new StringBuilder(69).append(" inconsistent values for threshold (").append(this.$(this.threshold())).append(") and thresholds (equivalent to ").append(t).append(")").toString()).toString());
        }
    }

    public Param<Matrix> lowerBoundsOnCoefficients();

    public static /* synthetic */ Matrix getLowerBoundsOnCoefficients$(LogisticRegressionParams $this) {
        return $this.getLowerBoundsOnCoefficients();
    }

    default public Matrix getLowerBoundsOnCoefficients() {
        return this.$(this.lowerBoundsOnCoefficients());
    }

    public Param<Matrix> upperBoundsOnCoefficients();

    public static /* synthetic */ Matrix getUpperBoundsOnCoefficients$(LogisticRegressionParams $this) {
        return $this.getUpperBoundsOnCoefficients();
    }

    default public Matrix getUpperBoundsOnCoefficients() {
        return this.$(this.upperBoundsOnCoefficients());
    }

    public Param<Vector> lowerBoundsOnIntercepts();

    public static /* synthetic */ Vector getLowerBoundsOnIntercepts$(LogisticRegressionParams $this) {
        return $this.getLowerBoundsOnIntercepts();
    }

    default public Vector getLowerBoundsOnIntercepts() {
        return this.$(this.lowerBoundsOnIntercepts());
    }

    public Param<Vector> upperBoundsOnIntercepts();

    public static /* synthetic */ Vector getUpperBoundsOnIntercepts$(LogisticRegressionParams $this) {
        return $this.getUpperBoundsOnIntercepts();
    }

    default public Vector getUpperBoundsOnIntercepts() {
        return this.$(this.upperBoundsOnIntercepts());
    }

    public static /* synthetic */ boolean usingBoundConstrainedOptimization$(LogisticRegressionParams $this) {
        return $this.usingBoundConstrainedOptimization();
    }

    default public boolean usingBoundConstrainedOptimization() {
        return this.isSet(this.lowerBoundsOnCoefficients()) || this.isSet(this.upperBoundsOnCoefficients()) || this.isSet(this.lowerBoundsOnIntercepts()) || this.isSet(this.upperBoundsOnIntercepts());
    }

    public static /* synthetic */ StructType validateAndTransformSchema$(LogisticRegressionParams $this, StructType schema, boolean fitting, DataType featuresDataType) {
        return $this.validateAndTransformSchema(schema, fitting, featuresDataType);
    }

    @Override
    default public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        block1: {
            this.checkThresholdConsistency();
            if (this.usingBoundConstrainedOptimization()) {
                Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fitting under bound constrained optimization only ").append(new StringBuilder(55).append("supports L2 regularization, but got elasticNetParam = ").append(this.getElasticNetParam()).append(".").toString()).toString());
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) break block1;
            Predef$.MODULE$.require(!this.isSet(this.lowerBoundsOnIntercepts()) && !this.isSet(this.upperBoundsOnIntercepts()), (Function0 & Serializable & scala.Serializable)() -> "Please don't set bounds on intercepts if fitting without intercept.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(schema, fitting, featuresDataType);
    }

    public static /* synthetic */ boolean $anonfun$family$1(String value) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LogisticRegression$.MODULE$.supportedFamilyNames())).contains((Object)value.toLowerCase(Locale.ROOT));
    }

    public static void $init$(LogisticRegressionParams $this) {
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(new Param<String>($this, "family", new StringBuilder(86).append("The name of family which is a description of the label distribution to be used in the ").append(new StringBuilder(27).append("model. Supported options: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LogisticRegression$.MODULE$.supportedFamilyNames())).mkString(", ")).append(".").toString()).toString(), (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)LogisticRegressionParams.$anonfun$family$1(value))));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(new Param<Matrix>($this, "lowerBoundsOnCoefficients", "The lower bounds on coefficients if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(new Param<Matrix>($this, "upperBoundsOnCoefficients", "The upper bounds on coefficients if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(new Param<Vector>($this, "lowerBoundsOnIntercepts", "The lower bounds on intercepts if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(new Param<Vector>($this, "upperBoundsOnIntercepts", "The upper bounds on intercepts if fitting under bound constrained optimization."));
    }
}

