/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.ann.FeedForwardTopology;
import org.apache.spark.ml.ann.FeedForwardTopology$;
import org.apache.spark.ml.ann.FeedForwardTrainer;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronClassifier$;
import org.apache.spark.ml.classification.MultilayerPerceptronParams;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.feature.OneHotEncoderModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]f\u0001B\u0001\u0003\u00015\u0011a$T;mi&d\u0017-_3s!\u0016\u00148-\u001a9ue>t7\t\\1tg&4\u0017.\u001a:\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dqy\u0002#B\b\u0011%aIR\"\u0001\u0002\n\u0005E\u0011!a\u0006)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0004mS:\fGnZ\u0005\u0003/Q\u0011aAV3di>\u0014\bCA\b\u0001!\ty!$\u0003\u0002\u001c\u0005\t9S*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\tyQ$\u0003\u0002\u001f\u0005\tQR*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u0004\u0016M]1ngB\u0011\u0001eI\u0007\u0002C)\u0011!\u0005B\u0001\u0005kRLG.\u0003\u0002%C\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0014\u0001\u0005\u000b\u0007I\u0011I\u0014\u0002\u0007ULG-F\u0001)!\tI#G\u0004\u0002+aA\u00111FL\u0007\u0002Y)\u0011Q\u0006D\u0001\u0007yI|w\u000e\u001e \u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0002\rA\u0013X\rZ3g\u0013\t\u0019DG\u0001\u0004TiJLgn\u001a\u0006\u0003c9B3!\n\u001c=!\t9$(D\u00019\u0015\tId!\u0001\u0006b]:|G/\u0019;j_:L!a\u000f\u001d\u0003\u000bMKgnY3\"\u0003u\nQ!\r\u00186]AB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0005k&$\u0007\u0005K\u0002?mqBQA\u0011\u0001\u0005\u0002\r\u000ba\u0001P5oSRtDC\u0001\rE\u0011\u00151\u0013\t1\u0001)Q\r!e\u0007\u0010\u0015\u0004\u0003Zb\u0004\"\u0002\"\u0001\t\u0003AE#\u0001\r)\u0007\u001d3D\bC\u0003L\u0001\u0011\u0005A*A\u0005tKRd\u0015-_3sgR\u0011QJT\u0007\u0002\u0001!)qJ\u0013a\u0001!\u0006)a/\u00197vKB\u0019\u0011K\u0015+\u000e\u00039J!a\u0015\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E+\u0016B\u0001,/\u0005\rIe\u000e\u001e\u0015\u0004\u0015Zb\u0004\"B-\u0001\t\u0003Q\u0016\u0001D:fi\ncwnY6TSj,GCA'\\\u0011\u0015y\u0005\f1\u0001UQ\rAf\u0007\u0010\u0005\u0006=\u0002!\taX\u0001\ng\u0016$8k\u001c7wKJ$\"!\u00141\t\u000b=k\u0006\u0019\u0001\u0015)\u0007u3$-I\u0001d\u0003\u0015\u0011d\u0006\r\u00181\u0011\u0015)\u0007\u0001\"\u0001g\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003\u001b\u001eDQa\u00143A\u0002QC3\u0001\u001a\u001c=\u0011\u0015Q\u0007\u0001\"\u0001l\u0003\u0019\u0019X\r\u001e+pYR\u0011Q\n\u001c\u0005\u0006\u001f&\u0004\r!\u001c\t\u0003#:L!a\u001c\u0018\u0003\r\u0011{WO\u00197fQ\rIg\u0007\u0010\u0005\u0006e\u0002!\ta]\u0001\bg\u0016$8+Z3e)\tiE\u000fC\u0003Pc\u0002\u0007Q\u000f\u0005\u0002Rm&\u0011qO\f\u0002\u0005\u0019>tw\rK\u0002rmqBQA\u001f\u0001\u0005\u0002m\f\u0011c]3u\u0013:LG/[1m/\u0016Lw\r\u001b;t)\tiE\u0010C\u0003Ps\u0002\u0007!\u0003K\u0002zm\tDaa \u0001\u0005\u0002\u0005\u0005\u0011aC:fiN#X\r]*ju\u0016$2!TA\u0002\u0011\u0015ye\u00101\u0001nQ\rqhG\u0019\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0003\u0011\u0019w\u000e]=\u0015\u0007a\ti\u0001\u0003\u0005\u0002\u0010\u0005\u001d\u0001\u0019AA\t\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\f\t\u0005)\u0001/\u0019:b[&!\u00111DA\u000b\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006BA\u0004mqBq!!\t\u0001\t#\n\u0019#A\u0003ue\u0006Lg\u000eF\u0002\u001a\u0003KA\u0001\"a\n\u0002 \u0001\u0007\u0011\u0011F\u0001\bI\u0006$\u0018m]3ua\u0011\tY#a\u000f\u0011\r\u00055\u00121GA\u001c\u001b\t\tyCC\u0002\u00022\u0019\t1a]9m\u0013\u0011\t)$a\f\u0003\u000f\u0011\u000bG/Y:fiB!\u0011\u0011HA\u001e\u0019\u0001!A\"!\u0010\u0002&\u0005\u0005\t\u0011!B\u0001\u0003\u007f\u00111a\u0018\u00132#\u0011\t\t%a\u0012\u0011\u0007E\u000b\u0019%C\u0002\u0002F9\u0012qAT8uQ&tw\rE\u0002R\u0003\u0013J1!a\u0013/\u0005\r\te.\u001f\u0015\u0004\u0001YbtaBA)\u0005!\u0005\u00111K\u0001\u001f\u001bVdG/\u001b7bs\u0016\u0014\b+\u001a:dKB$(o\u001c8DY\u0006\u001c8/\u001b4jKJ\u00042aDA+\r\u0019\t!\u0001#\u0001\u0002XMA\u0011QKA-\u0003?\n)\u0007E\u0002R\u00037J1!!\u0018/\u0005\u0019\te.\u001f*fMB!\u0001%!\u0019\u0019\u0013\r\t\u0019'\t\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\r\t\u0016qM\u0005\u0004\u0003Sr#\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\"\u0002V\u0011\u0005\u0011Q\u000e\u000b\u0003\u0003'B1\"!\u001d\u0002V\t\u0007I\u0011\u0001\u0002\u0002t\u0005)AJ\u0011$H'V\u0011\u0011Q\u000f\t\u0005\u0003o\n\t)\u0004\u0002\u0002z)!\u00111PA?\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0014\u0001\u00026bm\u0006L1aMA=\u0011%\t))!\u0016!\u0002\u0013\t)(\u0001\u0004M\u0005\u001a;5\u000b\t\u0005\f\u0003\u0013\u000b)F1A\u0005\u0002\t\t\u0019(\u0001\u0002H\t\"I\u0011QRA+A\u0003%\u0011QO\u0001\u0004\u000f\u0012\u0003\u0003bCAI\u0003+\u0012\r\u0011\"\u0001\u0003\u0003'\u000b\u0001c];qa>\u0014H/\u001a3T_24XM]:\u0016\u0005\u0005U\u0005\u0003B)S\u0003kB\u0011\"!'\u0002V\u0001\u0006I!!&\u0002#M,\b\u000f]8si\u0016$7k\u001c7wKJ\u001c\b\u0005\u0003\u0005\u0002\u001e\u0006UC\u0011IAP\u0003\u0011aw.\u00193\u0015\u0007a\t\t\u000bC\u0004\u0002$\u0006m\u0005\u0019\u0001\u0015\u0002\tA\fG\u000f\u001b\u0015\u0005\u000373$\r\u0003\u0006\u0002*\u0006U\u0013\u0011!C\u0005\u0003W\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0016\t\u0005\u0003o\ny+\u0003\u0003\u00022\u0006e$AB(cU\u0016\u001cG\u000f\u000b\u0003\u0002VY\u0012\u0007\u0006BA(m\t\u0004")
public class MultilayerPerceptronClassifier
extends ProbabilisticClassifier<Vector, MultilayerPerceptronClassifier, MultilayerPerceptronClassificationModel>
implements MultilayerPerceptronParams,
DefaultParamsWritable {
    private final String uid;
    private final IntArrayParam layers;
    private final IntParam blockSize;
    private final Param<String> solver;
    private final Param<Vector> initialWeights;
    private final DoubleParam stepSize;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final LongParam seed;

    public static MLReader<MultilayerPerceptronClassifier> read() {
        return MultilayerPerceptronClassifier$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return MultilayerPerceptronClassifier$.MODULE$.load(string);
    }

    public static MultilayerPerceptronClassifier load(String string) {
        return MultilayerPerceptronClassifier$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int[] getLayers() {
        return MultilayerPerceptronParams.getLayers$(this);
    }

    @Override
    public final int getBlockSize() {
        return MultilayerPerceptronParams.getBlockSize$(this);
    }

    @Override
    public final Vector getInitialWeights() {
        return MultilayerPerceptronParams.getInitialWeights$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final IntArrayParam layers() {
        return this.layers;
    }

    @Override
    public final IntParam blockSize() {
        return this.blockSize;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final Param<Vector> initialWeights() {
        return this.initialWeights;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$layers_$eq(IntArrayParam x$1) {
        this.layers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$initialWeights_$eq(Param<Vector> x$1) {
        this.initialWeights = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public MultilayerPerceptronClassifier setLayers(int[] value) {
        return (MultilayerPerceptronClassifier)this.set(this.layers(), value);
    }

    public MultilayerPerceptronClassifier setBlockSize(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setSolver(String value) {
        return (MultilayerPerceptronClassifier)this.set(this.solver(), value);
    }

    public MultilayerPerceptronClassifier setMaxIter(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setTol(double value) {
        return (MultilayerPerceptronClassifier)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public MultilayerPerceptronClassifier setSeed(long value) {
        return (MultilayerPerceptronClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public MultilayerPerceptronClassifier setInitialWeights(Vector value) {
        return (MultilayerPerceptronClassifier)this.set(this.initialWeights(), value);
    }

    public MultilayerPerceptronClassifier setStepSize(double value) {
        return (MultilayerPerceptronClassifier)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public MultilayerPerceptronClassifier copy(ParamMap extra) {
        return (MultilayerPerceptronClassifier)this.defaultCopy(extra);
    }

    @Override
    public MultilayerPerceptronClassificationModel train(Dataset<?> dataset) {
        return (MultilayerPerceptronClassificationModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Optimizer optimizer;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.predictionCol(), this.layers(), this.maxIter(), this.tol(), this.blockSize(), this.solver(), this.stepSize(), this.seed()}));
            int[] myLayers = this.$(this.layers());
            int labels = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).last());
            instr.logNumClasses(labels);
            instr.logNumFeatures(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).head()));
            String encodedLabelCol = new StringBuilder(8).append("_encoded").append((Object)this.$(this.labelCol())).toString();
            OneHotEncoderModel encodeModel = new OneHotEncoderModel(this.uid(), new int[]{labels}).setInputCols((String[])((Object[])new String[]{this.$(this.labelCol())})).setOutputCols((String[])((Object[])new String[]{encodedLabelCol})).setDropLast(false);
            Dataset<Row> encodedDataset = encodeModel.transform(dataset);
            RDD data = encodedDataset.select(this.$(this.featuresCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{encodedLabelCol})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Vector vector;
                Object encodedLabel;
                block3: {
                    Row row;
                    block2: {
                        row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                        Object features = ((SeqLike)some.get()).apply(0);
                        encodedLabel = ((SeqLike)some.get()).apply(1);
                        if (!(features instanceof Vector)) break block2;
                        vector = (Vector)features;
                        if (encodedLabel instanceof Vector) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                Vector vector2 = (Vector)encodedLabel;
                Tuple2 tuple2 = new Tuple2((Object)vector, (Object)vector2);
                return tuple2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            FeedForwardTopology topology = FeedForwardTopology$.MODULE$.multiLayerPerceptron(myLayers, true);
            FeedForwardTrainer trainer = new FeedForwardTrainer(topology, myLayers[0], BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(myLayers)).last()));
            FeedForwardTrainer feedForwardTrainer = this.isDefined(this.initialWeights()) ? trainer.setWeights(this.$(this.initialWeights())) : trainer.setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed())));
            String string = this.$(this.solver());
            String string2 = MultilayerPerceptronClassifier$.MODULE$.LBFGS();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                optimizer = trainer.LBFGSOptimizer().setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setNumIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())));
            } else {
                String string3 = this.$(this.solver());
                String string4 = MultilayerPerceptronClassifier$.MODULE$.GD();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    optimizer = trainer.SGDOptimizer().setNumIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setStepSize(BoxesRunTime.unboxToDouble((Object)this.$(this.stepSize())));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(63).append("The solver ").append(this.solver()).append(" is not supported by MultilayerPerceptronClassifier.").toString());
                }
            }
            trainer.setStackSize(BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
            TopologyModel mlpModel = trainer.train((RDD<Tuple2<Vector, Vector>>)data);
            return new MultilayerPerceptronClassificationModel(this.uid(), myLayers, mlpModel.weights());
        });
    }

    public MultilayerPerceptronClassifier(String uid) {
        this.uid = uid;
        HasSeed.$init$(this);
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasStepSize.$init$(this);
        HasSolver.$init$(this);
        MultilayerPerceptronParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public MultilayerPerceptronClassifier() {
        this(Identifiable$.MODULE$.randomUID("mlpc"));
    }
}

