/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasThresholds;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0003\u0003i!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\rqQCI\n\u0004\u0001=1\u0003\u0003\u0002\t\u0012'\u0005j\u0011AA\u0005\u0003%\t\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\taa)Z1ukJ,7\u000fV=qKF\u0011\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\b\u001d>$\b.\u001b8h!\tIr$\u0003\u0002!5\t\u0019\u0011I\\=\u0011\u0005Q\u0011C!B\u0012\u0001\u0005\u0004!#!A'\u0012\u0005a)\u0003\u0003\u0002\t\u0001'\u0005\u0002\"\u0001E\u0014\n\u0005!\u0012!!\b)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005)\u0003\"B\u0017\u0001\t\u0003q\u0013!E:fiB\u0013xNY1cS2LG/_\"pYR\u0011\u0011e\f\u0005\u0006a1\u0002\r!M\u0001\u0006m\u0006dW/\u001a\t\u0003eer!aM\u001c\u0011\u0005QRR\"A\u001b\u000b\u0005Yb\u0011A\u0002\u001fs_>$h(\u0003\u000295\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA$\u0004C\u0003>\u0001\u0011\u0005a(A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0003C}BQ\u0001\r\u001fA\u0002\u0001\u00032!G!D\u0013\t\u0011%DA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001a\t&\u0011QI\u0007\u0002\u0007\t>,(\r\\3\t\u000b\u001d\u0003A\u0011\t%\u0002\u0013Q\u0014\u0018M\\:g_JlGCA%[!\tQuK\u0004\u0002L):\u0011AJ\u0015\b\u0003\u001bFs!A\u0014)\u000f\u0005Qz\u0015\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t\u0019f!A\u0002tc2L!!\u0016,\u0002\u000fA\f7m[1hK*\u00111KB\u0005\u00031f\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005U3\u0006\"B.G\u0001\u0004a\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003;\n\u00042AX0b\u001b\u00051\u0016B\u00011W\u0005\u001d!\u0015\r^1tKR\u0004\"\u0001\u00062\u0005\u0013\rT\u0016\u0011!A\u0001\u0006\u00039\"aA0%c!)Q\r\u0001D\tM\u00061\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\r\u0006\u0002h[B\u0011\u0001n[\u0007\u0002S*\u0011!\u000eB\u0001\u0007Y&t\u0017\r\\4\n\u00051L'A\u0002,fGR|'\u000fC\u0003oI\u0002\u0007q-A\u0007sC^\u0004&/\u001a3jGRLwN\u001c\u0005\u0006a\u0002!\t\"]\u0001\u0010e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5usR\u0011qM\u001d\u0005\u0006]>\u0004\ra\u001a\u0005\u0006i\u0002!\t&^\u0001\u000fe\u0006<(\u0007\u001d:fI&\u001cG/[8o)\t\u0019e\u000fC\u0003og\u0002\u0007q\rC\u0003y\u0001\u0011E\u00110\u0001\nqe\u0016$\u0017n\u0019;Qe>\u0014\u0017MY5mSRLHCA4{\u0011\u0015Yx\u000f1\u0001\u0014\u0003!1W-\u0019;ve\u0016\u001c\b\"B?\u0001\t#q\u0018A\u00069s_\n\f'-\u001b7jif\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\u0005\r{\bBBA\u0001y\u0002\u0007q-A\u0006qe>\u0014\u0017MY5mSRL\bf\u0001\u0001\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0003\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\b\u0011\u0005M!\u0001#\u0001\u0005\u0003+\t\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0019\u0001#a\u0006\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0003\u0002\u001aM1\u0011qCA\u000e\u0003C\u00012!GA\u000f\u0013\r\tyB\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007e\t\u0019#C\u0002\u0002&i\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqAKA\f\t\u0003\tI\u0003\u0006\u0002\u0002\u0016!A\u0011QFA\f\t\u0003\ty#A\u0010o_Jl\u0017\r\\5{KR{\u0007K]8cC\nLG.\u001b;jKNLe\u000e\u00157bG\u0016$B!!\r\u00028A\u0019\u0011$a\r\n\u0007\u0005U\"D\u0001\u0003V]&$\b\u0002CA\u001d\u0003W\u0001\r!a\u000f\u0002\u0003Y\u00042\u0001[A\u001f\u0013\r\ty$\u001b\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0006\u0002D\u0005]\u0011\u0011!C\u0005\u0003\u000b\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\t\t\u0005\u0003\u0013\n\u0019&\u0004\u0002\u0002L)!\u0011QJA(\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002L\t1qJ\u00196fGR\u0004")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds.getThresholds$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        Predef$.MODULE$.require(value.length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append(this.getClass().getSimpleName()).append(".setThresholds() called with non-matching numClasses and thresholds.length.").append(new StringBuilder(40).append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(value.length).toString()).toString());
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset outputData;
        block10: {
            this.transformSchema(dataset.schema(), true);
            if (this.isDefined(this.thresholds())) {
                Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append(this.getClass().getSimpleName()).append(".transform() called with non-matching numClasses and thresholds.length.").append(new StringBuilder(40).append(" numClasses=").append(this.numClasses()).append(", but thresholds has length ").append(this.$(this.thresholds()).length).toString()).toString());
            }
            outputData = dataset;
            int numColsOutput = 0;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictRaw(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})));
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    JavaUniverse $u2 = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                        }
                    }
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> this.raw2probability((Vector)rawPrediction), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                        }
                    }
                    UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> this.predictProbability(features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(null)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column probUDF = column;
                outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF);
                ++numColsOutput;
            }
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
                Column column;
                if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)rawPrediction -> BoxesRunTime.boxToDouble((double)this.raw2prediction(rawPrediction)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
                } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                    JavaUniverse $u = package$.MODULE$.universe();
                    JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                    public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                    extends TypeCreator {
                        public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                            Universe $u = $m$untyped.universe();
                            Mirror<U> $m = $m$untyped;
                            return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                        }

                        public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                        }
                    }
                    column = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)probability -> BoxesRunTime.boxToDouble((double)this.probability2prediction(probability)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(null))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
                } else {
                    UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                    column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
                }
                Column predUDF = column;
                outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF);
                ++numColsOutput;
            }
            if (numColsOutput != false) break block10;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(99).append(this.uid()).append(": ProbabilisticClassificationModel.transform() was called as NOOP").append(" since no output columns were set.").toString());
        }
        return outputData.toDF();
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return !this.isDefined(this.thresholds()) ? (double)rawPrediction.argmax() : this.probability2prediction(this.raw2probability(rawPrediction));
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        double d;
        if (!this.isDefined(this.thresholds())) {
            d = probability.argmax();
        } else {
            double[] thresholds = this.getThresholds();
            int argMax = 0;
            double max = Double.NEGATIVE_INFINITY;
            int probabilitySize = probability.size();
            for (int i = 0; i < probabilitySize; ++i) {
                double scaled = probability.apply(i) / thresholds[i];
                if (!(scaled > max)) continue;
                max = scaled;
                argMax = i;
            }
            d = argMax;
        }
        return d;
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol.$init$(this);
        HasThresholds.$init$(this);
        ProbabilisticClassifierParams.$init$(this);
    }
}

