/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.package$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t5e\u0001B\u0001\u0003\u00015\u0011qDU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0007\u00019Ir$J\u0016\u0011\t=\u0001\"\u0003G\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002!!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\t\u00051A.\u001b8bY\u001eL!a\u0006\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\t\u0005!AO]3f\u0013\tq2D\u0001\u000fSC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0011\u0007i\u0001#%\u0003\u0002\"7\t\tBK]3f\u000b:\u001cX-\u001c2mK6{G-\u001a7\u0011\u0005=\u0019\u0013B\u0001\u0013\u0003\u0005}!UmY5tS>tGK]3f\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tA!\u001e;jY&\u0011!f\n\u0002\u000b\u001b2;&/\u001b;bE2,\u0007C\u0001\u00170\u001b\u0005i#\"\u0001\u0018\u0002\u000bM\u001c\u0017\r\\1\n\u0005Aj#\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011I\u001a\u0002\u0007ULG-F\u00015!\t)DH\u0004\u00027uA\u0011q'L\u0007\u0002q)\u0011\u0011\bD\u0001\u0007yI|w\u000e\u001e \n\u0005mj\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!aO\u0017)\u0007E\u0002e\t\u0005\u0002B\t6\t!I\u0003\u0002D\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0015\u0013%!B*j]\u000e,\u0017%A$\u0002\u000bErSG\f\u0019\t\u0011%\u0003!\u0011!Q\u0001\nQ\nA!^5eA!\u001a\u0001\n\u0011$\t\u00111\u0003!Q1A\u0005\n5\u000baa\u0018;sK\u0016\u001cX#\u0001(\u0011\u00071z%%\u0003\u0002Q[\t)\u0011I\u001d:bs\"A!\u000b\u0001B\u0001B\u0003%a*A\u0004`iJ,Wm\u001d\u0011\t\u0011Q\u0003!Q1A\u0005BU\u000b1B\\;n\r\u0016\fG/\u001e:fgV\ta\u000b\u0005\u0002-/&\u0011\u0001,\f\u0002\u0004\u0013:$\bfA*A5\u0006\n1,A\u00032]Yr\u0003\u0007\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003W\u00031qW/\u001c$fCR,(/Z:!Q\ra\u0006I\u0017\u0005\tA\u0002\u0011)\u0019!C!+\u0006Qa.^7DY\u0006\u001c8/Z:)\u0007}\u0003e\t\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003W\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u0007\t\u0004e\t\u0003\u0004g\u0001\u0011\u0005AaZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000baA'n[7\t\u000bI*\u0007\u0019\u0001\u001b)\u0007!\u0004e\tC\u0003MK\u0002\u0007a\nC\u0003UK\u0002\u0007a\u000bK\u0002l\u0001jCQ\u0001Y3A\u0002YC3!\u001c!G\u0011\u00191\u0007\u0001\"\u0001\u0005aR!\u0001$]:u\u0011\u0015\u0011x\u000e1\u0001O\u0003\u0015!(/Z3t\u0011\u0015!v\u000e1\u0001W\u0011\u0015\u0001w\u000e1\u0001W\u0011\u0015\u0011\b\u0001\"\u0011NQ\r)\bi^\u0011\u0002q\u0006)\u0011G\f\u001b/a!A!\u0010\u0001EC\u0002\u0013%10\u0001\u0007`iJ,WmV3jO\"$8/F\u0001}!\ras* \t\u0003YyL!a`\u0017\u0003\r\u0011{WO\u00197f\u0011\u0019\t\u0019\u0001\u0001C!w\u0006YAO]3f/\u0016Lw\r\u001b;tQ\u0011\t\t\u0001Q<\t\u000f\u0005%\u0001\u0001\"\u0015\u0002\f\u0005iAO]1og\u001a|'/\\%na2$B!!\u0004\u00020A!\u0011qBA\u0015\u001d\u0011\t\t\"a\t\u000f\t\u0005M\u0011q\u0004\b\u0005\u0003+\tiB\u0004\u0003\u0002\u0018\u0005mabA\u001c\u0002\u001a%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0004\u0003C1\u0011aA:rY&!\u0011QEA\u0014\u0003\u001d\u0001\u0018mY6bO\u0016T1!!\t\u0007\u0013\u0011\tY#!\f\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\u0013\u0003OA\u0001\"!\r\u0002\b\u0001\u0007\u00111G\u0001\bI\u0006$\u0018m]3ua\u0011\t)$!\u0011\u0011\r\u0005]\u0012\u0011HA\u001f\u001b\t\t9#\u0003\u0003\u0002<\u0005\u001d\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u007f\t\t\u0005\u0004\u0001\u0005\u0019\u0005\r\u0013qFA\u0001\u0002\u0003\u0015\t!!\u0012\u0003\u0007}##'\u0005\u0003\u0002H\u00055\u0003c\u0001\u0017\u0002J%\u0019\u00111J\u0017\u0003\u000f9{G\u000f[5oOB\u0019A&a\u0014\n\u0007\u0005ESFA\u0002B]fDq!!\u0016\u0001\t#\n9&\u0001\u0006qe\u0016$\u0017n\u0019;SC^$2AEA-\u0011\u001d\tY&a\u0015A\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\b\u0003?\u0002A\u0011KA1\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u0001\n\u0002d!9\u0011QMA/\u0001\u0004\u0011\u0012!\u0004:boB\u0013X\rZ5di&|g\u000eC\u0004\u0002j\u0001!\t%a\u001b\u0002\t\r|\u0007/\u001f\u000b\u00041\u00055\u0004\u0002CA8\u0003O\u0002\r!!\u001d\u0002\u000b\u0015DHO]1\u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tY(!\u001e\u0003\u0011A\u000b'/Y7NCBDC!a\u001aAo\"9\u0011\u0011\u0011\u0001\u0005B\u0005\r\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003QBC!a Ao\"Q\u0011\u0011\u0012\u0001\t\u0006\u0004%\t!a#\u0002%\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm]\u000b\u0002%!\"\u0011q\u0011!G\u0011!\t\t\n\u0001C\u0001\t\u0005M\u0015!\u0002;p\u001f2$WCAAK!\u0011\t9*a)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000bQ!\\8eK2T1\u0001HAP\u0015\r\t\tKB\u0001\u0006[2d\u0017NY\u0005\u0005\u0003K\u000bIJA\tSC:$w.\u001c$pe\u0016\u001cH/T8eK2Dq!!+\u0001\t\u0003\nY+A\u0003xe&$X-\u0006\u0002\u0002.B\u0019a%a,\n\u0007\u0005EvE\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015\t9\u000bQA[C\t\t9,A\u00033]Ar\u0003\u0007K\u0002\u0001\u0001^<q!!0\u0003\u0011\u0003\ty,A\u0010SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2\u00042aDAa\r\u0019\t!\u0001#\u0001\u0002DN9\u0011\u0011YAc\u0003\u0017\\\u0003c\u0001\u0017\u0002H&\u0019\u0011\u0011Z\u0017\u0003\r\u0005s\u0017PU3g!\u00111\u0013Q\u001a\r\n\u0007\u0005=wE\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016DqAZAa\t\u0003\t\u0019\u000e\u0006\u0002\u0002@\"A\u0011q[Aa\t\u0003\nI.\u0001\u0003sK\u0006$WCAAn!\u00111\u0013Q\u001c\r\n\u0007\u0005}wE\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0015\t)\u000eQA[\u0011!\t)/!1\u0005B\u0005\u001d\u0018\u0001\u00027pC\u0012$2\u0001GAu\u0011\u001d\tY/a9A\u0002Q\nA\u0001]1uQ\"*\u00111\u001d!\u00026\u001aI\u0011\u0011_Aa\u0001\u0005\u0005\u00171\u001f\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016dwK]5uKJ\u001cB!a<\u0002.\"Q\u0011q_Ax\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011%t7\u000f^1oG\u0016DqAZAx\t\u0003\tY\u0010\u0006\u0003\u0002~\n\u0005\u0001\u0003BA\u0000\u0003_l!!!1\t\u000f\u0005]\u0018\u0011 a\u00011!A!QAAx\t#\u00129!\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011IAa\u0004\u0011\u00071\u0012Y!C\u0002\u0003\u000e5\u0012A!\u00168ji\"9\u00111\u001eB\u0002\u0001\u0004!da\u0002B\n\u0003\u0003$!Q\u0003\u0002&%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d'+Z1eKJ\u001cBA!\u0005\u0002\\\"9aM!\u0005\u0005\u0002\teAC\u0001B\u000e!\u0011\tyP!\u0005\t\u0015\t}!\u0011\u0003b\u0001\n\u0013\u0011\t#A\u0005dY\u0006\u001c8OT1nKV\u0011!1\u0005\t\u0005\u0005K\u0011y#\u0004\u0002\u0003()!!\u0011\u0006B\u0016\u0003\u0011a\u0017M\\4\u000b\u0005\t5\u0012\u0001\u00026bm\u0006L1!\u0010B\u0014\u0011%\u0011\u0019D!\u0005!\u0002\u0013\u0011\u0019#\u0001\u0006dY\u0006\u001c8OT1nK\u0002B!Ba\u000e\u0003\u0012\t\u0007I\u0011\u0002B\u0011\u00035!(/Z3DY\u0006\u001c8OT1nK\"I!1\bB\tA\u0003%!1E\u0001\u000fiJ,Wm\u00117bgNt\u0015-\\3!\u0011!\t)O!\u0005\u0005B\t}Bc\u0001\r\u0003B!9\u00111\u001eB\u001f\u0001\u0004!\u0004\"\u0003B#\u0003\u0003$\t\u0001\u0002B$\u0003\u001d1'o\\7PY\u0012$2\u0002\u0007B%\u0005\u001b\u00129F!\u0019\u0003d!A!1\nB\"\u0001\u0004\t)*\u0001\u0005pY\u0012lu\u000eZ3m\u0011!\u0011yEa\u0011A\u0002\tE\u0013A\u00029be\u0016tG\u000fE\u0002\u0010\u0005'J1A!\u0016\u0003\u0005Y\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u0016\u0014\b\u0002\u0003B-\u0005\u0007\u0002\rAa\u0017\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000bU\u0012iF\u0016,\n\u0007\t}cHA\u0002NCBDa\u0001\u0019B\"\u0001\u00041\u0006\u0002\u0003+\u0003DA\u0005\t\u0019\u0001,\t\u0017\t\u001d\u0014\u0011YI\u0001\n\u0003!!\u0011N\u0001\u0012MJ|Wn\u00147eI\u0011,g-Y;mi\u0012*TC\u0001B6U\r1&QN\u0016\u0003\u0005_\u0002BA!\u001d\u0003z5\u0011!1\u000f\u0006\u0005\u0005k\u00129(A\u0005v]\u000eDWmY6fI*\u00111)L\u0005\u0005\u0005w\u0012\u0019HA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!Ba \u0002B\u0006\u0005I\u0011\u0002BA\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\r\u0005\u0003\u0002B\u0013\u0005\u000bKAAa\"\u0003(\t1qJ\u00196fGRDS!!1A\u0003kCS!a/A\u0003k\u0003")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private int totalNumNodes;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final DoubleParam subsamplingRate;
    private final Param<String> featureSubsetStrategy;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static /* bridge */ Object load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static RandomForestClassificationModel load(String string) {
        return RandomForestClassificationModel$.MODULE$.load(string);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public TreeClassifierParams setImpurity(String value) {
        return TreeClassifierParams.setImpurity$(this, value);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public RandomForestParams setNumTrees(int value) {
        return RandomForestParams.setNumTrees$(this, value);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public TreeEnsembleParams setSubsamplingRate(double value) {
        return TreeEnsembleParams.setSubsamplingRate$(this, value);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public TreeEnsembleParams setFeatureSubsetStrategy(String value) {
        return TreeEnsembleParams.setFeatureSubsetStrategy$(this, value);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public DecisionTreeParams setMaxDepth(int value) {
        return DecisionTreeParams.setMaxDepth$(this, value);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public DecisionTreeParams setMaxBins(int value) {
        return DecisionTreeParams.setMaxBins$(this, value);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public DecisionTreeParams setMinInstancesPerNode(int value) {
        return DecisionTreeParams.setMinInstancesPerNode$(this, value);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public DecisionTreeParams setMinInfoGain(double value) {
        return DecisionTreeParams.setMinInfoGain$(this, value);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public DecisionTreeParams setSeed(long value) {
        return DecisionTreeParams.setSeed$(this, value);
    }

    @Override
    public DecisionTreeParams setMaxMemoryInMB(int value) {
        return DecisionTreeParams.setMaxMemoryInMB$(this, value);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public DecisionTreeParams setCacheNodeIds(boolean value) {
        return DecisionTreeParams.setCacheNodeIds$(this, value);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public DecisionTreeParams setCheckpointInterval(int value) {
        return DecisionTreeParams.setCheckpointInterval$(this, value);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public Dataset<Row> transformImpl(Dataset<?> dataset) {
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)features -> BoxesRunTime.boxToDouble((double)RandomForestClassificationModel.$anonfun$transformImpl$1(bcastModel, features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.fill(this.numClasses(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).view().foreach((Function1 & Serializable & scala.Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$2(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (!(vector instanceof DenseVector)) {
            if (vector instanceof SparseVector) {
                throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
            }
            throw new MatchError((Object)vector);
        }
        DenseVector denseVector = (DenseVector)vector;
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(50).append("RandomForestClassificationModel (uid=").append(this.uid()).append(") with ").append(this.getNumTrees()).append(" trees").toString();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._trees())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toOld(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transformImpl$1(Broadcast bcastModel$1, Object features) {
        return ((ClassificationModel)bcastModel$1.value()).predict((Vector)features);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$2(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(classCounts)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_trees)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            Tuple2 tuple22 = tuple2;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple22._1();
            Tuple2[] treesData2 = (Tuple2[])tuple22._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numClasses")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])treesData2)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeClassificationModel decisionTreeClassificationModel = tree;
                return decisionTreeClassificationModel;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class)));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("RandomForestClassificationModel.load expected ").append(numTrees).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

