/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.BisectingKMeans$;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.clustering.BisectingKMeansParams;
import org.apache.spark.ml.clustering.BisectingKMeansSummary;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000bCSN,7\r^5oO.kU-\u00198t\u001b>$W\r\u001c\t\u0003']I!\u0001\u0007\u0002\u0003+\tK7/Z2uS:<7*T3b]N\u0004\u0016M]1ngB\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0005kRLG.\u0003\u0002\u001f7\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011I\u0011\u0002\u0007ULG-F\u0001#!\t\u0019CF\u0004\u0002%UA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005D\u0001\u0007yI|w\u000e\u001e \u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B3a\b\u00197!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u001a\u0003\u000bMKgnY3\"\u0003]\nQA\r\u00181]AB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0005k&$\u0007\u0005K\u00029aYBQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtDC\u0001 @!\t\u0019\u0002\u0001C\u0003!w\u0001\u0007!\u0005K\u0002@aYB3a\u000f\u00197\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003\u0011\u0019w\u000e]=\u0015\u0005y*\u0005\"\u0002$C\u0001\u00049\u0015!B3yiJ\f\u0007C\u0001%L\u001b\u0005I%B\u0001&\u0005\u0003\u0015\u0001\u0018M]1n\u0013\ta\u0015J\u0001\u0005QCJ\fW.T1qQ\r\u0011\u0005G\u000e\u0005\u0006y\u0001!\ta\u0014\u000b\u0002}!\u001aa\n\r\u001c\t\u000bI\u0003A\u0011A*\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011A+V\u0007\u0002\u0001!)a+\u0015a\u0001E\u0005)a/\u00197vK\"\u001a\u0011\u000b\r\u001c\t\u000be\u0003A\u0011\u0001.\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u0001+\\\u0011\u00151\u0006\f1\u0001#Q\rA\u0006G\u000e\u0005\u0006=\u0002!\taX\u0001\u0005g\u0016$8\n\u0006\u0002UA\")a+\u0018a\u0001CB\u0011!mY\u0007\u0002Q%\u0011A\r\u000b\u0002\u0004\u0013:$\bfA/1m!)q\r\u0001C\u0001Q\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005QK\u0007\"\u0002,g\u0001\u0004\t\u0007f\u000141m!)A\u000e\u0001C\u0001[\u000691/\u001a;TK\u0016$GC\u0001+o\u0011\u001516\u000e1\u0001p!\t\u0011\u0007/\u0003\u0002rQ\t!Aj\u001c8hQ\rY\u0007G\u000e\u0005\u0006i\u0002!\t!^\u0001\u001bg\u0016$X*\u001b8ESZL7/\u001b2mK\u000ecWo\u001d;feNK'0\u001a\u000b\u0003)ZDQAV:A\u0002]\u0004\"A\u0019=\n\u0005eD#A\u0002#pk\ndW\rK\u0002taYBQ\u0001 \u0001\u0005\u0002u\f!c]3u\t&\u001cH/\u00198dK6+\u0017m];sKR\u0011AK \u0005\u0006-n\u0004\rA\t\u0015\u0005wB\n\t!\t\u0002\u0002\u0004\u0005)!G\f\u001b/a!9\u0011q\u0001\u0001\u0005B\u0005%\u0011a\u00014jiR\u0019!#a\u0003\t\u0011\u00055\u0011Q\u0001a\u0001\u0003\u001f\tq\u0001Z1uCN,G\u000f\r\u0003\u0002\u0012\u0005\u0005\u0002CBA\n\u00033\ti\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u0004\u0002\u0007M\fH.\u0003\u0003\u0002\u001c\u0005U!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003?\t\t\u0003\u0004\u0001\u0005\u0019\u0005\r\u00121BA\u0001\u0002\u0003\u0015\t!!\n\u0003\u0007}#3'\u0005\u0003\u0002(\u00055\u0002c\u00012\u0002*%\u0019\u00111\u0006\u0015\u0003\u000f9{G\u000f[5oOB\u0019!-a\f\n\u0007\u0005E\u0002FA\u0002B]fDC!!\u00021m!9\u0011q\u0007\u0001\u0005B\u0005e\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005m\u0012q\t\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)!\u0011\u0011IA\u000b\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t)%a\u0010\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002J\u0005U\u0002\u0019AA\u001e\u0003\u0019\u00198\r[3nC\"\"\u0011Q\u0007\u00197Q\r\u0001\u0001GN\u0004\b\u0003#\u0012\u0001\u0012AA*\u0003=\u0011\u0015n]3di&twmS'fC:\u001c\bcA\n\u0002V\u00191\u0011A\u0001E\u0001\u0003/\u001a\u0002\"!\u0016\u0002Z\u0005}\u0013Q\r\t\u0004E\u0006m\u0013bAA/Q\t1\u0011I\\=SK\u001a\u0004BAGA1}%\u0019\u00111M\u000e\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB\u0019!-a\u001a\n\u0007\u0005%\u0004F\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004=\u0003+\"\t!!\u001c\u0015\u0005\u0005M\u0003\u0002CA9\u0003+\"\t%a\u001d\u0002\t1|\u0017\r\u001a\u000b\u0004}\u0005U\u0004bBA<\u0003_\u0002\rAI\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0002pA2\u0004BCA?\u0003+\n\t\u0011\"\u0003\u0002\u0000\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\u000bAA[1wC&!\u0011qRAC\u0005\u0019y%M[3di\"\"\u0011Q\u000b\u00197Q\u0011\ty\u0005\r\u001c")
public class BisectingKMeans
extends Estimator<BisectingKMeansModel>
implements BisectingKMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final DoubleParam minDivisibleClusterSize;
    private final Param<String> distanceMeasure;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static MLReader<BisectingKMeans> read() {
        return BisectingKMeans$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return BisectingKMeans$.MODULE$.load(string);
    }

    public static BisectingKMeans load(String string) {
        return BisectingKMeans$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return BisectingKMeansParams.getK$(this);
    }

    @Override
    public double getMinDivisibleClusterSize() {
        return BisectingKMeansParams.getMinDivisibleClusterSize$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return BisectingKMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleParam minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$minDivisibleClusterSize_$eq(DoubleParam x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public BisectingKMeans copy(ParamMap extra) {
        return (BisectingKMeans)this.defaultCopy(extra);
    }

    public BisectingKMeans setFeaturesCol(String value) {
        return (BisectingKMeans)this.set(this.featuresCol(), value);
    }

    public BisectingKMeans setPredictionCol(String value) {
        return (BisectingKMeans)this.set(this.predictionCol(), value);
    }

    public BisectingKMeans setK(int value) {
        return (BisectingKMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setMaxIter(int value) {
        return (BisectingKMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setSeed(long value) {
        return (BisectingKMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public BisectingKMeans setMinDivisibleClusterSize(double value) {
        return (BisectingKMeans)this.set(this.minDivisibleClusterSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public BisectingKMeans setDistanceMeasure(String value) {
        return (BisectingKMeans)this.set(this.distanceMeasure(), value);
    }

    @Override
    public BisectingKMeansModel fit(Dataset<?> dataset) {
        return (BisectingKMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            RDD<org.apache.spark.mllib.linalg.Vector> rdd = DatasetUtils$.MODULE$.columnToOldVector(dataset, this.getFeaturesCol());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.maxIter(), this.seed(), this.minDivisibleClusterSize(), this.distanceMeasure()}));
            org.apache.spark.mllib.clustering.BisectingKMeans bkm = new org.apache.spark.mllib.clustering.BisectingKMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setMinDivisibleClusterSize(BoxesRunTime.unboxToDouble((Object)this.$(this.minDivisibleClusterSize()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setDistanceMeasure(this.$(this.distanceMeasure()));
            org.apache.spark.mllib.clustering.BisectingKMeansModel parentModel = bkm.run(rdd, (Option<Instrumentation>)new Some(instr));
            BisectingKMeansModel model = this.copyValues(new BisectingKMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
            BisectingKMeansSummary summary = new BisectingKMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            instr.logNumFeatures(((Vector)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters())).head()).size());
            return model.setSummary((Option<BisectingKMeansSummary>)new Some((Object)summary));
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public BisectingKMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasDistanceMeasure.$init$(this);
        BisectingKMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)4)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.minDivisibleClusterSize().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public BisectingKMeans() {
        this(Identifiable$.MODULE$.randomUID("bisecting-kmeans"));
    }
}

