/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.impl.Utils$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\t5\u0011Q#\u0012=qK\u000e$\u0018\r^5p]\u0006;wM]3hCR|'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t1\u0001\u0011\t\u0011)A\u00053\u0005Ya.^7GK\u0006$XO]3t!\ty!$\u0003\u0002\u001c!\t\u0019\u0011J\u001c;\t\u0011u\u0001!\u0011!Q\u0001\ny\t\u0011BY2XK&<\u0007\u000e^:\u0011\u0007}\u0011C%D\u0001!\u0015\t\tc!A\u0005ce>\fGmY1ti&\u00111\u0005\t\u0002\n\u0005J|\u0017\rZ2bgR\u00042aD\u0013(\u0013\t1\u0003CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010Q%\u0011\u0011\u0006\u0005\u0002\u0007\t>,(\r\\3\t\u0011-\u0002!\u0011!Q\u0001\n1\n1BY2HCV\u001c8/[1ogB\u0019qDI\u0017\u0011\u0007=)c\u0006\u0005\u0003\u0010_E\n\u0014B\u0001\u0019\u0011\u0005\u0019!V\u000f\u001d7feA\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\u0007Y&t\u0017\r\\4\n\u0005Y\u001a$a\u0003#f]N,g+Z2u_JDQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtD\u0003\u0002\u001e={y\u0002\"a\u000f\u0001\u000e\u0003\tAQ\u0001G\u001cA\u0002eAQ!H\u001cA\u0002yAQaK\u001cA\u00021Bq\u0001\u0011\u0001C\u0002\u0013%\u0011)A\u0001l+\u0005I\u0002BB\"\u0001A\u0003%\u0011$\u0001\u0002lA!9Q\t\u0001a\u0001\n\u00131\u0015\u0001\u0003;pi\u0006d7I\u001c;\u0016\u0003\u001d\u0003\"a\u0004%\n\u0005%\u0003\"\u0001\u0002'p]\u001eDqa\u0013\u0001A\u0002\u0013%A*\u0001\u0007u_R\fGn\u00118u?\u0012*\u0017\u000f\u0006\u0002N!B\u0011qBT\u0005\u0003\u001fB\u0011A!\u00168ji\"9\u0011KSA\u0001\u0002\u00049\u0015a\u0001=%c!11\u000b\u0001Q!\n\u001d\u000b\u0011\u0002^8uC2\u001ce\u000e\u001e\u0011\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006\u0001b.Z<M_\u001ed\u0015n[3mS\"|w\u000eZ\u000b\u0002O!9\u0001\f\u0001a\u0001\n\u0013I\u0016\u0001\u00068fo2{w\rT5lK2L\u0007n\\8e?\u0012*\u0017\u000f\u0006\u0002N5\"9\u0011kVA\u0001\u0002\u00049\u0003B\u0002/\u0001A\u0003&q%A\toK^dun\u001a'jW\u0016d\u0017\u000e[8pI\u0002B\u0001B\u0018\u0001\t\u0006\u0004%IaX\u0001\u000b]\u0016<x+Z5hQR\u001cX#\u0001\u0013\t\u0011\u0005\u0004\u0001R1A\u0005\n\t\f\u0001B\\3x\u001b\u0016\fgn]\u000b\u0002GB\u0019q\"J\u0019\t\u0011\u0015\u0004\u0001R1A\u0005\n\t\fqA\\3x\u0007>48\u000f\u0003\u0005h\u0001!\u0015\r\u0011\"\u0003i\u00031yG\u000eZ$bkN\u001c\u0018.\u00198t+\u0005I\u0007cA\b&UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\rI&\u001cHO]5ckRLwN\u001c\u0006\u0003_\u0012\tAa\u001d;bi&\u0011\u0011\u000f\u001c\u0002\u0015\u001bVdG/\u001b<be&\fG/Z$bkN\u001c\u0018.\u00198)\u0005\u0019\u001c\bCA\bu\u0013\t)\bCA\u0005ue\u0006t7/[3oi\")q\u000f\u0001C\u0001\r\u0006)1m\\;oi\")\u0011\u0010\u0001C\u0001-\u0006iAn\\4MS.,G.\u001b5p_\u0012DQa\u001f\u0001\u0005\u0002}\u000bqa^3jO\"$8\u000fC\u0003~\u0001\u0011\u0005!-A\u0003nK\u0006t7\u000fC\u0003\u0000\u0001\u0011\u0005!-\u0001\u0003d_Z\u001c\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0004C\u0012$G\u0003BA\u0004\u0003\u0013i\u0011\u0001\u0001\u0005\t\u0003\u0017\t\t\u00011\u0001\u0002\u000e\u0005A\u0011N\\:uC:\u001cW\rE\u00023\u0003\u001fI1!!\u00054\u0005\u00191Vm\u0019;pe\"9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011!B7fe\u001e,G\u0003BA\u0004\u00033Aq!a\u0007\u0002\u0014\u0001\u0007!(A\u0003pi\",'\u000f")
public class ExpectationAggregator
implements Serializable {
    private double[] newWeights;
    private DenseVector[] newMeans;
    private DenseVector[] newCovs;
    private transient MultivariateGaussian[] oldGaussians;
    private final int numFeatures;
    private final Broadcast<double[]> bcWeights;
    private final Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians;
    private final int k;
    private long totalCnt;
    private double newLogLikelihood;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    private int k() {
        return this.k;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double newLogLikelihood() {
        return this.newLogLikelihood;
    }

    private void newLogLikelihood_$eq(double x$1) {
        this.newLogLikelihood = x$1;
    }

    private double[] newWeights$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.newWeights = new double[this.k()];
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.newWeights;
    }

    private double[] newWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.newWeights$lzycompute() : this.newWeights;
    }

    private DenseVector[] newMeans$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.newMeans = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & java.io.Serializable & Serializable)() -> new DenseVector((double[])Array$.MODULE$.fill($this.numFeatures, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> 0.0, ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.newMeans;
    }

    private DenseVector[] newMeans() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.newMeans$lzycompute() : this.newMeans;
    }

    private DenseVector[] newCovs$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.newCovs = (DenseVector[])Array$.MODULE$.fill(this.k(), (Function0 & java.io.Serializable & Serializable)() -> new DenseVector((double[])Array$.MODULE$.fill($this.numFeatures * ($this.numFeatures + 1) / 2, (Function0)(JFunction0.mcD.sp & java.io.Serializable & Serializable)() -> 0.0, ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(DenseVector.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.newCovs;
    }

    private DenseVector[] newCovs() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.newCovs$lzycompute() : this.newCovs;
    }

    private MultivariateGaussian[] oldGaussians$lzycompute() {
        ExpectationAggregator expectationAggregator = this;
        synchronized (expectationAggregator) {
            if (!this.bitmap$trans$0) {
                this.oldGaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bcGaussians.value())).map((Function1 & java.io.Serializable & Serializable)x0$7 -> {
                    Tuple2 tuple2 = x0$7;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    DenseVector mean = (DenseVector)tuple2._1();
                    DenseVector covVec = (DenseVector)tuple2._2();
                    DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix($this.numFeatures, covVec.values());
                    MultivariateGaussian multivariateGaussian = new MultivariateGaussian((Vector)mean, (Matrix)cov);
                    return multivariateGaussian;
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
                this.bitmap$trans$0 = true;
            }
        }
        return this.oldGaussians;
    }

    private MultivariateGaussian[] oldGaussians() {
        return !this.bitmap$trans$0 ? this.oldGaussians$lzycompute() : this.oldGaussians;
    }

    public long count() {
        return this.totalCnt();
    }

    public double logLikelihood() {
        return this.newLogLikelihood();
    }

    public double[] weights() {
        return this.newWeights();
    }

    public DenseVector[] means() {
        return this.newMeans();
    }

    public DenseVector[] covs() {
        return this.newCovs();
    }

    public ExpectationAggregator add(Vector instance) {
        int i;
        double[] localWeights = (double[])this.bcWeights.value();
        MultivariateGaussian[] localOldGaussians = this.oldGaussians();
        double[] prob = new double[this.k()];
        double probSum = 0.0;
        for (i = 0; i < this.k(); ++i) {
            double p;
            prob[i] = p = Utils$.MODULE$.EPSILON() + localWeights[i] * localOldGaussians[i].pdf(instance);
            probSum += p;
        }
        this.newLogLikelihood_$eq(this.newLogLikelihood() + package$.MODULE$.log(probSum));
        double[] localNewWeights = this.newWeights();
        DenseVector[] localNewMeans = this.newMeans();
        DenseVector[] localNewCovs = this.newCovs();
        for (i = 0; i < this.k(); ++i) {
            int n = i;
            prob[n] = prob[n] / probSum;
            int n2 = i;
            localNewWeights[n2] = localNewWeights[n2] + prob[i];
            BLAS$.MODULE$.axpy(prob[i], instance, (Vector)localNewMeans[i]);
            BLAS$.MODULE$.spr(prob[i], instance, localNewCovs[i]);
        }
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public ExpectationAggregator merge(ExpectationAggregator other) {
        block1: {
            if (other.count() == 0L) break block1;
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            double[] localThisNewWeights = this.newWeights();
            double[] localOtherNewWeights = other.newWeights();
            DenseVector[] localThisNewMeans = this.newMeans();
            DenseVector[] localOtherNewMeans = other.newMeans();
            DenseVector[] localThisNewCovs = this.newCovs();
            DenseVector[] localOtherNewCovs = other.newCovs();
            for (int i = 0; i < this.k(); ++i) {
                int n = i;
                localThisNewWeights[n] = localThisNewWeights[n] + localOtherNewWeights[i];
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewMeans[i], (Vector)localThisNewMeans[i]);
                BLAS$.MODULE$.axpy(1.0, (Vector)localOtherNewCovs[i], (Vector)localThisNewCovs[i]);
            }
            this.newLogLikelihood_$eq(this.newLogLikelihood() + other.newLogLikelihood());
        }
        return this;
    }

    public ExpectationAggregator(int numFeatures, Broadcast<double[]> bcWeights, Broadcast<Tuple2<DenseVector, DenseVector>[]> bcGaussians) {
        this.numFeatures = numFeatures;
        this.bcWeights = bcWeights;
        this.bcGaussians = bcGaussians;
        this.k = ((double[])bcWeights.value()).length;
        this.totalCnt = 0L;
        this.newLogLikelihood = 0.0;
    }
}

