/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.ExpectationAggregator;
import org.apache.spark.ml.clustering.GaussianMixture$;
import org.apache.spark.ml.clustering.GaussianMixtureModel;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.IndexedSeqView;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}a\u0001B\u0001\u0003\u00015\u0011qbR1vgNL\u0017M\\'jqR,(/\u001a\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000bHCV\u001c8/[1o\u001b&DH/\u001e:f\u001b>$W\r\u001c\t\u0003']I!\u0001\u0007\u0002\u0003+\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016\u0004\u0016M]1ngB\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0005kRLG.\u0003\u0002\u001f7\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011I\u0011\u0002\u0007ULG-F\u0001#!\t\u0019CF\u0004\u0002%UA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005D\u0001\u0007yI|w\u000e\u001e \u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B3a\b\u00197!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u001a\u0003\u000bMKgnY3\"\u0003]\nQA\r\u00181]AB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0005k&$\u0007\u0005K\u00029aYBQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtDC\u0001 @!\t\u0019\u0002\u0001C\u0003!w\u0001\u0007!\u0005K\u0002@aYB3a\u000f\u00197\u0011\u0015\u0019\u0005\u0001\"\u0011E\u0003\u0011\u0019w\u000e]=\u0015\u0005y*\u0005\"\u0002$C\u0001\u00049\u0015!B3yiJ\f\u0007C\u0001%L\u001b\u0005I%B\u0001&\u0005\u0003\u0015\u0001\u0018M]1n\u0013\ta\u0015J\u0001\u0005QCJ\fW.T1qQ\r\u0011\u0005G\u000e\u0005\u0006y\u0001!\ta\u0014\u000b\u0002}!\u001aa\n\r\u001c\t\u000bI\u0003A\u0011A*\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011A+V\u0007\u0002\u0001!)a+\u0015a\u0001E\u0005)a/\u00197vK\"\u001a\u0011\u000b\r\u001c\t\u000be\u0003A\u0011\u0001.\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u0001+\\\u0011\u00151\u0006\f1\u0001#Q\rA\u0006G\u000e\u0005\u0006=\u0002!\taX\u0001\u0012g\u0016$\bK]8cC\nLG.\u001b;z\u0007>dGC\u0001+a\u0011\u00151V\f1\u0001#Q\ri\u0006G\u000e\u0005\u0006G\u0002!\t\u0001Z\u0001\u0005g\u0016$8\n\u0006\u0002UK\")aK\u0019a\u0001MB\u0011q\r[\u0007\u0002Q%\u0011\u0011\u000e\u000b\u0002\u0004\u0013:$\bf\u000121m!)A\u000e\u0001C\u0001[\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005Qs\u0007\"\u0002,l\u0001\u00041\u0007fA61m!)\u0011\u000f\u0001C\u0001e\u000611/\u001a;U_2$\"\u0001V:\t\u000bY\u0003\b\u0019\u0001;\u0011\u0005\u001d,\u0018B\u0001<)\u0005\u0019!u.\u001e2mK\"\u001a\u0001\u000f\r\u001c\t\u000be\u0004A\u0011\u0001>\u0002\u000fM,GoU3fIR\u0011Ak\u001f\u0005\u0006-b\u0004\r\u0001 \t\u0003OvL!A \u0015\u0003\t1{gn\u001a\u0015\u0004qB2\u0004\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0003)qW/\\*b[BdWm]\u000b\u0002M\"9\u0011\u0011\u0002\u0001!\u0002\u00131\u0017a\u00038v[N\u000bW\u000e\u001d7fg\u0002Bq!!\u0004\u0001\t\u0003\ny!A\u0002gSR$2AEA\t\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003/\t9\u0003\u0005\u0004\u0002\u001a\u0005}\u00111E\u0007\u0003\u00037Q1!!\b\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003C\tYBA\u0004ECR\f7/\u001a;\u0011\t\u0005\u0015\u0012q\u0005\u0007\u0001\t1\tI#!\u0005\u0002\u0002\u0003\u0005)\u0011AA\u0016\u0005\ryFEM\t\u0005\u0003[\t\u0019\u0004E\u0002h\u0003_I1!!\r)\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aZA\u001b\u0013\r\t9\u0004\u000b\u0002\u0004\u0003:L\b\u0006BA\u0006aYBq!!\u0010\u0001\t\u0003\ny$A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\t%!\u0014\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bRA!a\u0012\u0002\u001c\u0005)A/\u001f9fg&!\u00111JA#\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003\u001f\nY\u00041\u0001\u0002B\u000511o\u00195f[\u0006DC!a\u000f1m!9\u0011Q\u000b\u0001\u0005\n\u0005]\u0013AC5oSR\u0014\u0016M\u001c3p[RA\u0011\u0011LA;\u0003\u0017\u000by\tE\u0004h\u00037\ny&!\u001a\n\u0007\u0005u\u0003F\u0001\u0004UkBdWM\r\t\u0005O\u0006\u0005D/C\u0002\u0002d!\u0012Q!\u0011:sCf\u0004RaZA1\u0003O\u0002raZA.\u0003S\nI\u0007\u0005\u0003\u0002l\u0005ETBAA7\u0015\r\ty\u0007B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005M\u0014Q\u000e\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0005\u0002x\u0005M\u0003\u0019AA=\u0003%Ign\u001d;b]\u000e,7\u000f\u0005\u0004\u0002|\u0005\u0005\u0015QQ\u0007\u0003\u0003{R1!a \u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003\u0007\u000biHA\u0002S\t\u0012\u0003B!a\u001b\u0002\b&!\u0011\u0011RA7\u0005\u00191Vm\u0019;pe\"9\u0011QRA*\u0001\u00041\u0017a\u00038v[\u000ecWo\u001d;feNDq!!%\u0002T\u0001\u0007a-A\u0006ok64U-\u0019;ve\u0016\u001c\bf\u0001\u00011m\u001d9\u0011q\u0013\u0002\t\u0002\u0005e\u0015aD$bkN\u001c\u0018.\u00198NSb$XO]3\u0011\u0007M\tYJ\u0002\u0004\u0002\u0005!\u0005\u0011QT\n\t\u00037\u000by*!*\u0002,B\u0019q-!)\n\u0007\u0005\r\u0006F\u0001\u0004B]f\u0014VM\u001a\t\u00055\u0005\u001df(C\u0002\u0002*n\u0011Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002h\u0003[K1!a,)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001da\u00141\u0014C\u0001\u0003g#\"!!'\t\u0017\u0005]\u00161\u0014b\u0001\n\u0003\u0011\u0011QA\u0001\u0011\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bNC\u0001\"a/\u0002\u001c\u0002\u0006IAZ\u0001\u0012\u001b\u0006CvLT+N?\u001a+\u0015\tV+S\u000bN\u0003\u0003\u0002CA`\u00037#\t%!1\u0002\t1|\u0017\r\u001a\u000b\u0004}\u0005\r\u0007bBAc\u0003{\u0003\rAI\u0001\u0005a\u0006$\b\u000e\u000b\u0003\u0002>B2\u0004\"CAf\u00037#\tAAAg\u0003e\u0019\bn\\;mI\u0012K7\u000f\u001e:jEV$XmR1vgNL\u0017M\\:\u0015\r\u0005=\u0017Q[Al!\r9\u0017\u0011[\u0005\u0004\u0003'D#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u001b\u000bI\r1\u0001g\u0011\u001d\t\t*!3A\u0002\u0019D\u0011\"a7\u0002\u001c\u0012\u0005!!!8\u00027Ut\u0007/Y2l+B\u0004XM\u001d+sS\u0006tw-\u001e7be6\u000bGO]5y)\u0019\ty.!:\u0002jB!\u00111NAq\u0013\u0011\t\u0019/!\u001c\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0005\b\u0003O\fI\u000e1\u0001g\u0003\u0005q\u0007\u0002CAv\u00033\u0004\r!a\u0018\u0002!Q\u0014\u0018.\u00198hk2\f'OV1mk\u0016\u001c\b\"CAx\u00037#\tAAAy\u0003e)\b\u000fZ1uK^+\u0017n\u001a5ug\u0006sGmR1vgNL\u0017M\\:\u0015\u0015\u0005M\u0018Q_A}\u0003{\u0014\t\u0001\u0005\u0004h\u00037\"\u0018q\r\u0005\t\u0003o\fi\u000f1\u0001\u0002j\u0005!Q.Z1o\u0011!\tY0!<A\u0002\u0005%\u0014aA2pm\"9\u0011q`Aw\u0001\u0004!\u0018AB<fS\u001eDG\u000fC\u0004\u0003\u0004\u00055\b\u0019\u0001;\u0002\u0015M,XnV3jO\"$8\u000f\u0003\u0006\u0003\b\u0005m\u0015\u0011!C\u0005\u0005\u0013\t1B]3bIJ+7o\u001c7wKR\u0011!1\u0002\t\u0005\u0005\u001b\u00119\"\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003\u0011a\u0017M\\4\u000b\u0005\tU\u0011\u0001\u00026bm\u0006LAA!\u0007\u0003\u0010\t1qJ\u00196fGRDC!a'1m!\"\u0011Q\u0013\u00197\u0001")
public class GaussianMixture
extends Estimator<GaussianMixtureModel>
implements GaussianMixtureParams,
DefaultParamsWritable {
    private final String uid;
    private final int numSamples;
    private final IntParam k;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static MLReader<GaussianMixture> read() {
        return GaussianMixture$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return GaussianMixture$.MODULE$.load(string);
    }

    public static GaussianMixture load(String string) {
        return GaussianMixture$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GaussianMixture copy(ParamMap extra) {
        return (GaussianMixture)this.defaultCopy(extra);
    }

    public GaussianMixture setFeaturesCol(String value) {
        return (GaussianMixture)this.set(this.featuresCol(), value);
    }

    public GaussianMixture setPredictionCol(String value) {
        return (GaussianMixture)this.set(this.predictionCol(), value);
    }

    public GaussianMixture setProbabilityCol(String value) {
        return (GaussianMixture)this.set(this.probabilityCol(), value);
    }

    public GaussianMixture setK(int value) {
        return (GaussianMixture)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setMaxIter(int value) {
        return (GaussianMixture)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public GaussianMixture setTol(double value) {
        return (GaussianMixture)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public GaussianMixture setSeed(long value) {
        return (GaussianMixture)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    private int numSamples() {
        return this.numSamples;
    }

    @Override
    public GaussianMixtureModel fit(Dataset<?> dataset) {
        return (GaussianMixtureModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            int iter;
            this.transformSchema(dataset.schema(), true);
            SparkContext sc = dataset.sparkSession().sparkContext();
            int numClusters = BoxesRunTime.unboxToInt((Object)this.$(this.k()));
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})).rdd().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                org.apache.spark.ml.linalg.Vector vector;
                Object features;
                Row row = x0$3;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(1) != 0 || !((features = ((SeqLike)some.get()).apply(0)) instanceof org.apache.spark.ml.linalg.Vector)) {
                    throw new MatchError((Object)row);
                }
                org.apache.spark.ml.linalg.Vector vector2 = vector = (org.apache.spark.ml.linalg.Vector)features;
                return vector2;
            }, ClassTag$.MODULE$.apply(org.apache.spark.ml.linalg.Vector.class)).cache();
            int numFeatures = ((org.apache.spark.ml.linalg.Vector)instances.first()).size();
            Predef$.MODULE$.require(numFeatures < GaussianMixture$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("GaussianMixture cannot handle more ").append(new StringBuilder(49).append("than ").append(GaussianMixture$.MODULE$.MAX_NUM_FEATURES()).append(" features because the size of the covariance").toString()).append(" matrix is quadratic in the number of features.").toString());
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.probabilityCol(), this.k(), this.maxIter(), this.seed(), this.tol()}));
            instr.logNumFeatures(numFeatures);
            boolean shouldDistributeGaussians = GaussianMixture$.MODULE$.shouldDistributeGaussians(numClusters, numFeatures);
            Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> tuple2 = this.initRandom((RDD<org.apache.spark.ml.linalg.Vector>)instances, numClusters, numFeatures);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double[] weights = (double[])tuple2._1();
            Tuple2[] gaussians = (Tuple2[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)weights, (Object)gaussians);
            Tuple2 tuple23 = tuple22;
            double[] weights2 = (double[])tuple23._1();
            Tuple2[] gaussians2 = (Tuple2[])tuple23._2();
            double logLikelihood = Double$.MODULE$.MinValue();
            double logLikelihoodPrev = 0.0;
            for (iter = 0; iter < BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())) && package$.MODULE$.abs(logLikelihood - logLikelihoodPrev) > BoxesRunTime.unboxToDouble((Object)this.$(this.tol())); ++iter) {
                Broadcast bcWeights = instances.sparkContext().broadcast((Object)weights2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
                Broadcast bcGaussians = instances.sparkContext().broadcast((Object)gaussians2, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                ExpectationAggregator x$4 = new ExpectationAggregator(numFeatures, (Broadcast<double[]>)bcWeights, (Broadcast<Tuple2<DenseVector, DenseVector>[]>)bcGaussians);
                Function2 & Serializable & scala.Serializable x$5 = (Function2 & Serializable & scala.Serializable)(c, v) -> {
                    Tuple2 tuple2 = new Tuple2(c, v);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExpectationAggregator aggregator = (ExpectationAggregator)tuple2._1();
                    org.apache.spark.ml.linalg.Vector instance = (org.apache.spark.ml.linalg.Vector)tuple2._2();
                    ExpectationAggregator expectationAggregator = aggregator.add(instance);
                    return expectationAggregator;
                };
                Function2 & Serializable & scala.Serializable x$6 = (Function2 & Serializable & scala.Serializable)(c1, c2) -> {
                    Tuple2 tuple2 = new Tuple2(c1, c2);
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    ExpectationAggregator aggregator1 = (ExpectationAggregator)tuple2._1();
                    ExpectationAggregator aggregator2 = (ExpectationAggregator)tuple2._2();
                    ExpectationAggregator expectationAggregator = aggregator1.merge(aggregator2);
                    return expectationAggregator;
                };
                int x$7 = instances.treeAggregate$default$4((Object)x$4);
                ExpectationAggregator sums = (ExpectationAggregator)instances.treeAggregate((Object)x$4, (Function2)x$5, (Function2)x$6, x$7, ClassTag$.MODULE$.apply(ExpectationAggregator.class));
                bcWeights.destroy(false);
                bcGaussians.destroy(false);
                if (iter == 0) {
                    long numSamples = sums.count();
                    instr.logNumExamples(numSamples);
                }
                double sumWeights = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(sums.weights())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (shouldDistributeGaussians) {
                    int numPartitions = package$.MODULE$.min(numClusters, 1024);
                    Seq tuples = (Seq)Seq$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$fit$6(sums, BoxesRunTime.unboxToInt((Object)i)));
                    Tuple2 tuple24 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sc.parallelize(tuples, numPartitions, ClassTag$.MODULE$.apply(Tuple3.class)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        Tuple3 tuple3 = x0$4;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        DenseVector mean = (DenseVector)tuple3._1();
                        DenseVector cov = (DenseVector)tuple3._2();
                        double weight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple2 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(mean, cov, weight, sumWeights);
                        return tuple2;
                    }, ClassTag$.MODULE$.apply(Tuple2.class)).collect())).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class));
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    double[] ws = (double[])tuple24._1();
                    Tuple2[] gs = (Tuple2[])tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)ws, (Object)gs);
                    Tuple2 tuple26 = tuple25;
                    double[] ws2 = (double[])tuple26._1();
                    Tuple2[] gs2 = (Tuple2[])tuple26._2();
                    Array$.MODULE$.copy((Object)ws2, 0, (Object)weights2, 0, ws2.length);
                    Array$.MODULE$.copy((Object)gs2, 0, (Object)gaussians2, 0, gs2.length);
                } else {
                    for (int i2 = 0; i2 < numClusters; ++i2) {
                        Tuple2<Object, Tuple2<DenseVector, DenseVector>> tuple27 = GaussianMixture$.MODULE$.updateWeightsAndGaussians(sums.means()[i2], sums.covs()[i2], sums.weights()[i2], sumWeights);
                        if (tuple27 == null) {
                            throw new MatchError(tuple27);
                        }
                        double weight = tuple27._1$mcD$sp();
                        Tuple2 gaussian = (Tuple2)tuple27._2();
                        Tuple2 tuple28 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)weight), (Object)gaussian);
                        Tuple2 tuple29 = tuple28;
                        double weight2 = tuple29._1$mcD$sp();
                        Tuple2 gaussian2 = (Tuple2)tuple29._2();
                        weights2[i2] = weight2;
                        gaussians2[i2] = gaussian2;
                    }
                }
                logLikelihoodPrev = logLikelihood;
                logLikelihood = sums.logLikelihood();
            }
            instances.unpersist(false);
            MultivariateGaussian[] gaussianDists = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians2)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DenseVector mean = (DenseVector)tuple2._1();
                DenseVector covVec = (DenseVector)tuple2._2();
                DenseMatrix cov = GaussianMixture$.MODULE$.unpackUpperTriangularMatrix(numFeatures, covVec.values());
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian((org.apache.spark.ml.linalg.Vector)mean, (Matrix)cov);
                return multivariateGaussian;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = ((Model)this.copyValues(new GaussianMixtureModel(this.uid(), weights2, gaussianDists), this.copyValues$default$2())).setParent(this);
            GaussianMixtureSummary summary = new GaussianMixtureSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.probabilityCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), logLikelihood, iter);
            instr.logNamedValue("logLikelihood", logLikelihood);
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            return model.setSummary((Option<GaussianMixtureSummary>)new Some((Object)summary));
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    private Tuple2<double[], Tuple2<DenseVector, DenseVector>[]> initRandom(RDD<org.apache.spark.ml.linalg.Vector> instances, int numClusters, int numFeatures) {
        org.apache.spark.ml.linalg.Vector[] samples = (org.apache.spark.ml.linalg.Vector[])instances.takeSample(true, numClusters * this.numSamples(), BoxesRunTime.unboxToLong((Object)this.$(this.seed())));
        double[] weights = (double[])Array$.MODULE$.fill(numClusters, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0 / (double)numClusters, ClassTag$.MODULE$.Double());
        Tuple2[] gaussians = (Tuple2[])Array$.MODULE$.tabulate(numClusters, (Function1 & Serializable & scala.Serializable)i -> GaussianMixture.$anonfun$initRandom$2(this, numFeatures, samples, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2((Object)weights, (Object)gaussians);
    }

    public static final /* synthetic */ Tuple3 $anonfun$fit$6(ExpectationAggregator sums$1, int i) {
        return new Tuple3((Object)sums$1.means()[i], (Object)sums$1.covs()[i], (Object)BoxesRunTime.boxToDouble((double)sums$1.weights()[i]));
    }

    public static final /* synthetic */ void $anonfun$initRandom$5(DenseVector covVec$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._1$mcD$sp();
        int i = tuple2._2$mcI$sp();
        double d = v;
        int n = i;
        covVec$1.values()[n + n * (n + 1) / 2] = d;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$initRandom$2(GaussianMixture $this, int numFeatures$2, org.apache.spark.ml.linalg.Vector[] samples$1, int i) {
        IndexedSeqView slice = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])samples$1)).view(i * $this.numSamples(), (i + 1) * $this.numSamples());
        DenseVector v = new DenseVector(new double[numFeatures$2]);
        for (int i2 = 0; i2 < $this.numSamples(); ++i2) {
            BLAS$.MODULE$.axpy(1.0, (org.apache.spark.ml.linalg.Vector)slice.apply(i2), (org.apache.spark.ml.linalg.Vector)v);
        }
        BLAS$.MODULE$.scal(1.0 / (double)$this.numSamples(), (org.apache.spark.ml.linalg.Vector)v);
        DenseVector mean = v;
        Vector ss = new DenseVector(new double[numFeatures$2]).asBreeze();
        slice.foreach((Function1 & Serializable & scala.Serializable)xi -> (Vector)ss.$plus$eq(((ImmutableNumericOps)xi.asBreeze().$minus((Object)mean.asBreeze(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub())).$up$colon$up((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpPow()), (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_Idempotent_UpdateOp_Double_OpAdd()));
        org.apache.spark.ml.linalg.Vector diagVec = Vectors$.MODULE$.fromBreeze(ss);
        BLAS$.MODULE$.scal(1.0 / (double)$this.numSamples(), diagVec);
        DenseVector covVec = new DenseVector((double[])Array$.MODULE$.fill(numFeatures$2 * (numFeatures$2 + 1) / 2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(diagVec.toArray())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            GaussianMixture.$anonfun$initRandom$5(covVec, x0$6);
            return BoxedUnit.UNIT;
        });
        DenseVector cov = covVec;
        return new Tuple2((Object)mean, (Object)cov);
    }

    public GaussianMixture(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100)), this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)0.01))}));
        this.numSamples = 5;
    }

    public GaussianMixture() {
        this(Identifiable$.MODULE$.randomUID("GaussianMixture"));
    }
}

