/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.linalg.DenseVector;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$Data$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015e\u0001B\u0001\u0003\u00015\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\t)Qj\u001c3fYB\u00111\u0003A\u0007\u0002\u0005A\u00111#F\u0005\u0003-\t\u0011QcR1vgNL\u0017M\\'jqR,(/\u001a)be\u0006l7\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\t\u0005!Q\u000f^5m\u0013\ta\u0012D\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016D\u0001B\b\u0001\u0003\u0006\u0004%\teH\u0001\u0004k&$W#\u0001\u0011\u0011\u0005\u0005RcB\u0001\u0012)!\t\u0019c%D\u0001%\u0015\t)C\"\u0001\u0004=e>|GO\u0010\u0006\u0002O\u0005)1oY1mC&\u0011\u0011FJ\u0001\u0007!J,G-\u001a4\n\u0005-b#AB*ue&twM\u0003\u0002*M!\u001aQD\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011AC1o]>$\u0018\r^5p]&\u00111\u0007\r\u0002\u0006'&t7-Z\u0011\u0002k\u0005)!G\f\u0019/a!Aq\u0007\u0001B\u0001B\u0003%\u0001%\u0001\u0003vS\u0012\u0004\u0003f\u0001\u001c/i!A!\b\u0001BC\u0002\u0013\u00051(A\u0004xK&<\u0007\u000e^:\u0016\u0003q\u00022!\u0010 A\u001b\u00051\u0013BA '\u0005\u0015\t%O]1z!\ti\u0014)\u0003\u0002CM\t1Ai\\;cY\u0016D3!\u000f\u00185\u0011!)\u0005A!A!\u0002\u0013a\u0014\u0001C<fS\u001eDGo\u001d\u0011)\u0007\u0011sC\u0007\u0003\u0005I\u0001\t\u0015\r\u0011\"\u0001J\u0003%9\u0017-^:tS\u0006t7/F\u0001K!\ridh\u0013\t\u0003\u0019Fk\u0011!\u0014\u0006\u0003\u001d>\u000bA\u0002Z5tiJL'-\u001e;j_:T!\u0001\u0015\u0003\u0002\tM$\u0018\r^\u0005\u0003%6\u0013A#T;mi&4\u0018M]5bi\u0016<\u0015-^:tS\u0006t\u0007fA$/i!AQ\u000b\u0001B\u0001B\u0003%!*\u0001\u0006hCV\u001c8/[1og\u0002B3\u0001\u0016\u00185\u0011\u0019A\u0006\u0001\"\u0001\u00053\u00061A(\u001b8jiz\"BA\u0005.]=\")ad\u0016a\u0001A!\u001a!L\f\u001b\t\u000bi:\u0006\u0019\u0001\u001f)\u0007qsC\u0007C\u0003I/\u0002\u0007!\nK\u0002_]QBQ!\u0019\u0001\u0005\u0002\t\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0002dI6\t\u0001\u0001C\u0003fA\u0002\u0007\u0001%A\u0003wC2,X\rK\u0002a]\u001d\f\u0013\u0001[\u0001\u0006e9\nd\u0006\r\u0005\u0006U\u0002!\ta[\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"a\u00197\t\u000b\u0015L\u0007\u0019\u0001\u0011)\u0007%ts\rC\u0003p\u0001\u0011\u0005\u0001/A\ttKR\u0004&o\u001c2bE&d\u0017\u000e^=D_2$\"aY9\t\u000b\u0015t\u0007\u0019\u0001\u0011)\u00079ts\rC\u0003u\u0001\u0011\u0005S/\u0001\u0003d_BLHC\u0001\nw\u0011\u001598\u000f1\u0001y\u0003\u0015)\u0007\u0010\u001e:b!\tIH0D\u0001{\u0015\tYH!A\u0003qCJ\fW.\u0003\u0002~u\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002t]QBq!!\u0001\u0001\t\u0003\n\u0019!A\u0005ue\u0006t7OZ8s[R!\u0011QAA\u0014!\u0011\t9!!\t\u000f\t\u0005%\u00111\u0004\b\u0005\u0003\u0017\t9B\u0004\u0003\u0002\u000e\u0005Ua\u0002BA\b\u0003'q1aIA\t\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"C\u0002\u0002\u001a\u0019\t1a]9m\u0013\u0011\ti\"a\b\u0002\u000fA\f7m[1hK*\u0019\u0011\u0011\u0004\u0004\n\t\u0005\r\u0012Q\u0005\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!\b\u0002 !9\u0011\u0011F@A\u0002\u0005-\u0012a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003[\tI\u0004\u0005\u0004\u00020\u0005E\u0012QG\u0007\u0003\u0003?IA!a\r\u0002 \t9A)\u0019;bg\u0016$\b\u0003BA\u001c\u0003sa\u0001\u0001\u0002\u0007\u0002<\u0005\u001d\u0012\u0011!A\u0001\u0006\u0003\tiDA\u0002`IE\nB!a\u0010\u0002FA\u0019Q(!\u0011\n\u0007\u0005\rcEA\u0004O_RD\u0017N\\4\u0011\u0007u\n9%C\u0002\u0002J\u0019\u00121!\u00118zQ\ryh\u0006\u000e\u0005\b\u0003\u001f\u0002A\u0011IA)\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA*\u0003?\u0002B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0005\u00033\ny\"A\u0003usB,7/\u0003\u0003\u0002^\u0005]#AC*ueV\u001cG\u000fV=qK\"A\u0011\u0011MA'\u0001\u0004\t\u0019&\u0001\u0004tG\",W.\u0019\u0015\u0005\u0003\u001brC\u0007\u0003\u0005\u0002h\u0001!\tAAA5\u0003\u001d\u0001(/\u001a3jGR$B!a\u001b\u0002rA\u0019Q(!\u001c\n\u0007\u0005=dEA\u0002J]RD\u0001\"a\u001d\u0002f\u0001\u0007\u0011QO\u0001\tM\u0016\fG/\u001e:fgB!\u0011qOA?\u001b\t\tIHC\u0002\u0002|\u0011\ta\u0001\\5oC2<\u0017\u0002BA@\u0003s\u0012aAV3di>\u0014\b\u0002CAB\u0001\u0011\u0005!!!\"\u0002%A\u0014X\rZ5diB\u0013xNY1cS2LG/\u001f\u000b\u0005\u0003k\n9\t\u0003\u0005\u0002t\u0005\u0005\u0005\u0019AA;\u0011\u001d\tY\t\u0001C\u0001\u0003\u001b\u000b1bZ1vgNL\u0017M\\:E\rV\u0011\u0011Q\u0001\u0015\u0005\u0003\u0013sC\u0007C\u0004\u0002\u0014\u0002!\t%!&\u0002\u000b]\u0014\u0018\u000e^3\u0016\u0005\u0005]\u0005c\u0001\r\u0002\u001a&\u0019\u00111T\r\u0003\u00115cuK]5uKJDC!!%/i!I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111U\u0001\u0010iJ\f\u0017N\\5oON+X.\\1ssV\u0011\u0011Q\u0015\t\u0006{\u0005\u001d\u00161V\u0005\u0004\u0003S3#AB(qi&|g\u000eE\u0002\u0014\u0003[K1!a,\u0003\u0005Y9\u0015-^:tS\u0006tW*\u001b=ukJ,7+^7nCJL\b\"CAZ\u0001\u0001\u0007I\u0011BA[\u0003M!(/Y5oS:<7+^7nCJLx\fJ3r)\u0011\t9,!0\u0011\u0007u\nI,C\u0002\u0002<\u001a\u0012A!\u00168ji\"Q\u0011qXAY\u0003\u0003\u0005\r!!*\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002D\u0002\u0001\u000b\u0015BAS\u0003A!(/Y5oS:<7+^7nCJL\b\u0005\u0003\u0005\u0002H\u0002!\tAAAe\u0003)\u0019X\r^*v[6\f'/\u001f\u000b\u0004G\u0006-\u0007\u0002CAg\u0003\u000b\u0004\r!!*\u0002\u000fM,X.\\1ss\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0017A\u00035bgN+X.\\1ssV\u0011\u0011Q\u001b\t\u0004{\u0005]\u0017bAAmM\t9!i\\8mK\u0006t\u0007\u0006BAh]QBq!!4\u0001\t\u0003\ty.\u0006\u0002\u0002,\"\"\u0011Q\u001c\u00185Q\r\u0001a\u0006N\u0004\b\u0003O\u0014\u0001\u0012AAu\u0003Q9\u0015-^:tS\u0006tW*\u001b=ukJ,Wj\u001c3fYB\u00191#a;\u0007\r\u0005\u0011\u0001\u0012AAw'!\tY/a<\u0002v\u0006m\bcA\u001f\u0002r&\u0019\u00111\u001f\u0014\u0003\r\u0005s\u0017PU3g!\u0011A\u0012q\u001f\n\n\u0007\u0005e\u0018D\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u00042!PA\u007f\u0013\r\tyP\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b1\u0006-H\u0011\u0001B\u0002)\t\tI\u000f\u0003\u0005\u0003\b\u0005-H\u0011\tB\u0005\u0003\u0011\u0011X-\u00193\u0016\u0005\t-\u0001\u0003\u0002\r\u0003\u000eII1Aa\u0004\u001a\u0005!iEJU3bI\u0016\u0014\b\u0006\u0002B\u0003]QB\u0001B!\u0006\u0002l\u0012\u0005#qC\u0001\u0005Y>\fG\rF\u0002\u0013\u00053AqAa\u0007\u0003\u0014\u0001\u0007\u0001%\u0001\u0003qCRD\u0007\u0006\u0002B\n]Q2\u0011B!\t\u0002l\u0002\tYOa\t\u00035\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016lu\u000eZ3m/JLG/\u001a:\u0014\t\t}\u0011q\u0013\u0005\u000b\u0005O\u0011yB!A!\u0002\u0013\u0011\u0012\u0001C5ogR\fgnY3\t\u000fa\u0013y\u0002\"\u0001\u0003,Q!!Q\u0006B\u0019!\u0011\u0011yCa\b\u000e\u0005\u0005-\bb\u0002B\u0014\u0005S\u0001\rA\u0005\u0004\b\u0005k\u0011y\u0002\u0012B\u001c\u0005\u0011!\u0015\r^1\u0014\u0011\tM\u0012q\u001eB\u001d\u0003w\u00042!\u0010B\u001e\u0013\r\u0011iD\n\u0002\b!J|G-^2u\u0011%Q$1\u0007BK\u0002\u0013\u00051\bC\u0005F\u0005g\u0011\t\u0012)A\u0005y!Y!Q\tB\u001a\u0005+\u0007I\u0011\u0001B$\u0003\riWo]\u000b\u0003\u0005\u0013\u0002B!\u0010 \u0003LA!!Q\nB+\u001b\t\u0011yE\u0003\u0003\u0002|\tE#b\u0001B*\r\u0005)Q\u000e\u001c7jE&!\u0011q\u0010B(\u0011-\u0011IFa\r\u0003\u0012\u0003\u0006IA!\u0013\u0002\t5,8\u000f\t\u0005\f\u0005;\u0012\u0019D!f\u0001\n\u0003\u0011y&\u0001\u0004tS\u001el\u0017m]\u000b\u0003\u0005C\u0002B!\u0010 \u0003dA!!Q\nB3\u0013\u0011\u00119Ga\u0014\u0003\r5\u000bGO]5y\u0011-\u0011YGa\r\u0003\u0012\u0003\u0006IA!\u0019\u0002\u000fMLw-\\1tA!9\u0001La\r\u0005\u0002\t=D\u0003\u0003B9\u0005k\u00129H!\u001f\u0011\t\tM$1G\u0007\u0003\u0005?AaA\u000fB7\u0001\u0004a\u0004\u0002\u0003B#\u0005[\u0002\rA!\u0013\t\u0011\tu#Q\u000ea\u0001\u0005CB\u0011\u0002\u001eB\u001a\u0003\u0003%\tA! \u0015\u0011\tE$q\u0010BA\u0005\u0007C\u0001B\u000fB>!\u0003\u0005\r\u0001\u0010\u0005\u000b\u0005\u000b\u0012Y\b%AA\u0002\t%\u0003B\u0003B/\u0005w\u0002\n\u00111\u0001\u0003b!Q!q\u0011B\u001a#\u0003%\tA!#\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0012\u0016\u0004y\t55F\u0001BH!\u0011\u0011\tJ!'\u000e\u0005\tM%\u0002\u0002BK\u0005/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005E2\u0013\u0002\u0002BN\u0005'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0011yJa\r\u0012\u0002\u0013\u0005!\u0011U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019K\u000b\u0003\u0003J\t5\u0005B\u0003BT\u0005g\t\n\u0011\"\u0001\u0003*\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001BVU\u0011\u0011\tG!$\t\u0015\t=&1GA\u0001\n\u0003\u0012\t,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005g\u0003BA!.\u0003@6\u0011!q\u0017\u0006\u0005\u0005s\u0013Y,\u0001\u0003mC:<'B\u0001B_\u0003\u0011Q\u0017M^1\n\u0007-\u00129\f\u0003\u0006\u0003D\nM\u0012\u0011!C\u0001\u0005\u000b\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u001b\t\u0015\t%'1GA\u0001\n\u0003\u0011Y-\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u0015#Q\u001a\u0005\u000b\u0003\u007f\u00139-!AA\u0002\u0005-\u0004B\u0003Bi\u0005g\t\t\u0011\"\u0011\u0003T\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003VB1!q\u001bBo\u0003\u000bj!A!7\u000b\u0007\tmg%\u0001\u0006d_2dWm\u0019;j_:LAAa8\u0003Z\nA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003d\nM\u0012\u0011!C\u0001\u0005K\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003+\u00149\u000f\u0003\u0006\u0002@\n\u0005\u0018\u0011!a\u0001\u0003\u000bB!Ba;\u00034\u0005\u0005I\u0011\tBw\u0003!A\u0017m\u001d5D_\u0012,GCAA6\u0011)\u0011\tPa\r\u0002\u0002\u0013\u0005#1_\u0001\ti>\u001cFO]5oOR\u0011!1\u0017\u0005\u000b\u0005o\u0014\u0019$!A\u0005B\te\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002V\nm\bBCA`\u0005k\f\t\u00111\u0001\u0002F\u001dQ!q B\u0010\u0003\u0003EIa!\u0001\u0002\t\u0011\u000bG/\u0019\t\u0005\u0005g\u001a\u0019A\u0002\u0006\u00036\t}\u0011\u0011!E\u0005\u0007\u000b\u0019baa\u0001\u0004\b\u0005m\bcCB\u0005\u0007\u001fa$\u0011\nB1\u0005cj!aa\u0003\u000b\u0007\r5a%A\u0004sk:$\u0018.\\3\n\t\rE11\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001c\u0004b\u0002-\u0004\u0004\u0011\u00051Q\u0003\u000b\u0003\u0007\u0003A!B!=\u0004\u0004\u0005\u0005IQ\tBz\u0011)\u0019Yba\u0001\u0002\u0002\u0013\u00055QD\u0001\u0006CB\u0004H.\u001f\u000b\t\u0005c\u001ayb!\t\u0004$!1!h!\u0007A\u0002qB\u0001B!\u0012\u0004\u001a\u0001\u0007!\u0011\n\u0005\t\u0005;\u001aI\u00021\u0001\u0003b!Q1qEB\u0002\u0003\u0003%\ti!\u000b\u0002\u000fUt\u0017\r\u001d9msR!11FB\u001a!\u0015i\u0014qUB\u0017!!i4q\u0006\u001f\u0003J\t\u0005\u0014bAB\u0019M\t1A+\u001e9mKNB!b!\u000e\u0004&\u0005\u0005\t\u0019\u0001B9\u0003\rAH\u0005\r\u0005\t\u0007s\u0011y\u0002\"\u0015\u0004<\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u00028\u000eu\u0002b\u0002B\u000e\u0007o\u0001\r\u0001\t\u0004\b\u0007\u0003\nY\u000fBB\"\u0005i9\u0015-^:tS\u0006tW*\u001b=ukJ,Wj\u001c3fYJ+\u0017\rZ3s'\u0011\u0019yDa\u0003\t\u000fa\u001by\u0004\"\u0001\u0004HQ\u00111\u0011\n\t\u0005\u0005_\u0019y\u0004\u0003\u0006\u0004N\r}\"\u0019!C\u0005\u0005c\u000b\u0011b\u00197bgNt\u0015-\\3\t\u0013\rE3q\bQ\u0001\n\tM\u0016AC2mCN\u001ch*Y7fA!A!QCB \t\u0003\u001a)\u0006F\u0002\u0013\u0007/BqAa\u0007\u0004T\u0001\u0007\u0001\u0005C\u0005\u0004\\\u0005-H\u0011\u0001\u0002\u0004^\u0005!2m\\7qkR,\u0007K]8cC\nLG.\u001b;jKN$r\u0001PB0\u0007_\u001a\u0019\b\u0003\u0005\u0002t\re\u0003\u0019AB1!\u0015\u0019\u0019ga\u001bA\u001b\t\u0019)G\u0003\u0003\u0002|\r\u001d$BAB5\u0003\u0019\u0011'/Z3{K&!1QNB3\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\rE4\u0011\fa\u0001\u0015\u0006)A-[:ug\"1!h!\u0017A\u0002qB!ba\u001e\u0002l\u0006\u0005I\u0011BB=\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rm\u0004\u0003\u0002B[\u0007{JAaa \u00038\n1qJ\u00196fGRDC!a;/i!\"\u0011Q\u001d\u00185\u0001")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable {
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private final IntParam k;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static /* bridge */ Object load(String string) {
        return GaussianMixtureModel$.MODULE$.load(string);
    }

    public static GaussianMixtureModel load(String string) {
        return GaussianMixtureModel$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return GaussianMixtureParams.getK$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    public GaussianMixtureModel setFeaturesCol(String value) {
        return (GaussianMixtureModel)this.set(this.featuresCol(), value);
    }

    public GaussianMixtureModel setPredictionCol(String value) {
        return (GaussianMixtureModel)this.set(this.predictionCol(), value);
    }

    public GaussianMixtureModel setProbabilityCol(String value) {
        return (GaussianMixtureModel)this.set(this.probabilityCol(), value);
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = this.copyValues(new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians()), extra);
        return (GaussianMixtureModel)copied.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> BoxesRunTime.boxToInteger((int)this.predict(vector)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(null)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)vector -> this.predictProbability((org.apache.spark.ml.linalg.Vector)vector), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(null)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(null)));
        return dataset.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())}))).withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities((DenseVector<Object>)features.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        Tuple2[] modelGaussians = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.gaussians())).map((Function1 & Serializable & scala.Serializable)gaussian -> new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.mllib.linalg.Matrix").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])modelGaussians), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    private Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GaussianMixtureModel setSummary(Option<GaussianMixtureSummary> summary) {
        this.trainingSummary_$eq(summary);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)this.trainingSummary().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException(new StringBuilder(38).append("No training summary available for the ").append(this.getClass().getSimpleName()).toString());
        });
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasProbabilityCol.$init$(this);
        HasTol.$init$(this);
        GaussianMixtureParams.$init$(this);
        MLWritable.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }

    public static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Matrix[] sigmas;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
            double[] weights = (double[])row.getSeq(0).toArray(ClassTag$.MODULE$.Double());
            Vector[] mus = (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class));
            Predef$.MODULE$.require(mus.length == (sigmas = (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class))).length, (Function0 & Serializable & scala.Serializable)() -> "Length of Mu and Sigma array must match");
            Predef$.MODULE$.require(mus.length == weights.length, (Function0 & Serializable & scala.Serializable)() -> "Length of weight and Gaussian array must match");
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mus)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sigmas), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Vector mu = (Vector)tuple2._1();
                Matrix sigma = (Matrix)tuple2._2();
                MultivariateGaussian multivariateGaussian = new MultivariateGaussian(mu.asML(), sigma.asML());
                return multivariateGaussian;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), weights, gaussians);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private volatile GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data$module;
        private final GaussianMixtureModel instance;

        private GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data() {
            if (this.Data$module == null) {
                this.Data$lzycompute$1();
            }
            return this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)g -> Vectors$.MODULE$.fromML(g.mean()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Matrix[] sigmas = (Matrix[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])gaussians)).map((Function1 & Serializable & scala.Serializable)c -> Matrices$.MODULE$.fromML(c.cov()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Matrix.class)));
            Data data = new Data(this, weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType((Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1(GaussianMixtureModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1(null))).repartition(1).write().parquet(dataPath);
        }

        private final void Data$lzycompute$1() {
            GaussianMixtureModelWriter gaussianMixtureModelWriter = this;
            synchronized (gaussianMixtureModelWriter) {
                if (this.Data$module == null) {
                    this.Data$module = new GaussianMixtureModel$GaussianMixtureModelWriter$Data$(this);
                }
            }
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        scala.Serializable {
            private final double[] weights;
            private final Vector[] mus;
            private final Matrix[] sigmas;
            public final /* synthetic */ GaussianMixtureModelWriter $outer;

            public double[] weights() {
                return this.weights;
            }

            public Vector[] mus() {
                return this.mus;
            }

            public Matrix[] sigmas() {
                return this.sigmas;
            }

            public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
                return new Data(this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer(), weights, mus, sigmas);
            }

            public double[] copy$default$1() {
                return this.weights();
            }

            public Vector[] copy$default$2() {
                return this.mus();
            }

            public Matrix[] copy$default$3() {
                return this.sigmas();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object[] objectArray;
                int n = x$1;
                switch (n) {
                    case 0: {
                        objectArray = this.weights();
                        break;
                    }
                    case 1: {
                        objectArray = this.mus();
                        break;
                    }
                    case 2: {
                        objectArray = this.sigmas();
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return objectArray;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                if (((Data)object).org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() != this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer()) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.weights() != data.weights()) return false;
                if (this.mus() != data.mus()) return false;
                if (this.sigmas() != data.sigmas()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GaussianMixtureModelWriter org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GaussianMixtureModelWriter $outer, double[] weights, Vector[] mus, Matrix[] sigmas) {
                this.weights = weights;
                this.mus = mus;
                this.sigmas = sigmas;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
    }
}

