/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.KMeans$;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.clustering.KMeansParams;
import org.apache.spark.ml.clustering.KMeansSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasDistanceMeasure;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dYI\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\tIQi\u001d;j[\u0006$xN\u001d\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111bS'fC:\u001cXj\u001c3fYB\u00111cF\u0005\u00031\t\u0011AbS'fC:\u001c\b+\u0019:b[N\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003=m\u0011Q\u0003R3gCVdG\u000fU1sC6\u001cxK]5uC\ndW\r\u0003\u0005!\u0001\t\u0015\r\u0011\"\u0011\"\u0003\r)\u0018\u000eZ\u000b\u0002EA\u00111\u0005\f\b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u0007\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-B\u0003fA\u00101mA\u0011\u0011\u0007N\u0007\u0002e)\u00111GB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u001b3\u0005\u0015\u0019\u0016N\\2fC\u00059\u0014!B\u0019/k9\u0002\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\tULG\r\t\u0015\u0004qA2\u0004\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\b\u0006\u0002?\u007fA\u00111\u0003\u0001\u0005\u0006Am\u0002\rA\t\u0015\u0004\u007fA2\u0004fA\u001e1m!)1\t\u0001C!\t\u0006!1m\u001c9z)\tqT\tC\u0003G\u0005\u0002\u0007q)A\u0003fqR\u0014\u0018\r\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\t\u0005)\u0001/\u0019:b[&\u0011A*\u0013\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a!\t\r\u001c\t\u000bq\u0002A\u0011A(\u0015\u0003yB3A\u0014\u00197\u0011\u0015\u0011\u0006\u0001\"\u0001T\u00039\u0019X\r\u001e$fCR,(/Z:D_2$\"\u0001V+\u000e\u0003\u0001AQAV)A\u0002\t\nQA^1mk\u0016D3!\u0015\u00197\u0011\u0015I\u0006\u0001\"\u0001[\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002U7\")a\u000b\u0017a\u0001E!\u001a\u0001\f\r\u001c\t\u000by\u0003A\u0011A0\u0002\tM,Go\u0013\u000b\u0003)\u0002DQAV/A\u0002\u0005\u0004\"AY2\u000e\u0003!J!\u0001\u001a\u0015\u0003\u0007%sG\u000fK\u0002^aYBQa\u001a\u0001\u0005\u0002!\f1b]3u\u0013:LG/T8eKR\u0011A+\u001b\u0005\u0006-\u001a\u0004\rA\t\u0015\u0004MB2\u0004\"\u00027\u0001\t\u0003i\u0017AE:fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016$\"\u0001\u00168\t\u000bY[\u0007\u0019\u0001\u0012)\u0007-\u0004\u0004/I\u0001r\u0003\u0015\u0011d\u0006\u000e\u00181\u0011\u0015\u0019\b\u0001\"\u0001u\u00031\u0019X\r^%oSR\u001cF/\u001a9t)\t!V\u000fC\u0003We\u0002\u0007\u0011\rK\u0002saYBQ\u0001\u001f\u0001\u0005\u0002e\f!b]3u\u001b\u0006D\u0018\n^3s)\t!&\u0010C\u0003Wo\u0002\u0007\u0011\rK\u0002xaYBQ! \u0001\u0005\u0002y\faa]3u)>dGC\u0001+\u0000\u0011\u00191F\u00101\u0001\u0002\u0002A\u0019!-a\u0001\n\u0007\u0005\u0015\u0001F\u0001\u0004E_V\u0014G.\u001a\u0015\u0004yB2\u0004bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\bg\u0016$8+Z3e)\r!\u0016q\u0002\u0005\b-\u0006%\u0001\u0019AA\t!\r\u0011\u00171C\u0005\u0004\u0003+A#\u0001\u0002'p]\u001eDC!!\u00031m!9\u00111\u0004\u0001\u0005B\u0005u\u0011a\u00014jiR\u0019!#a\b\t\u0011\u0005\u0005\u0012\u0011\u0004a\u0001\u0003G\tq\u0001Z1uCN,G\u000f\r\u0003\u0002&\u0005U\u0002CBA\u0014\u0003[\t\t$\u0004\u0002\u0002*)\u0019\u00111\u0006\u0004\u0002\u0007M\fH.\u0003\u0003\u00020\u0005%\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003g\t)\u0004\u0004\u0001\u0005\u0019\u0005]\u0012qDA\u0001\u0002\u0003\u0015\t!!\u000f\u0003\u0007}#3'\u0005\u0003\u0002<\u0005\u0005\u0003c\u00012\u0002>%\u0019\u0011q\b\u0015\u0003\u000f9{G\u000f[5oOB\u0019!-a\u0011\n\u0007\u0005\u0015\u0003FA\u0002B]fDS!!\u00071\u0003\u0013\n#!a\u0013\u0002\u000bIr\u0003G\f\u0019\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R\u0005yAO]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002T\u0005}\u0003\u0003BA+\u00037j!!a\u0016\u000b\t\u0005e\u0013\u0011F\u0001\u0006if\u0004Xm]\u0005\u0005\u0003;\n9F\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"!\u0019\u0002N\u0001\u0007\u00111K\u0001\u0007g\u000eDW-\\1)\t\u00055\u0003G\u000e\u0015\u0004\u0001A2taBA5\u0005!\u0005\u00111N\u0001\u0007\u00176+\u0017M\\:\u0011\u0007M\tiG\u0002\u0004\u0002\u0005!\u0005\u0011qN\n\t\u0003[\n\t(a\u001e\u0002~A\u0019!-a\u001d\n\u0007\u0005U\u0004F\u0001\u0004B]f\u0014VM\u001a\t\u00055\u0005ed(C\u0002\u0002|m\u0011Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002c\u0003\u007fJ1!!!)\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001da\u0014Q\u000eC\u0001\u0003\u000b#\"!a\u001b\t\u0011\u0005%\u0015Q\u000eC!\u0003\u0017\u000bA\u0001\\8bIR\u0019a(!$\t\u000f\u0005=\u0015q\u0011a\u0001E\u0005!\u0001/\u0019;iQ\u0015\t9\tMAJC\t\t)*A\u00032]Yr\u0003\u0007\u0003\u0006\u0002\u001a\u00065\u0014\u0011!C\u0005\u00037\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0016\u0001\u00026bm\u0006LA!a+\u0002\"\n1qJ\u00196fGRDS!!\u001c1\u0003'CS!a\u001a1\u0003'\u0003")
public class KMeans
extends Estimator<KMeansModel>
implements KMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final Param<String> initMode;
    private final IntParam initSteps;
    private final Param<String> distanceMeasure;
    private final DoubleParam tol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static MLReader<KMeans> read() {
        return KMeans$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return KMeans$.MODULE$.load(string);
    }

    public static KMeans load(String string) {
        return KMeans$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return KMeansParams.getK$(this);
    }

    @Override
    public String getInitMode() {
        return KMeansParams.getInitMode$(this);
    }

    @Override
    public int getInitSteps() {
        return KMeansParams.getInitSteps$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return KMeansParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure.getDistanceMeasure$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final Param<String> initMode() {
        return this.initMode;
    }

    @Override
    public final IntParam initSteps() {
        return this.initSteps;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initMode_$eq(Param<String> x$1) {
        this.initMode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$KMeansParams$_setter_$initSteps_$eq(IntParam x$1) {
        this.initSteps = x$1;
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param<String> x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public KMeans copy(ParamMap extra) {
        return (KMeans)this.defaultCopy(extra);
    }

    public KMeans setFeaturesCol(String value) {
        return (KMeans)this.set(this.featuresCol(), value);
    }

    public KMeans setPredictionCol(String value) {
        return (KMeans)this.set(this.predictionCol(), value);
    }

    public KMeans setK(int value) {
        return (KMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setInitMode(String value) {
        return (KMeans)this.set(this.initMode(), value);
    }

    public KMeans setDistanceMeasure(String value) {
        return (KMeans)this.set(this.distanceMeasure(), value);
    }

    public KMeans setInitSteps(int value) {
        return (KMeans)this.set(this.initSteps(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setMaxIter(int value) {
        return (KMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public KMeans setTol(double value) {
        return (KMeans)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public KMeans setSeed(long value) {
        return (KMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public KMeansModel fit(Dataset<?> dataset) {
        return (KMeansModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            this.transformSchema(dataset.schema(), true);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD<Vector> instances = DatasetUtils$.MODULE$.columnToOldVector(dataset, this.getFeaturesCol());
            Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.featuresCol(), this.predictionCol(), this.k(), this.initMode(), this.initSteps(), this.distanceMeasure(), this.maxIter(), this.seed(), this.tol()}));
            org.apache.spark.mllib.clustering.KMeans algo = new org.apache.spark.mllib.clustering.KMeans().setK(BoxesRunTime.unboxToInt((Object)this.$(this.k()))).setInitializationMode(this.$(this.initMode())).setInitializationSteps(BoxesRunTime.unboxToInt((Object)this.$(this.initSteps()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$(this.seed()))).setEpsilon(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setDistanceMeasure(this.$(this.distanceMeasure()));
            org.apache.spark.mllib.clustering.KMeansModel parentModel = algo.run(instances, (Option<Instrumentation>)Option$.MODULE$.apply(instr));
            KMeansModel model = this.copyValues(new KMeansModel(this.uid(), parentModel).setParent(this), this.copyValues$default$2());
            KMeansSummary summary = new KMeansSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$(this.k())), parentModel.numIter(), parentModel.trainingCost());
            model.setSummary((Option<KMeansSummary>)new Some((Object)summary));
            instr.logNamedValue("clusterSizes", summary.clusterSizes());
            Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
            return model;
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public KMeans(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasFeaturesCol.$init$(this);
        HasSeed.$init$(this);
        HasPredictionCol.$init$(this);
        HasTol.$init$(this);
        HasDistanceMeasure.$init$(this);
        KMeansParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.initMode().$minus$greater(org.apache.spark.mllib.clustering.KMeans$.MODULE$.K_MEANS_PARALLEL()), this.initSteps().$minus$greater(BoxesRunTime.boxToInteger((int)2)), this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-4)), this.distanceMeasure().$minus$greater(DistanceMeasure$.MODULE$.EUCLIDEAN())}));
    }

    public KMeans() {
        this(Identifiable$.MODULE$.randomUID("kmeans"));
    }
}

