/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}h!B\u0001\u0003\u0003\u0003i!\u0001\u0003'E\u00036{G-\u001a7\u000b\u0005\r!\u0011AC2mkN$XM]5oO*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002F\f\u001e!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u00131#\u0015\tU1sC6\u001c\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001e\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003*\u0013aA;jIV\ta\u0005\u0005\u0002(a9\u0011\u0001F\f\t\u0003S1j\u0011A\u000b\u0006\u0003W1\ta\u0001\u0010:p_Rt$\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b\u0013A\u0002)sK\u0012,g-\u0003\u00022e\t11\u000b\u001e:j]\u001eT!a\f\u0017)\u0007\r\"$\b\u0005\u00026q5\taG\u0003\u00028\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005e2$!B*j]\u000e,\u0017%A\u001e\u0002\u000bErcG\f\u0019\t\u0011u\u0002!\u0011!Q\u0001\n\u0019\nA!^5eA!\u001aA\b\u000e\u001e\t\u0011\u0001\u0003!Q1A\u0005\u0002\u0005\u000b\u0011B^8dC\n\u001c\u0016N_3\u0016\u0003\t\u0003\"a\u0011#\u000e\u00031J!!\u0012\u0017\u0003\u0007%sG\u000fK\u0002@iiB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006IAQ\u0001\u000bm>\u001c\u0017MY*ju\u0016\u0004\u0003fA$5u!I1\n\u0001BC\u0002\u0013\u0005A\u0001T\u0001\rgB\f'o[*fgNLwN\\\u000b\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\u0011\u0001KB\u0001\u0004gFd\u0017B\u0001*P\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8oQ\rQEG\u000f\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001b\u0006i1\u000f]1sWN+7o]5p]\u0002B#\u0001V,\u0011\u0005\rC\u0016BA--\u0005%!(/\u00198tS\u0016tG\u000fK\u0002UiiBa\u0001\u0018\u0001\u0005\u0002\u0011i\u0016A\u0002\u001fj]&$h\b\u0006\u0003\u0013=\u0002\u0014\u0007\"\u0002\u0013\\\u0001\u00041\u0003f\u000105u!)\u0001i\u0017a\u0001\u0005\"\u001a\u0001\r\u000e\u001e\t\u000b-[\u0006\u0019A')\u0007\t$$\b\u0003\u0004f\u0001\u0019\u0005!AZ\u0001\u000e_2$Gj\\2bY6{G-\u001a7\u0016\u0003\u001d\u0004\"\u0001\u001b7\u000e\u0003%T!a\u00016\u000b\u0005-4\u0011!B7mY&\u0014\u0017BA7j\u00055aunY1m\u0019\u0012\u000bUj\u001c3fY\"\u001aA\r\u000e\u001e\t\rA\u0004a\u0011\u0001\u0002r\u0003!9W\r^'pI\u0016dW#\u0001:\u0011\u0005!\u001c\u0018BA\u0001jQ\ryGG\u000f\u0005\u0007m\u0002!\t\u0001B<\u00029\u001d,G/\u00124gK\u000e$\u0018N^3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]V\t\u0001\u0010E\u0002DsnL!A\u001f\u0017\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\rc\u0018BA?-\u0005\u0019!u.\u001e2mK\"9q\u0010\u0001C\u0001\t\u0005\u0005\u0011AH4fi\u00163g-Z2uSZ,Gk\u001c9jG\u000e{gnY3oiJ\fG/[8o+\u0005Y\bbBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\u0011\tI!a\u0003\u000e\u0003\u0001Aq!!\u0004\u0002\u0004\u0001\u0007a%A\u0003wC2,X\r\u000b\u0003\u0002\u0004QR\u0004bBA\n\u0001\u0011\u0005\u0011QC\u0001\u0018g\u0016$Hk\u001c9jG\u0012K7\u000f\u001e:jEV$\u0018n\u001c8D_2$B!!\u0003\u0002\u0018!9\u0011QBA\t\u0001\u00041\u0003&BA\ti\u0005m\u0011EAA\u000f\u0003\u0015\u0011dF\r\u00181\u0011\u001d\t\t\u0003\u0001C\u0001\u0003G\tqa]3u'\u0016,G\r\u0006\u0003\u0002\n\u0005\u0015\u0002\u0002CA\u0007\u0003?\u0001\r!a\n\u0011\u0007\r\u000bI#C\u0002\u0002,1\u0012A\u0001T8oO\"\"\u0011q\u0004\u001b;\u0011\u001d\t\t\u0004\u0001C!\u0003g\t\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005U\u00121\u000b\t\u0005\u0003o\tiE\u0004\u0003\u0002:\u0005%c\u0002BA\u001e\u0003\u000frA!!\u0010\u0002F9!\u0011qHA\"\u001d\rI\u0013\u0011I\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!\u0001\u0015\u0004\n\u0007\u0005-s*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0013\u0011\u000b\u0002\n\t\u0006$\u0018M\u0012:b[\u0016T1!a\u0013P\u0011!\t)&a\fA\u0002\u0005]\u0013a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u00033\n\u0019\u0007E\u0003O\u00037\ny&C\u0002\u0002^=\u0013q\u0001R1uCN,G\u000f\u0005\u0003\u0002b\u0005\rD\u0002\u0001\u0003\r\u0003K\n\u0019&!A\u0001\u0002\u000b\u0005\u0011q\r\u0002\u0004?\u0012\n\u0014\u0003BA5\u0003_\u00022aQA6\u0013\r\ti\u0007\f\u0002\b\u001d>$\b.\u001b8h!\r\u0019\u0015\u0011O\u0005\u0004\u0003gb#aA!os\"*\u0011q\u0006\u001b\u0002x\u0005\u0012\u0011\u0011P\u0001\u0006e9\u0002d\u0006\r\u0005\b\u0003{\u0002A\u0011IA@\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BAA\u0003\u001b\u0003B!a!\u0002\n6\u0011\u0011Q\u0011\u0006\u0004\u0003\u000f{\u0015!\u0002;za\u0016\u001c\u0018\u0002BAF\u0003\u000b\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011!\ty)a\u001fA\u0002\u0005\u0005\u0015AB:dQ\u0016l\u0017\r\u000b\u0003\u0002|QR\u0004bBAK\u0001\u0011\u0005\u0011qS\u0001\u001aKN$\u0018.\\1uK\u0012$unY\"p]\u000e,g\u000e\u001e:bi&|g.\u0006\u0002\u0002\u001aB!\u00111TAQ\u001b\t\tiJC\u0002\u0002 \u0012\ta\u0001\\5oC2<\u0017\u0002BAR\u0003;\u0013aAV3di>\u0014\b&BAJi\u0005]\u0004bBAU\u0001\u0011\u0005\u00111V\u0001\ri>\u0004\u0018nY:NCR\u0014\u0018\u000e_\u000b\u0003\u0003[\u0003B!a'\u00020&!\u0011\u0011WAO\u0005\u0019i\u0015\r\u001e:jq\"*\u0011q\u0015\u001b\u0002x!9\u0011q\u0017\u0001\u0007\u0002\u0005e\u0016!D5t\t&\u001cHO]5ckR,G-\u0006\u0002\u0002<B\u00191)!0\n\u0007\u0005}FFA\u0004C_>dW-\u00198)\t\u0005UFG\u000f\u0005\b\u0003\u000b\u0004A\u0011AAd\u00035awn\u001a'jW\u0016d\u0017\u000e[8pIR\u001910!3\t\u0011\u0005U\u00131\u0019a\u0001\u0003\u0017\u0004D!!4\u0002RB)a*a\u0017\u0002PB!\u0011\u0011MAi\t1\t\u0019.!3\u0002\u0002\u0003\u0005)\u0011AA4\u0005\ryFE\r\u0015\u0006\u0003\u0007$\u0014q\u000f\u0005\b\u00033\u0004A\u0011AAn\u00035awn\u001a)feBdW\r_5usR\u001910!8\t\u0011\u0005U\u0013q\u001ba\u0001\u0003?\u0004D!!9\u0002fB)a*a\u0017\u0002dB!\u0011\u0011MAs\t1\t9/!8\u0002\u0002\u0003\u0005)\u0011AA4\u0005\ryFe\r\u0015\u0006\u0003/$\u0014q\u000f\u0005\b\u0003[\u0004A\u0011AAx\u00039!Wm]2sS\n,Gk\u001c9jGN$B!!\u000e\u0002r\"9\u00111_Av\u0001\u0004\u0011\u0015\u0001E7bqR+'/\\:QKJ$v\u000e]5dQ\u0011\tY\u000f\u000e\u001e\t\u000f\u00055\b\u0001\"\u0001\u0002zR\u0011\u0011Q\u0007\u0015\u0005\u0003o$$\bK\u0002\u0001ii\u0002")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final BooleanParam keepLastCheckpoint;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getK() {
        return LDAParams.getK$(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams.getDocConcentration$(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams.getOldDocConcentration$(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams.getTopicConcentration$(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams.getOldTopicConcentration$(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams.getOptimizer$(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams.getTopicDistributionCol$(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams.getLearningOffset$(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams.getLearningDecay$(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams.getSubsamplingRate$(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams.getOptimizeDocConcentration$(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams.getKeepLastCheckpoint$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams.getOldOptimizer$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param<String> x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param<String> x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public double[] getEffectiveDocConcentration() {
        return this.getModel().docConcentration().toArray();
    }

    public double getEffectiveTopicConcentration() {
        return this.getModel().topicConcentration();
    }

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setTopicDistributionCol(String value) {
        return (LDAModel)this.set(this.topicDistributionCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            Function1<Vector, Vector> transformer = this.oldLocalModel().getTopicDistributionMethod();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)v -> ((Vector)transformer.apply((Object)Vectors$.MODULE$.fromML((org.apache.spark.ml.linalg.Vector)v))).asML(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(null)));
            dataset2 = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.columnToVector(dataset, this.getFeaturesCol())}))).toDF();
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.");
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            int topic;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$2;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    topic = tuple22._2$mcI$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int[] termIndices = (int[])tuple2._1();
            double[] termWeights = (double[])tuple2._2();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(termIndices)).toSeq(), (Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights)).toSeq());
            return tuple3;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$))));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol.$init$(this);
        HasMaxIter.$init$(this);
        HasSeed.$init$(this);
        HasCheckpointInterval.$init$(this);
        LDAParams.$init$(this);
        MLWritable.$init$(this);
    }
}

