/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.ml.clustering.LDAParams$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001C\u0001\u0003!\u0003\r\tA\u0001\u0007\u0003\u00131#\u0015\tU1sC6\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cr\u0001A\u0007\u00143}\u0011S\u0005\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0011\tQ\u0001]1sC6L!\u0001G\u000b\u0003\rA\u000b'/Y7t!\tQR$D\u0001\u001c\u0015\taR#\u0001\u0004tQ\u0006\u0014X\rZ\u0005\u0003=m\u0011a\u0002S1t\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0005\u0002\u001bA%\u0011\u0011e\u0007\u0002\u000b\u0011\u0006\u001cX*\u0019=Ji\u0016\u0014\bC\u0001\u000e$\u0013\t!3DA\u0004ICN\u001cV-\u001a3\u0011\u0005i1\u0013BA\u0014\u001c\u0005UA\u0015m]\"iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2DQ!\u000b\u0001\u0005\u0002-\na\u0001J5oSR$3\u0001\u0001\u000b\u0002YA\u0011a\"L\u0005\u0003]=\u0011A!\u00168ji\"9\u0001\u0007\u0001b\u0001\n\u000b\t\u0014!A6\u0016\u0003I\u0002\"\u0001F\u001a\n\u0005Q*\"\u0001C%oiB\u000b'/Y7)\u0007=2D\b\u0005\u00028u5\t\u0001H\u0003\u0002:\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005mB$!B*j]\u000e,\u0017%A\u001f\u0002\u000bErcG\f\u0019\t\u000b}\u0002A\u0011\u0001!\u0002\t\u001d,GoS\u000b\u0002\u0003B\u0011aBQ\u0005\u0003\u0007>\u00111!\u00138uQ\rqd\u0007\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0002H\u0003A!wnY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001I!\t!\u0012*\u0003\u0002K+\t\u0001Bi\\;cY\u0016\f%O]1z!\u0006\u0014\u0018-\u001c\u0015\u0004\u000bZb\u0004\"B'\u0001\t\u0003q\u0015aE4fi\u0012{7mQ8oG\u0016tGO]1uS>tW#A(\u0011\u00079\u0001&+\u0003\u0002R\u001f\t)\u0011I\u001d:bsB\u0011abU\u0005\u0003)>\u0011a\u0001R8vE2,\u0007f\u0001'7y!)q\u000b\u0001C\t1\u00061r-\u001a;PY\u0012$unY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001Z!\tQV,D\u0001\\\u0015\taF!\u0001\u0004mS:\fGnZ\u0005\u0003=n\u0013aAV3di>\u0014\bb\u00021\u0001\u0005\u0004%)!Y\u0001\u0013i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g.F\u0001c!\t!2-\u0003\u0002e+\tYAi\\;cY\u0016\u0004\u0016M]1nQ\ryf\u0007\u0010\u0005\u0006O\u0002!\t\u0001[\u0001\u0016O\u0016$Hk\u001c9jG\u000e{gnY3oiJ\fG/[8o+\u0005\u0011\u0006f\u000147y!)1\u000e\u0001C\tQ\u0006Ar-\u001a;PY\u0012$v\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\t\u000f5\u0004!\u0019!C\u0003]\u0006\u00192/\u001e9q_J$X\rZ(qi&l\u0017N_3sgV\tq\u000eE\u0002\u000f!B\u0004\"!\u001d=\u000f\u0005I4\bCA:\u0010\u001b\u0005!(BA;+\u0003\u0019a$o\\8u}%\u0011qoD\u0001\u0007!J,G-\u001a4\n\u0005eT(AB*ue&twM\u0003\u0002x\u001f!\u001aAN\u000e\u001f\t\u000fu\u0004!\u0019!C\u0003}\u0006Iq\u000e\u001d;j[&TXM]\u000b\u0002\u007fB!A#!\u0001q\u0013\r\t\u0019!\u0006\u0002\u0006!\u0006\u0014\u0018-\u001c\u0015\u0004yZb\u0004bBA\u0005\u0001\u0011\u0005\u00111B\u0001\rO\u0016$x\n\u001d;j[&TXM]\u000b\u0002a\"\"\u0011q\u0001\u001c=\u0011!\t\t\u0002\u0001b\u0001\n\u000bq\u0018\u0001\u0006;pa&\u001cG)[:ue&\u0014W\u000f^5p]\u000e{G\u000e\u000b\u0003\u0002\u0010Yb\u0004bBA\f\u0001\u0011\u0005\u00111B\u0001\u0018O\u0016$Hk\u001c9jG\u0012K7\u000f\u001e:jEV$\u0018n\u001c8D_2DC!!\u00067y!A\u0011Q\u0004\u0001C\u0002\u0013\u0015\u0011-\u0001\bmK\u0006\u0014h.\u001b8h\u001f\u001a47/\u001a;)\t\u0005ma\u0007\u0010\u0005\u0007\u0003G\u0001A\u0011\u00015\u0002#\u001d,G\u000fT3be:LgnZ(gMN,G\u000f\u000b\u0003\u0002\"Yb\u0004\u0002CA\u0015\u0001\t\u0007IQA1\u0002\u001b1,\u0017M\u001d8j]\u001e$UmY1zQ\u0011\t9C\u000e\u001f\t\r\u0005=\u0002\u0001\"\u0001i\u0003A9W\r\u001e'fCJt\u0017N\\4EK\u000e\f\u0017\u0010\u000b\u0003\u0002.Yb\u0004\u0002CA\u001b\u0001\t\u0007IQA1\u0002\u001fM,(m]1na2Lgn\u001a*bi\u0016DC!a\r7y!1\u00111\b\u0001\u0005\u0002!\f!cZ3u'V\u00147/Y7qY&twMU1uK\"\"\u0011\u0011\b\u001c=\u0011%\t\t\u0005\u0001b\u0001\n\u000b\t\u0019%\u0001\rpaRLW.\u001b>f\t>\u001c7i\u001c8dK:$(/\u0019;j_:,\"!!\u0012\u0011\u0007Q\t9%C\u0002\u0002JU\u0011ABQ8pY\u0016\fg\u000eU1sC6DC!a\u00107y!9\u0011q\n\u0001\u0005\u0002\u0005E\u0013aG4fi>\u0003H/[7ju\u0016$unY\"p]\u000e,g\u000e\u001e:bi&|g.\u0006\u0002\u0002TA\u0019a\"!\u0016\n\u0007\u0005]sBA\u0004C_>dW-\u00198)\t\u00055c\u0007\u0010\u0005\n\u0003;\u0002!\u0019!C\u0003\u0003\u0007\n!c[3fa2\u000b7\u000f^\"iK\u000e\\\u0007o\\5oi\"*\u00111\f\u001c\u0002b\u0005\u0012\u00111M\u0001\u0006e9\u0002d\u0006\r\u0005\b\u0003O\u0002A\u0011AA)\u0003U9W\r^&fKBd\u0015m\u001d;DQ\u0016\u001c7\u000e]8j]RDS!!\u001a7\u0003CBq!!\u001c\u0001\t#\ty'\u0001\u000ewC2LG-\u0019;f\u0003:$GK]1og\u001a|'/\\*dQ\u0016l\u0017\r\u0006\u0003\u0002r\u0005\u0005\u0005\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0006if\u0004Xm\u001d\u0006\u0004\u0003w2\u0011aA:rY&!\u0011qPA;\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003\u0007\u000bY\u00071\u0001\u0002r\u000511o\u00195f[\u0006D\u0001\"a\"\u0001\t\u0003\u0011\u0011\u0011R\u0001\u0010O\u0016$x\n\u001c3PaRLW.\u001b>feV\u0011\u00111\u0012\t\u0005\u0003\u001b\u000b)*\u0004\u0002\u0002\u0010*\u00191!!%\u000b\u0007\u0005Me!A\u0003nY2L'-\u0003\u0003\u0002\u0018\u0006=%\u0001\u0004'E\u0003>\u0003H/[7ju\u0016\u0014xaBAN\u0005!%\u0011QT\u0001\n\u0019\u0012\u000b\u0005+\u0019:b[N\u0004B!a(\u0002\"6\t!A\u0002\u0004\u0002\u0005!%\u00111U\n\u0006\u0003Ck\u0011Q\u0015\t\u0004\u001d\u0005\u001d\u0016bAAU\u001f\ta1+\u001a:jC2L'0\u00192mK\"A\u0011QVAQ\t\u0003\ty+\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003;C\u0001\"a-\u0002\"\u0012\u0005\u0011QW\u0001\u0010O\u0016$\u0018I\u001c3TKR\u0004\u0016M]1ngR)A&a.\u0002>\"A\u0011\u0011XAY\u0001\u0004\tY,A\u0003n_\u0012,G\u000eE\u0002\u0002 \u0002A\u0001\"a0\u00022\u0002\u0007\u0011\u0011Y\u0001\t[\u0016$\u0018\rZ1uCB!\u00111YAq\u001d\u0011\t)-a7\u000f\t\u0005\u001d\u0017q\u001b\b\u0005\u0003\u0013\f)N\u0004\u0003\u0002L\u0006Mg\u0002BAg\u0003#t1a]Ah\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002\u0006\r%\u0019\u0011\u0011\u001c\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\fy.A\nEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012,'OC\u0002\u0002Z\u0012IA!a9\u0002f\nAQ*\u001a;bI\u0006$\u0018M\u0003\u0003\u0002^\u0006}\u0007BCAu\u0003C\u000b\t\u0011\"\u0003\u0002l\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u000f\u0005\u0003\u0002p\u0006eXBAAy\u0015\u0011\t\u00190!>\u0002\t1\fgn\u001a\u0006\u0003\u0003o\fAA[1wC&!\u00111`Ay\u0005\u0019y%M[3di\u0002")
public interface LDAParams
extends HasFeaturesCol,
HasMaxIter,
HasSeed,
HasCheckpointInterval {
    public static void getAndSetParams(LDAParams lDAParams, DefaultParamsReader.Metadata metadata) {
        LDAParams$.MODULE$.getAndSetParams(lDAParams, metadata);
    }

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param<String> var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param<String> var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam var1);

    public void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam var1);

    public IntParam k();

    public static /* synthetic */ int getK$(LDAParams $this) {
        return $this.getK();
    }

    default public int getK() {
        return BoxesRunTime.unboxToInt((Object)this.$(this.k()));
    }

    public DoubleArrayParam docConcentration();

    public static /* synthetic */ double[] getDocConcentration$(LDAParams $this) {
        return $this.getDocConcentration();
    }

    default public double[] getDocConcentration() {
        return this.$(this.docConcentration());
    }

    public static /* synthetic */ Vector getOldDocConcentration$(LDAParams $this) {
        return $this.getOldDocConcentration();
    }

    default public Vector getOldDocConcentration() {
        return this.isSet(this.docConcentration()) ? Vectors$.MODULE$.dense(this.getDocConcentration()) : Vectors$.MODULE$.dense(-1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
    }

    public DoubleParam topicConcentration();

    public static /* synthetic */ double getTopicConcentration$(LDAParams $this) {
        return $this.getTopicConcentration();
    }

    default public double getTopicConcentration() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.topicConcentration()));
    }

    public static /* synthetic */ double getOldTopicConcentration$(LDAParams $this) {
        return $this.getOldTopicConcentration();
    }

    default public double getOldTopicConcentration() {
        return this.isSet(this.topicConcentration()) ? this.getTopicConcentration() : -1.0;
    }

    public String[] supportedOptimizers();

    public Param<String> optimizer();

    public static /* synthetic */ String getOptimizer$(LDAParams $this) {
        return $this.getOptimizer();
    }

    default public String getOptimizer() {
        return this.$(this.optimizer());
    }

    public Param<String> topicDistributionCol();

    public static /* synthetic */ String getTopicDistributionCol$(LDAParams $this) {
        return $this.getTopicDistributionCol();
    }

    default public String getTopicDistributionCol() {
        return this.$(this.topicDistributionCol());
    }

    public DoubleParam learningOffset();

    public static /* synthetic */ double getLearningOffset$(LDAParams $this) {
        return $this.getLearningOffset();
    }

    default public double getLearningOffset() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.learningOffset()));
    }

    public DoubleParam learningDecay();

    public static /* synthetic */ double getLearningDecay$(LDAParams $this) {
        return $this.getLearningDecay();
    }

    default public double getLearningDecay() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.learningDecay()));
    }

    public DoubleParam subsamplingRate();

    public static /* synthetic */ double getSubsamplingRate$(LDAParams $this) {
        return $this.getSubsamplingRate();
    }

    default public double getSubsamplingRate() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.subsamplingRate()));
    }

    public BooleanParam optimizeDocConcentration();

    public static /* synthetic */ boolean getOptimizeDocConcentration$(LDAParams $this) {
        return $this.getOptimizeDocConcentration();
    }

    default public boolean getOptimizeDocConcentration() {
        return BoxesRunTime.unboxToBoolean((Object)this.$(this.optimizeDocConcentration()));
    }

    public BooleanParam keepLastCheckpoint();

    public static /* synthetic */ boolean getKeepLastCheckpoint$(LDAParams $this) {
        return $this.getKeepLastCheckpoint();
    }

    default public boolean getKeepLastCheckpoint() {
        return BoxesRunTime.unboxToBoolean((Object)this.$(this.keepLastCheckpoint()));
    }

    public static /* synthetic */ StructType validateAndTransformSchema$(LDAParams $this, StructType schema) {
        return $this.validateAndTransformSchema(schema);
    }

    default public StructType validateAndTransformSchema(StructType schema) {
        if (this.isSet(this.docConcentration())) {
            String string;
            if (this.getDocConcentration().length != 1) {
                Predef$.MODULE$.require(this.getDocConcentration().length == this.getK(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("LDA docConcentration was of length").append(new StringBuilder(50).append(" ").append(this.getDocConcentration().length).append(", but k = ").append(this.getK()).append(".  docConcentration must be an array of").toString()).append(" length either 1 (scalar) or k (num topics).").toString());
            }
            if ("online".equals(string = this.getOptimizer().toLowerCase(Locale.ROOT))) {
                Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.getDocConcentration())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$2 -> x$2 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("For Online LDA optimizer, docConcentration values must be >= 0.  Found values: ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.getDocConcentration())).mkString(",")).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("em".equals(string)) {
                Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.getDocConcentration())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$3 -> x$3 >= 0.0), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("For EM optimizer, docConcentration values must be >= 1.  Found values: ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.getDocConcentration())).mkString(",")).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)string);
            }
        }
        if (this.isSet(this.topicConcentration())) {
            String string = this.getOptimizer().toLowerCase(Locale.ROOT);
            if ("online".equals(string)) {
                Predef$.MODULE$.require(this.getTopicConcentration() >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("For Online LDA optimizer, topicConcentration").append(new StringBuilder(29).append(" must be >= 0.  Found value: ").append(this.getTopicConcentration()).toString()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("em".equals(string)) {
                Predef$.MODULE$.require(this.getTopicConcentration() >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("For EM optimizer, topicConcentration").append(new StringBuilder(29).append(" must be >= 1.  Found value: ").append(this.getTopicConcentration()).toString()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)string);
            }
        }
        SchemaUtils$.MODULE$.validateVectorCompatibleColumn(schema, this.getFeaturesCol());
        return SchemaUtils$.MODULE$.appendColumn(schema, this.$(this.topicDistributionCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static /* synthetic */ LDAOptimizer getOldOptimizer$(LDAParams $this) {
        return $this.getOldOptimizer();
    }

    default public LDAOptimizer getOldOptimizer() {
        LDAOptimizer lDAOptimizer;
        String string = this.getOptimizer().toLowerCase(Locale.ROOT);
        if ("online".equals(string)) {
            lDAOptimizer = new OnlineLDAOptimizer().setTau0(BoxesRunTime.unboxToDouble((Object)this.$(this.learningOffset()))).setKappa(BoxesRunTime.unboxToDouble((Object)this.$(this.learningDecay()))).setMiniBatchFraction(BoxesRunTime.unboxToDouble((Object)this.$(this.subsamplingRate()))).setOptimizeDocConcentration(BoxesRunTime.unboxToBoolean((Object)this.$(this.optimizeDocConcentration())));
        } else if ("em".equals(string)) {
            lDAOptimizer = new EMLDAOptimizer().setKeepLastCheckpoint(BoxesRunTime.unboxToBoolean((Object)this.$(this.keepLastCheckpoint())));
        } else {
            throw new MatchError((Object)string);
        }
        return lDAOptimizer;
    }

    public static /* synthetic */ boolean $anonfun$docConcentration$1(double[] alpha) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(alpha)).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0.0);
    }

    public static /* synthetic */ boolean $anonfun$optimizer$1(LDAParams $this, String value) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.supportedOptimizers())).contains((Object)value.toLowerCase(Locale.ROOT));
    }

    public static void $init$(LDAParams $this) {
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(new IntParam((Identifiable)$this, "k", "The number of topics (clusters) to infer. Must be > 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(1.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(new DoubleArrayParam($this, "docConcentration", "Concentration parameter (commonly named \"alpha\") for the prior placed on documents' distributions over topics (\"theta\").", (Function1<double[], Object>)(Function1 & Serializable & scala.Serializable)alpha -> BoxesRunTime.boxToBoolean((boolean)LDAParams.$anonfun$docConcentration$1(alpha))));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(new DoubleParam((Identifiable)$this, "topicConcentration", "Concentration parameter (commonly named \"beta\" or \"eta\") for the prior placed on topic' distributions over terms.", (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq((String[])((Object[])new String[]{"online", "em"}));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(new Param<String>($this, "optimizer", new StringBuilder(76).append("Optimizer or inference algorithm used to estimate the LDA model. Supported: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.supportedOptimizers())).mkString(", ")).toString(), (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)LDAParams.$anonfun$optimizer$1($this, value))));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(new Param<String>($this, "topicDistributionCol", "Output column with estimates of the topic mixture distribution for each document (often called \"theta\" in the literature).  Returns a vector of zeros for an empty document."));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.topicDistributionCol().$minus$greater("topicDistribution")}));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(new DoubleParam((Identifiable)$this, "learningOffset", "(For online optimizer) A (positive) learning parameter that downweights early iterations. Larger values make early iterations count less.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(new DoubleParam((Identifiable)$this, "learningDecay", "(For online optimizer) Learning rate, set as an exponential decay rate. This should be between (0.5, 1.0] to guarantee asymptotic convergence.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(new DoubleParam((Identifiable)$this, "subsamplingRate", "(For online optimizer) Fraction of the corpus to be sampled and used in each iteration of mini-batch gradient descent, in range (0, 1].", (Function1<Object, Object>)ParamValidators$.MODULE$.inRange(0.0, 1.0, false, true)));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(new BooleanParam($this, "optimizeDocConcentration", "(For online optimizer only, currently) Indicates whether the docConcentration (Dirichlet parameter for document-topic distribution) will be optimized during training."));
        $this.org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(new BooleanParam($this, "keepLastCheckpoint", "(For EM optimizer) If using checkpointing, this indicates whether to keep the last checkpoint. If false, then the checkpoint will be deleted. Deleting the checkpoint can cause failures if a data partition is lost, so set this bit with care."));
    }
}

