/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00015\u0011QDQ5oCJL8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"\u001a<bYV\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q!CG\u000f\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!C#wC2,\u0018\r^8s!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003/\u0011\tQ\u0001]1sC6L!!\u0007\u000b\u0003'!\u000b7OU1x!J,G-[2uS>t7i\u001c7\u0011\u0005MY\u0012B\u0001\u000f\u0015\u0005-A\u0015m\u001d'bE\u0016d7i\u001c7\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001B;uS2L!AI\u0010\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\"AA\u0005\u0001BC\u0002\u0013\u0005S%A\u0002vS\u0012,\u0012A\n\t\u0003OAr!\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-b\u0011A\u0002\u001fs_>$hHC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyC&\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018-Q\r\u0019CG\u000f\t\u0003kaj\u0011A\u000e\u0006\u0003o\u0019\t!\"\u00198o_R\fG/[8o\u0013\tIdGA\u0003TS:\u001cW-I\u0001<\u0003\u0015\td\u0006\u000e\u00181\u0011!i\u0004A!A!\u0002\u00131\u0013\u0001B;jI\u0002B3\u0001\u0010\u001b;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u0019a\u0014N\\5u}Q\u0011!i\u0011\t\u0003\u001f\u0001AQ\u0001J A\u0002\u0019B3a\u0011\u001b;Q\ryDG\u000f\u0005\u0006\u0001\u0002!\ta\u0012\u000b\u0002\u0005\"\u001aa\tN%\"\u0003)\u000bQ!\r\u00183]ABq\u0001\u0014\u0001C\u0002\u0013\u0005Q*\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012A\u0014\t\u0004\u001fB3S\"\u0001\f\n\u0005E3\"!\u0002)be\u0006l\u0007fA&5\u0013\"1A\u000b\u0001Q\u0001\n9\u000b1\"\\3ue&\u001cg*Y7fA!\u001a1\u000bN%\t\u000b]\u0003A\u0011A\u0013\u0002\u001b\u001d,G/T3ue&\u001cg*Y7fQ\r1F'\u0013\u0005\u00065\u0002!\taW\u0001\u000eg\u0016$X*\u001a;sS\u000et\u0015-\\3\u0015\u0005qkV\"\u0001\u0001\t\u000byK\u0006\u0019\u0001\u0014\u0002\u000bY\fG.^3)\u0007e#\u0014\nC\u0003b\u0001\u0011\u0005!-A\ntKR\u0014\u0016m\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002]G\")a\f\u0019a\u0001M!\u001a\u0001\rN3\"\u0003\u0019\fQ!\r\u00186]ABQ\u0001\u001b\u0001\u0005\u0002%\f1b]3u\u0019\u0006\u0014W\r\\\"pYR\u0011AL\u001b\u0005\u0006=\u001e\u0004\rA\n\u0015\u0004ORJ\u0005\"B7\u0001\t\u0003r\u0017\u0001C3wC2,\u0018\r^3\u0015\u0005=\u001c\bC\u00019r\u001b\u0005a\u0013B\u0001:-\u0005\u0019!u.\u001e2mK\")A\u000f\u001ca\u0001k\u00069A-\u0019;bg\u0016$\bG\u0001<\u007f!\r9(\u0010`\u0007\u0002q*\u0011\u0011PB\u0001\u0004gFd\u0017BA>y\u0005\u001d!\u0015\r^1tKR\u0004\"! @\r\u0001\u0011Qqp]A\u0001\u0002\u0003\u0015\t!!\u0001\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0004\u0005%\u0001c\u00019\u0002\u0006%\u0019\u0011q\u0001\u0017\u0003\u000f9{G\u000f[5oOB\u0019\u0001/a\u0003\n\u0007\u00055AFA\u0002B]fDC\u0001\u001c\u001b\u0002\u0012\u0005\u0012\u00111C\u0001\u0006e9\u0002d\u0006\r\u0005\b\u0003/\u0001A\u0011IA\r\u00039I7\u000fT1sO\u0016\u0014()\u001a;uKJ,\"!a\u0007\u0011\u0007A\fi\"C\u0002\u0002 1\u0012qAQ8pY\u0016\fg\u000e\u000b\u0003\u0002\u0016Q*\u0007bBA\u0013\u0001\u0011\u0005\u0013qE\u0001\u0005G>\u0004\u0018\u0010F\u0002C\u0003SA\u0001\"a\u000b\u0002$\u0001\u0007\u0011QF\u0001\u0006Kb$(/\u0019\t\u0004\u001f\u0006=\u0012bAA\u0019-\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0003\u0002$Q\n)$\t\u0002\u00028\u0005)\u0011G\f\u001b/c!\u001a\u0001!a\u000f\u0011\u0007U\ni$C\u0002\u0002@Y\u0012A\"\u0012=qKJLW.\u001a8uC2D3\u0001\u0001\u001bJ\u000f\u001d\t)E\u0001E\u0001\u0003\u000f\nQDQ5oCJL8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\t\u0004\u001f\u0005%cAB\u0001\u0003\u0011\u0003\tYe\u0005\u0005\u0002J\u00055\u00131KA-!\r\u0001\u0018qJ\u0005\u0004\u0003#b#AB!osJ+g\r\u0005\u0003\u001f\u0003+\u0012\u0015bAA,?\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007c\u00019\u0002\\%\u0019\u0011Q\f\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0001\u000bI\u0005\"\u0001\u0002bQ\u0011\u0011q\t\u0005\t\u0003K\nI\u0005\"\u0011\u0002h\u0005!An\\1e)\r\u0011\u0015\u0011\u000e\u0005\b\u0003W\n\u0019\u00071\u0001'\u0003\u0011\u0001\u0018\r\u001e5)\u000b\u0005\rD'a\u001c\"\u0005\u0005E\u0014!B\u0019/m9\u0002\u0004BCA;\u0003\u0013\n\t\u0011\"\u0003\u0002x\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qQA?\u0005\u0019y%M[3di\"*\u0011\u0011\n\u001b\u0002p!*\u00111\t\u001b\u0002p\u0001")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    public static MLReader<BinaryClassificationEvaluator> read() {
        return BinaryClassificationEvaluator$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return BinaryClassificationEvaluator$.MODULE$.load(string);
    }

    public static BinaryClassificationEvaluator load(String string) {
        return BinaryClassificationEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setRawPredictionCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.rawPredictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DoubleType$.MODULE$, new VectorUDT()}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        RDD scoreAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            Some some2 = Row$.MODULE$.unapplySeq(row);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                Object rawPrediction = ((SeqLike)some2.get()).apply(0);
                Object label = ((SeqLike)some2.get()).apply(1);
                if (rawPrediction instanceof Vector) {
                    Vector vector = (Vector)rawPrediction;
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        return new Tuple2.mcDD.sp(vector.apply(1), d);
                    }
                }
            }
            if ((some = Row$.MODULE$.unapplySeq(row)).isEmpty()) throw new MatchError((Object)row);
            if (some.get() == null) throw new MatchError((Object)row);
            if (((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError((Object)row);
            Object rawPrediction = ((SeqLike)some.get()).apply(0);
            Object label = ((SeqLike)some.get()).apply(1);
            if (!(rawPrediction instanceof Double)) throw new MatchError((Object)row);
            double d = BoxesRunTime.unboxToDouble((Object)rawPrediction);
            if (!(label instanceof Double)) throw new MatchError((Object)row);
            double d2 = BoxesRunTime.unboxToDouble((Object)label);
            return new Tuple2.mcDD.sp(d, d2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
        String string = this.$(this.metricName());
        if ("areaUnderROC".equals(string)) {
            d = metrics.areaUnderROC();
        } else if ("areaUnderPR".equals(string)) {
            d = metrics.areaUnderPR();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        metrics.unpersist();
        return metric;
    }

    @Override
    public boolean isLargerBetter() {
        boolean bl;
        String string = this.$(this.metricName());
        if ("areaUnderROC".equals(string)) {
            bl = true;
        } else if ("areaUnderPR".equals(string)) {
            bl = true;
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"areaUnderROC", "areaUnderPR"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC")}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

