/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.ClusteringEvaluator$;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\u0001\u0003\u00015\u00111c\u00117vgR,'/\u001b8h\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tq\u0001*Y:GK\u0006$XO]3t\u0007>d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011)H/\u001b7\n\u0005\tz\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C!K\u0005\u0019Q/\u001b3\u0016\u0003\u0019\u0002\"a\n\u0019\u000f\u0005!r\u0003CA\u0015-\u001b\u0005Q#BA\u0016\r\u0003\u0019a$o\\8u})\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyC\u0006K\u0002$ii\u0002\"!\u000e\u001d\u000e\u0003YR!a\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002:m\t)1+\u001b8dK\u0006\n1(A\u00033]Mr\u0003\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003'\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007q\"$\bC\u0003A\u0001\u0011\u0005\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0003\u0005\u000e\u0003\"a\u0004\u0001\t\u000b\u0011z\u0004\u0019\u0001\u0014)\u0007\r#$\bK\u0002@iiBQ\u0001\u0011\u0001\u0005\u0002\u001d#\u0012A\u0011\u0015\u0004\rRR\u0004\"\u0002&\u0001\t\u0003Z\u0015\u0001B2paf$\"A\u0011'\t\u000b5K\u0005\u0019\u0001(\u0002\tAl\u0015\r\u001d\t\u0003\u001fBk\u0011AF\u0005\u0003#Z\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004\u0013RR\u0004\"\u0002+\u0001\t\u0003*\u0016AD5t\u0019\u0006\u0014x-\u001a:CKR$XM]\u000b\u0002-B\u0011q\u000bW\u0007\u0002Y%\u0011\u0011\f\f\u0002\b\u0005>|G.Z1oQ\r\u0019FG\u000f\u0005\u00069\u0002!\t!X\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"AX0\u000e\u0003\u0001AQ\u0001Y.A\u0002\u0019\nQA^1mk\u0016D3a\u0017\u001b;\u0011\u0015\u0019\u0007\u0001\"\u0001e\u00039\u0019X\r\u001e$fCR,(/Z:D_2$\"AX3\t\u000b\u0001\u0014\u0007\u0019\u0001\u0014)\u0007\t$$\bC\u0004i\u0001\t\u0007I\u0011A5\u0002\u00155,GO]5d\u001d\u0006lW-F\u0001k!\ry5NJ\u0005\u0003YZ\u0011Q\u0001U1sC6D3a\u001a\u001b;\u0011\u0019y\u0007\u0001)A\u0005U\u0006YQ.\u001a;sS\u000et\u0015-\\3!Q\rqGG\u000f\u0005\u0006e\u0002!\t!J\u0001\u000eO\u0016$X*\u001a;sS\u000et\u0015-\\3)\u0007E$$\bC\u0003v\u0001\u0011\u0005a/A\u0007tKRlU\r\u001e:jG:\u000bW.\u001a\u000b\u0003=^DQ\u0001\u0019;A\u0002\u0019B3\u0001\u001e\u001b;\u0011\u001dQ\bA1A\u0005\u0002%\fq\u0002Z5ti\u0006t7-Z'fCN,(/\u001a\u0015\u0004sRb\u0018%A?\u0002\u000bIrCG\f\u0019\t\r}\u0004\u0001\u0015!\u0003k\u0003A!\u0017n\u001d;b]\u000e,W*Z1tkJ,\u0007\u0005K\u0002\u007fiqDa!!\u0002\u0001\t\u0003)\u0013AE4fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016DC!a\u00015y\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011AE:fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016$2AXA\b\u0011\u0019\u0001\u0017\u0011\u0002a\u0001M!\"\u0011\u0011\u0002\u001b}\u0011\u001d\t)\u0002\u0001C!\u0003/\t\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u00033\ty\u0002E\u0002X\u00037I1!!\b-\u0005\u0019!u.\u001e2mK\"A\u0011\u0011EA\n\u0001\u0004\t\u0019#A\u0004eCR\f7/\u001a;1\t\u0005\u0015\u0012Q\u0007\t\u0007\u0003O\ti#!\r\u000e\u0005\u0005%\"bAA\u0016\r\u0005\u00191/\u001d7\n\t\u0005=\u0012\u0011\u0006\u0002\b\t\u0006$\u0018m]3u!\u0011\t\u0019$!\u000e\r\u0001\u0011a\u0011qGA\u0010\u0003\u0003\u0005\tQ!\u0001\u0002:\t\u0019q\fJ\u0019\u0012\t\u0005m\u0012\u0011\t\t\u0004/\u0006u\u0012bAA Y\t9aj\u001c;iS:<\u0007cA,\u0002D%\u0019\u0011Q\t\u0017\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0002\u0014QR\u0004f\u0001\u00015u!\u001a\u0001!!\u0014\u0011\u0007U\ny%C\u0002\u0002RY\u0012A\"\u0012=qKJLW.\u001a8uC2<q!!\u0016\u0003\u0011\u0003\t9&A\nDYV\u001cH/\u001a:j]\u001e,e/\u00197vCR|'\u000fE\u0002\u0010\u000332a!\u0001\u0002\t\u0002\u0005m3\u0003CA-\u0003;\n\u0019'!\u001b\u0011\u0007]\u000by&C\u0002\u0002b1\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0010\u0002f\tK1!a\u001a \u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042aVA6\u0013\r\ti\u0007\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0001\u0006eC\u0011AA9)\t\t9\u0006\u0003\u0005\u0002v\u0005eC\u0011IA<\u0003\u0011aw.\u00193\u0015\u0007\t\u000bI\bC\u0004\u0002|\u0005M\u0004\u0019\u0001\u0014\u0002\tA\fG\u000f\u001b\u0015\u0005\u0003g\"$\b\u0003\u0006\u0002\u0002\u0006e\u0013\u0011!C\u0005\u0003\u0007\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006LA!a%\u0002\n\n1qJ\u00196fGRDC!!\u00175u!\"\u00111\u000b\u001b;\u0001")
public class ClusteringEvaluator
extends Evaluator
implements HasPredictionCol,
HasFeaturesCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> distanceMeasure;
    private final Param<String> featuresCol;
    private final Param<String> predictionCol;

    public static MLReader<ClusteringEvaluator> read() {
        return ClusteringEvaluator$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    public static ClusteringEvaluator load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol.getFeaturesCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param<String> x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public ClusteringEvaluator copy(ParamMap pMap) {
        return (ClusteringEvaluator)this.defaultCopy(pMap);
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    public ClusteringEvaluator setPredictionCol(String value) {
        return (ClusteringEvaluator)this.set(this.predictionCol(), value);
    }

    public ClusteringEvaluator setFeaturesCol(String value) {
        return (ClusteringEvaluator)this.set(this.featuresCol(), value);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public ClusteringEvaluator setMetricName(String value) {
        return (ClusteringEvaluator)this.set(this.metricName(), value);
    }

    public Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    public String getDistanceMeasure() {
        return this.$(this.distanceMeasure());
    }

    public ClusteringEvaluator setDistanceMeasure(String value) {
        return (ClusteringEvaluator)this.set(this.distanceMeasure(), value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double evaluate(Dataset<?> dataset) {
        SchemaUtils$.MODULE$.validateVectorCompatibleColumn(dataset.schema(), this.$(this.featuresCol()));
        SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), this.$(this.predictionCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
        Dataset df = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), vectorCol.as(this.$(this.featuresCol()), dataset.schema().apply(this.$(this.featuresCol())).metadata())}));
        Tuple2 tuple2 = new Tuple2((Object)this.$(this.metricName()), (Object)this.$(this.distanceMeasure()));
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string2 = (String)tuple2._2();
            if ("silhouette".equals(string) && "squaredEuclidean".equals(string2)) {
                return SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 != null) {
            String string = (String)tuple2._1();
            String string3 = (String)tuple2._2();
            if ("silhouette".equals(string) && "cosine".equals(string3)) {
                return CosineSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        String mn = (String)tuple2._1();
        String dm = (String)tuple2._2();
        throw new IllegalArgumentException(new StringBuilder(33).append("No support for metric ").append(mn).append(", distance ").append(dm).toString());
    }

    public ClusteringEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasFeaturesCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"silhouette"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (silhouette)", allowedParams);
        String[] availableValues = (String[])((Object[])new String[]{"squaredEuclidean", "cosine"});
        Function1 allowedParams2 = ParamValidators$.MODULE$.inArray(availableValues);
        this.distanceMeasure = new Param(this, "distanceMeasure", new StringBuilder(51).append("distance measure in evaluation. Supported options: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])availableValues)).mkString("'", "', '", "'")).toString(), allowedParams2);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("silhouette"), this.distanceMeasure().$minus$greater("squaredEuclidean")}));
    }

    public ClusteringEvaluator() {
        this(Identifiable$.MODULE$.randomUID("cluEval"));
    }
}

