/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u00055\u00111CU3he\u0016\u001c8/[8o\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tY\u0001*Y:MC\n,GnQ8m!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0003vi&d\u0017B\u0001\u0012 \u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001\u0002\n\u0001\u0003\u0006\u0004%\t%J\u0001\u0004k&$W#\u0001\u0014\u0011\u0005\u001d\u0002dB\u0001\u0015/!\tIC&D\u0001+\u0015\tYC\"\u0001\u0004=e>|GO\u0010\u0006\u0002[\u0005)1oY1mC&\u0011q\u0006L\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020Y!\u001a1\u0005\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]2\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011H\u000e\u0002\u0006'&t7-Z\u0011\u0002w\u0005)\u0011G\f\u001b/a!AQ\b\u0001B\u0001B\u0003%a%\u0001\u0003vS\u0012\u0004\u0003f\u0001\u001f5u!)\u0001\t\u0001C\u0001\u0003\u00061A(\u001b8jiz\"\"AQ\"\u0011\u0005=\u0001\u0001\"\u0002\u0013@\u0001\u00041\u0003fA\"5u!\u001aq\b\u000e\u001e\t\u000b\u0001\u0003A\u0011A$\u0015\u0003\tC3A\u0012\u001b;\u0011\u001dQ\u0005A1A\u0005\u0002-\u000b!\"\\3ue&\u001cg*Y7f+\u0005a\u0005cA'OM5\ta#\u0003\u0002P-\t)\u0001+\u0019:b[\"\u001a\u0011\n\u000e\u001e\t\rI\u0003\u0001\u0015!\u0003M\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011)\u0007E#$\bC\u0003V\u0001\u0011\u0005Q%A\u0007hKRlU\r\u001e:jG:\u000bW.\u001a\u0015\u0004)RR\u0004\"\u0002-\u0001\t\u0003I\u0016!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002[76\t\u0001\u0001C\u0003]/\u0002\u0007a%A\u0003wC2,X\rK\u0002XiiBQa\u0018\u0001\u0005\u0002\u0001\f\u0001c]3u!J,G-[2uS>t7i\u001c7\u0015\u0005i\u000b\u0007\"\u0002/_\u0001\u00041\u0003f\u000105u!)A\r\u0001C\u0001K\u0006Y1/\u001a;MC\n,GnQ8m)\tQf\rC\u0003]G\u0002\u0007a\u0005K\u0002diiBQ!\u001b\u0001\u0005B)\f\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003W>\u0004\"\u0001\\7\u000e\u00031J!A\u001c\u0017\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\b\u000e1\u0001r\u0003\u001d!\u0017\r^1tKR\u0004$A\u001d>\u0011\u0007M4\b0D\u0001u\u0015\t)h!A\u0002tc2L!a\u001e;\u0003\u000f\u0011\u000bG/Y:fiB\u0011\u0011P\u001f\u0007\u0001\t%Yx.!A\u0001\u0002\u000b\u0005APA\u0002`IE\n2!`A\u0001!\tag0\u0003\u0002\u0000Y\t9aj\u001c;iS:<\u0007c\u00017\u0002\u0004%\u0019\u0011Q\u0001\u0017\u0003\u0007\u0005s\u0017\u0010\u000b\u0003ii\u0005%\u0011EAA\u0006\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\ty\u0001\u0001C!\u0003#\ta\"[:MCJ<WM\u001d\"fiR,'/\u0006\u0002\u0002\u0014A\u0019A.!\u0006\n\u0007\u0005]AFA\u0004C_>dW-\u00198)\t\u00055AG\u000f\u0005\b\u0003;\u0001A\u0011IA\u0010\u0003\u0011\u0019w\u000e]=\u0015\u0007\t\u000b\t\u0003\u0003\u0005\u0002$\u0005m\u0001\u0019AA\u0013\u0003\u0015)\u0007\u0010\u001e:b!\ri\u0015qE\u0005\u0004\u0003S1\"\u0001\u0003)be\u0006lW*\u00199)\u000b\u0005mA'!\f\"\u0005\u0005=\u0012!B\u0019/k9\u0002\u0004f\u0001\u0001\u00024A\u0019Q'!\u000e\n\u0007\u0005]bG\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001ii:q!!\u0010\u0003\u0011\u0003\ty$A\nSK\u001e\u0014Xm]:j_:,e/\u00197vCR|'\u000fE\u0002\u0010\u0003\u00032a!\u0001\u0002\t\u0002\u0005\r3\u0003CA!\u0003\u000b\nY%!\u0015\u0011\u00071\f9%C\u0002\u0002J1\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0010\u0002N\tK1!a\u0014 \u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042\u0001\\A*\u0013\r\t)\u0006\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b\u0001\u0006\u0005C\u0011AA-)\t\ty\u0004\u0003\u0005\u0002^\u0005\u0005C\u0011IA0\u0003\u0011aw.\u00193\u0015\u0007\t\u000b\t\u0007C\u0004\u0002d\u0005m\u0003\u0019\u0001\u0014\u0002\tA\fG\u000f\u001b\u0015\u0006\u00037\"\u0014qM\u0011\u0003\u0003S\nQ!\r\u00187]AB!\"!\u001c\u0002B\u0005\u0005I\u0011BA8\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0004\u0003BA:\u0003{j!!!\u001e\u000b\t\u0005]\u0014\u0011P\u0001\u0005Y\u0006twM\u0003\u0002\u0002|\u0005!!.\u0019<b\u0013\u0011\ty(!\u001e\u0003\r=\u0013'.Z2uQ\u0015\t\t\u0005NA4Q\u0015\tY\u0004NA4\u0001")
public final class RegressionEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MLReader<RegressionEvaluator> read() {
        return RegressionEvaluator$.MODULE$.read();
    }

    public static /* bridge */ Object load(String string) {
        return RegressionEvaluator$.MODULE$.load(string);
    }

    public static RegressionEvaluator load(String string) {
        return RegressionEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RegressionEvaluator setMetricName(String value) {
        return (RegressionEvaluator)this.set(this.metricName(), value);
    }

    public RegressionEvaluator setPredictionCol(String value) {
        return (RegressionEvaluator)this.set(this.predictionCol(), value);
    }

    public RegressionEvaluator setLabelCol(String value) {
        return (RegressionEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.predictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FractionalType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        RDD predictionAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double d;
            Object label;
            block3: {
                Row row;
                block2: {
                    row = x0$1;
                    Some some = Row$.MODULE$.unapplySeq(row);
                    if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block2;
                    Object prediction = ((SeqLike)some.get()).apply(0);
                    label = ((SeqLike)some.get()).apply(1);
                    if (!(prediction instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (label instanceof Double) break block3;
                }
                throw new MatchError((Object)row);
            }
            double d2 = BoxesRunTime.unboxToDouble((Object)label);
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics metrics = new RegressionMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
        String string = this.$(this.metricName());
        if ("rmse".equals(string)) {
            d = metrics.rootMeanSquaredError();
        } else if ("mse".equals(string)) {
            d = metrics.meanSquaredError();
        } else if ("r2".equals(string)) {
            d = metrics.r2();
        } else if ("mae".equals(string)) {
            d = metrics.meanAbsoluteError();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        return metric;
    }

    @Override
    public boolean isLargerBetter() {
        boolean bl;
        String string = this.$(this.metricName());
        if ("rmse".equals(string)) {
            bl = false;
        } else if ("mse".equals(string)) {
            bl = false;
        } else if ("r2".equals(string)) {
            bl = true;
        } else if ("mae".equals(string)) {
            bl = false;
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.defaultCopy(extra);
    }

    public RegressionEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"mse", "rmse", "r2", "mae"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (mse|rmse|r2|mae)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("rmse")}));
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regEval"));
    }
}

