/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.SparkException;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t3Q!\u0001\u0002\u0001\t1\u0011aBR3biV\u0014X-\u00128d_\u0012,'O\u0003\u0002\u0004\t\u00059a-Z1ukJ,'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00059!\u0012BA\u000b\u0010\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!9\u0002A!A!\u0002\u0013I\u0012a\u00038v[\u001a+\u0017\r^;sKN\u001c\u0001\u0001E\u0002\u000f5qI!aG\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00059i\u0012B\u0001\u0010\u0010\u0005\rIe\u000e\u001e\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t\"\u0003CA\u0012\u0001\u001b\u0005\u0011\u0001\"B\f \u0001\u0004I\u0002b\u0002\u0014\u0001\u0005\u0004%\taJ\u0001\u000b_V$\b/\u001e;TSj,W#\u0001\u000f\t\r%\u0002\u0001\u0015!\u0003\u001d\u0003-yW\u000f\u001e9viNK'0\u001a\u0011\t\u000f-\u0002!\u0019!C\u0005Y\u0005iq.\u001e;qkR|eMZ:fiN,\u0012!\u0007\u0005\u0007]\u0001\u0001\u000b\u0011B\r\u0002\u001d=,H\u000f];u\u001f\u001a47/\u001a;tA!)\u0001\u0007\u0001C\u0001c\u0005!bm\u001c:fC\u000eDgj\u001c8{KJ|w*\u001e;qkR$2AM\u001b;!\tq1'\u0003\u00025\u001f\t!QK\\5u\u0011\u00151t\u00061\u00018\u0003\u00151\u0018\r\\;f!\tq\u0001(\u0003\u0002:\u001f\t\u0019\u0011I\\=\t\u000bmz\u0003\u0019\u0001\u001f\u0002\u0003\u0019\u0004RAD\u001f\u001d\u007fIJ!AP\b\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004C\u0001\bA\u0013\t\tuB\u0001\u0004E_V\u0014G.\u001a")
public class FeatureEncoder
implements Serializable {
    private final int[] numFeatures;
    private final int outputSize;
    private final int[] outputOffsets;

    public int outputSize() {
        return this.outputSize;
    }

    private int[] outputOffsets() {
        return this.outputOffsets;
    }

    public void foreachNonzeroOutput(Object value, Function2<Object, Object, BoxedUnit> f) {
        Object object = value;
        if (object instanceof Double) {
            BoxedUnit boxedUnit;
            double d = BoxesRunTime.unboxToDouble((Object)object);
            Predef$.MODULE$.assert(this.numFeatures.length == 1, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(41).append(DoubleType$.MODULE$.catalogString()).append(" columns should only contain one feature.").toString());
            int numOutputCols = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.numFeatures)).head());
            if (numOutputCols > 1) {
                Predef$.MODULE$.assert(d >= 0.0 && d == (double)((int)d) && d < (double)numOutputCols, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(d).append(".").toString());
                f.apply$mcVID$sp((int)d, 1.0);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                f.apply$mcVID$sp(0, d);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            Predef$.MODULE$.assert(this.numFeatures.length == vector.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("Vector column size was ").append(vector.size()).append(", expected ").append($this.numFeatures.length).toString());
            vector.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(i, v) -> {
                int numOutputCols = $this.numFeatures[i];
                if (numOutputCols > 1) {
                    Predef$.MODULE$.assert(v >= 0.0 && v == (double)((int)v) && v < (double)numOutputCols, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Values from column must be indices, but got ").append(v).append(".").toString());
                    f.apply$mcVID$sp(this.outputOffsets()[i] + (int)v, 1.0);
                } else {
                    f.apply$mcVID$sp(this.outputOffsets()[i], v);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (object == null) {
                throw new SparkException("Values to interact cannot be null.");
            }
            throw new SparkException(new StringBuilder(27).append(object).append(" of type ").append(object.getClass().getName()).append(" is not supported.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public FeatureEncoder(int[] numFeatures) {
        void var2_2;
        this.numFeatures = numFeatures;
        Predef$.MODULE$.assert(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(numFeatures)).forall((Function1)(JFunction1.mcZI.sp & java.io.Serializable & Serializable)x$1 -> x$1 > 0), (Function0 & java.io.Serializable & Serializable)() -> "Features counts must all be positive.");
        this.outputSize = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(numFeatures)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int[] arr = new int[numFeatures.length];
        for (int i = 1; i < arr.length; ++i) {
            arr[i] = arr[i - 1] + numFeatures[i - 1];
        }
        this.outputOffsets = var2_2;
    }
}

