/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.LSHParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005caB\u0001\u0003\u0003\u0003!AB\u0005\u0002\t\u0019NCUj\u001c3fY*\u00111\u0001B\u0001\bM\u0016\fG/\u001e:f\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014x-\u0006\u0002\u000e)M!\u0001A\u0004\u0011$!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'Qa\u0001\u0001B\u0003\u0016\u0001\t\u0007qCA\u0001U\u0007\u0001\t\"\u0001\u0007\u0010\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000f9{G\u000f[5oOB\u0019q\u0004\u0001\n\u000e\u0003\t\u0001\"aH\u0011\n\u0005\t\u0012!!\u0003'T\u0011B\u000b'/Y7t!\t!s%D\u0001&\u0015\t1C!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003yAQ!\f\u0001\u0005\u00029\n1b]3u\u0013:\u0004X\u000f^\"pYR\u0011q\u0006M\u0007\u0002\u0001!)\u0011\u0007\fa\u0001e\u0005)a/\u00197vKB\u00111G\u000f\b\u0003ia\u0002\"!\u000e\u000e\u000e\u0003YR!a\u000e\f\u0002\rq\u0012xn\u001c;?\u0013\tI$$\u0001\u0004Qe\u0016$WMZ\u0005\u0003wq\u0012aa\u0015;sS:<'BA\u001d\u001b\u0011\u0015q\u0004\u0001\"\u0001@\u00031\u0019X\r^(viB,HoQ8m)\ty\u0003\tC\u00032{\u0001\u0007!\u0007\u0003\u0004C\u0001\u0019EAaQ\u0001\rQ\u0006\u001c\bNR;oGRLwN\u001c\u000b\u0003\t6\u00032!G#H\u0013\t1%DA\u0003BeJ\f\u0017\u0010\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\t\u00051A.\u001b8bY\u001eL!\u0001T%\u0003\rY+7\r^8s\u0011\u0015q\u0015\t1\u0001H\u0003\u0015)G.Z7t\u0011\u0019\u0001\u0006A\"\u0005\u0005#\u0006Y1.Z=ESN$\u0018M\\2f)\r\u0011Vk\u0016\t\u00033MK!\u0001\u0016\u000e\u0003\r\u0011{WO\u00197f\u0011\u00151v\n1\u0001H\u0003\u0005A\b\"\u0002-P\u0001\u00049\u0015!A=\t\ri\u0003a\u0011\u0003\u0003\\\u00031A\u0017m\u001d5ESN$\u0018M\\2f)\r\u0011FL\u001a\u0005\u0006-f\u0003\r!\u0018\t\u0004=\u000e<eBA0b\u001d\t)\u0004-C\u0001\u001c\u0013\t\u0011'$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'aA*fc*\u0011!M\u0007\u0005\u00061f\u0003\r!\u0018\u0005\u0006Q\u0002!\t%[\u0001\niJ\fgn\u001d4pe6$\"A\u001b>\u0011\u0005-<hB\u00017v\u001d\ti7O\u0004\u0002oe:\u0011q.\u001d\b\u0003kAL\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005Q4\u0011aA:rY&\u0011!M\u001e\u0006\u0003i\u001aI!\u0001_=\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u00012w\u0011\u0015Yx\r1\u0001}\u0003\u001d!\u0017\r^1tKR\u00044!`A\u0003!\u0011qx0a\u0001\u000e\u0003YL1!!\u0001w\u0005\u001d!\u0015\r^1tKR\u00042aEA\u0003\t-\t9A_A\u0001\u0002\u0003\u0015\t!!\u0003\u0003\u0007}#\u0013'E\u0002\u0019\u0003\u0017\u00012!GA\u0007\u0013\r\tyA\u0007\u0002\u0004\u0003:L\bbBA\n\u0001\u0011\u0005\u0013QC\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011qCA\u0012!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fm\u0006)A/\u001f9fg&!\u0011\u0011EA\u000e\u0005)\u0019FO];diRK\b/\u001a\u0005\t\u0003K\t\t\u00021\u0001\u0002\u0018\u000511o\u00195f[\u0006D\u0001\"!\u000b\u0001\t\u0003\u0011\u00111F\u0001\u0017CB\u0004(o\u001c=OK\u0006\u0014Xm\u001d;OK&<\u0007NY8sgRa\u0011QFA\u001c\u0003\u0007\n9%!\u0015\u0002\\A\"\u0011qFA\u001a!\u0011qx0!\r\u0011\u0007M\t\u0019\u0004\u0002\u0007\u00026\u0005\u001d\u0012\u0011!A\u0001\u0006\u0003\tIAA\u0002`IMBqa_A\u0014\u0001\u0004\tI\u0004\r\u0003\u0002<\u0005}\u0002\u0003\u0002@\u0000\u0003{\u00012aEA \t1\t\t%a\u000e\u0002\u0002\u0003\u0005)\u0011AA\u0005\u0005\ryFE\r\u0005\b\u0003\u000b\n9\u00031\u0001H\u0003\rYW-\u001f\u0005\t\u0003\u0013\n9\u00031\u0001\u0002L\u0005\u0019b.^7OK\u0006\u0014Xm\u001d;OK&<\u0007NY8sgB\u0019\u0011$!\u0014\n\u0007\u0005=#DA\u0002J]RD\u0001\"a\u0015\u0002(\u0001\u0007\u0011QK\u0001\fg&tw\r\\3Qe>\u0014W\rE\u0002\u001a\u0003/J1!!\u0017\u001b\u0005\u001d\u0011un\u001c7fC:Dq!!\u0018\u0002(\u0001\u0007!'A\u0004eSN$8i\u001c7\t\u000f\u0005%\u0002\u0001\"\u0001\u0002bQQ\u00111MA7\u0003s\nY(! 1\t\u0005\u0015\u0014\u0011\u000e\t\u0005}~\f9\u0007E\u0002\u0014\u0003S\"A\"a\u001b\u0002`\u0005\u0005\t\u0011!B\u0001\u0003\u0013\u00111a\u0018\u00136\u0011\u001dY\u0018q\fa\u0001\u0003_\u0002D!!\u001d\u0002vA!ap`A:!\r\u0019\u0012Q\u000f\u0003\r\u0003o\ni'!A\u0001\u0002\u000b\u0005\u0011\u0011\u0002\u0002\u0004?\u0012\"\u0004bBA#\u0003?\u0002\ra\u0012\u0005\t\u0003\u0013\ny\u00061\u0001\u0002L!9\u0011QLA0\u0001\u0004\u0011\u0004bBA\u0015\u0001\u0011\u0005\u0011\u0011\u0011\u000b\t\u0003\u0007\u000bi)!'\u0002\u001cB\"\u0011QQAE!\u0011qx0a\"\u0011\u0007M\tI\t\u0002\u0007\u0002\f\u0006}\u0014\u0011!A\u0001\u0006\u0003\tIAA\u0002`I]Bqa_A@\u0001\u0004\ty\t\r\u0003\u0002\u0012\u0006U\u0005\u0003\u0002@\u0000\u0003'\u00032aEAK\t1\t9*!$\u0002\u0002\u0003\u0005)\u0011AA\u0005\u0005\ryFE\u000e\u0005\b\u0003\u000b\ny\b1\u0001H\u0011!\tI%a A\u0002\u0005-\u0003\u0002CAP\u0001\u0001&I!!)\u0002\u001dA\u0014xnY3tg\u0012\u000bG/Y:fiRA\u00111UAW\u0003s\u000bi\f\r\u0003\u0002&\u0006%\u0006\u0003\u0002@\u0000\u0003O\u00032aEAU\t1\tY+!(\u0002\u0002\u0003\u0005)\u0011AA\u0005\u0005\ryF%\u000f\u0005\bw\u0006u\u0005\u0019AAXa\u0011\t\t,!.\u0011\ty|\u00181\u0017\t\u0004'\u0005UF\u0001DA\\\u0003[\u000b\t\u0011!A\u0003\u0002\u0005%!aA0%q!9\u00111XAO\u0001\u0004\u0011\u0014!C5oaV$h*Y7f\u0011!\ty,!(A\u0002\u0005\u0005\u0017aC3ya2|G-Z\"pYN\u00042AX23\u0011!\t)\r\u0001Q\u0005\n\u0005\u001d\u0017a\u0003:fGJ,\u0017\r^3D_2$\u0002\"!3\u0002T\u0006}\u00171\u001d\u0019\u0005\u0003\u0017\fy\r\u0005\u0003\u007f\u007f\u00065\u0007cA\n\u0002P\u0012a\u0011\u0011[Ab\u0003\u0003\u0005\tQ!\u0001\u0002\n\t!q\fJ\u00192\u0011\u001dY\u00181\u0019a\u0001\u0003+\u0004D!a6\u0002\\B!ap`Am!\r\u0019\u00121\u001c\u0003\r\u0003;\f\u0019.!A\u0001\u0002\u000b\u0005\u0011\u0011\u0002\u0002\u0005?\u0012\n\u0004\u0007C\u0004\u0002b\u0006\r\u0007\u0019\u0001\u001a\u0002\u000f\r|GNT1nK\"9\u0011Q]Ab\u0001\u0004\u0011\u0014A\u0003;na\u000e{GNT1nK\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\u0018\u0001F1qaJ|\u0007pU5nS2\f'/\u001b;z\u0015>Lg\u000e\u0006\u0006\u0002n\u0006](Q\u0001B\n\u0005/\u0001D!a<\u0002tB!ap`Ay!\r\u0019\u00121\u001f\u0003\r\u0003k\f9/!A\u0001\u0002\u000b\u0005\u0011\u0011\u0002\u0002\u0005?\u0012\nD\u0007\u0003\u0005\u0002z\u0006\u001d\b\u0019AA~\u0003!!\u0017\r^1tKR\f\u0005\u0007BA\u007f\u0005\u0003\u0001BA`@\u0002\u0000B\u00191C!\u0001\u0005\u0019\t\r\u0011q_A\u0001\u0002\u0003\u0015\t!!\u0003\u0003\t}#\u0013G\r\u0005\t\u0005\u000f\t9\u000f1\u0001\u0003\n\u0005AA-\u0019;bg\u0016$(\t\r\u0003\u0003\f\t=\u0001\u0003\u0002@\u0000\u0005\u001b\u00012a\u0005B\b\t1\u0011\tB!\u0002\u0002\u0002\u0003\u0005)\u0011AA\u0005\u0005\u0011yF%M\u001a\t\u000f\tU\u0011q\u001da\u0001%\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\u0005\b\u0003;\n9\u000f1\u00013\u0011\u001d\tI\u000f\u0001C\u0001\u00057!\u0002B!\b\u0003(\tM\"q\b\u0019\u0005\u0005?\u0011\u0019\u0003\u0005\u0003\u007f\u007f\n\u0005\u0002cA\n\u0003$\u0011a!Q\u0005B\r\u0003\u0003\u0005\tQ!\u0001\u0002\n\t!q\fJ\u00198\u0011!\tIP!\u0007A\u0002\t%\u0002\u0007\u0002B\u0016\u0005_\u0001BA`@\u0003.A\u00191Ca\f\u0005\u0019\tE\"qEA\u0001\u0002\u0003\u0015\t!!\u0003\u0003\t}#\u0013'\u000e\u0005\t\u0005\u000f\u0011I\u00021\u0001\u00036A\"!q\u0007B\u001e!\u0011qxP!\u000f\u0011\u0007M\u0011Y\u0004\u0002\u0007\u0003>\tM\u0012\u0011!A\u0001\u0006\u0003\tIA\u0001\u0003`IE2\u0004b\u0002B\u000b\u00053\u0001\rA\u0015")
public abstract class LSHModel<T extends LSHModel<T>>
extends Model<T>
implements LSHParams,
MLWritable {
    private final IntParam numHashTables;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final int getNumHashTables() {
        return LSHParams.getNumHashTables$(this);
    }

    @Override
    public final StructType validateAndTransformSchema(StructType schema) {
        return LSHParams.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam numHashTables() {
        return this.numHashTables;
    }

    @Override
    public final void org$apache$spark$ml$feature$LSHParams$_setter_$numHashTables_$eq(IntParam x$1) {
        this.numHashTables = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    public T setInputCol(String value) {
        return (T)((LSHModel)this.set(this.inputCol(), value));
    }

    public T setOutputCol(String value) {
        return (T)((LSHModel)this.set(this.outputCol(), value));
    }

    public abstract Vector[] hashFunction(Vector var1);

    public abstract double keyDistance(Vector var1, Vector var2);

    public abstract double hashDistance(Seq<Vector> var1, Seq<Vector> var2);

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        UserDefinedFunction transformUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x$1 -> this.hashFunction((Vector)x$1), (DataType)DataTypes.createArrayType((DataType)new VectorUDT()));
        return dataset.withColumn(this.$(this.outputCol()), transformUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dataset.apply(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, boolean singleProbe, String distCol) {
        Dataset dataset2;
        Dataset<Row> modelDataset;
        Predef$.MODULE$.require(numNearestNeighbors > 0, (Function0 & Serializable & scala.Serializable)() -> "The number of nearest neighbors cannot be less than 1");
        Vector[] keyHash = this.hashFunction(key);
        Dataset<Row> dataset3 = modelDataset = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).contains((Object)this.$(this.outputCol())) ? this.transform(dataset) : dataset.toDF();
        if (singleProbe) {
            UserDefinedFunction sameBucketWithKeyUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LSHModel.sameBucket$1(x, (Seq)Predef$.MODULE$.wrapRefArray((Object[])keyHash))), DataTypes.BooleanType);
            dataset2 = modelDataset.filter(sameBucketWithKeyUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))})));
        } else {
            UserDefinedFunction hashDistUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)this.hashDistance((Seq<Vector>)x, (Seq<Vector>)Predef$.MODULE$.wrapRefArray((Object[])keyHash))), DataTypes.DoubleType);
            Column hashDistCol = hashDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.outputCol()))}));
            Dataset modelDatasetSortedByHash = modelDataset.sort((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{hashDistCol})).limit(numNearestNeighbors);
            Dataset thresholdDataset = modelDatasetSortedByHash.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(hashDistCol)}));
            double hashThreshold = ((Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])thresholdDataset.take(1))).head()).getDouble(0);
            dataset2 = modelDataset.filter(hashDistCol.$less$eq((Object)BoxesRunTime.boxToDouble((double)hashThreshold)));
        }
        Dataset modelSubset = dataset2;
        UserDefinedFunction keyDistUDF = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToDouble((double)this.keyDistance(x, key)), DataTypes.DoubleType);
        Dataset modelSubsetWithDistCol = modelSubset.withColumn(distCol, keyDistUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
        return modelSubsetWithDistCol.sort(distCol, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).limit(numNearestNeighbors);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors, String distCol) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, distCol);
    }

    public Dataset<?> approxNearestNeighbors(Dataset<?> dataset, Vector key, int numNearestNeighbors) {
        return this.approxNearestNeighbors(dataset, key, numNearestNeighbors, true, "distCol");
    }

    private Dataset<?> processDataset(Dataset<?> dataset, String inputName, Seq<String> explodeCols) {
        Predef$.MODULE$.require(explodeCols.size() == 2, (Function0 & Serializable & scala.Serializable)() -> "explodeCols must be two strings.");
        Dataset<Row> modelDataset = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.columns())).contains((Object)this.$(this.outputCol())) ? this.transform(dataset) : dataset.toDF();
        return modelDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*")})).as(inputName), functions$.MODULE$.posexplode(functions$.MODULE$.col(this.$(this.outputCol()))).as(explodeCols)}));
    }

    private Dataset<?> recreateCol(Dataset<?> dataset, String colName, String tmpColName) {
        return dataset.withColumnRenamed(colName, tmpColName).withColumn(colName, functions$.MODULE$.col(tmpColName)).drop(tmpColName);
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold, String distCol) {
        Dataset<?> dataset;
        String leftColName = "datasetA";
        String rightColName = "datasetB";
        Seq explodeCols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entry", "hashValue"}));
        Dataset<?> explodedA = this.processDataset(datasetA, leftColName, (Seq<String>)explodeCols);
        Dataset<?> dataset2 = datasetA;
        Dataset<?> dataset3 = datasetB;
        if (dataset2 == null ? dataset3 != null : !dataset2.equals(dataset3)) {
            dataset = this.processDataset(datasetB, rightColName, (Seq<String>)explodeCols);
        } else {
            Dataset<?> recreatedB = this.recreateCol(datasetB, this.$(this.inputCol()), new StringBuilder(1).append((Object)this.$(this.inputCol())).append("#").append(Random$.MODULE$.nextString(5)).toString());
            dataset = this.processDataset(recreatedB, rightColName, (Seq<String>)explodeCols);
        }
        Dataset<?> explodedB = dataset;
        Dataset joinedDataset = explodedA.join(explodedB, explodeCols).drop(explodeCols).distinct();
        UserDefinedFunction distUDF = functions$.MODULE$.udf((Function2 & Serializable & scala.Serializable)(x, y) -> BoxesRunTime.boxToDouble((double)this.keyDistance(x, y)), DataTypes.DoubleType);
        Dataset joinedDatasetWithDist = joinedDataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), distUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(1).append(leftColName).append(".").append((Object)this.$(this.inputCol())).toString()), functions$.MODULE$.col(new StringBuilder(1).append(rightColName).append(".").append((Object)this.$(this.inputCol())).toString())})).as(distCol)}));
        return joinedDatasetWithDist.filter(functions$.MODULE$.col(distCol).$less((Object)BoxesRunTime.boxToDouble((double)threshold)));
    }

    public Dataset<?> approxSimilarityJoin(Dataset<?> datasetA, Dataset<?> datasetB, double threshold) {
        return this.approxSimilarityJoin(datasetA, datasetB, threshold, "distCol");
    }

    public static final /* synthetic */ boolean $anonfun$approxNearestNeighbors$2(Tuple2 tuple) {
        return BoxesRunTime.equals((Object)tuple._1(), (Object)tuple._2());
    }

    private static final boolean sameBucket$1(Seq x, Seq y) {
        return ((IterableLike)x.zip((GenIterable)y, Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)tuple -> BoxesRunTime.boxToBoolean((boolean)LSHModel.$anonfun$approxNearestNeighbors$2(tuple)));
    }

    public LSHModel() {
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        LSHParams.$init$(this);
        MLWritable.$init$(this);
    }
}

