/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.feature.Word2VecBase;
import org.apache.spark.ml.feature.Word2VecModel$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelReader$;
import org.apache.spark.ml.feature.Word2VecModel$Word2VecModelWriter$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.VersionUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r5c\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u0019]{'\u000f\u001a\u001aWK\u000e\u0014\u0015m]3\u0011\u0005aYR\"A\r\u000b\u0005i!\u0011\u0001B;uS2L!\u0001H\r\u0003\u00155cuK]5uC\ndW\r\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0011 \u0003\r)\u0018\u000eZ\u000b\u0002AA\u0011\u0011E\u000b\b\u0003E!\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0007\u0002\rq\u0012xn\u001c;?\u0015\u00059\u0013!B:dC2\f\u0017BA\u0015'\u0003\u0019\u0001&/\u001a3fM&\u00111\u0006\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%2\u0003fA\u000f/iA\u0011qFM\u0007\u0002a)\u0011\u0011GB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u001a1\u0005\u0015\u0019\u0016N\\2fC\u0005)\u0014!B\u0019/i9\u0002\u0004\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002\tULG\r\t\u0015\u0004m9\"\u0004\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011B\u001e\u0002\u0017]|'\u000f\u001a,fGR|'o]\u000b\u0002yA\u0011Q(Q\u0007\u0002})\u00111a\u0010\u0006\u0003\u0001\u001a\tQ!\u001c7mS\nL!!\u0001 \t\u0011\r\u0003!\u0011!Q\u0001\nq\nAb^8sIZ+7\r^8sg\u0002B#AQ#\u0011\u0005\u0019;U\"\u0001\u0014\n\u0005!3#!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0019Q\u0005\u0001\"\u0001\u0005\u0017\u00061A(\u001b8jiz\"2A\u0005'O\u0011\u0015q\u0012\n1\u0001!Q\rae\u0006\u000e\u0005\u0006u%\u0003\r\u0001\u0010\u0005\t!\u0002A)\u0019!C\u0001#\u0006Qq-\u001a;WK\u000e$xN]:\u0016\u0003I\u0003\"a\u00151\u000f\u0005QkfBA+\\\u001d\t1&L\u0004\u0002X3:\u00111\u0005W\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!\u0001\u0018\u0004\u0002\u0007M\fH.\u0003\u0002_?\u00069\u0001/Y2lC\u001e,'B\u0001/\u0007\u0013\t\t'MA\u0005ECR\fgI]1nK*\u0011al\u0018\u0015\u0003\u001f\u0016C3a\u0014\u0018fC\u00051\u0017!B\u0019/k9\u0002\u0004\"\u00025\u0001\t\u0003I\u0017\u0001\u00044j]\u0012\u001c\u0016P\\8os6\u001cHc\u0001*kY\")1n\u001aa\u0001A\u0005!qo\u001c:e\u0011\u0015iw\r1\u0001o\u0003\rqW/\u001c\t\u0003\r>L!\u0001\u001d\u0014\u0003\u0007%sG\u000fK\u0002h]\u0015DQ\u0001\u001b\u0001\u0005\u0002M$2A\u0015;}\u0011\u0015)(\u000f1\u0001w\u0003\r1Xm\u0019\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0012\ta\u0001\\5oC2<\u0017BA>y\u0005\u00191Vm\u0019;pe\")QN\u001da\u0001]\"\u001a!O\f@\"\u0003}\fQA\r\u00181]ABq!a\u0001\u0001\t\u0003\t)!A\tgS:$7+\u001f8p]fl7/\u0011:sCf$b!a\u0002\u0002\u001a\u0005m\u0001#\u0002$\u0002\n\u00055\u0011bAA\u0006M\t)\u0011I\u001d:bsB1a)a\u0004!\u0003'I1!!\u0005'\u0005\u0019!V\u000f\u001d7feA\u0019a)!\u0006\n\u0007\u0005]aE\u0001\u0004E_V\u0014G.\u001a\u0005\u0007k\u0006\u0005\u0001\u0019\u0001<\t\r5\f\t\u00011\u0001oQ\u0015\t\tALA\u0010C\t\t\t#A\u00033]Ir\u0003\u0007C\u0004\u0002\u0004\u0001!\t!!\n\u0015\r\u0005\u001d\u0011qEA\u0015\u0011\u0019Y\u00171\u0005a\u0001A!1Q.a\tA\u00029DS!a\t/\u0003?Aq!a\f\u0001\t\u0003\t\t$A\u0006tKRLe\u000e];u\u0007>dG\u0003BA\u001a\u0003ki\u0011\u0001\u0001\u0005\b\u0003o\ti\u00031\u0001!\u0003\u00151\u0018\r\\;fQ\u0011\tiC\f\u001b\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@\u0005a1/\u001a;PkR\u0004X\u000f^\"pYR!\u00111GA!\u0011\u001d\t9$a\u000fA\u0002\u0001BC!a\u000f/i!9\u0011q\t\u0001\u0005B\u0005%\u0013!\u0003;sC:\u001chm\u001c:n)\r\u0011\u00161\n\u0005\t\u0003\u001b\n)\u00051\u0001\u0002P\u00059A-\u0019;bg\u0016$\b\u0007BA)\u0003;\u0002b!a\u0015\u0002V\u0005eS\"A0\n\u0007\u0005]sLA\u0004ECR\f7/\u001a;\u0011\t\u0005m\u0013Q\f\u0007\u0001\t1\ty&a\u0013\u0002\u0002\u0003\u0005)\u0011AA1\u0005\ryFEM\t\u0005\u0003G\nI\u0007E\u0002G\u0003KJ1!a\u001a'\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ARA6\u0013\r\tiG\n\u0002\u0004\u0003:L\b\u0006BA#]yDq!a\u001d\u0001\t\u0003\n)(A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t9(a!\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wR1!! `\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\t)a\u001f\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0005\u0002\u0006\u0006E\u0004\u0019AA<\u0003\u0019\u00198\r[3nC\"\"\u0011\u0011\u000f\u00185\u0011\u001d\tY\t\u0001C!\u0003\u001b\u000bAaY8qsR\u0019!#a$\t\u0011\u0005E\u0015\u0011\u0012a\u0001\u0003'\u000bQ!\u001a=ue\u0006\u0004B!!&\u0002\u001c6\u0011\u0011q\u0013\u0006\u0004\u00033#\u0011!\u00029be\u0006l\u0017\u0002BAO\u0003/\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0006\u0003\u0013s\u0013\u0011U\u0011\u0003\u0003G\u000bQ!\r\u00185]EBq!a*\u0001\t\u0003\nI+A\u0003xe&$X-\u0006\u0002\u0002,B\u0019\u0001$!,\n\u0007\u0005=\u0016D\u0001\u0005N\u0019^\u0013\u0018\u000e^3sQ\u0015\t)KLAZC\t\t),A\u00032]Yr\u0003\u0007K\u0002\u0001]Q:q!a/\u0003\u0011\u0003\ti,A\u0007X_J$'GV3d\u001b>$W\r\u001c\t\u0004'\u0005}fAB\u0001\u0003\u0011\u0003\t\tm\u0005\u0005\u0002@\u0006\r\u0017\u0011ZAh!\r1\u0015QY\u0005\u0004\u0003\u000f4#AB!osJ+g\r\u0005\u0003\u0019\u0003\u0017\u0014\u0012bAAg3\tQQ\n\u0014*fC\u0012\f'\r\\3\u0011\u0007\u0019\u000b\t.C\u0002\u0002T\u001a\u0012AbU3sS\u0006d\u0017N_1cY\u0016DqASA`\t\u0003\t9\u000e\u0006\u0002\u0002>\u001a9\u00111\\A`\t\u0006u'\u0001\u0002#bi\u0006\u001c\u0002\"!7\u0002D\u0006}\u0017q\u001a\t\u0004\r\u0006\u0005\u0018bAArM\t9\u0001K]8ek\u000e$\b\"C6\u0002Z\nU\r\u0011\"\u0001 \u0011)\tI/!7\u0003\u0012\u0003\u0006I\u0001I\u0001\u0006o>\u0014H\r\t\u0005\f\u0003[\fIN!f\u0001\n\u0003\ty/\u0001\u0004wK\u000e$xN]\u000b\u0003\u0003c\u0004RARA\u0005\u0003g\u00042ARA{\u0013\r\t9P\n\u0002\u0006\r2|\u0017\r\u001e\u0005\f\u0003w\fIN!E!\u0002\u0013\t\t0A\u0004wK\u000e$xN\u001d\u0011\t\u000f)\u000bI\u000e\"\u0001\u0002\u0000R1!\u0011\u0001B\u0003\u0005\u000f\u0001BAa\u0001\u0002Z6\u0011\u0011q\u0018\u0005\u0007W\u0006u\b\u0019\u0001\u0011\t\u0011\u00055\u0018Q a\u0001\u0003cD!\"a#\u0002Z\u0006\u0005I\u0011\u0001B\u0006)\u0019\u0011\tA!\u0004\u0003\u0010!A1N!\u0003\u0011\u0002\u0003\u0007\u0001\u0005\u0003\u0006\u0002n\n%\u0001\u0013!a\u0001\u0003cD!Ba\u0005\u0002ZF\u0005I\u0011\u0001B\u000b\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\u0006+\u0007\u0001\u0012Ib\u000b\u0002\u0003\u001cA!!Q\u0004B\u0013\u001b\t\u0011yB\u0003\u0003\u0003\"\t\r\u0012!C;oG\",7m[3e\u0015\t\td%\u0003\u0003\u0003(\t}!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!1FAm#\u0003%\tA!\f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0006\u0016\u0005\u0003c\u0014I\u0002\u0003\u0006\u00034\u0005e\u0017\u0011!C!\u0005k\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\u001c!\u0011\u0011IDa\u0011\u000e\u0005\tm\"\u0002\u0002B\u001f\u0005\u007f\tA\u0001\\1oO*\u0011!\u0011I\u0001\u0005U\u00064\u0018-C\u0002,\u0005wA!Ba\u0012\u0002Z\u0006\u0005I\u0011\u0001B%\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005q\u0007B\u0003B'\u00033\f\t\u0011\"\u0001\u0003P\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA5\u0005#B\u0011Ba\u0015\u0003L\u0005\u0005\t\u0019\u00018\u0002\u0007a$\u0013\u0007\u0003\u0006\u0003X\u0005e\u0017\u0011!C!\u00053\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u00057\u0002bA!\u0018\u0003d\u0005%TB\u0001B0\u0015\r\u0011\tGJ\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B3\u0005?\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0005S\nI.!A\u0005\u0002\t-\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t5$1\u000f\t\u0004\r\n=\u0014b\u0001B9M\t9!i\\8mK\u0006t\u0007B\u0003B*\u0005O\n\t\u00111\u0001\u0002j!Q!qOAm\u0003\u0003%\tE!\u001f\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012A\u001c\u0005\u000b\u0005{\nI.!A\u0005B\t}\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t]\u0002B\u0003BB\u00033\f\t\u0011\"\u0011\u0003\u0006\u00061Q-];bYN$BA!\u001c\u0003\b\"Q!1\u000bBA\u0003\u0003\u0005\r!!\u001b\b\u0015\t-\u0015qXA\u0001\u0012\u0013\u0011i)\u0001\u0003ECR\f\u0007\u0003\u0002B\u0002\u0005\u001f3!\"a7\u0002@\u0006\u0005\t\u0012\u0002BI'\u0019\u0011yIa%\u0002PBI!Q\u0013BNA\u0005E(\u0011A\u0007\u0003\u0005/S1A!''\u0003\u001d\u0011XO\u001c;j[\u0016LAA!(\u0003\u0018\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f)\u0013y\t\"\u0001\u0003\"R\u0011!Q\u0012\u0005\u000b\u0005{\u0012y)!A\u0005F\t}\u0004B\u0003BT\u0005\u001f\u000b\t\u0011\"!\u0003*\u0006)\u0011\r\u001d9msR1!\u0011\u0001BV\u0005[Caa\u001bBS\u0001\u0004\u0001\u0003\u0002CAw\u0005K\u0003\r!!=\t\u0015\tE&qRA\u0001\n\u0003\u0013\u0019,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tU&Q\u0018\t\u0006\r\n]&1X\u0005\u0004\u0005s3#AB(qi&|g\u000e\u0005\u0004G\u0003\u001f\u0001\u0013\u0011\u001f\u0005\u000b\u0005\u007f\u0013y+!AA\u0002\t\u0005\u0011a\u0001=%a!Q!1\u0019BH\u0003\u0003%IA!2\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u000f\u0004BA!\u000f\u0003J&!!1\u001aB\u001e\u0005\u0019y%M[3di\u001aI!qZA`\u0001\u0005}&\u0011\u001b\u0002\u0014/>\u0014HM\r,fG6{G-\u001a7Xe&$XM]\n\u0005\u0005\u001b\fY\u000b\u0003\u0006\u0003V\n5'\u0011!Q\u0001\nI\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\b\u0015\n5G\u0011\u0001Bm)\u0011\u0011YN!8\u0011\t\t\r!Q\u001a\u0005\b\u0005+\u00149\u000e1\u0001\u0013\u0011!\u0011\tO!4\u0005R\t\r\u0018\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\t\u0015(1\u001e\t\u0004\r\n\u001d\u0018b\u0001BuM\t!QK\\5u\u0011\u001d\u0011iOa8A\u0002\u0001\nA\u0001]1uQ\u001eI!\u0011_A`\u0011\u0003\u0011!1_\u0001\u0014/>\u0014HM\r,fG6{G-\u001a7Xe&$XM\u001d\t\u0005\u0005\u0007\u0011)PB\u0005\u0003P\u0006}\u0006\u0012\u0001\u0002\u0003xN!!Q_Ab\u0011\u001dQ%Q\u001fC\u0001\u0005w$\"Aa=\t\u0011\t}(Q\u001fC\u0001\u0007\u0003\t1dY1mGVd\u0017\r^3Ok6\u0014WM](g!\u0006\u0014H/\u001b;j_:\u001cHc\u00028\u0004\u0004\r51\u0011\u0003\u0005\t\u0007\u000b\u0011i\u00101\u0001\u0004\b\u0005\t\"-\u001e4gKJ\u001c\u0016N_3J]\nKH/Z:\u0011\u0007\u0019\u001bI!C\u0002\u0004\f\u0019\u0012A\u0001T8oO\"91q\u0002B\u007f\u0001\u0004q\u0017\u0001\u00038v[^{'\u000fZ:\t\u000f\rM!Q a\u0001]\u0006Qa/Z2u_J\u001c\u0016N_3\u0007\u000f\r]\u0011q\u0018\u0003\u0004\u001a\t\u0019rk\u001c:eeY+7-T8eK2\u0014V-\u00193feN!1QCB\u000e!\u0011A2Q\u0004\n\n\u0007\r}\u0011D\u0001\u0005N\u0019J+\u0017\rZ3s\u0011\u001dQ5Q\u0003C\u0001\u0007G!\"a!\n\u0011\t\t\r1Q\u0003\u0005\u000b\u0007S\u0019)B1A\u0005\n\tU\u0012!C2mCN\u001ch*Y7f\u0011%\u0019ic!\u0006!\u0002\u0013\u00119$\u0001\u0006dY\u0006\u001c8OT1nK\u0002B\u0001b!\r\u0004\u0016\u0011\u000531G\u0001\u0005Y>\fG\rF\u0002\u0013\u0007kAqA!<\u00040\u0001\u0007\u0001\u0005\u0003\u0005\u0004:\u0005}F\u0011IB\u001e\u0003\u0011\u0011X-\u00193\u0016\u0005\rm\u0001&BB\u001c]\u0005M\u0006\u0002CB\u0019\u0003\u007f#\te!\u0011\u0015\u0007I\u0019\u0019\u0005C\u0004\u0003n\u000e}\u0002\u0019\u0001\u0011)\u000b\r}b&a-\t\u0015\t\r\u0017qXA\u0001\n\u0013\u0011)\rK\u0003\u0002@:\n\u0019\fK\u0003\u0002::\n\u0019\f")
public class Word2VecModel
extends Model<Word2VecModel>
implements Word2VecBase,
MLWritable {
    private transient Dataset<Row> getVectors;
    private final String uid;
    private final transient org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    private final IntParam vectorSize;
    private final IntParam windowSize;
    private final IntParam numPartitions;
    private final IntParam minCount;
    private final IntParam maxSentenceLength;
    private final LongParam seed;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final Param<String> outputCol;
    private final Param<String> inputCol;
    private volatile transient boolean bitmap$trans$0;

    public static /* bridge */ Object load(String string) {
        return Word2VecModel$.MODULE$.load(string);
    }

    public static Word2VecModel load(String string) {
        return Word2VecModel$.MODULE$.load(string);
    }

    public static MLReader<Word2VecModel> read() {
        return Word2VecModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public int getVectorSize() {
        return Word2VecBase.getVectorSize$(this);
    }

    @Override
    public int getWindowSize() {
        return Word2VecBase.getWindowSize$(this);
    }

    @Override
    public int getNumPartitions() {
        return Word2VecBase.getNumPartitions$(this);
    }

    @Override
    public int getMinCount() {
        return Word2VecBase.getMinCount$(this);
    }

    @Override
    public int getMaxSentenceLength() {
        return Word2VecBase.getMaxSentenceLength$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return Word2VecBase.validateAndTransformSchema$(this, schema);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$(this);
    }

    @Override
    public final String getInputCol() {
        return HasInputCol.getInputCol$(this);
    }

    @Override
    public final IntParam vectorSize() {
        return this.vectorSize;
    }

    @Override
    public final IntParam windowSize() {
        return this.windowSize;
    }

    @Override
    public final IntParam numPartitions() {
        return this.numPartitions;
    }

    @Override
    public final IntParam minCount() {
        return this.minCount;
    }

    @Override
    public final IntParam maxSentenceLength() {
        return this.maxSentenceLength;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$vectorSize_$eq(IntParam x$1) {
        this.vectorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$windowSize_$eq(IntParam x$1) {
        this.windowSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$numPartitions_$eq(IntParam x$1) {
        this.numPartitions = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$minCount_$eq(IntParam x$1) {
        this.minCount = x$1;
    }

    @Override
    public final void org$apache$spark$ml$feature$Word2VecBase$_setter_$maxSentenceLength_$eq(IntParam x$1) {
        this.maxSentenceLength = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public org.apache.spark.mllib.feature.Word2VecModel org$apache$spark$ml$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors;
    }

    private Dataset<Row> getVectors$lzycompute() {
        Word2VecModel word2VecModel = this;
        synchronized (word2VecModel) {
            if (!this.bitmap$trans$0) {
                SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
                Map wordVec = this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vec -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$2 -> x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))));
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(Word2VecModel $outer) {
                    }
                }
                this.getVectors = spark.createDataFrame(wordVec.toSeq(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator1$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "vector"}));
                this.bitmap$trans$0 = true;
            }
        }
        return this.getVectors;
    }

    public Dataset<Row> getVectors() {
        return !this.bitmap$trans$0 ? this.getVectors$lzycompute() : this.getVectors;
    }

    public Dataset<Row> findSynonyms(String word, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(word, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator2$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Dataset<Row> findSynonyms(Vector vec, int num) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$m.staticClass("scala.Double").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator3$1(Word2VecModel $outer) {
            }
        }
        return spark.createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.findSynonymsArray(vec, num)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator3$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"word", "similarity"}));
    }

    public Tuple2<String, Object>[] findSynonymsArray(Vector vec, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(VectorImplicits$.MODULE$.mlVectorToMLlibVector(vec), num);
    }

    public Tuple2<String, Object>[] findSynonymsArray(String word, int num) {
        return this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().findSynonyms(word, num);
    }

    public Word2VecModel setInputCol(String value) {
        return (Word2VecModel)this.set(this.inputCol(), value);
    }

    public Word2VecModel setOutputCol(String value) {
        return (Word2VecModel)this.set(this.outputCol(), value);
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("scala")), (Symbols.SymbolApi)$m.staticModule("scala.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.package").asModule().moduleClass(), "Seq"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$));
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1(Word2VecModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1(Word2VecModel $outer) {
            }
        }
        this.transformSchema(dataset.schema(), true);
        Map vectors = (Map)this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors().mapValues((Function1 & Serializable & scala.Serializable)vv -> Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vv)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$3 -> x$3, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
        Broadcast bVectors = dataset.sparkSession().sparkContext().broadcast((Object)vectors, ClassTag$.MODULE$.apply(Map.class));
        int d = BoxesRunTime.unboxToInt((Object)this.$(this.vectorSize()));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModel.class.getClassLoader());
        UserDefinedFunction word2Vec = functions$.MODULE$.udf((Function1 & Serializable & scala.Serializable)sentence -> {
            Vector vector;
            if (sentence.isEmpty()) {
                vector = Vectors$.MODULE$.sparse(d, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            } else {
                void var3_3;
                Vector sum = Vectors$.MODULE$.zeros(d);
                sentence.foreach((Function1 & Serializable & scala.Serializable)word -> {
                    Word2VecModel.$anonfun$transform$5(bVectors, sum, word);
                    return BoxedUnit.UNIT;
                });
                BLAS$.MODULE$.scal(1.0 / (double)sentence.size(), sum);
                vector = var3_3;
            }
            return vector;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator4$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$$typecreator5$1(null)));
        return dataset.withColumn(this.$(this.outputCol()), word2Vec.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    @Override
    public Word2VecModel copy(ParamMap extra) {
        Word2VecModel copied = new Word2VecModel(this.uid(), this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors());
        return (Word2VecModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new Word2VecModelWriter(this);
    }

    public static final /* synthetic */ void $anonfun$transform$5(Broadcast bVectors$1, Vector sum$1, String word) {
        ((MapLike)bVectors$1.value()).get((Object)word).foreach((Function1 & Serializable & scala.Serializable)v -> {
            BLAS$.MODULE$.axpy(1.0, v, sum$1);
            return BoxedUnit.UNIT;
        });
    }

    public Word2VecModel(String uid, org.apache.spark.mllib.feature.Word2VecModel wordVectors) {
        this.uid = uid;
        this.org$apache$spark$ml$feature$Word2VecModel$$wordVectors = wordVectors;
        HasInputCol.$init$(this);
        HasOutputCol.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasSeed.$init$(this);
        Word2VecBase.$init$(this);
        MLWritable.$init$(this);
    }

    public static class Data
    implements Product,
    scala.Serializable {
        private final String word;
        private final float[] vector;

        public String word() {
            return this.word;
        }

        public float[] vector() {
            return this.vector;
        }

        public Data copy(String word, float[] vector) {
            return new Data(word, vector);
        }

        public String copy$default$1() {
            return this.word();
        }

        public float[] copy$default$2() {
            return this.vector();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.word();
                    break;
                }
                case 1: {
                    object = this.vector();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            String string = this.word();
            String string2 = data.word();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.vector() != data.vector()) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(String word, float[] vector) {
            this.word = word;
            this.vector = vector;
            Product.$init$((Product)this);
        }
    }

    public static class Word2VecModelReader
    extends MLReader<Word2VecModel> {
        private final String className = Word2VecModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public Word2VecModel load(String path) {
            org.apache.spark.mllib.feature.Word2VecModel word2VecModel;
            SparkSession spark = this.sparkSession();
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            Tuple2 tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int major = tuple2._1$mcI$sp();
            int minor = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(major, minor);
            Tuple2.mcII.sp sp3 = sp2;
            int major2 = sp3._1$mcI$sp();
            int minor2 = sp3._2$mcI$sp();
            String dataPath = new Path(path, "data").toString();
            if (major2 < 2 || major2 == 2 && minor2 < 2) {
                Row data = (Row)spark.read().parquet(dataPath).select("wordIndex", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"wordVectors"})).head();
                Map wordIndex = (Map)data.getAs(0);
                float[] wordVectors = (float[])((TraversableOnce)data.getAs(1)).toArray(ClassTag$.MODULE$.Float());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, Object>)wordIndex, wordVectors);
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelReader.class.getClassLoader());
                public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator17$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator17$1(Word2VecModelReader $outer) {
                    }
                }
                Map wordVectorsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spark.read().parquet(dataPath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelReader$$typecreator17$1(null)))).collect())).map((Function1 & Serializable & scala.Serializable)wordVector -> new Tuple2((Object)wordVector.word(), (Object)wordVector.vector()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                word2VecModel = new org.apache.spark.mllib.feature.Word2VecModel((Map<String, float[]>)wordVectorsMap);
            }
            org.apache.spark.mllib.feature.Word2VecModel oldModel = word2VecModel;
            Word2VecModel model = new Word2VecModel(metadata.uid(), oldModel);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class Word2VecModelWriter
    extends MLWriter {
        private final Word2VecModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.feature.Word2VecModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1(Word2VecModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Map<String, float[]> wordVectors = this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().getVectors();
            String dataPath = new Path(path, "data").toString();
            long bufferSizeInBytes = Utils$.MODULE$.byteStringAsBytes(this.sc().conf().get("spark.kryoserializer.buffer.max", "64m"));
            int numPartitions = Word2VecModel$Word2VecModelWriter$.MODULE$.calculateNumberOfPartitions(bufferSizeInBytes, this.instance.org$apache$spark$ml$feature$Word2VecModel$$wordVectors().wordIndex().size(), this.instance.getVectorSize());
            SparkSession spark = this.sparkSession();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(Word2VecModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator9$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Array"), (List)new .colon.colon((Object)$m.staticClass("scala.Float").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator9$1(Word2VecModelWriter $outer) {
                }
            }
            spark.createDataset(wordVectors.toSeq(), spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator9$1(null)))).repartition(numPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String word = (String)tuple2._1();
                float[] vector = (float[])tuple2._2();
                Data data = new Data(word, vector);
                return data;
            }, spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_feature_Word2VecModel$Word2VecModelWriter$$typecreator10$1(null)))).toDF().write().parquet(dataPath);
        }

        public Word2VecModelWriter(Word2VecModel instance) {
            this.instance = instance;
        }
    }
}

