/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.input.PortableDataStream;
import org.apache.spark.ml.image.RecursiveFlag$;
import org.apache.spark.ml.image.SamplePathFilter$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Experimental
public final class ImageSchema$ {
    public static ImageSchema$ MODULE$;
    private final String undefinedImageType;
    private final scala.collection.immutable.Map<String, Object> ocvTypes;
    private final Map<String, Object> javaOcvTypes;
    private final StructType columnSchema;
    private final String[] imageFields;
    private final StructType imageSchema;

    static {
        new ImageSchema$();
    }

    public String undefinedImageType() {
        return this.undefinedImageType;
    }

    public scala.collection.immutable.Map<String, Object> ocvTypes() {
        return this.ocvTypes;
    }

    public Map<String, Object> javaOcvTypes() {
        return this.javaOcvTypes;
    }

    public StructType columnSchema() {
        return this.columnSchema;
    }

    public String[] imageFields() {
        return this.imageFields;
    }

    public StructType imageSchema() {
        return this.imageSchema;
    }

    public String getOrigin(Row row) {
        return row.getString(0);
    }

    public int getHeight(Row row) {
        return row.getInt(1);
    }

    public int getWidth(Row row) {
        return row.getInt(2);
    }

    public int getNChannels(Row row) {
        return row.getInt(3);
    }

    public int getMode(Row row) {
        return row.getInt(4);
    }

    public byte[] getData(Row row) {
        return (byte[])row.getAs(5);
    }

    public Row invalidImageRow(String origin) {
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), BoxesRunTime.boxToInteger((int)-1), this.ocvTypes().apply((Object)this.undefinedImageType()), Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte())}))}));
    }

    public Option<Row> decode(String origin, byte[] bytes) {
        None$ none$;
        BufferedImage img = ImageIO.read(new ByteArrayInputStream(bytes));
        if (img == null) {
            none$ = None$.MODULE$;
        } else {
            Tuple2.mcII.sp sp2;
            boolean isGray = img.getColorModel().getColorSpace().getType() == 6;
            boolean hasAlpha = img.getColorModel().hasAlpha();
            int height = img.getHeight();
            int width = img.getWidth();
            Tuple2.mcII.sp sp3 = isGray ? new Tuple2.mcII.sp(1, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC1"))) : (sp2 = hasAlpha ? new Tuple2.mcII.sp(4, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC4"))) : new Tuple2.mcII.sp(3, BoxesRunTime.unboxToInt((Object)this.ocvTypes().apply((Object)"CV_8UC3"))));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int nChannels = sp2._1$mcI$sp();
            int mode = sp2._2$mcI$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(nChannels, mode);
            Tuple2.mcII.sp sp5 = sp4;
            int nChannels2 = sp5._1$mcI$sp();
            int mode2 = sp5._2$mcI$sp();
            int imageSize = height * width * nChannels2;
            Predef$.MODULE$.assert((double)imageSize < 1.0E9, (Function0 & Serializable & scala.Serializable)() -> "image is too large");
            byte[] decoded = (byte[])Array$.MODULE$.ofDim(imageSize, ClassTag$.MODULE$.Byte());
            if (isGray) {
                IntRef offset = IntRef.create((int)0);
                WritableRaster raster = img.getRaster();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)h -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)w -> {
                    decoded$1[offset$1.elem] = (byte)raster.getSample(w, h, 0);
                    ++offset$1.elem;
                }));
            } else {
                IntRef offset = IntRef.create((int)0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), height).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)h -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), width).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)w -> {
                    Color color = new Color(img.getRGB(w, h), hasAlpha);
                    decoded$1[offset$2.elem] = (byte)color.getBlue();
                    decoded$1[offset$2.elem + 1] = (byte)color.getGreen();
                    decoded$1[offset$2.elem + 2] = (byte)color.getRed();
                    if (hasAlpha) {
                        decoded$1[offset$2.elem + 3] = (byte)color.getAlpha();
                    }
                    offset$2.elem += nChannels2;
                }));
            }
            none$ = new Some((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{origin, BoxesRunTime.boxToInteger((int)height), BoxesRunTime.boxToInteger((int)width), BoxesRunTime.boxToInteger((int)nChannels2), BoxesRunTime.boxToInteger((int)mode2), decoded}))})));
        }
        return none$;
    }

    public Dataset<Row> readImages(String path) {
        return this.readImages(path, null, false, -1, false, 1.0, 0L);
    }

    public Dataset<Row> readImages(String path, SparkSession sparkSession, boolean recursive, int numPartitions, boolean dropImageFailures, double sampleRatio, long seed) {
        Predef$.MODULE$.require(sampleRatio <= 1.0 && sampleRatio >= 0.0, (Function0 & Serializable & scala.Serializable)() -> "sampleRatio should be between 0 and 1");
        SparkSession session = sparkSession != null ? sparkSession : SparkSession$.MODULE$.builder().getOrCreate();
        int partitions = numPartitions > 0 ? numPartitions : session.sparkContext().defaultParallelism();
        return (Dataset)RecursiveFlag$.MODULE$.withRecursiveFlag(recursive, session, (Function0 & Serializable & scala.Serializable)() -> (Dataset)SamplePathFilter$.MODULE$.withPathFilter(sampleRatio, session, seed, (Function0 & Serializable & scala.Serializable)() -> {
            RDD rDD;
            RDD binResult = session.sparkContext().binaryFiles(path, partitions);
            if (numPartitions == -1) {
                rDD = binResult;
            } else {
                int x$9 = partitions;
                Ordering x$10 = binResult.repartition$default$2(x$9);
                rDD = binResult.repartition(x$9, x$10);
            }
            RDD streams = rDD;
            Function2 & Serializable & scala.Serializable convert = (Function2 & Serializable & scala.Serializable)(origin, bytes) -> MODULE$.decode((String)origin, bytes.toArray());
            RDD images = dropImageFailures ? streams.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String origin = (String)tuple2._1();
                PortableDataStream bytes = (PortableDataStream)tuple2._2();
                Iterable iterable = Option$.MODULE$.option2Iterable((Option)convert.apply((Object)origin, (Object)bytes));
                return iterable;
            }, ClassTag$.MODULE$.apply(Row.class)) : streams.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String origin = (String)tuple2._1();
                PortableDataStream bytes = (PortableDataStream)tuple2._2();
                Row row = (Row)((Option)convert.apply((Object)origin, (Object)bytes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.invalidImageRow(origin));
                return row;
            }, ClassTag$.MODULE$.apply(Row.class));
            return session.createDataFrame(images, MODULE$.imageSchema());
        }));
    }

    private ImageSchema$() {
        MODULE$ = this;
        this.undefinedImageType = "Undefined";
        this.ocvTypes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.undefinedImageType()), (Object)BoxesRunTime.boxToInteger((int)-1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8U"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC1"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC3"), (Object)BoxesRunTime.boxToInteger((int)16)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CV_8UC4"), (Object)BoxesRunTime.boxToInteger((int)24))}));
        this.javaOcvTypes = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.ocvTypes()).asJava();
        StructField structField = new StructField("origin", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("height", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField3 = new StructField("width", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("nChannels", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("mode", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField6 = new StructField("data", (DataType)BinaryType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        this.columnSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField6).$colon$colon((Object)structField5).$colon$colon((Object)structField4).$colon$colon((Object)structField3).$colon$colon((Object)structField2).$colon$colon((Object)structField));
        this.imageFields = this.columnSchema().fieldNames();
        StructField structField7 = new StructField("image", (DataType)this.columnSchema(), true, StructField$.MODULE$.apply$default$4());
        this.imageSchema = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField7));
    }
}

