/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0001\r1\u0011\u0011\"T1ue&DX\u000b\u0012+\u000b\u0005\r!\u0011A\u00027j]\u0006dwM\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dM)R\"A\b\u000b\u0005A\t\u0012!\u0002;za\u0016\u001c(B\u0001\n\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003)=\u0011q\"V:fe\u0012+g-\u001b8fIRK\b/\u001a\t\u0003-]i\u0011AA\u0005\u00031\t\u0011a!T1ue&D\b\"\u0002\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003u\u0001\"A\u0006\u0001\t\u000b}\u0001A\u0011\t\u0011\u0002\u000fM\fH\u000eV=qKV\t\u0011\u0005\u0005\u0002\u000fE%\u00111e\u0004\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\u0013\u0001\t\u00032\u0013!C:fe&\fG.\u001b>f)\t9S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+#\u0005A1-\u0019;bYf\u001cH/\u0003\u0002-S\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015qC\u00051\u0001\u0016\u0003\ry'M\u001b\u0005\u0006a\u0001!\t%M\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0002\u0016e!)1g\fa\u0001i\u0005)A-\u0019;v[B\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t\u0019\u0011I\\=\t\u000bm\u0002A\u0011\t\u001f\u0002\u0013U\u001cXM]\"mCN\u001cX#A\u001f\u0011\u0007y*UC\u0004\u0002@\u0007B\u0011\u0001IN\u0007\u0002\u0003*\u0011!iG\u0001\u0007yI|w\u000e\u001e \n\u0005\u00113\u0014A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n)1\t\\1tg*\u0011AI\u000e\u0005\u0006\u0013\u0002!\tES\u0001\u0007KF,\u0018\r\\:\u0015\u0005-s\u0005CA\u001bM\u0013\tieGA\u0004C_>dW-\u00198\t\u000b=C\u0005\u0019\u0001\u001b\u0002\u0003=DQ!\u0015\u0001\u0005BI\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002'B\u0011Q\u0007V\u0005\u0003+Z\u00121!\u00138u\u0011\u00159\u0006\u0001\"\u0011Y\u0003!!\u0018\u0010]3OC6,W#A-\u0011\u0005yR\u0016BA.H\u0005\u0019\u0019FO]5oO\")Q\f\u0001C!1\u0006)\u0001/_+E)\"1q\f\u0001C!\r\u0001\f!\"Y:Ok2d\u0017M\u00197f+\u0005i\u0002")
public class MatrixUDT
extends UserDefinedType<Matrix> {
    public StructType sqlType() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numRows", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numCols", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("colPtrs", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("rowIndices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("isTransposed", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow serialize(Matrix obj) {
        void var3_2;
        GenericInternalRow row = new GenericInternalRow(7);
        Matrix matrix = obj;
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            row.setByte(0, (byte)0);
            row.setInt(1, sparseMatrix.numRows());
            row.setInt(2, sparseMatrix.numCols());
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.colPtrs()));
            row.update(4, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.rowIndices()));
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])sparseMatrix.values()));
            row.setBoolean(6, sparseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix;
            row.setByte(0, (byte)1);
            row.setInt(1, denseMatrix.numRows());
            row.setInt(2, denseMatrix.numCols());
            row.setNullAt(3);
            row.setNullAt(4);
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])denseMatrix.values()));
            row.setBoolean(6, denseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)matrix);
        }
        return var3_2;
    }

    public Matrix deserialize(Object datum) {
        DenseMatrix denseMatrix;
        Object object = datum;
        if (object instanceof InternalRow) {
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 7, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("MatrixUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 7").toString());
            byte tpe = internalRow.getByte(0);
            int numRows = internalRow.getInt(1);
            int numCols = internalRow.getInt(2);
            double[] values = internalRow.getArray(5).toDoubleArray();
            boolean isTransposed = internalRow.getBoolean(6);
            byte by = tpe;
            switch (by) {
                case 0: {
                    int[] colPtrs = internalRow.getArray(3).toIntArray();
                    int[] rowIndices = internalRow.getArray(4).toIntArray();
                    denseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
                    break;
                }
                case 1: {
                    denseMatrix = new DenseMatrix(numRows, numCols, values, isTransposed);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseMatrix denseMatrix2 = denseMatrix;
        return denseMatrix2;
    }

    public Class<Matrix> userClass() {
        return Matrix.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof MatrixUDT;
        return bl;
    }

    public int hashCode() {
        return MatrixUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "matrix";
    }

    public String pyUDT() {
        return "pyspark.ml.linalg.MatrixUDT";
    }

    public MatrixUDT asNullable() {
        return this;
    }
}

