/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.SparseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4Q!\u0001\u0002\u0001\r1\u0011\u0011BV3di>\u0014X\u000b\u0012+\u000b\u0005\r!\u0011A\u00027j]\u0006dwM\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0004\u001dM)R\"A\b\u000b\u0005A\t\u0012!\u0002;za\u0016\u001c(B\u0001\n\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003)=\u0011q\"V:fe\u0012+g-\u001b8fIRK\b/\u001a\t\u0003-]i\u0011AA\u0005\u00031\t\u0011aAV3di>\u0014\b\"\u0002\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003u\u0001\"A\u0006\u0001\t\u000b}\u0001AQ\t\u0011\u0002\u000fM\fH\u000eV=qKV\t\u0011\u0005\u0005\u0002\u000fE%\u00111e\u0004\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"B\u0013\u0001\t\u00032\u0013!C:fe&\fG.\u001b>f)\t9S\u0006\u0005\u0002)W5\t\u0011F\u0003\u0002+#\u0005A1-\u0019;bYf\u001cH/\u0003\u0002-S\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015qC\u00051\u0001\u0016\u0003\ry'M\u001b\u0005\u0006a\u0001!\t%M\u0001\fI\u0016\u001cXM]5bY&TX\r\u0006\u0002\u0016e!)1g\fa\u0001i\u0005)A-\u0019;v[B\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t\u0019\u0011I\\=\t\u000bm\u0002A\u0011\t\u001f\u0002\u000bALX\u000b\u0012+\u0016\u0003u\u0002\"AP#\u000f\u0005}\u001a\u0005C\u0001!7\u001b\u0005\t%B\u0001\"\u001c\u0003\u0019a$o\\8u}%\u0011AIN\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002Em!)\u0011\n\u0001C!\u0015\u0006IQo]3s\u00072\f7o]\u000b\u0002\u0017B\u0019a\bT\u000b\n\u00055;%!B\"mCN\u001c\b\"B(\u0001\t\u0003\u0002\u0016AB3rk\u0006d7\u000f\u0006\u0002R)B\u0011QGU\u0005\u0003'Z\u0012qAQ8pY\u0016\fg\u000eC\u0003V\u001d\u0002\u0007A'A\u0001p\u0011\u00159\u0006\u0001\"\u0011Y\u0003!A\u0017m\u001d5D_\u0012,G#A-\u0011\u0005UR\u0016BA.7\u0005\rIe\u000e\u001e\u0005\u0006;\u0002!\t\u0005P\u0001\tif\u0004XMT1nK\"1q\f\u0001C!\r\u0001\f!\"Y:Ok2d\u0017M\u00197f+\u0005i\u0002B\u00022\u0001A\u0003%\u0011%\u0001\u0005`gFdG+\u001f9f\u0001")
public class VectorUDT
extends UserDefinedType<Vector> {
    private final StructType _sqlType = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("size", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), new StructField("indices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4())})));

    public final StructType sqlType() {
        return this._sqlType;
    }

    public InternalRow serialize(Vector obj) {
        DenseVector denseVector;
        Option option;
        GenericInternalRow genericInternalRow;
        SparseVector sparseVector;
        Option option2;
        Vector vector = obj;
        if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
            int size = BoxesRunTime.unboxToInt((Object)((Tuple3)option2.get())._1());
            int[] indices = (int[])((Tuple3)option2.get())._2();
            double[] values = (double[])((Tuple3)option2.get())._3();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)0);
            row.setInt(1, size);
            row.update(2, (Object)UnsafeArrayData.fromPrimitiveArray((int[])indices));
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
            double[] values = (double[])option.get();
            GenericInternalRow row = new GenericInternalRow(4);
            row.setByte(0, (byte)1);
            row.setNullAt(1);
            row.setNullAt(2);
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((double[])values));
            genericInternalRow = row;
        } else {
            throw new MatchError((Object)vector);
        }
        return genericInternalRow;
    }

    public Vector deserialize(Object datum) {
        DenseVector denseVector;
        Object object = datum;
        if (object instanceof InternalRow) {
            byte tpe;
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 4, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("VectorUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 4").toString());
            byte by = tpe = internalRow.getByte(0);
            switch (by) {
                case 0: {
                    int size = internalRow.getInt(1);
                    int[] indices = internalRow.getArray(2).toIntArray();
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    denseVector = new SparseVector(size, indices, values);
                    break;
                }
                case 1: {
                    double[] values = internalRow.getArray(3).toDoubleArray();
                    denseVector = new DenseVector(values);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseVector denseVector2 = denseVector;
        return denseVector2;
    }

    public String pyUDT() {
        return "pyspark.ml.linalg.VectorUDT";
    }

    public Class<Vector> userClass() {
        return Vector.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof VectorUDT;
        return bl;
    }

    public int hashCode() {
        return VectorUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "vector";
    }

    public VectorUDT asNullable() {
        return this;
    }
}

