/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}b!B\u0001\u0003\u0001\u0011a!\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002\u0004\t\u0005)q\u000e\u001d;j[*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u000f)%\u0011Qc\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t/\u0001\u0011)\u0019!C\u00013\u0005aa-\u001b;J]R,'oY3qi\u000e\u0001Q#\u0001\u000e\u0011\u00059Y\u0012B\u0001\u000f\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001B\b\u0001\u0003\u0002\u0003\u0006IAG\u0001\u000eM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\u0011\u0001\u0002!Q1A\u0005\u0002\u0005\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0002EA\u0011abI\u0005\u0003I=\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u001f\u0015d\u0017m\u001d;jG:+G\u000fU1sC6D\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IAI\u0001\u0011K2\f7\u000f^5d\u001d\u0016$\b+\u0019:b[\u0002B\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!G\u0001\u0014gR\fg\u000eZ1sI&TXMR3biV\u0014Xm\u001d\u0005\t]\u0001\u0011\t\u0011)A\u00055\u0005!2\u000f^1oI\u0006\u0014H-\u001b>f\r\u0016\fG/\u001e:fg\u0002B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!G\u0001\u0011gR\fg\u000eZ1sI&TX\rT1cK2D\u0001B\r\u0001\u0003\u0002\u0003\u0006IAG\u0001\u0012gR\fg\u000eZ1sI&TX\rT1cK2\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\u0015M|GN^3s)f\u0004X-F\u00017!\t9\u0014J\u0004\u00029s5\t!a\u0002\u0004;\u0005!\u0005AaO\u0001\u0015/\u0016Lw\r\u001b;fI2+\u0017m\u001d;TcV\f'/Z:\u0011\u0005abdAB\u0001\u0003\u0011\u0003!QhE\u0002=\u001bMAQa\u0010\u001f\u0005\u0002\u0001\u000ba\u0001P5oSRtD#A\u001e\t\u000f\tc$\u0019!C\u0001\u0007\u0006\u0001R*\u0011-`\u001dVkuLR#B)V\u0013ViU\u000b\u0002\tB\u0011a\"R\u0005\u0003\r>\u00111!\u00138u\u0011\u0019AE\b)A\u0005\t\u0006\tR*\u0011-`\u001dVkuLR#B)V\u0013Vi\u0015\u0011\u0007\u000f)c\u0004\u0013aI\u0011\u0017\n11k\u001c7wKJ\u001c\"!S\u0007*\r%k\u0015QBA\u0019\r\u0015qE\b#!P\u0005\u0011\tU\u000f^8\u0014\u000b5k\u0001KU\n\u0011\u0005EKU\"\u0001\u001f\u0011\u00059\u0019\u0016B\u0001+\u0010\u0005\u001d\u0001&o\u001c3vGRDQaP'\u0005\u0002Y#\u0012a\u0016\t\u0003#6Cq!W'\u0002\u0002\u0013\u0005#,A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005Y\u0006twMC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&AB*ue&tw\rC\u0004e\u001b\u0006\u0005I\u0011A\"\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u000f\u0019l\u0015\u0011!C\u0001O\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HC\u00015l!\tq\u0011.\u0003\u0002k\u001f\t\u0019\u0011I\\=\t\u000f1,\u0017\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\t\u000f9l\u0015\u0011!C!_\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001q!\r\tH\u000f[\u0007\u0002e*\u00111oD\u0001\u000bG>dG.Z2uS>t\u0017BA;s\u0005!IE/\u001a:bi>\u0014\bbB<N\u0003\u0003%\t\u0001_\u0001\tG\u0006tW)];bYR\u0011!$\u001f\u0005\bYZ\f\t\u00111\u0001i\u0011\u001dYX*!A\u0005Bq\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\t\"9a0TA\u0001\n\u0003z\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003mC\u0011\"a\u0001N\u0003\u0003%I!!\u0002\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u000f\u00012\u0001XA\u0005\u0013\r\tY!\u0018\u0002\u0007\u001f\nTWm\u0019;\u0007\u000f\u0005=A\b#!\u0002\u0012\tA1\t[8mKN\\\u0017p\u0005\u0004\u0002\u000e5\u0001&k\u0005\u0005\b\u007f\u00055A\u0011AA\u000b)\t\t9\u0002E\u0002R\u0003\u001bA\u0001\"WA\u0007\u0003\u0003%\tE\u0017\u0005\tI\u00065\u0011\u0011!C\u0001\u0007\"Ia-!\u0004\u0002\u0002\u0013\u0005\u0011q\u0004\u000b\u0004Q\u0006\u0005\u0002\u0002\u00037\u0002\u001e\u0005\u0005\t\u0019\u0001#\t\u00119\fi!!A\u0005B=D\u0011b^A\u0007\u0003\u0003%\t!a\n\u0015\u0007i\tI\u0003\u0003\u0005m\u0003K\t\t\u00111\u0001i\u0011!Y\u0018QBA\u0001\n\u0003b\b\u0002\u0003@\u0002\u000e\u0005\u0005I\u0011I@\t\u0015\u0005\r\u0011QBA\u0001\n\u0013\t)AB\u0004\u00024qB\t)!\u000e\u0003\u0017E+\u0018m]5OK^$xN\\\n\u0007\u0003ci\u0001KU\n\t\u000f}\n\t\u0004\"\u0001\u0002:Q\u0011\u00111\b\t\u0004#\u0006E\u0002\u0002C-\u00022\u0005\u0005I\u0011\t.\t\u0011\u0011\f\t$!A\u0005\u0002\rC\u0011BZA\u0019\u0003\u0003%\t!a\u0011\u0015\u0007!\f)\u0005\u0003\u0005m\u0003\u0003\n\t\u00111\u0001E\u0011!q\u0017\u0011GA\u0001\n\u0003z\u0007\"C<\u00022\u0005\u0005I\u0011AA&)\rQ\u0012Q\n\u0005\tY\u0006%\u0013\u0011!a\u0001Q\"A10!\r\u0002\u0002\u0013\u0005C\u0010\u0003\u0005\u007f\u0003c\t\t\u0011\"\u0011\u0000\u0011)\t\u0019!!\r\u0002\u0002\u0013%\u0011QA\u0004\u0007\u0003/b\u0004\u0012Q,\u0002\t\u0005+Ho\\\u0004\b\u00037b\u0004\u0012QA\f\u0003!\u0019\u0005n\u001c7fg.LxaBA0y!\u0005\u00151H\u0001\f#V\f7/\u001b(foR|g\u000eC\u0005\u0002dq\u0012\r\u0011\"\u0001\u0002f\u0005\u00012/\u001e9q_J$X\rZ*pYZ,'o]\u000b\u0003\u0003O\u0002RADA5\u0003[J1!a\u001b\u0010\u0005\u0015\t%O]1z%\u0015\tyGU\nQ\r\u0019\t\t\b\u0010\u0001\u0002n\taAH]3gS:,W.\u001a8u}!A\u0011Q\u000f\u001f!\u0002\u0013\t9'A\ttkB\u0004xN\u001d;fIN{GN^3sg\u00022a!!\u001f=\t\u0005m$AC!hOJ,w-\u0019;peN!\u0011qO\u0007\u0014\u0011\u001dy\u0014q\u000fC\u0001\u0003\u007f\"\"!!!\u0011\u0007E\u000b9\bC\u0005\u0002\u0006\u0006]\u0004\u0019!C\u00013\u0005Y\u0011N\\5uS\u0006d\u0017N_3e\u0011)\tI)a\u001eA\u0002\u0013\u0005\u00111R\u0001\u0010S:LG/[1mSj,Gm\u0018\u0013fcR!\u0011QRAJ!\rq\u0011qR\u0005\u0004\u0003#{!\u0001B+oSRD\u0001\u0002\\AD\u0003\u0003\u0005\rA\u0007\u0005\t\u0003/\u000b9\b)Q\u00055\u0005a\u0011N\\5uS\u0006d\u0017N_3eA!Y\u00111TA<\u0001\u0004\u0005\r\u0011\"\u0001D\u0003\u0005Y\u0007\u0002DAP\u0003o\u0002\r\u00111A\u0005\u0002\u0005\u0005\u0016!B6`I\u0015\fH\u0003BAG\u0003GC\u0001\u0002\\AO\u0003\u0003\u0005\r\u0001\u0012\u0005\f\u0003O\u000b9\b1A\u0001B\u0003&A)\u0001\u0002lA!a\u00111VA<\u0001\u0004\u0005\r\u0011\"\u0001\u0002.\u0006)1m\\;oiV\u0011\u0011q\u0016\t\u0004\u001d\u0005E\u0016bAAZ\u001f\t!Aj\u001c8h\u00111\t9,a\u001eA\u0002\u0003\u0007I\u0011AA]\u0003%\u0019w.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0006m\u0006\"\u00037\u00026\u0006\u0005\t\u0019AAX\u00111\ty,a\u001eA\u0002\u0003\u0005\u000b\u0015BAX\u0003\u0019\u0019w.\u001e8uA!Y\u00111YA<\u0001\u0004\u0005\r\u0011\"\u0001D\u0003\u0011!(/[&\t\u0019\u0005\u001d\u0017q\u000fa\u0001\u0002\u0004%\t!!3\u0002\u0011Q\u0014\u0018nS0%KF$B!!$\u0002L\"AA.!2\u0002\u0002\u0003\u0007A\tC\u0006\u0002P\u0006]\u0004\u0019!A!B\u0013!\u0015!\u0002;sS.\u0003\u0003bCAj\u0003o\u0002\r\u00111A\u0005\u0002\u0005\nAa^*v[\"a\u0011q[A<\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z\u0006AqoU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0006m\u0007\u0002\u00037\u0002V\u0006\u0005\t\u0019\u0001\u0012\t\u0017\u0005}\u0017q\u000fa\u0001\u0002\u0003\u0006KAI\u0001\u0006oN+X\u000e\t\u0005\f\u0003G\f9\b1AA\u0002\u0013%\u0011%A\u0003xoN+X\u000e\u0003\u0007\u0002h\u0006]\u0004\u0019!a\u0001\n\u0013\tI/A\u0005xoN+Xn\u0018\u0013fcR!\u0011QRAv\u0011!a\u0017Q]A\u0001\u0002\u0004\u0011\u0003bCAx\u0003o\u0002\r\u0011!Q!\n\t\naa^<Tk6\u0004\u0003bCAz\u0003o\u0002\r\u00111A\u0005\n\u0005\nAAY*v[\"a\u0011q_A<\u0001\u0004\u0005\r\u0011\"\u0003\u0002z\u0006A!mU;n?\u0012*\u0017\u000f\u0006\u0003\u0002\u000e\u0006m\b\u0002\u00037\u0002v\u0006\u0005\t\u0019\u0001\u0012\t\u0017\u0005}\u0018q\u000fa\u0001\u0002\u0003\u0006KAI\u0001\u0006EN+X\u000e\t\u0005\f\u0005\u0007\t9\b1AA\u0002\u0013%\u0011%A\u0003cEN+X\u000e\u0003\u0007\u0003\b\u0005]\u0004\u0019!a\u0001\n\u0013\u0011I!A\u0005cEN+Xn\u0018\u0013fcR!\u0011Q\u0012B\u0006\u0011!a'QAA\u0001\u0002\u0004\u0011\u0003b\u0003B\b\u0003o\u0002\r\u0011!Q!\n\t\naA\u00192Tk6\u0004\u0003\u0002\u0004B\n\u0003o\u0002\r\u00111A\u0005\n\tU\u0011\u0001B1Tk6,\"Aa\u0006\u0011\t\te!qD\u0007\u0003\u00057Q1A!\b\u0005\u0003\u0019a\u0017N\\1mO&!!\u0011\u0005B\u000e\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u0019\t\u0015\u0012q\u000fa\u0001\u0002\u0004%IAa\n\u0002\u0011\u0005\u001cV/\\0%KF$B!!$\u0003*!IANa\t\u0002\u0002\u0003\u0007!q\u0003\u0005\r\u0005[\t9\b1A\u0001B\u0003&!qC\u0001\u0006CN+X\u000e\t\u0005\r\u0005c\t9\b1AA\u0002\u0013%!QC\u0001\u0006C\n\u001cV/\u001c\u0005\r\u0005k\t9\b1AA\u0002\u0013%!qG\u0001\nC\n\u001cV/\\0%KF$B!!$\u0003:!IANa\r\u0002\u0002\u0003\u0007!q\u0003\u0005\r\u0005{\t9\b1A\u0001B\u0003&!qC\u0001\u0007C\n\u001cV/\u001c\u0011\t\u0019\t\u0005\u0013q\u000fa\u0001\u0002\u0004%IA!\u0006\u0002\u000b\u0005\f7+^7\t\u0019\t\u0015\u0013q\u000fa\u0001\u0002\u0004%IAa\u0012\u0002\u0013\u0005\f7+^7`I\u0015\fH\u0003BAG\u0005\u0013B\u0011\u0002\u001cB\"\u0003\u0003\u0005\rAa\u0006\t\u0019\t5\u0013q\u000fa\u0001\u0002\u0003\u0006KAa\u0006\u0002\r\u0005\f7+^7!\u0011!\u0011\t&a\u001e\u0005\n\tM\u0013\u0001B5oSR$B!!$\u0003V!9\u00111\u0014B(\u0001\u0004!\u0005\u0002\u0003B-\u0003o\"\tAa\u0017\u0002\u0007\u0005$G\r\u0006\u0003\u0003^\t}SBAA<\u0011!\u0011\tGa\u0016A\u0002\t\r\u0014\u0001C5ogR\fgnY3\u0011\t\t\u0015$1N\u0007\u0003\u0005OR1A!\u001b\u0005\u0003\u001d1W-\u0019;ve\u0016LAA!\u001c\u0003h\tA\u0011J\\:uC:\u001cW\r\u0003\u0005\u0003r\u0005]D\u0011\u0001B:\u0003\u0015iWM]4f)\u0011\u0011iF!\u001e\t\u0011\t]$q\u000ea\u0001\u0003\u0003\u000bQa\u001c;iKJD\u0001Ba\u001f\u0002x\u0011\u0005!QP\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011\u0011Q\u0012\u0005\t\u0005\u0003\u000b9\b\"\u0001\u0003\u0016\u0005!\u0011MQ1s\u0011\u001d\u0011))a\u001e\u0005\u0002\u0005\nAA\u0019\"be\"9!\u0011RA<\t\u0003\t\u0013!\u00022c\u0005\u0006\u0014\bb\u0002BG\u0003o\"\t!I\u0001\u0005EN#H\r\u0003\u0005\u0003\u0012\u0006]D\u0011\u0001B\u000b\u0003\u0015\t'MQ1s\u0011!\u0011)*a\u001e\u0005\u0002\tU\u0011!B1b\u0005\u0006\u0014\b\u0002\u0003BM\u0003o\"\tA!\u0006\u0002\t\u0005\u001cF\u000f\u001a\u0005\t\u0005;\u000b9\b\"\u0001\u0003\u0016\u0005!\u0011MV1s\u0011%\u0011\t\u000bPI\u0001\n\u0003\u0011\u0019+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0003\u0005KS3A\u000eBTW\t\u0011I\u000b\u0005\u0003\u0003,\nUVB\u0001BW\u0015\u0011\u0011yK!-\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BZ\u001f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t]&Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B^yE\u0005I\u0011\u0001B_\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0018\u0016\u0004\t\n\u001d\u0006\"\u0003BbyE\u0005I\u0011\u0001Bc\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!q\u0019\u0016\u0004E\t\u001d\u0006\"CA\u0002y\u0005\u0005I\u0011BA\u0003\u0011%\u0011i\r\u0001B\u0001B\u0003%a'A\u0006t_24XM\u001d+za\u0016\u0004\u0003\"\u0003Bi\u0001\t\u0015\r\u0011\"\u0001D\u0003\u001di\u0017\r_%uKJD\u0011B!6\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\u0002\u00115\f\u00070\u0013;fe\u0002B\u0011B!7\u0001\u0005\u000b\u0007I\u0011A\u0011\u0002\u0007Q|G\u000eC\u0005\u0003^\u0002\u0011\t\u0011)A\u0005E\u0005!Ao\u001c7!\u0011\u0019y\u0004\u0001\"\u0001\u0003bR\u0011\"1\u001dBs\u0005O\u0014IOa;\u0003n\n=(\u0011\u001fBz!\tA\u0004\u0001\u0003\u0004\u0018\u0005?\u0004\rA\u0007\u0005\u0007A\t}\u0007\u0019\u0001\u0012\t\r!\u0012y\u000e1\u0001#\u0011\u0019a#q\u001ca\u00015!1\u0001Ga8A\u0002iA\u0001\u0002\u000eBp!\u0003\u0005\rA\u000e\u0005\n\u0005#\u0014y\u000e%AA\u0002\u0011C\u0011B!7\u0003`B\u0005\t\u0019\u0001\u0012\t\u000f\t]\b\u0001\"\u0001\u0003z\u0006\u0019a-\u001b;\u0015\r\tm8\u0011AB\t!\rA$Q`\u0005\u0004\u0005\u007f\u0014!!G,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7/T8eK2D\u0001ba\u0001\u0003v\u0002\u00071QA\u0001\nS:\u001cH/\u00198dKN\u0004baa\u0002\u0004\u000e\t\rTBAB\u0005\u0015\r\u0019YAB\u0001\u0004e\u0012$\u0017\u0002BB\b\u0007\u0013\u00111A\u0015#E\u0011)\u0019\u0019B!>\u0011\u0002\u0003\u00071QC\u0001\u0006S:\u001cHO\u001d\t\u0005\u0007/\u0019i\"\u0004\u0002\u0004\u001a)\u001911\u0004\u0003\u0002\tU$\u0018\u000e\\\u0005\u0005\u0007?\u0019IBA\fPaRLwN\\1m\u0013:\u001cHO];nK:$\u0018\r^5p]\"911\u0005\u0001\u0005\n\r\u0015\u0012AB4fi\u0006#\u0018\t\u0006\u0004\u0003\u0018\r\u001d21\u0006\u0005\t\u0005+\u001b\t\u00031\u0001\u0004*A!a\"!\u001b#\u0011!\u0011\ti!\tA\u0002\r%\u0002bBB\u0018\u0001\u0011%1\u0011G\u0001\u0007O\u0016$\u0018\t\u001e\"\u0015\r\t]11GB\u001b\u0011!\u0011\tj!\fA\u0002\r%\u0002b\u0002BC\u0007[\u0001\rA\t\u0005\n\u0007s\u0001\u0011\u0013!C\u0001\u0007w\tQBZ5uI\u0011,g-Y;mi\u0012\u0012TCAB\u001fU\u0011\u0019)Ba*")
public class WeightedLeastSquares
implements scala.Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances, OptionalInstrumentation instr) {
        block31: {
            block28: {
                block27: {
                    if (this.regParam() == 0.0) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$1(), ()Ljava/lang/String;)());
                    }
                    x$7 = new Aggregator();
                    x$8 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$2(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.feature.Instance ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/feature/Instance;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)();
                    x$9 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$3(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)();
                    x$10 = instances.treeAggregate$default$4((Object)x$7);
                    summary = (Aggregator)instances.treeAggregate((Object)x$7, (Function2)x$8, (Function2)x$9, x$10, ClassTag$.MODULE$.apply(Aggregator.class));
                    summary.validate();
                    instr.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$4(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), ()Ljava/lang/String;)((Aggregator)summary));
                    k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
                    numFeatures = summary.k();
                    triK = summary.triK();
                    wSum = summary.wSum();
                    rawBStd = summary.bStd();
                    rawBBar = summary.bBar();
                    v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
                    if (rawBStd == (double)false) {
                        if (this.fitIntercept() || rawBBar == 0.0) {
                            if (rawBBar == 0.0) {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$5(), ()Ljava/lang/String;)());
                            } else {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$6(), ()Ljava/lang/String;)());
                            }
                            coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double()));
                            intercept = rawBBar;
                            diagInvAtWA = new DenseVector(new double[]{0.0});
                            return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                        }
                        Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$7(), ()Ljava/lang/String;)());
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$8(), ()Ljava/lang/String;)());
                    }
                    bBar = summary.bBar() / bStd;
                    bbBar = summary.bbBar() / (bStd * bStd);
                    aStd = summary.aStd();
                    aStdValues = aStd.values();
                    _aBar = summary.aBar();
                    _aBarValues = _aBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _aBarValues[i] = 0.0;
                            continue;
                        }
                        var36_25 = i;
                        _aBarValues[var36_25] = _aBarValues[var36_25] / aStdValues[i];
                    }
                    aBar = _aBar;
                    aBarValues = aBar.values();
                    _abBar = summary.abBar();
                    _abBarValues = _abBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _abBarValues[i] = 0.0;
                            continue;
                        }
                        var42_31 = i;
                        _abBarValues[var42_31] = _abBarValues[var42_31] / (aStdValues[i] * bStd);
                    }
                    abBar = _abBar;
                    abBarValues = abBar.values();
                    _aaBar = summary.aaBar();
                    _aaBarValues = _aaBar.values();
                    p = 0;
                    for (j = 0; j < numFeatures; ++j) {
                        aStdJ = aStdValues[j];
                        for (i = 0; i <= j; ++i) {
                            aStdI = aStdValues[i];
                            if (aStdJ == 0.0 || aStdI == 0.0) {
                                _aaBarValues[p] = 0.0;
                            } else {
                                var54_41 = p;
                                _aaBarValues[var54_41] = _aaBarValues[var54_41] / (aStdI * aStdJ);
                            }
                            ++p;
                        }
                    }
                    aaBar = _aaBar;
                    aaBarValues = aaBar.values();
                    effectiveRegParam = this.regParam() / bStd;
                    effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
                    effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
                    i = 0;
                    j = 2;
                    while (i < triK) {
                        lambda = effectiveL2RegParam;
                        if (!this.standardizeFeatures()) {
                            std = aStdValues[j - 2];
                            lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                        }
                        if (!this.standardizeLabel()) {
                            lambda *= bStd;
                        }
                        var68_51 = i;
                        aaBarValues[var68_51] = aaBarValues[var68_51] + lambda;
                        i += j;
                        ++j;
                    }
                    aa = this.getAtA(aaBarValues, aBarValues);
                    ab = this.getAtB(abBarValues, bBar);
                    v1 = this.solverType();
                    var72_54 = WeightedLeastSquares$Auto$.MODULE$;
                    if (v1 != null ? v1.equals(var72_54) == false : var72_54 != null) break block27;
                    if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
                }
                v2 = this.solverType();
                var73_55 = WeightedLeastSquares$QuasiNewton$.MODULE$;
                if (!(v2 != null ? v2.equals(var73_55) == false : var73_55 != null)) lbl-1000:
                // 2 sources

                {
                    effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)(JFunction1.mcDI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)D, $anonfun$fit$9(org.apache.spark.ml.optim.WeightedLeastSquares int double[] double int ), (I)D)((WeightedLeastSquares)this, (int)numFeatures, (double[])aStdValues, (double)effectiveL1RegParam)) : None$.MODULE$;
                    v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
                } else {
                    v3 /* !! */  = new CholeskySolver();
                }
                var76_58 = solver = v3 /* !! */ ;
                if (!(var76_58 instanceof CholeskySolver)) break block28;
                var77_59 = var76_58;
                try {
                    v4 = var77_59.solve(bBar, bbBar, ab, aa, aBar);
                }
                catch (Throwable var78_60) {
                    block30: {
                        block29: {
                            var79_61 = var78_60;
                            if (!(var79_61 instanceof SingularMatrixException)) break block29;
                            v5 = this.solverType();
                            var80_62 = WeightedLeastSquares$Auto$.MODULE$;
                            if (!(v5 != null ? v5.equals(var80_62) == false : var80_62 != null)) break block30;
                        }
                        throw var78_60;
                    }
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$10(), ()Ljava/lang/String;)());
                    _aa = this.getAtA(aaBarValues, aBarValues);
                    _ab = this.getAtB(abBarValues, bBar);
                    newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                    var5_66 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                    v4 = var5_66;
                }
                var4_67 = v4;
                break block31;
            }
            if (var76_58 instanceof QuasiNewtonSolver) {
                var84_68 = (QuasiNewtonSolver)var76_58;
                var4_67 = var84_68.solve(bBar, bbBar, ab, aa, aBar);
            } else {
                throw new MatchError((Object)var76_58);
            }
        }
        solution = var4_67;
        v6 = var86_70 = this.fitIntercept() != false ? new Tuple2(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).slice(0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).last()) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
        if (var86_70 == null) {
            throw new MatchError((Object)var86_70);
        }
        coefficientArray = (double[])var86_70._1();
        intercept = var86_70._2$mcD$sp();
        var3_73 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
        var85_74 = var3_73;
        coefficientArray = (double[])var85_74._1();
        intercept = var85_74._2$mcD$sp();
        len = coefficientArray.length;
        for (q = 0; q < len; ++q) {
            var95_79 = q;
            coefficientArray[var95_79] = coefficientArray[var95_79] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
        }
        diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$11(org.apache.spark.ml.optim.WeightedLeastSquares int double double[] double[] ), ([D)Lorg/apache/spark/ml/linalg/DenseVector;)((WeightedLeastSquares)this, (int)k, (double)wSum, (double[])aStdValues)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$13(), ()Lorg/apache/spark/ml/linalg/DenseVector;)());
        return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$14(), ()[D)()));
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(WeightedLeastSquares.class);
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])abBar.clone());
    }

    public static final /* synthetic */ String $anonfun$fit$1() {
        return "regParam is zero, which might cause numerical instability and overfitting.";
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$2(Aggregator x$1, Instance x$2) {
        return x$1.add(x$2);
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$3(Aggregator x$3, Aggregator x$4) {
        return x$3.merge(x$4);
    }

    public static final /* synthetic */ String $anonfun$fit$4(Aggregator summary$1) {
        return new StringBuilder(22).append("Number of instances: ").append(summary$1.count()).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$5() {
        return new StringBuilder(143).append("Mean and standard deviation of the label are zero, so the ").append("coefficients and the intercept will all be zero; as a result, training is not ").append("needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$6() {
        return new StringBuilder(164).append("The standard deviation of the label is zero, so the coefficients ").append("will be zeros and the intercept will be the mean of the label; as a result, ").append("training is not needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$7() {
        return "The standard deviation of the label is zero. Model cannot be regularized with standardization=true";
    }

    public static final /* synthetic */ String $anonfun$fit$8() {
        return new StringBuilder(80).append("The standard deviation of the label is zero. Consider setting ").append("fitIntercept=true.").toString();
    }

    public static final /* synthetic */ double $anonfun$fit$9(WeightedLeastSquares $this, int numFeatures$1, double[] aStdValues$1, double effectiveL1RegParam$1, int index) {
        return $this.fitIntercept() && index == numFeatures$1 ? 0.0 : ($this.standardizeFeatures() ? effectiveL1RegParam$1 : (aStdValues$1[index] != 0.0 ? effectiveL1RegParam$1 / aStdValues$1[index] : 0.0));
    }

    public static final /* synthetic */ String $anonfun$fit$10() {
        return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$11(WeightedLeastSquares $this, int k$1, double wSum$1, double[] aStdValues$1, double[] inv) {
        return new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), k$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double multiplier = i == k$1 && $this.fitIntercept() ? 1.0 : aStdValues$1[i - 1] * aStdValues$1[i - 1];
            return inv[i + (i - 1) * i / 2 - 1] / (wSum$1 * multiplier);
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$13() {
        return new DenseVector(new double[]{0.0});
    }

    public static final /* synthetic */ double[] $anonfun$fit$14() {
        return new double[]{0.0};
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("regParam cannot be negative: ").append(this.regParam()).toString());
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("elasticNetParam must be in [0, 1]: ").append(this.elasticNetParam()).toString());
        Predef$.MODULE$.require(maxIter >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("maxIter must be a positive integer: ").append(this.maxIter()).toString());
        Predef$.MODULE$.require(tol >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("tol must be >= 0, but was set to ").append(this.tol()).toString());
    }

    public static class Aggregator
    implements scala.Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("In order to take the normal equation approach efficiently, ").append(new StringBuilder(47).append("we set the max number of features to ").append(WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()).append(" but got ").append(k).append(".").toString()).toString());
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 == null) {
                throw new MatchError((Object)instance2);
            }
            double l = instance2.label();
            double w = instance2.weight();
            Vector f = instance2.features();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)f);
            Tuple3 tuple32 = tuple3;
            double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            double w2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            Vector f2 = (Vector)tuple32._3();
            int ak = f2.size();
            if (!this.initialized()) {
                this.init(ak);
            }
            Predef$.MODULE$.assert(ak == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Dimension mismatch. Expect vectors of size ").append(this.k()).append(" but got ").append(ak).append(".").toString());
            this.count_$eq(this.count() + 1L);
            this.wSum_$eq(this.wSum() + w2);
            this.wwSum_$eq(this.wwSum() + w2 * w2);
            this.bSum_$eq(this.bSum() + w2 * l2);
            this.bbSum_$eq(this.bbSum() + w2 * l2 * l2);
            BLAS$.MODULE$.axpy(w2, f2, (Vector)this.aSum());
            BLAS$.MODULE$.axpy(w2 * l2, f2, (Vector)this.abSum());
            BLAS$.MODULE$.spr(w2, f2, this.aaSum());
            return this;
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (!other.initialized()) {
                aggregator = this;
            } else {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("dimension mismatch: this.k = ").append(this.k()).append(" but other.k = ").append(other.k()).toString());
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0 & Serializable & scala.Serializable)() -> "Training dataset is empty.");
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Sum of weights cannot be zero.");
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance);
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance);
        }
    }

    public static interface Solver {
    }
}

