/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0001\r9\u0011q\u0002S5oO\u0016\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"Y4he\u0016<\u0017\r^8s\u0015\t)a!A\u0003paRLWN\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111r#G\u0010\u000e\u0003\tI!\u0001\u0007\u0002\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011!$H\u0007\u00027)\u0011ADB\u0001\bM\u0016\fG/\u001e:f\u0013\tq2D\u0001\u0005J]N$\u0018M\\2f!\t1\u0002\u0001\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003$\u00035\u00117MR3biV\u0014Xm]*uI\u000e\u0001\u0001c\u0001\u0013(S5\tQE\u0003\u0002'\u0011\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003Q\u0015\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007AQC&\u0003\u0002,#\t)\u0011I\u001d:bsB\u0011\u0001#L\u0005\u0003]E\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019\u0019LG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005A\u0011\u0014BA\u001a\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\u000fE\u000e\u001cu.\u001a4gS\u000eLWM\u001c;t!\r!se\u000e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0019\ta\u0001\\5oC2<\u0017B\u0001\u001f:\u0005\u00191Vm\u0019;pe\")a\b\u0001C\u0001\u007f\u00051A(\u001b8jiz\"2\u0001\u0011\"D)\ty\u0012\tC\u00036{\u0001\u0007a\u0007C\u0003\"{\u0001\u00071\u0005C\u00031{\u0001\u0007\u0011\u0007C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002\u000fB\u0011\u0001\u0003S\u0005\u0003\u0013F\u00111!\u00138u\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006aa.^7GK\u0006$XO]3tA!9Q\n\u0001b\u0001\n\u00131\u0015\u0001\u00078v[\u001a+\u0017\r^;sKN\u0004F.^:J]R,'oY3qi\"1q\n\u0001Q\u0001\n\u001d\u000b\u0011D\\;n\r\u0016\fG/\u001e:fgBcWo]%oi\u0016\u00148-\u001a9uA!A\u0011\u000b\u0001EC\u0002\u0013%!+A\td_\u00164g-[2jK:$8/\u0011:sCf,\u0012!\u000b\u0015\u0003!R\u0003\"\u0001E+\n\u0005Y\u000b\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u001dA\u0006A1A\u0005R\u0019\u000b1\u0001Z5n\u0011\u0019Q\u0006\u0001)A\u0005\u000f\u0006!A-[7!\u0011\u0015a\u0006\u0001\"\u0001^\u0003\r\tG\r\u001a\u000b\u0003=~k\u0011\u0001\u0001\u0005\u0006An\u0003\r!G\u0001\tS:\u001cH/\u00198dK\u0002")
public class HingeAggregator
implements DifferentiableLossAggregator<Instance, HingeAggregator> {
    private transient double[] coefficientsArray;
    private final Broadcast<double[]> bcFeaturesStd;
    private final boolean fitIntercept;
    private final Broadcast<Vector> bcCoefficients;
    private final int numFeatures;
    private final int numFeaturesPlusIntercept;
    private final int dim;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        HingeAggregator hingeAggregator = this;
        synchronized (hingeAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    private int numFeaturesPlusIntercept() {
        return this.numFeaturesPlusIntercept;
    }

    private double[] coefficientsArray$lzycompute() {
        HingeAggregator hingeAggregator = this;
        synchronized (hingeAggregator) {
            if (!this.bitmap$trans$0) {
                double[] values;
                DenseVector denseVector;
                Option option;
                Vector vector = (Vector)this.bcCoefficients.value();
                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("coefficients only supports dense vector").append(new StringBuilder(15).append(" but got type ").append(this.bcCoefficients.value().getClass()).append(".").toString()).toString());
                }
                double[] dArray = values = (double[])option.get();
                this.coefficientsArray = dArray;
                this.bitmap$trans$0 = true;
            }
        }
        return this.coefficientsArray;
    }

    private double[] coefficientsArray() {
        return !this.bitmap$trans$0 ? this.coefficientsArray$lzycompute() : this.coefficientsArray;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    @Override
    public HingeAggregator add(Instance instance) {
        double loss;
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double dotProduct;
            double labelScaled;
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Dimensions mismatch when adding new instance.").append(new StringBuilder(21).append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString()).toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
            double[] localCoefficients = this.coefficientsArray();
            double[] localGradientSumArray = this.gradientSumArray();
            DoubleRef sum = DoubleRef.create((double)0.0);
            features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                block0: {
                    if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                    sum$1.elem += localCoefficients[index] * value / localFeaturesStd[index];
                }
            });
            if (this.fitIntercept) {
                sum.elem += localCoefficients[this.numFeaturesPlusIntercept() - 1];
            }
            double d = loss = 1.0 > (labelScaled = (double)2 * label - 1.0) * (dotProduct = sum.elem) ? (1.0 - labelScaled * dotProduct) * weight : 0.0;
            if (1.0 > labelScaled * dotProduct) {
                double gradientScale = -labelScaled * weight;
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + value * gradientScale / localFeaturesStd[index];
                    }
                });
                if (this.fitIntercept) {
                    int n = localGradientSumArray.length - 1;
                    localGradientSumArray[n] = localGradientSumArray[n] + gradientScale;
                }
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.lossSum_$eq(this.lossSum() + loss);
        this.weightSum_$eq(this.weightSum() + weight);
        HingeAggregator hingeAggregator = this;
        return hingeAggregator;
    }

    public HingeAggregator(Broadcast<double[]> bcFeaturesStd, boolean fitIntercept, Broadcast<Vector> bcCoefficients) {
        this.bcFeaturesStd = bcFeaturesStd;
        this.fitIntercept = fitIntercept;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator.$init$(this);
        this.numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.numFeaturesPlusIntercept = fitIntercept ? this.numFeatures() + 1 : this.numFeatures();
        this.dim = this.numFeaturesPlusIntercept();
    }
}

