/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00054Q!\u0001\u0002\u0001\r9\u0011q\u0002S;cKJ\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"Y4he\u0016<\u0017\r^8s\u0015\t)a!A\u0003paRLWN\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111r#G\u0010\u000e\u0003\tI!\u0001\u0007\u0002\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011!$H\u0007\u00027)\u0011ADB\u0001\bM\u0016\fG/\u001e:f\u0013\tq2D\u0001\u0005J]N$\u0018M\\2f!\t1\u0002\u0001\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003$\u000311\u0017\u000e^%oi\u0016\u00148-\u001a9u\u0007\u0001\u0001\"\u0001\u0005\u0013\n\u0005\u0015\n\"a\u0002\"p_2,\u0017M\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u00059Q\r]:jY>t\u0007C\u0001\t*\u0013\tQ\u0013C\u0001\u0004E_V\u0014G.\u001a\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005i!m\u0019$fCR,(/Z:Ti\u0012\u00042AL\u00194\u001b\u0005y#B\u0001\u0019\t\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u00023_\tI!I]8bI\u000e\f7\u000f\u001e\t\u0004!QB\u0013BA\u001b\u0012\u0005\u0015\t%O]1z\u0011!9\u0004A!A!\u0002\u0013A\u0014\u0001\u00042d!\u0006\u0014\u0018-\\3uKJ\u001c\bc\u0001\u00182sA\u0011!(P\u0007\u0002w)\u0011AHB\u0001\u0007Y&t\u0017\r\\4\n\u0005yZ$A\u0002,fGR|'\u000fC\u0003A\u0001\u0011\u0005\u0011)\u0001\u0004=S:LGO\u0010\u000b\u0005\u0005\u0012+e\t\u0006\u0002 \u0007\")qg\u0010a\u0001q!)\u0011e\u0010a\u0001G!)qe\u0010a\u0001Q!)Af\u0010a\u0001[!9\u0001\n\u0001b\u0001\n#J\u0015a\u00013j[V\t!\n\u0005\u0002\u0011\u0017&\u0011A*\u0005\u0002\u0004\u0013:$\bB\u0002(\u0001A\u0003%!*\u0001\u0003eS6\u0004\u0003b\u0002)\u0001\u0005\u0004%I!S\u0001\f]Vlg)Z1ukJ,7\u000f\u0003\u0004S\u0001\u0001\u0006IAS\u0001\r]Vlg)Z1ukJ,7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003\u0015\u0019\u0018nZ7b+\u0005A\u0003BB,\u0001A\u0003%\u0001&\u0001\u0004tS\u001el\u0017\r\t\u0005\b3\u0002\u0011\r\u0011\"\u0003V\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0003\u0004\\\u0001\u0001\u0006I\u0001K\u0001\u000bS:$XM]2faR\u0004\u0003\"B/\u0001\t\u0003q\u0016aA1eIR\u0011qd\u0018\u0005\u0006Ar\u0003\r!G\u0001\tS:\u001cH/\u00198dK\u0002")
public class HuberAggregator
implements DifferentiableLossAggregator<Instance, HuberAggregator> {
    private final boolean fitIntercept;
    private final double epsilon;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<Vector> bcParameters;
    private final int dim;
    private final int numFeatures;
    private final double sigma;
    private final double intercept;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        HuberAggregator huberAggregator = this;
        synchronized (huberAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    private double sigma() {
        return this.sigma;
    }

    private double intercept() {
        return this.intercept;
    }

    @Override
    public HuberAggregator add(Instance instance) {
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double margin;
            double linearLoss;
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Dimensions mismatch when adding new sample.").append(new StringBuilder(21).append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString()).toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
            double[] localCoefficients = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(((Vector)this.bcParameters.value()).toArray())).slice(0, this.numFeatures());
            double[] localGradientSumArray = this.gradientSumArray();
            DoubleRef sum = DoubleRef.create((double)0.0);
            features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                block0: {
                    if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                    sum$1.elem += localCoefficients[index] * (value / localFeaturesStd[index]);
                }
            });
            if (this.fitIntercept) {
                sum.elem += this.intercept();
            }
            if (package$.MODULE$.abs(linearLoss = label - (margin = sum.elem)) <= this.sigma() * this.epsilon) {
                this.lossSum_$eq(this.lossSum() + 0.5 * weight * (this.sigma() + package$.MODULE$.pow(linearLoss, 2.0) / this.sigma()));
                double linearLossDivSigma = linearLoss / this.sigma();
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + -1.0 * weight * linearLossDivSigma * (value / localFeaturesStd[index]);
                    }
                });
                if (this.fitIntercept) {
                    int n = this.dim() - 2;
                    localGradientSumArray[n] = localGradientSumArray[n] + -1.0 * weight * linearLossDivSigma;
                }
                int n = this.dim() - 1;
                localGradientSumArray[n] = localGradientSumArray[n] + 0.5 * weight * (1.0 - package$.MODULE$.pow(linearLossDivSigma, 2.0));
            } else {
                double sign = linearLoss >= 0.0 ? -1.0 : 1.0;
                this.lossSum_$eq(this.lossSum() + 0.5 * weight * (this.sigma() + 2.0 * this.epsilon * package$.MODULE$.abs(linearLoss) - this.sigma() * this.epsilon * this.epsilon));
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + weight * sign * $this.epsilon * (value / localFeaturesStd[index]);
                    }
                });
                if (this.fitIntercept) {
                    int n = this.dim() - 2;
                    localGradientSumArray[n] = localGradientSumArray[n] + weight * sign * this.epsilon;
                }
                int n = this.dim() - 1;
                localGradientSumArray[n] = localGradientSumArray[n] + 0.5 * weight * (1.0 - this.epsilon * this.epsilon);
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.weightSum_$eq(this.weightSum() + weight);
        HuberAggregator huberAggregator = this;
        return huberAggregator;
    }

    public HuberAggregator(boolean fitIntercept, double epsilon, Broadcast<double[]> bcFeaturesStd, Broadcast<Vector> bcParameters) {
        this.fitIntercept = fitIntercept;
        this.epsilon = epsilon;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcParameters = bcParameters;
        DifferentiableLossAggregator.$init$(this);
        this.dim = ((Vector)bcParameters.value()).size();
        this.numFeatures = fitIntercept ? this.dim() - 2 : this.dim() - 1;
        this.sigma = ((Vector)bcParameters.value()).apply(this.dim() - 1);
        this.intercept = fitIntercept ? ((Vector)bcParameters.value()).apply(this.dim() - 2) : 0.0;
    }
}

