/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\r9\u0011a\u0003T3bgR\u001c\u0016/^1sKN\fum\u001a:fO\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"Y4he\u0016<\u0017\r^8s\u0015\t)a!A\u0003paRLWN\u0003\u0002\b\u0011\u0005\u0011Q\u000e\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\u00111r#G\u0010\u000e\u0003\tI!\u0001\u0007\u0002\u00039\u0011KgMZ3sK:$\u0018.\u00192mK2{7o]!hOJ,w-\u0019;peB\u0011!$H\u0007\u00027)\u0011ADB\u0001\bM\u0016\fG/\u001e:f\u0013\tq2D\u0001\u0005J]N$\u0018M\\2f!\t1\u0002\u0001\u0003\u0005\"\u0001\t\u0005\t\u0015!\u0003$\u0003!a\u0017MY3m'R$7\u0001\u0001\t\u0003!\u0011J!!J\t\u0003\r\u0011{WO\u00197f\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!\u00037bE\u0016dW*Z1o\u0011!I\u0003A!A!\u0002\u0013Q\u0013\u0001\u00044ji&sG/\u001a:dKB$\bC\u0001\t,\u0013\ta\u0013CA\u0004C_>dW-\u00198\t\u00119\u0002!\u0011!Q\u0001\n=\nQBY2GK\u0006$XO]3t'R$\u0007c\u0001\u00194k5\t\u0011G\u0003\u00023\u0011\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0003iE\u0012\u0011B\u0011:pC\u0012\u001c\u0017m\u001d;\u0011\u0007A14%\u0003\u00028#\t)\u0011I\u001d:bs\"A\u0011\b\u0001B\u0001B\u0003%q&\u0001\bcG\u001a+\u0017\r^;sKNlU-\u00198\t\u0011m\u0002!\u0011!Q\u0001\nq\naBY2D_\u00164g-[2jK:$8\u000fE\u00021gu\u0002\"AP!\u000e\u0003}R!\u0001\u0011\u0004\u0002\r1Lg.\u00197h\u0013\t\u0011uH\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\t\u0002!\t!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0019C\u0015JS&M)\tyr\tC\u0003<\u0007\u0002\u0007A\bC\u0003\"\u0007\u0002\u00071\u0005C\u0003(\u0007\u0002\u00071\u0005C\u0003*\u0007\u0002\u0007!\u0006C\u0003/\u0007\u0002\u0007q\u0006C\u0003:\u0007\u0002\u0007q\u0006C\u0004O\u0001\t\u0007I\u0011B(\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002!B\u0011\u0001#U\u0005\u0003%F\u00111!\u00138u\u0011\u0019!\u0006\u0001)A\u0005!\u0006aa.^7GK\u0006$XO]3tA!9a\u000b\u0001b\u0001\n#z\u0015a\u00013j[\"1\u0001\f\u0001Q\u0001\nA\u000bA\u0001Z5nA!A!\f\u0001EC\u0002\u0013%1,A\u0006gK\u0006$XO]3t'R$W#A\u001b)\u0005ek\u0006C\u0001\t_\u0013\ty\u0016CA\u0005ue\u0006t7/[3oi\"A\u0011\r\u0001EC\u0002\u0013%!-\u0001\ffM\u001a,7\r^5wK\u000e{WMZ!oI>3gm]3u+\u0005\u0019\u0007\u0003\u0002\te{\rJ!!Z\t\u0003\rQ+\b\u000f\\33Q\t\u0001W\f\u0003\u0005i\u0001!\u0015\r\u0011\"\u0003j\u0003m)gMZ3di&4XmQ8fM\u001aL7-[3oiN4Vm\u0019;peV\tQ\b\u000b\u0002h;\"AA\u000e\u0001EC\u0002\u0013%Q.\u0001\u0004pM\u001a\u001cX\r^\u000b\u0002G!\u00121.\u0018\u0005\u0006a\u0002!\t!]\u0001\u0004C\u0012$GCA\u0010s\u0011\u0015\u0019x\u000e1\u0001\u001a\u0003!Ign\u001d;b]\u000e,\u0007")
public class LeastSquaresAggregator
implements DifferentiableLossAggregator<Instance, LeastSquaresAggregator> {
    private transient double[] featuresStd;
    private transient Tuple2<Vector, Object> effectiveCoefAndOffset;
    private transient Vector effectiveCoefficientsVector;
    private transient double offset;
    private final double labelStd;
    private final double labelMean;
    private final boolean fitIntercept;
    private final Broadcast<double[]> bcFeaturesStd;
    private final Broadcast<double[]> bcFeaturesMean;
    private final Broadcast<Vector> bcCoefficients;
    private final int numFeatures;
    private final int dim;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] featuresStd$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.featuresStd = (double[])this.bcFeaturesStd.value();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.featuresStd;
    }

    private double[] featuresStd() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.featuresStd$lzycompute() : this.featuresStd;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] coefficientsArray = (double[])((Vector)this.bcCoefficients.value()).toArray().clone();
                double[] featuresMean = (double[])this.bcFeaturesMean.value();
                double sum = 0.0;
                int len = coefficientsArray.length;
                for (int i = 0; i < len; ++i) {
                    if (this.featuresStd()[i] != 0.0) {
                        int n = i;
                        coefficientsArray[n] = coefficientsArray[n] / this.featuresStd()[i];
                        sum += coefficientsArray[i] * featuresMean[i];
                        continue;
                    }
                    coefficientsArray[i] = 0.0;
                }
                double offset = this.fitIntercept ? this.labelMean / this.labelStd - sum : 0.0;
                this.effectiveCoefAndOffset = new Tuple2((Object)Vectors$.MODULE$.dense(coefficientsArray), (Object)BoxesRunTime.boxToDouble((double)offset));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.effectiveCoefAndOffset;
    }

    private Tuple2<Vector, Object> effectiveCoefAndOffset() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.effectiveCoefAndOffset$lzycompute() : this.effectiveCoefAndOffset;
    }

    private Vector effectiveCoefficientsVector$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.effectiveCoefficientsVector = (Vector)this.effectiveCoefAndOffset()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.effectiveCoefficientsVector;
    }

    private Vector effectiveCoefficientsVector() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.effectiveCoefficientsVector$lzycompute() : this.effectiveCoefficientsVector;
    }

    private double offset$lzycompute() {
        LeastSquaresAggregator leastSquaresAggregator = this;
        synchronized (leastSquaresAggregator) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.offset = this.effectiveCoefAndOffset()._2$mcD$sp();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.offset;
    }

    private double offset() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.offset$lzycompute() : this.offset;
    }

    @Override
    public LeastSquaresAggregator add(Instance instance) {
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(43).append("Dimensions mismatch when adding new sample.").append(new StringBuilder(21).append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString()).toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            double diff = BLAS$.MODULE$.dot(features, this.effectiveCoefficientsVector()) - label / this.labelStd + this.offset();
            if (diff != 0.0) {
                double[] localGradientSumArray = this.gradientSumArray();
                double[] localFeaturesStd = this.featuresStd();
                features.foreachActive((Function2)(JFunction2.mcVID.sp & java.io.Serializable & Serializable)(index, value) -> {
                    block0: {
                        double fStd = localFeaturesStd[index];
                        if (fStd == 0.0 || value == 0.0) break block0;
                        localGradientSumArray$1[index] = localGradientSumArray[index] + weight * diff * value / fStd;
                    }
                });
                this.lossSum_$eq(this.lossSum() + weight * diff * diff / 2.0);
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.weightSum_$eq(this.weightSum() + weight);
        LeastSquaresAggregator leastSquaresAggregator = this;
        return leastSquaresAggregator;
    }

    public LeastSquaresAggregator(double labelStd, double labelMean, boolean fitIntercept, Broadcast<double[]> bcFeaturesStd, Broadcast<double[]> bcFeaturesMean, Broadcast<Vector> bcCoefficients) {
        this.labelStd = labelStd;
        this.labelMean = labelMean;
        this.fitIntercept = fitIntercept;
        this.bcFeaturesStd = bcFeaturesStd;
        this.bcFeaturesMean = bcFeaturesMean;
        this.bcCoefficients = bcCoefficients;
        DifferentiableLossAggregator.$init$(this);
        Predef$.MODULE$.require(labelStd > 0.0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(54).append(this.getClass().getName()).append(" requires the label standard ").append("deviation to be positive.").toString());
        this.numFeatures = ((double[])bcFeaturesStd.value()).length;
        this.dim = this.numFeatures();
    }
}

