/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim.aggregator;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.DenseVector$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.aggregator.DifferentiableLossAggregator;
import org.apache.spark.mllib.util.MLUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da!B\u0001\u0003\u0001\u0019q!A\u0005'pO&\u001cH/[2BO\u001e\u0014XmZ1u_JT!a\u0001\u0003\u0002\u0015\u0005<wM]3hCR|'O\u0003\u0002\u0006\r\u0005)q\u000e\u001d;j[*\u0011q\u0001C\u0001\u0003[2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0005\u0001=)\u0002\u0005\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\t\u0005-]Ir$D\u0001\u0003\u0013\tA\"A\u0001\u000fES\u001a4WM]3oi&\f'\r\\3M_N\u001c\u0018iZ4sK\u001e\fGo\u001c:\u0011\u0005iiR\"A\u000e\u000b\u0005q1\u0011a\u00024fCR,(/Z\u0005\u0003=m\u0011\u0001\"\u00138ti\u0006t7-\u001a\t\u0003-\u0001\u0001\"!\t\u0013\u000e\u0003\tR!a\t\u0005\u0002\u0011%tG/\u001a:oC2L!!\n\u0012\u0003\u000f1{wmZ5oO\"Aq\u0005\u0001B\u0001B\u0003%\u0011&A\u0007cG\u001a+\u0017\r^;sKN\u001cF\u000fZ\u0002\u0001!\rQSfL\u0007\u0002W)\u0011A\u0006C\u0001\nEJ|\u0017\rZ2bgRL!AL\u0016\u0003\u0013\t\u0013x.\u00193dCN$\bc\u0001\t1e%\u0011\u0011'\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003!MJ!\u0001N\t\u0003\r\u0011{WO\u00197f\u0011!1\u0004A!A!\u0002\u00139\u0014A\u00038v[\u000ec\u0017m]:fgB\u0011\u0001\u0003O\u0005\u0003sE\u00111!\u00138u\u0011!Y\u0004A!A!\u0002\u0013a\u0014\u0001\u00044ji&sG/\u001a:dKB$\bC\u0001\t>\u0013\tq\u0014CA\u0004C_>dW-\u00198\t\u0011\u0001\u0003!\u0011!Q\u0001\nq\n1\"\\;mi&tw.\\5bY\"A!\t\u0001B\u0001B\u0003%1)\u0001\bcG\u000e{WM\u001a4jG&,g\u000e^:\u0011\u0007)jC\t\u0005\u0002F\u00116\taI\u0003\u0002H\r\u00051A.\u001b8bY\u001eL!!\u0013$\u0003\rY+7\r^8s\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u0019a\u0014N\\5u}Q)Qj\u0014)R%R\u0011qD\u0014\u0005\u0006\u0005*\u0003\ra\u0011\u0005\u0006O)\u0003\r!\u000b\u0005\u0006m)\u0003\ra\u000e\u0005\u0006w)\u0003\r\u0001\u0010\u0005\u0006\u0001*\u0003\r\u0001\u0010\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003]Baa\u0016\u0001!\u0002\u00139\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003bB-\u0001\u0005\u0004%I!V\u0001\u0019]Vlg)Z1ukJ,7\u000f\u00157vg&sG/\u001a:dKB$\bBB.\u0001A\u0003%q'A\rok64U-\u0019;ve\u0016\u001c\b\u000b\\;t\u0013:$XM]2faR\u0004\u0003bB/\u0001\u0005\u0004%I!V\u0001\u0010G>,gMZ5dS\u0016tGoU5{K\"1q\f\u0001Q\u0001\n]\n\u0001cY8fM\u001aL7-[3oiNK'0\u001a\u0011\t\u000f\u0005\u0004!\u0019!C)+\u0006\u0019A-[7\t\r\r\u0004\u0001\u0015!\u00038\u0003\u0011!\u0017.\u001c\u0011\t\u0011\u0015\u0004\u0001R1A\u0005\n\u0019\f\u0011cY8fM\u001aL7-[3oiN\f%O]1z+\u0005y\u0003F\u00013i!\t\u0001\u0012.\u0003\u0002k#\tIAO]1og&,g\u000e\u001e\u0005\u0006Y\u0002!I!\\\u0001\u0014E&t\u0017M]=Va\u0012\fG/Z%o!2\f7-\u001a\u000b\u0005]F\u001cX\u000f\u0005\u0002\u0011_&\u0011\u0001/\u0005\u0002\u0005+:LG\u000fC\u0003sW\u0002\u0007A)\u0001\u0005gK\u0006$XO]3t\u0011\u0015!8\u000e1\u00013\u0003\u00199X-[4ii\")ao\u001ba\u0001e\u0005)A.\u00192fY\")\u0001\u0010\u0001C\u0005s\u0006AR.\u001e7uS:|W.[1m+B$\u0017\r^3J]Bc\u0017mY3\u0015\t9T8\u0010 \u0005\u0006e^\u0004\r\u0001\u0012\u0005\u0006i^\u0004\rA\r\u0005\u0006m^\u0004\rA\r\u0005\u0006}\u0002!\ta`\u0001\u0004C\u0012$G\u0003BA\u0001\u0003\u0007i\u0011\u0001\u0001\u0005\u0007\u0003\u000bi\b\u0019A\r\u0002\u0011%t7\u000f^1oG\u0016\u0004")
public class LogisticAggregator
implements DifferentiableLossAggregator<Instance, LogisticAggregator>,
Logging {
    private transient double[] coefficientsArray;
    private final Broadcast<double[]> bcFeaturesStd;
    private final int numClasses;
    private final boolean fitIntercept;
    private final boolean multinomial;
    private final Broadcast<Vector> bcCoefficients;
    private final int numFeatures;
    private final int numFeaturesPlusIntercept;
    private final int coefficientSize;
    private final int dim;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private double weightSum;
    private double lossSum;
    private double[] gradientSumArray;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public DifferentiableLossAggregator merge(DifferentiableLossAggregator other) {
        return DifferentiableLossAggregator.merge$(this, other);
    }

    @Override
    public Vector gradient() {
        return DifferentiableLossAggregator.gradient$(this);
    }

    @Override
    public double weight() {
        return DifferentiableLossAggregator.weight$(this);
    }

    @Override
    public double loss() {
        return DifferentiableLossAggregator.loss$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public double weightSum() {
        return this.weightSum;
    }

    @Override
    public void weightSum_$eq(double x$1) {
        this.weightSum = x$1;
    }

    @Override
    public double lossSum() {
        return this.lossSum;
    }

    @Override
    public void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private double[] gradientSumArray$lzycompute() {
        LogisticAggregator logisticAggregator = this;
        synchronized (logisticAggregator) {
            if (!this.bitmap$0) {
                this.gradientSumArray = DifferentiableLossAggregator.gradientSumArray$(this);
                this.bitmap$0 = true;
            }
        }
        return this.gradientSumArray;
    }

    @Override
    public double[] gradientSumArray() {
        return !this.bitmap$0 ? this.gradientSumArray$lzycompute() : this.gradientSumArray;
    }

    private int numFeatures() {
        return this.numFeatures;
    }

    private int numFeaturesPlusIntercept() {
        return this.numFeaturesPlusIntercept;
    }

    private int coefficientSize() {
        return this.coefficientSize;
    }

    @Override
    public int dim() {
        return this.dim;
    }

    private double[] coefficientsArray$lzycompute() {
        LogisticAggregator logisticAggregator = this;
        synchronized (logisticAggregator) {
            if (!this.bitmap$trans$0) {
                double[] values;
                DenseVector denseVector;
                Option option;
                Vector vector = (Vector)this.bcCoefficients.value();
                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("coefficients only supports dense vector but ").append(new StringBuilder(11).append("got type ").append(this.bcCoefficients.value().getClass()).append(".)").toString()).toString());
                }
                double[] dArray = values = (double[])option.get();
                this.coefficientsArray = dArray;
                this.bitmap$trans$0 = true;
            }
        }
        return this.coefficientsArray;
    }

    private double[] coefficientsArray() {
        return !this.bitmap$trans$0 ? this.coefficientsArray$lzycompute() : this.coefficientsArray;
    }

    private void binaryUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        double[] localCoefficients = this.coefficientsArray();
        double[] localGradientArray = this.gradientSumArray();
        DoubleRef sum = DoubleRef.create((double)0.0);
        features.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                sum$1.elem += localCoefficients[index] * value / localFeaturesStd[index];
            }
        });
        if (this.fitIntercept) {
            sum.elem += localCoefficients[this.numFeaturesPlusIntercept() - 1];
        }
        double margin = -sum.elem;
        double multiplier = weight * (1.0 / (1.0 + package$.MODULE$.exp(margin)) - label);
        features.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            block0: {
                if (localFeaturesStd[index] == 0.0 || value == 0.0) break block0;
                localGradientArray$1[index] = localGradientArray[index] + multiplier * value / localFeaturesStd[index];
            }
        });
        if (this.fitIntercept) {
            int n = this.numFeaturesPlusIntercept() - 1;
            localGradientArray[n] = localGradientArray[n] + multiplier;
        }
        if (label > 0.0) {
            this.lossSum_$eq(this.lossSum() + weight * MLUtils$.MODULE$.log1pExp(margin));
        } else {
            this.lossSum_$eq(this.lossSum() + weight * (MLUtils$.MODULE$.log1pExp(margin) - margin));
        }
    }

    private void multinomialUpdateInPlace(Vector features, double weight, double label) {
        double[] localFeaturesStd = (double[])this.bcFeaturesStd.value();
        double[] localCoefficients = this.coefficientsArray();
        double[] localGradientArray = this.gradientSumArray();
        double marginOfLabel = 0.0;
        double maxMargin = Double.NEGATIVE_INFINITY;
        double[] margins = new double[this.numClasses];
        features.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            if (localFeaturesStd[index] != 0.0 && value != 0.0) {
                double stdValue = value / localFeaturesStd[index];
                for (int j = 0; j < $this.numClasses; ++j) {
                    int n = j;
                    margins$1[n] = margins[n] + localCoefficients[index * $this.numClasses + j] * stdValue;
                }
            }
        });
        for (int i2 = 0; i2 < this.numClasses; ++i2) {
            if (this.fitIntercept) {
                int n = i2;
                margins[n] = margins[n] + localCoefficients[this.numClasses * this.numFeatures() + i2];
            }
            if (i2 == (int)label) {
                marginOfLabel = margins[i2];
            }
            if (!(margins[i2] > maxMargin)) continue;
            maxMargin = margins[i2];
        }
        double[] multipliers = new double[this.numClasses];
        double temp = 0.0;
        for (int i3 = 0; i3 < this.numClasses; ++i3) {
            if (maxMargin > 0.0) {
                int n = i3;
                margins[n] = margins[n] - maxMargin;
            }
            double exp = package$.MODULE$.exp(margins[i3]);
            temp += exp;
            multipliers[i3] = exp;
        }
        double sum = temp;
        new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(margins)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            multipliers$1[i] = multipliers[i] / sum - (label == (double)i ? 1.0 : 0.0);
        });
        features.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(index, value) -> {
            if (localFeaturesStd[index] != 0.0 && value != 0.0) {
                double stdValue = value / localFeaturesStd[index];
                for (int j = 0; j < $this.numClasses; ++j) {
                    int n = index * $this.numClasses + j;
                    localGradientArray$2[n] = localGradientArray[n] + weight * multipliers[j] * stdValue;
                }
            }
        });
        if (this.fitIntercept) {
            for (int i4 = 0; i4 < this.numClasses; ++i4) {
                int n = this.numFeatures() * this.numClasses + i4;
                localGradientArray[n] = localGradientArray[n] + weight * multipliers[i4];
            }
        }
        double loss = maxMargin > 0.0 ? package$.MODULE$.log(sum) - marginOfLabel + maxMargin : package$.MODULE$.log(sum) - marginOfLabel;
        this.lossSum_$eq(this.lossSum() + weight * loss);
    }

    @Override
    public LogisticAggregator add(Instance instance) {
        double weight;
        Instance instance2 = instance;
        if (instance2 != null) {
            double label = instance2.label();
            weight = instance2.weight();
            Vector features = instance2.features();
            Predef$.MODULE$.require(this.numFeatures() == features.size(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Dimensions mismatch when adding new instance.").append(new StringBuilder(21).append(" Expecting ").append(this.numFeatures()).append(" but got ").append(features.size()).append(".").toString()).toString());
            Predef$.MODULE$.require(weight >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("instance weight, ").append(weight).append(" has to be >= 0.0").toString());
            if (weight == 0.0) {
                return this;
            }
            if (this.multinomial) {
                this.multinomialUpdateInPlace(features, weight, label);
            } else {
                this.binaryUpdateInPlace(features, weight, label);
            }
        } else {
            throw new MatchError((Object)instance2);
        }
        this.weightSum_$eq(this.weightSum() + weight);
        LogisticAggregator logisticAggregator = this;
        return logisticAggregator;
    }

    public LogisticAggregator(Broadcast<double[]> bcFeaturesStd, int numClasses, boolean fitIntercept, boolean multinomial, Broadcast<Vector> bcCoefficients) {
        block2: {
            this.bcFeaturesStd = bcFeaturesStd;
            this.numClasses = numClasses;
            this.fitIntercept = fitIntercept;
            this.multinomial = multinomial;
            this.bcCoefficients = bcCoefficients;
            DifferentiableLossAggregator.$init$(this);
            Logging.$init$((Logging)this);
            this.numFeatures = ((double[])bcFeaturesStd.value()).length;
            this.numFeaturesPlusIntercept = fitIntercept ? this.numFeatures() + 1 : this.numFeatures();
            this.coefficientSize = ((Vector)bcCoefficients.value()).size();
            this.dim = this.coefficientSize();
            if (multinomial) {
                Predef$.MODULE$.require(numClasses == this.coefficientSize() / this.numFeaturesPlusIntercept(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("The number of ").append(new StringBuilder(32).append("coefficients should be ").append($this.numClasses * this.numFeaturesPlusIntercept()).append(" but was ").append(this.coefficientSize()).toString()).toString());
            } else {
                Predef$.MODULE$.require(this.coefficientSize() == this.numFeaturesPlusIntercept(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Expected ").append(this.numFeaturesPlusIntercept()).append(" ").append(new StringBuilder(21).append("coefficients but got ").append(this.coefficientSize()).toString()).toString());
                Predef$.MODULE$.require(numClasses == 1 || numClasses == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Binary logistic aggregator requires numClasses ").append(new StringBuilder(21).append("in {1, 2} but found ").append($this.numClasses).append(".").toString()).toString());
            }
            if (!multinomial || numClasses > 2) break block2;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(324).append("Multinomial logistic regression for binary classification yields separate ").append("coefficients for positive and negative classes. When no regularization is applied, the").append("result will be effectively the same as binary logistic regression. When regularization").append("is applied, multinomial loss will produce a result different from binary loss.").toString());
        }
    }
}

