/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.param;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.linalg.JsonMatrixConverter$;
import org.apache.spark.ml.linalg.JsonVectorConverter$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param$;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.util.Identifiable;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011Q\u0001U1sC6T!a\u0001\u0003\u0002\u000bA\f'/Y7\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001da\u001a2\u0001A\b\u0016!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011\u0001CF\u0005\u0003/E\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0006\u0004%\tAG\u0001\u0007a\u0006\u0014XM\u001c;\u0016\u0003m\u0001\"\u0001H\u0012\u000f\u0005u\t\u0003C\u0001\u0010\u0012\u001b\u0005y\"B\u0001\u0011\r\u0003\u0019a$o\\8u}%\u0011!%E\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002##!Aq\u0005\u0001B\u0001B\u0003%1$A\u0004qCJ,g\u000e\u001e\u0011\t\u0011%\u0002!Q1A\u0005\u0002i\tAA\\1nK\"A1\u0006\u0001B\u0001B\u0003%1$A\u0003oC6,\u0007\u0005\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\r!wn\u0019\u0005\t_\u0001\u0011\t\u0011)A\u00057\u0005!Am\\2!\u0011!\t\u0004A!b\u0001\n\u0003\u0011\u0014aB5t-\u0006d\u0017\u000eZ\u000b\u0002gA!\u0001\u0003\u000e\u001cB\u0013\t)\u0014CA\u0005Gk:\u001cG/[8ocA\u0011q\u0007\u000f\u0007\u0001\t\u0015I\u0004A1\u0001;\u0005\u0005!\u0016CA\u001e?!\t\u0001B(\u0003\u0002>#\t9aj\u001c;iS:<\u0007C\u0001\t@\u0013\t\u0001\u0015CA\u0002B]f\u0004\"\u0001\u0005\"\n\u0005\r\u000b\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005g\u0005A\u0011n\u001d,bY&$\u0007\u0005C\u0003H\u0001\u0011\u0005\u0001*\u0001\u0004=S:LGO\u0010\u000b\u0006\u0013.cUJ\u0014\t\u0004\u0015\u00021T\"\u0001\u0002\t\u000be1\u0005\u0019A\u000e\t\u000b%2\u0005\u0019A\u000e\t\u000b52\u0005\u0019A\u000e\t\u000bE2\u0005\u0019A\u001a\t\u000b\u001d\u0003A\u0011\u0001)\u0015\u000b%\u000b\u0006,\u0017.\t\u000bey\u0005\u0019\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0005U#\u0011\u0001B;uS2L!a\u0016+\u0003\u0019%#WM\u001c;jM&\f'\r\\3\t\u000b%z\u0005\u0019A\u000e\t\u000b5z\u0005\u0019A\u000e\t\u000bEz\u0005\u0019A\u001a\t\u000b\u001d\u0003A\u0011\u0001/\u0015\t%kfl\u0018\u0005\u00063m\u0003\ra\u0007\u0005\u0006Sm\u0003\ra\u0007\u0005\u0006[m\u0003\ra\u0007\u0005\u0006\u000f\u0002!\t!\u0019\u000b\u0005\u0013\n\u001cG\rC\u0003\u001aA\u0002\u0007!\u000bC\u0003*A\u0002\u00071\u0004C\u0003.A\u0002\u00071\u0004\u0003\u0004g\u0001\u0011\u0005!aZ\u0001\tm\u0006d\u0017\u000eZ1uKR\u0011\u0001n\u001b\t\u0003!%L!A[\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\u0016\u0004\rAN\u0001\u0006m\u0006dW/\u001a\u0005\u0006]\u0002!\ta\\\u0001\u0002oR\u0011\u0001o\u001d\t\u0004\u0015F4\u0014B\u0001:\u0003\u0005%\u0001\u0016M]1n!\u0006L'\u000fC\u0003m[\u0002\u0007a\u0007C\u0003v\u0001\u0011\u0005a/\u0001\b%[&tWo\u001d\u0013he\u0016\fG/\u001a:\u0015\u0005A<\b\"\u00027u\u0001\u00041\u0004\"B=\u0001\t\u0003Q\u0018A\u00036t_:,enY8eKR\u00111d\u001f\u0005\u0006Yb\u0004\rA\u000e\u0005\u0006{\u0002!\tA`\u0001\u000bUN|g\u000eR3d_\u0012,GC\u0001\u001c\u0000\u0011\u0019\t\t\u0001 a\u00017\u0005!!n]8o\u0011\u001d\t)\u0001\u0001Q\u0001\nm\tAc\u001d;sS:<'+\u001a9sKN,g\u000e^1uS>t\u0007bBA\u0005\u0001\u0011\u0015\u00131B\u0001\ti>\u001cFO]5oOR\t1\u0004C\u0004\u0002\u0010\u0001!)%!\u0005\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0005\u0011\u0007A\t)\"C\u0002\u0002\u0018E\u00111!\u00138u\u0011\u001d\tY\u0002\u0001C#\u0003;\ta!Z9vC2\u001cHcA!\u0002 !9\u0011\u0011EA\r\u0001\u0004q\u0014aA8cU\"\u001a\u0001!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\tIC\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018n\u0002\u0005\u00024\tA\t\u0001BA\u001b\u0003\u0015\u0001\u0016M]1n!\rQ\u0015q\u0007\u0004\b\u0003\tA\t\u0001BA\u001d'\u0011\t9dD\u000b\t\u000f\u001d\u000b9\u0004\"\u0001\u0002>Q\u0011\u0011Q\u0007\u0005\b{\u0006]B\u0011AA!+\u0011\t\u0019%a\u0012\u0015\t\u0005\u0015\u0013\u0011\n\t\u0004o\u0005\u001dCAB\u001d\u0002@\t\u0007!\bC\u0004\u0002\u0002\u0005}\u0002\u0019A\u000e\t\u0015\u00055\u0013qGA\u0001\n\u0013\ty%A\u0006sK\u0006$'+Z:pYZ,GCAA)!\u0011\t\u0019&!\u0018\u000e\u0005\u0005U#\u0002BA,\u00033\nA\u0001\\1oO*\u0011\u00111L\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002`\u0005U#AB(cU\u0016\u001cG\u000f")
public class Param<T>
implements Serializable {
    private final String parent;
    private final String name;
    private final String doc;
    private final Function1<T, Object> isValid;
    private final String stringRepresentation;

    public String parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public String doc() {
        return this.doc;
    }

    public Function1<T, Object> isValid() {
        return this.isValid;
    }

    public void validate(T value) {
        if (!BoxesRunTime.unboxToBoolean((Object)this.isValid().apply(value))) {
            String string;
            T t = value;
            if (ScalaRunTime$.MODULE$.isArray(t, 1)) {
                T t2 = t;
                string = Predef$.MODULE$.genericArrayOps(t2).mkString("[", ",", "]");
            } else {
                string = value.toString();
            }
            String valueToString = string;
            throw new IllegalArgumentException(new StringBuilder(33).append(this.parent()).append(" parameter ").append(this.name()).append(" given invalid value ").append(valueToString).append(".").toString());
        }
    }

    public ParamPair<T> w(T value) {
        return this.$minus$greater(value);
    }

    public ParamPair<T> $minus$greater(T value) {
        return new ParamPair<T>(this, value);
    }

    public String jsonEncode(T value) {
        String string;
        T t = value;
        if (t instanceof String) {
            String string2 = (String)t;
            JsonAST.JString x$16 = package$.MODULE$.JString().apply(string2);
            Formats x$17 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$16);
            string = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$16, x$17));
        } else if (t instanceof Vector) {
            T t2 = t;
            string = JsonVectorConverter$.MODULE$.toJson((Vector)t2);
        } else if (t instanceof Matrix) {
            T t3 = t;
            string = JsonMatrixConverter$.MODULE$.toJson((Matrix)t3);
        } else {
            throw new NotImplementedError(new StringBuilder(64).append("The default jsonEncode only supports string, vector and matrix. ").append(new StringBuilder(31).append(this.getClass().getName()).append(" must override jsonEncode for ").append(value.getClass().getName()).append(".").toString()).toString());
        }
        return string;
    }

    public T jsonDecode(String json) {
        return Param$.MODULE$.jsonDecode(json);
    }

    public final String toString() {
        return this.stringRepresentation;
    }

    public final int hashCode() {
        return Statics.anyHash((Object)this.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Param)) return false;
        Param param = (Param)object;
        String string = param.parent();
        String string2 = this.parent();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = param.name();
        String string4 = this.name();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public Param(String parent, String name, String doc, Function1<T, Object> isValid) {
        this.parent = parent;
        this.name = name;
        this.doc = doc;
        this.isValid = isValid;
        this.stringRepresentation = new StringBuilder(2).append(parent).append("__").append(name).toString();
    }

    public Param(Identifiable parent, String name, String doc, Function1<T, Object> isValid) {
        this(parent.uid(), name, doc, isValid);
    }

    public Param(String parent, String name, String doc) {
        this(parent, name, doc, ParamValidators$.MODULE$.alwaysTrue());
    }

    public Param(Identifiable parent, String name, String doc) {
        this(parent.uid(), name, doc);
    }
}

