/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineModel$;
import org.apache.spark.ml.clustering.KMeansModel;
import org.apache.spark.ml.r.KMeansWrapper$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eg!B\u0001\u0003\u0001\ta!!D&NK\u0006t7o\u0016:baB,'O\u0003\u0002\u0004\t\u0005\t!O\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0019\u0001!D\n\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g!\t!r#D\u0001\u0016\u0015\t1B!\u0001\u0003vi&d\u0017B\u0001\r\u0016\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\t5\u0001\u0011)\u0019!C\u00019\u0005A\u0001/\u001b9fY&tWm\u0001\u0001\u0016\u0003u\u0001\"AH\u0010\u000e\u0003\u0011I!\u0001\t\u0003\u0003\u001bAK\u0007/\u001a7j]\u0016lu\u000eZ3m\u0011!\u0011\u0003A!A!\u0002\u0013i\u0012!\u00039ja\u0016d\u0017N\\3!\u0011!!\u0003A!b\u0001\n\u0003)\u0013\u0001\u00034fCR,(/Z:\u0016\u0003\u0019\u00022AD\u0014*\u0013\tAsBA\u0003BeJ\f\u0017\u0010\u0005\u0002+c9\u00111f\f\t\u0003Y=i\u0011!\f\u0006\u0003]m\ta\u0001\u0010:p_Rt\u0014B\u0001\u0019\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Az\u0001\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0003\u0002C\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\u0002\tML'0Z\u000b\u0002sA\u0019ab\n\u001e\u0011\u00059Y\u0014B\u0001\u001f\u0010\u0005\u0011auN\\4\t\u0011y\u0002!\u0011!Q\u0001\ne\nQa]5{K\u0002B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t!Q\u0001\tSNdu.\u00193fIV\t!\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u0005>|G.Z1o\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015!C5t\u0019>\fG-\u001a3!\u0011\u0015A\u0005\u0001\"\u0003J\u0003\u0019a\u0014N\\5u}Q)!\nT'O\u001fB\u00111\nA\u0007\u0002\u0005!)!d\u0012a\u0001;!)Ae\u0012a\u0001M!)qg\u0012a\u0001s!9\u0001i\u0012I\u0001\u0002\u0004\u0011\u0005bB)\u0001\u0005\u0004%IAU\u0001\fW6+\u0017M\\:N_\u0012,G.F\u0001T!\t!v+D\u0001V\u0015\t1F!\u0001\u0006dYV\u001cH/\u001a:j]\u001eL!\u0001W+\u0003\u0017-kU-\u00198t\u001b>$W\r\u001c\u0005\u00075\u0002\u0001\u000b\u0011B*\u0002\u0019-lU-\u00198t\u001b>$W\r\u001c\u0011\t\u0011q\u0003\u0001R1A\u0005\u0002u\u000bAbY8fM\u001aL7-[3oiN,\u0012A\u0018\t\u0004\u001d\u001dz\u0006C\u0001\ba\u0013\t\twB\u0001\u0004E_V\u0014G.\u001a\u0005\tG\u0002A)\u0019!C\u0001I\u0006\t1.F\u0001f!\tqa-\u0003\u0002h\u001f\t\u0019\u0011J\u001c;\t\u0011%\u0004\u0001R1A\u0005\u0002)\fqa\u00197vgR,'/F\u0001l!\ta\u0017P\u0004\u0002nm:\u0011a\u000e\u001e\b\u0003_Nt!\u0001\u001d:\u000f\u00051\n\u0018\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)h!A\u0002tc2L!a\u001e=\u0002\u000fA\f7m[1hK*\u0011QOB\u0005\u0003un\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005]D\b\u0002C?\u0001\u0011\u000b\u0007I\u0011\u00013\u0002\u0017\rdWo\u001d;feNK'0\u001a\u0005\u0007\u007f\u0002!\t!!\u0001\u0002\r\u0019LG\u000f^3e)\rY\u00171\u0001\u0005\u0007\u0003\u000bq\b\u0019A\u0015\u0002\r5,G\u000f[8e\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017\t\u0011\u0002\u001e:b]N4wN]7\u0015\u0007-\fi\u0001\u0003\u0005\u0002\u0010\u0005\u001d\u0001\u0019AA\t\u0003\u001d!\u0017\r^1tKR\u0004D!a\u0005\u0002 A1\u0011QCA\f\u00037i\u0011\u0001_\u0005\u0004\u00033A(a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003;\ty\u0002\u0004\u0001\u0005\u0019\u0005\u0005\u0012QBA\u0001\u0002\u0003\u0015\t!a\t\u0003\u0007}#\u0013'\u0005\u0003\u0002&\u0005-\u0002c\u0001\b\u0002(%\u0019\u0011\u0011F\b\u0003\u000f9{G\u000f[5oOB\u0019a\"!\f\n\u0007\u0005=rBA\u0002B]fDq!a\r\u0001\t\u0003\n)$A\u0003xe&$X-\u0006\u0002\u00028A\u0019A#!\u000f\n\u0007\u0005mRC\u0001\u0005N\u0019^\u0013\u0018\u000e^3s\u000f!\tyD\u0001E\u0001\u0005\u0005\u0005\u0013!D&NK\u0006t7o\u0016:baB,'\u000fE\u0002L\u0003\u00072q!\u0001\u0002\t\u0002\t\t)eE\u0003\u0002D5\t9\u0005\u0005\u0003\u0015\u0003\u0013R\u0015bAA&+\tQQ\n\u0014*fC\u0012\f'\r\\3\t\u000f!\u000b\u0019\u0005\"\u0001\u0002PQ\u0011\u0011\u0011\t\u0005\t\u0003'\n\u0019\u0005\"\u0001\u0002V\u0005\u0019a-\u001b;\u0015#)\u000b9&a\u0017\u0002`\u0005\u0005\u0014QMA5\u0003[\n\t\bC\u0004\u0002Z\u0005E\u0003\u0019A6\u0002\t\u0011\fG/\u0019\u0005\b\u0003;\n\t\u00061\u0001*\u0003\u001d1wN]7vY\u0006DaaYA)\u0001\u0004)\u0007bBA2\u0003#\u0002\r!Z\u0001\b[\u0006D\u0018\n^3s\u0011\u001d\t9'!\u0015A\u0002%\n\u0001\"\u001b8ji6{G-\u001a\u0005\b\u0003W\n\t\u00061\u0001*\u0003\u0011\u0019X-\u001a3\t\u000f\u0005=\u0014\u0011\u000ba\u0001K\u0006I\u0011N\\5u'R,\u0007o\u001d\u0005\b\u0003g\n\t\u00061\u0001`\u0003\r!x\u000e\u001c\u0005\t\u0003o\n\u0019\u0005\"\u0011\u0002z\u0005!!/Z1e+\t\tY\b\u0005\u0003\u0015\u0003{R\u0015bAA@+\tAQ\n\u0014*fC\u0012,'\u000f\u0003\u0005\u0002\u0004\u0006\rC\u0011IAC\u0003\u0011aw.\u00193\u0015\u0007)\u000b9\tC\u0004\u0002\n\u0006\u0005\u0005\u0019A\u0015\u0002\tA\fG\u000f\u001b\u0004\b\u0003\u001b\u000b\u0019\u0005AAH\u0005MYU*Z1og^\u0013\u0018\r\u001d9fe^\u0013\u0018\u000e^3s'\u0011\tY)a\u000e\t\u0015\u0005M\u00151\u0012B\u0001B\u0003%!*\u0001\u0005j]N$\u0018M\\2f\u0011\u001dA\u00151\u0012C\u0001\u0003/#B!!'\u0002\u001eB!\u00111TAF\u001b\t\t\u0019\u0005C\u0004\u0002\u0014\u0006U\u0005\u0019\u0001&\t\u0011\u0005\u0005\u00161\u0012C)\u0003G\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0003K\u000bY\u000bE\u0002\u000f\u0003OK1!!+\u0010\u0005\u0011)f.\u001b;\t\u000f\u0005%\u0015q\u0014a\u0001S\u00199\u0011qVA\"\u0001\u0005E&aE&NK\u0006t7o\u0016:baB,'OU3bI\u0016\u00148\u0003BAW\u0003wBq\u0001SAW\t\u0003\t)\f\u0006\u0002\u00028B!\u00111TAW\u0011!\t\u0019)!,\u0005B\u0005mFc\u0001&\u0002>\"9\u0011\u0011RA]\u0001\u0004I\u0003BCAa\u0003\u0007\n\n\u0011\"\u0003\u0002D\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"!!2+\u0007\t\u000b9m\u000b\u0002\u0002JB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017!C;oG\",7m[3e\u0015\r\t\u0019nD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAl\u0003\u001b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KMeansWrapper
implements MLWritable {
    private double[] coefficients;
    private int k;
    private Dataset<Row> cluster;
    private int clusterSize;
    private final PipelineModel pipeline;
    private final String[] features;
    private final long[] size;
    private final boolean isLoaded;
    private final KMeansModel kMeansModel;
    private volatile byte bitmap$0;

    public static /* bridge */ Object load(String string) {
        return KMeansWrapper$.MODULE$.load(string);
    }

    public static KMeansWrapper load(String string) {
        return KMeansWrapper$.MODULE$.load(string);
    }

    public static MLReader<KMeansWrapper> read() {
        return KMeansWrapper$.MODULE$.read();
    }

    public static KMeansWrapper fit(Dataset<Row> dataset, String string, int n, int n2, String string2, String string3, int n3, double d) {
        return KMeansWrapper$.MODULE$.fit(dataset, string, n, n2, string2, string3, n3, d);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    public PipelineModel pipeline() {
        return this.pipeline;
    }

    public String[] features() {
        return this.features;
    }

    public long[] size() {
        return this.size;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    private KMeansModel kMeansModel() {
        return this.kMeansModel;
    }

    private double[] coefficients$lzycompute() {
        KMeansWrapper kMeansWrapper = this;
        synchronized (kMeansWrapper) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.coefficients = (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.kMeansModel().clusterCenters())).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(x$1.toArray())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.coefficients;
    }

    public double[] coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.coefficients$lzycompute() : this.coefficients;
    }

    private int k$lzycompute() {
        KMeansWrapper kMeansWrapper = this;
        synchronized (kMeansWrapper) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.k = this.kMeansModel().getK();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.k;
    }

    public int k() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.k$lzycompute() : this.k;
    }

    private Dataset<Row> cluster$lzycompute() {
        KMeansWrapper kMeansWrapper = this;
        synchronized (kMeansWrapper) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.cluster = this.kMeansModel().summary().cluster();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.cluster;
    }

    public Dataset<Row> cluster() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.cluster$lzycompute() : this.cluster;
    }

    private int clusterSize$lzycompute() {
        KMeansWrapper kMeansWrapper = this;
        synchronized (kMeansWrapper) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.clusterSize = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.kMeansModel().clusterCenters())).size();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.clusterSize;
    }

    public int clusterSize() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.clusterSize$lzycompute() : this.clusterSize;
    }

    public Dataset<Row> fitted(String method) {
        Dataset<Row> dataset;
        String string = method;
        String string2 = "centers";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            dataset = this.kMeansModel().summary().predictions().drop(this.kMeansModel().getFeaturesCol());
        } else {
            String string3 = method;
            String string4 = "classes";
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                dataset = this.kMeansModel().summary().cluster();
            } else {
                throw new UnsupportedOperationException(new StringBuilder(48).append("Method (centers or classes) required but ").append(method).append(" found.").toString());
            }
        }
        return dataset;
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        return this.pipeline().transform(dataset).drop(this.kMeansModel().getFeaturesCol());
    }

    @Override
    public MLWriter write() {
        return new KMeansWrapperWriter(this);
    }

    public KMeansWrapper(PipelineModel pipeline, String[] features, long[] size, boolean isLoaded) {
        this.pipeline = pipeline;
        this.features = features;
        this.size = size;
        this.isLoaded = isLoaded;
        MLWritable.$init$(this);
        this.kMeansModel = (KMeansModel)pipeline.stages()[1];
    }

    public static class KMeansWrapperReader
    extends MLReader<KMeansWrapper> {
        @Override
        public KMeansWrapper load(String path) {
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            String rMetadataPath = new Path(path, "rMetadata").toString();
            String pipelinePath = new Path(path, "pipeline").toString();
            PipelineModel pipeline = PipelineModel$.MODULE$.load(pipelinePath);
            String rMetadataStr = (String)this.sc().textFile(rMetadataPath, 1).first();
            JsonAST.JValue rMetadata = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(rMetadataStr), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
            String[] features = (String[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(rMetadata).$bslash("features")).extract((Formats)format, ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)));
            long[] size = (long[])package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(rMetadata).$bslash("size")).extract((Formats)format, ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Long()));
            return new KMeansWrapper(pipeline, features, size, true);
        }
    }

    public static class KMeansWrapperWriter
    extends MLWriter {
        private final KMeansWrapper instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject rMetadata;
            String rMetadataPath = new Path(path, "rMetadata").toString();
            String pipelinePath = new Path(path, "pipeline").toString();
            JsonAST.JObject x$3 = rMetadata = JsonDSL$.MODULE$.jobject2assoc(JsonDSL$.MODULE$.pair2Assoc(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"class"), (Object)this.instance.getClass().getName()), (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)).$tilde(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"features"), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.instance.features())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)))).$tilde(JsonDSL$.MODULE$.pair2jvalue(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.instance.size())).toSeq()), (Function1 & Serializable & scala.Serializable)s -> JsonDSL$.MODULE$.seq2jvalue(s, (Function1 & Serializable & scala.Serializable)x -> JsonDSL$.MODULE$.long2jvalue(BoxesRunTime.unboxToLong((Object)x)))));
            Formats x$4 = JsonMethods$.MODULE$.render$default$2((JsonAST.JValue)x$3);
            String rMetadataJson = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JsonAST.JValue)x$3, x$4));
            this.sc().parallelize((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{rMetadataJson})), 1, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(rMetadataPath);
            this.instance.pipeline().save(pipelinePath);
        }

        public KMeansWrapperWriter(KMeansWrapper instance) {
            this.instance = instance;
        }
    }
}

